/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.service;

import java.util.ArrayList;
import java.util.List;
import org.egov.wtms.masters.entity.ApplicationType;
import org.egov.wtms.masters.entity.DocumentNames;
import org.egov.wtms.masters.repository.DocumentNamesRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DocumentNamesService {
    private final DocumentNamesRepository documentNamesRepository;

    @Autowired
    public DocumentNamesService(DocumentNamesRepository documentNamesRepository) {
        this.documentNamesRepository = documentNamesRepository;
    }

    public DocumentNames findOne(Long documentNameId) {
        return (DocumentNames)((Object)this.documentNamesRepository.findOne(documentNameId));
    }

    @Transactional
    public DocumentNames createDocumentName(DocumentNames documentNames) {
        documentNames.setActive(true);
        return (DocumentNames)((Object)this.documentNamesRepository.save((Object)documentNames));
    }

    @Transactional
    public void updateDocumentName(DocumentNames documentNames) {
        this.documentNamesRepository.save((Object)documentNames);
    }

    public List<DocumentNames> findAll() {
        return this.documentNamesRepository.findAll(new Sort(Sort.Direction.DESC, new String[]{"documentName"}));
    }

    public DocumentNames findByDocumentName(String documentName) {
        return this.documentNamesRepository.findByDocumentName(documentName);
    }

    public DocumentNames load(Long id) {
        return (DocumentNames)((Object)this.documentNamesRepository.getOne(id));
    }

    public Page<DocumentNames> getListOfDocumentNames(Integer pageNumber, Integer pageSize) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.ASC, new String[]{"documentName"});
        return this.documentNamesRepository.findAll((Pageable)pageable);
    }

    public List<DocumentNames> findByApplicationType(ApplicationType applicationType) {
        return this.documentNamesRepository.findByApplicationType(applicationType);
    }

    public DocumentNames findByApplicationTypeAndDocumentName(ApplicationType applicationType, String documentName) {
        return this.documentNamesRepository.findByApplicationTypeAndDocumentName(applicationType, documentName);
    }

    public List<DocumentNames> getAllActiveDocumentNamesByApplicationType(ApplicationType applicationType) {
        return this.documentNamesRepository.findByActiveTrueAndApplicationTypeOrderByIdAsc(applicationType);
    }

    public List<DocumentNames> getAllActiveDocumentNames() {
        return this.documentNamesRepository.findByActiveTrueOrderByIdAsc();
    }

    public List<DocumentNames> getDocumentNamesListForRest() {
        List<DocumentNames> documentNamesList = this.documentNamesRepository.findByActiveTrueOrderByIdAsc();
        ArrayList<DocumentNames> prepareListForRest = new ArrayList<DocumentNames>(0);
        for (DocumentNames documentNames : documentNamesList) {
            DocumentNames documentNamesRest = new DocumentNames();
            documentNamesRest.setDocumentName(documentNames.getDocumentName());
            documentNamesRest.setRequired(documentNames.isRequired());
            documentNamesRest.setActive(documentNames.isActive());
            documentNamesRest.setApplicationTypeName(documentNames.getApplicationType().getName());
            prepareListForRest.add(documentNamesRest);
        }
        return prepareListForRest;
    }
}

