/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.service;

import java.util.List;
import org.egov.wtms.masters.entity.ConnectionCharges;
import org.egov.wtms.masters.repository.ConnectionChargesRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ConnectionChargesService {
    private final ConnectionChargesRepository connectionChargesRepository;

    @Autowired
    public ConnectionChargesService(ConnectionChargesRepository connectionChargesRepository) {
        this.connectionChargesRepository = connectionChargesRepository;
    }

    public ConnectionCharges findBy(Long connectionChargesId) {
        return (ConnectionCharges)((Object)this.connectionChargesRepository.findOne(connectionChargesId));
    }

    @Transactional
    public ConnectionCharges createConnectionCharges(ConnectionCharges connectionCharges) {
        return (ConnectionCharges)((Object)this.connectionChargesRepository.save((Object)connectionCharges));
    }

    @Transactional
    public void updateConnectionCharges(ConnectionCharges connectionCharges) {
        this.connectionChargesRepository.save((Object)connectionCharges);
    }

    public List<ConnectionCharges> findAll() {
        return this.connectionChargesRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"type"}));
    }

    public List<ConnectionCharges> findByType(String type) {
        return this.connectionChargesRepository.findByType(type);
    }

    public ConnectionCharges load(Long id) {
        return (ConnectionCharges)((Object)this.connectionChargesRepository.getOne(id));
    }

    public Page<ConnectionCharges> getListOfConnectionCharges(Integer pageNumber, Integer pageSize) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.ASC, new String[]{"type"});
        return this.connectionChargesRepository.findAll((Pageable)pageable);
    }

    public ConnectionCharges findByTypeAndDate(String type) {
        return this.connectionChargesRepository.findByTypeAndDate(type);
    }
}

