/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service.collection;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.egov.collection.entity.ReceiptDetail;
import org.egov.collection.integration.models.BillAccountDetails;
import org.egov.collection.integration.models.BillDetails;
import org.egov.collection.integration.models.BillInfo;
import org.egov.collection.integration.models.BillInfoImpl;
import org.egov.collection.integration.models.BillPayeeDetails;
import org.egov.collection.integration.models.BillReceiptInfo;
import org.egov.collection.integration.models.PaymentInfo;
import org.egov.collection.integration.models.PaymentInfoCard;
import org.egov.collection.integration.models.PaymentInfoCash;
import org.egov.collection.integration.models.PaymentInfoChequeDD;
import org.egov.collection.integration.services.CollectionIntegrationService;
import org.egov.commons.Bank;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.BankHibernateDAO;
import org.egov.commons.dao.FinancialYearDAO;
import org.egov.dcb.bean.CashPayment;
import org.egov.dcb.bean.ChequePayment;
import org.egov.dcb.bean.CreditCardPayment;
import org.egov.dcb.bean.DDPayment;
import org.egov.dcb.bean.Payment;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillDetails;
import org.egov.demand.model.EgDemand;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.autonumber.AutonumberServiceBeanResolver;
import org.egov.ptis.domain.dao.demand.PtDemandDao;
import org.egov.ptis.domain.dao.property.BasicPropertyDAO;
import org.egov.ptis.domain.entity.property.BasicProperty;
import org.egov.ptis.domain.entity.property.PropertyOwnerInfo;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.ErrorDetails;
import org.egov.ptis.domain.model.RestPropertyTaxDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.collection.ConnectionBillService;
import org.egov.wtms.application.service.collection.WaterConnectionBillable;
import org.egov.wtms.application.service.collection.WaterTaxCollection;
import org.egov.wtms.autonumber.BillReferenceNumberGenerator;
import org.egov.wtms.masters.entity.PayWaterTaxDetails;
import org.egov.wtms.masters.entity.WaterReceiptDetails;
import org.egov.wtms.masters.entity.WaterTaxDetails;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.constants.WaterTaxConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.transaction.annotation.Transactional;

public class WaterTaxExternalService {
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private CollectionIntegrationService collectionService;
    @Autowired
    private ConnectionDemandService connectionDemandService;
    @Autowired
    private AutonumberServiceBeanResolver beanResolver;
    @Autowired
    private ConnectionBillService connectionBillService;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private BasicPropertyDAO basicPropertyDAO;
    @Autowired
    private PtDemandDao ptDemandDAO;
    @Autowired
    private BankHibernateDAO bankHibernateDAO;
    @Autowired
    private FinancialYearDAO financialYearDAO;

    public WaterReceiptDetails payWaterTax(PayWaterTaxDetails payWaterTaxDetails) {
        WaterReceiptDetails waterReceiptDetails = null;
        ErrorDetails errorDetails = null;
        String currentInstallmentYear = null;
        SimpleDateFormat formatYear = new SimpleDateFormat("yyyy");
        BillReferenceNumberGenerator billRefeNumber = (BillReferenceNumberGenerator)this.beanResolver.getAutoNumberServiceFor(BillReferenceNumberGenerator.class);
        WaterConnectionDetails waterConnectionDetails = null;
        if (payWaterTaxDetails.getApplicaionNumber() != null && !"".equals(payWaterTaxDetails.getApplicaionNumber())) {
            waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(payWaterTaxDetails.getApplicaionNumber());
        } else if (payWaterTaxDetails.getConsumerNo() != null) {
            waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCodeAndStatus(payWaterTaxDetails.getConsumerNo(), ConnectionStatus.ACTIVE);
        }
        WaterConnectionBillable waterConnectionBillable = (WaterConnectionBillable)((Object)this.context.getBean("waterConnectionBillable"));
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
        waterConnectionBillable.setWaterConnectionDetails(waterConnectionDetails);
        waterConnectionBillable.setAssessmentDetails(assessmentDetails);
        waterConnectionBillable.setUserId(2L);
        ApplicationThreadLocals.setUserId((Long)2L);
        if (ConnectionStatus.INPROGRESS.equals((Object)waterConnectionDetails.getConnectionStatus())) {
            currentInstallmentYear = formatYear.format(this.connectionDemandService.getCurrentInstallment("Water Tax Management", "Yearly", new Date()).getInstallmentYear());
        } else if (ConnectionStatus.ACTIVE.equals((Object)waterConnectionDetails.getConnectionStatus()) && ConnectionType.NON_METERED.equals((Object)waterConnectionDetails.getConnectionType())) {
            currentInstallmentYear = formatYear.format(this.connectionDemandService.getCurrentInstallment("Property Tax", null, new Date()).getInstallmentYear());
        } else if (ConnectionStatus.ACTIVE.equals((Object)waterConnectionDetails.getConnectionStatus()) && ConnectionType.METERED.equals((Object)waterConnectionDetails.getConnectionType())) {
            currentInstallmentYear = formatYear.format(this.connectionDemandService.getCurrentInstallment("Water Tax Management", "Monthly", new Date()).getInstallmentYear());
        }
        waterConnectionBillable.setReferenceNumber(billRefeNumber.generateBillNumber(currentInstallmentYear));
        waterConnectionBillable.setBillType(this.connectionDemandService.getBillTypeByCode("MANUAL"));
        waterConnectionBillable.setTransanctionReferenceNumber(payWaterTaxDetails.getTransactionId());
        EgBill egBill = this.generateBill(waterConnectionBillable);
        BillReceiptInfo billReceiptInfo = this.getBillReceiptInforForwaterTax(payWaterTaxDetails, egBill);
        if (null != billReceiptInfo) {
            waterReceiptDetails = new WaterReceiptDetails();
            waterReceiptDetails.setReceiptNo(billReceiptInfo.getReceiptNum());
            waterReceiptDetails.setReceiptDate(this.formatDate(billReceiptInfo.getReceiptDate()));
            waterReceiptDetails.setPayeeName(billReceiptInfo.getPayeeName());
            waterReceiptDetails.setPayeeAddress(billReceiptInfo.getPayeeAddress());
            waterReceiptDetails.setBillReferenceNo(billReceiptInfo.getBillReferenceNum());
            waterReceiptDetails.setServiceName(billReceiptInfo.getServiceName());
            waterReceiptDetails.setDescription(billReceiptInfo.getDescription());
            waterReceiptDetails.setPaidBy(billReceiptInfo.getPaidBy());
            waterReceiptDetails.setPaymentMode(payWaterTaxDetails.getPaymentMode());
            waterReceiptDetails.setPaymentAmount(billReceiptInfo.getTotalAmount());
            waterReceiptDetails.setTransactionId(billReceiptInfo.getManualReceiptNumber());
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WTMS-REST-0");
            errorDetails.setErrorMessage("SUCCESS");
            waterReceiptDetails.setErrorDetails(errorDetails);
        }
        return waterReceiptDetails;
    }

    public WaterTaxDetails getWaterTaxDemandDet(PayWaterTaxDetails payWaterTaxDetails) {
        WaterTaxDetails waterTaxDetails = new WaterTaxDetails();
        WaterConnectionDetails waterConnectionDetails = null;
        ErrorDetails errorDetails = null;
        if (payWaterTaxDetails.getApplicaionNumber() != null && !"".equals(payWaterTaxDetails.getApplicaionNumber())) {
            waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(payWaterTaxDetails.getApplicaionNumber());
        } else if (payWaterTaxDetails.getConsumerNo() != null) {
            waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCodeAndStatus(payWaterTaxDetails.getConsumerNo(), ConnectionStatus.ACTIVE);
        }
        if (waterConnectionDetails == null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WTAX101");
            errorDetails.setErrorMessage("Water Connection details with Consumer code " + (payWaterTaxDetails.getConsumerNo() != null ? payWaterTaxDetails.getConsumerNo() : payWaterTaxDetails.getApplicaionNumber()) + " does not exist");
            waterTaxDetails.setErrorDetails(errorDetails);
        } else {
            waterTaxDetails.setConsumerNo(waterConnectionDetails.getConnection().getConsumerCode());
            waterTaxDetails = this.getWaterTaxDetails(waterTaxDetails, waterConnectionDetails);
        }
        return waterTaxDetails;
    }

    public WaterTaxDetails getWaterTaxDemandDetByConsumerCode(String consumerCode) {
        WaterTaxDetails waterTaxDetails = new WaterTaxDetails();
        WaterConnectionDetails waterConnectionDetails = null;
        ErrorDetails errorDetails = null;
        if (consumerCode != null) {
            waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCodeAndStatus(consumerCode, ConnectionStatus.ACTIVE);
        }
        if (waterConnectionDetails == null) {
            errorDetails = new ErrorDetails();
            errorDetails.setErrorCode("WTAX101");
            errorDetails.setErrorMessage("Water Connection details with Consumer code " + consumerCode + " does not exist");
            waterTaxDetails.setErrorDetails(errorDetails);
        } else {
            waterTaxDetails.setConsumerNo(consumerCode);
            waterTaxDetails = this.getWaterTaxDetails(waterTaxDetails, waterConnectionDetails);
        }
        return waterTaxDetails;
    }

    @Transactional
    public BillReceiptInfo executeCollection(Payment payment, EgBill bill, String source) {
        if (!this.isCollectionPermitted(bill)) {
            throw new ApplicationRuntimeException("Collection is not allowed - current balance is zero and advance coll exists.");
        }
        List<PaymentInfo> paymentInfoList = this.preparePaymentInfo(payment);
        BillInfoImpl billInfo = this.prepareBillInfo(payment.getAmount(), BillInfo.COLLECTIONTYPE.F, bill, source);
        return this.collectionService.createReceipt((BillInfo)billInfo, paymentInfoList);
    }

    private List<PaymentInfo> preparePaymentInfo(Payment payment) {
        ArrayList<PaymentInfo> paymentInfoList = new ArrayList<PaymentInfo>();
        PaymentInfoCard paymentInfo = null;
        if (payment != null) {
            if (payment instanceof ChequePayment) {
                ChequePayment chequePayment = (ChequePayment)payment;
                paymentInfo = new PaymentInfoChequeDD(chequePayment.getBankId(), chequePayment.getBranchName(), chequePayment.getInstrumentDate(), chequePayment.getInstrumentNumber(), PaymentInfo.TYPE.cheque, payment.getAmount());
            } else if (payment instanceof DDPayment) {
                DDPayment chequePayment = (DDPayment)payment;
                paymentInfo = new PaymentInfoChequeDD(chequePayment.getBankId(), chequePayment.getBranchName(), chequePayment.getInstrumentDate(), chequePayment.getInstrumentNumber(), PaymentInfo.TYPE.dd, payment.getAmount());
            } else if (payment instanceof CreditCardPayment) {
                paymentInfo = this.prepareCardPaymentInfo((CreditCardPayment)payment, new PaymentInfoCard());
            } else if (payment instanceof CashPayment) {
                paymentInfo = new PaymentInfoCash(payment.getAmount());
            }
        }
        paymentInfoList.add((PaymentInfo)paymentInfo);
        return paymentInfoList;
    }

    public BillInfoImpl prepareBillInfo(BigDecimal amountPaid, BillInfo.COLLECTIONTYPE collType, EgBill bill, String source) {
        BillInfoImpl billInfoImpl = this.initialiseFromBill(amountPaid, collType, bill);
        ArrayList<ReceiptDetail> receiptDetails = new ArrayList<ReceiptDetail>(0);
        ArrayList billDetails = new ArrayList(bill.getEgBillDetails());
        Collections.sort(billDetails);
        for (EgBillDetails billDet : billDetails) {
            receiptDetails.add(this.initReceiptDetail(billDet.getGlcode(), BigDecimal.ZERO, billDet.getCrAmount(), billDet.getDrAmount(), billDet.getDescription()));
        }
        Boolean isActualDemand = false;
        new WaterTaxCollection().apportionPaidAmount(String.valueOf(bill.getId()), amountPaid, receiptDetails);
        block1: for (EgBillDetails billDet : bill.getEgBillDetails()) {
            for (ReceiptDetail rd : receiptDetails) {
                if (!billDet.getGlcode().equals(rd.getAccounthead().getGlcode()) || !billDet.getDescription().equals(rd.getDescription())) continue;
                isActualDemand = billDet.getAdditionalFlag() == 1;
                BillAccountDetails billAccDetails = new BillAccountDetails(billDet.getGlcode(), billDet.getOrderNo(), rd.getCramount(), rd.getDramount(), billDet.getFunctionCode(), billDet.getDescription(), isActualDemand, this.getPurpose(billDet));
                ((BillDetails)((BillPayeeDetails)billInfoImpl.getPayees().get(0)).getBillDetails().get(0)).addBillAccountDetails(billAccDetails);
                continue block1;
            }
        }
        billInfoImpl.setTransactionReferenceNumber(bill.getTransanctionReferenceNumber());
        billInfoImpl.setSource(source);
        return billInfoImpl;
    }

    private BillInfoImpl initialiseFromBill(BigDecimal amountPaid, BillInfo.COLLECTIONTYPE collType, EgBill bill) {
        String[] collModes;
        BillInfoImpl billInfoImpl = null;
        BillPayeeDetails billPayeeDet = null;
        ArrayList<BillPayeeDetails> billPayeeDetList = new ArrayList<BillPayeeDetails>(0);
        ArrayList<String> collModesList = new ArrayList<String>();
        for (String coll : collModes = bill.getCollModesNotAllowed().split(",")) {
            collModesList.add(coll);
        }
        billInfoImpl = new BillInfoImpl(bill.getServiceCode(), bill.getFundCode(), bill.getFunctionaryCode(), bill.getFundSourceCode(), bill.getDepartmentCode(), "Water Charge Collection", bill.getCitizenName(), bill.getPartPaymentAllowed(), bill.getOverrideAccountHeadsAllowed(), collModesList, collType);
        billPayeeDet = new BillPayeeDetails(bill.getCitizenName(), bill.getCitizenAddress(), bill.getEmailId());
        BillDetails billDetails = new BillDetails(bill.getId().toString(), bill.getCreateDate(), bill.getConsumerId(), bill.getBoundaryNum().toString(), bill.getBoundaryType(), bill.getDescription(), amountPaid, bill.getMinAmtPayable());
        billPayeeDet.addBillDetails(billDetails);
        billPayeeDetList.add(billPayeeDet);
        billInfoImpl.setPayees(billPayeeDetList);
        return billInfoImpl;
    }

    public BillAccountDetails.PURPOSE getPurpose(EgBillDetails billDet) {
        CFinancialYear finYear = this.financialYearDAO.getFinancialYearByDate(new Date());
        if (billDet.getDescription().contains("Advance")) {
            return BillAccountDetails.PURPOSE.ADVANCE_AMOUNT;
        }
        if (billDet.getEgDemandReason().getEgInstallmentMaster().getToDate().compareTo(finYear.getStartingDate()) < 0) {
            return BillAccountDetails.PURPOSE.ARREAR_AMOUNT;
        }
        if (billDet.getEgDemandReason().getEgInstallmentMaster().getFromDate().compareTo(finYear.getStartingDate()) >= 0 && billDet.getEgDemandReason().getEgInstallmentMaster().getFromDate().compareTo(finYear.getEndingDate()) < 0) {
            return BillAccountDetails.PURPOSE.CURRENT_AMOUNT;
        }
        return BillAccountDetails.PURPOSE.OTHERS;
    }

    private ReceiptDetail initReceiptDetail(String glCode, BigDecimal crAmount, BigDecimal crAmountToBePaid, BigDecimal drAmount, String description) {
        ReceiptDetail receiptDetail = new ReceiptDetail();
        CChartOfAccounts accountHead = new CChartOfAccounts();
        accountHead.setGlcode(glCode);
        receiptDetail.setAccounthead(accountHead);
        receiptDetail.setDescription(description);
        receiptDetail.setCramount(crAmount);
        receiptDetail.setCramountToBePaid(crAmountToBePaid);
        receiptDetail.setDramount(drAmount);
        return receiptDetail;
    }

    private PaymentInfoCard prepareCardPaymentInfo(CreditCardPayment cardPayment, PaymentInfoCard paymentInfoCard) {
        paymentInfoCard.setInstrumentNumber(cardPayment.getCreditCardNo());
        paymentInfoCard.setInstrumentAmount(cardPayment.getAmount());
        paymentInfoCard.setExpMonth(cardPayment.getExpMonth());
        paymentInfoCard.setExpYear(cardPayment.getExpYear());
        paymentInfoCard.setCvvNumber(cardPayment.getCvv());
        paymentInfoCard.setCardTypeValue(cardPayment.getCardType());
        paymentInfoCard.setTransactionNumber(cardPayment.getTransactionNumber());
        return paymentInfoCard;
    }

    public boolean isCollectionPermitted(EgBill bill) {
        boolean allowed = this.thereIsCurrentBalanceToBePaid(bill);
        return allowed;
    }

    private boolean thereIsCurrentBalanceToBePaid(EgBill bill) {
        boolean result = false;
        BigDecimal currentBal = BigDecimal.ZERO;
        for (Map.Entry<String, String> entry : WaterTaxConstants.GLCODEMAP_FOR_CURRENTTAX.entrySet()) {
            currentBal = currentBal.add(bill.balanceForGLCode(entry.getValue()));
        }
        if (currentBal != null && currentBal.compareTo(BigDecimal.ZERO) > 0) {
            result = true;
        }
        return result;
    }

    public BillReceiptInfo getBillReceiptInforForwaterTax(PayWaterTaxDetails payWaterTaxDetails, EgBill egBill) {
        HashMap<String, String> paymentDetailsMap = new HashMap<String, String>(0);
        paymentDetailsMap.put("amount", payWaterTaxDetails.getPaymentAmount().toString());
        paymentDetailsMap.put("paidBy", payWaterTaxDetails.getPaidBy());
        if ("CHEQUE".equalsIgnoreCase(payWaterTaxDetails.getPaymentMode().toLowerCase()) || "DD".equalsIgnoreCase(payWaterTaxDetails.getPaymentMode().toLowerCase())) {
            paymentDetailsMap.put("instrumentNumber", payWaterTaxDetails.getChqddNo());
            paymentDetailsMap.put("instrumentDate", payWaterTaxDetails.getChqddDate());
            paymentDetailsMap.put("branchName", payWaterTaxDetails.getBranchName());
            Long validatesBankId = this.validateBank(payWaterTaxDetails.getBankName());
            paymentDetailsMap.put("bankId", validatesBankId.toString());
            paymentDetailsMap.put("bankName", payWaterTaxDetails.getBankName());
        }
        Payment payment = Payment.create((String)payWaterTaxDetails.getPaymentMode().toLowerCase(), paymentDetailsMap);
        BillReceiptInfo billReceiptInfo = this.executeCollection(payment, egBill, payWaterTaxDetails.getSource());
        return billReceiptInfo;
    }

    private String formatDate(Date date) {
        SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy");
        return sdf.format(date);
    }

    private Long validateBank(String bankCodeOrName) {
        Bank bank = this.bankHibernateDAO.getBankByCode(bankCodeOrName);
        if (bank == null) {
            bank = this.bankHibernateDAO.getBankByCode(bankCodeOrName);
        }
        return new Long(bank.getId().intValue());
    }

    public BillReceiptInfo validateTransanctionIdPresent(String transantion) {
        return this.collectionService.getReceiptInfo("WT", transantion);
    }

    public final EgBill generateBill(Billable billObj) {
        EgBill bill = this.generateBillForConnection(billObj, this.financialYearDAO);
        this.egBillDAO.create(bill);
        return bill;
    }

    public WaterTaxDetails getWaterTaxDetails(WaterTaxDetails waterTaxDetails, WaterConnectionDetails waterConnectionDetails) {
        List list;
        ErrorDetails errorDetails = null;
        waterTaxDetails.setConsumerNo(waterConnectionDetails.getConnection().getConsumerCode());
        String propertyIdentifier = waterConnectionDetails.getConnection().getPropertyIdentifier();
        BasicProperty basicProperty = this.basicPropertyDAO.getAllBasicPropertyByPropertyID(propertyIdentifier);
        waterTaxDetails.setPropertyAddress(basicProperty.getAddress().toString());
        waterTaxDetails.setLocalityName(basicProperty.getPropertyID().getLocality().getName());
        List propOwnerInfos = basicProperty.getPropertyOwnerInfo();
        if (propOwnerInfos.size() > 0) {
            waterTaxDetails.setOwnerName(((PropertyOwnerInfo)propOwnerInfos.get(0)).getOwner().getName());
            waterTaxDetails.setMobileNo(((PropertyOwnerInfo)propOwnerInfos.get(0)).getOwner().getMobileNumber());
        }
        if ((list = this.ptDemandDAO.getTaxDetailsForWaterConnection(waterConnectionDetails.getConnection().getConsumerCode(), waterConnectionDetails.getConnectionType().name())).size() > 0) {
            waterTaxDetails.setTaxDetails(new ArrayList<RestPropertyTaxDetails>(0));
        }
        String loopInstallment = "";
        RestPropertyTaxDetails arrearDetails = null;
        BigDecimal total = BigDecimal.ZERO;
        for (Object record : list) {
            Object[] data = (Object[])record;
            String taxType = (String)data[0];
            String installment = (String)data[1];
            BigDecimal dmd = new BigDecimal((Double)data[2]);
            Double col = (Double)data[3];
            BigDecimal demand = BigDecimal.valueOf(dmd.intValue());
            BigDecimal collection = BigDecimal.valueOf(col);
            if (loopInstallment.isEmpty()) {
                loopInstallment = installment;
                arrearDetails = new RestPropertyTaxDetails();
                arrearDetails.setInstallment(installment);
            }
            if (loopInstallment.equals(installment)) {
                if ("PENALTY_FINES".equalsIgnoreCase(taxType)) {
                    arrearDetails.setPenalty(demand.subtract(collection));
                    continue;
                }
                if ("CHQ_BUNC_PENALTY".equalsIgnoreCase(taxType)) {
                    arrearDetails.setChqBouncePenalty(demand.subtract(collection));
                    continue;
                }
                total = total.add(demand.subtract(collection));
                continue;
            }
            arrearDetails.setTaxAmount(total);
            arrearDetails.setTotalAmount(total.add(arrearDetails.getPenalty()).add(arrearDetails.getChqBouncePenalty()));
            waterTaxDetails.getTaxDetails().add(arrearDetails);
            loopInstallment = installment;
            arrearDetails = new RestPropertyTaxDetails();
            arrearDetails.setInstallment(installment);
            total = BigDecimal.ZERO;
            if ("PENALTY_FINES".equalsIgnoreCase(taxType)) {
                arrearDetails.setPenalty(demand.subtract(collection));
                continue;
            }
            if ("CHQ_BUNC_PENALTY".equalsIgnoreCase(taxType)) {
                arrearDetails.setChqBouncePenalty(demand.subtract(collection));
                continue;
            }
            total = total.add(demand.subtract(collection));
        }
        if (arrearDetails != null) {
            arrearDetails.setTaxAmount(total);
            arrearDetails.setTotalAmount(total.add(arrearDetails.getPenalty()).add(arrearDetails.getChqBouncePenalty()));
            waterTaxDetails.getTaxDetails().add(arrearDetails);
        }
        errorDetails = new ErrorDetails();
        errorDetails.setErrorCode("WTMS-REST-0");
        errorDetails.setErrorMessage("SUCCESS");
        waterTaxDetails.setErrorDetails(errorDetails);
        return waterTaxDetails;
    }

    public EgBill generateBillForConnection(Billable billObj, FinancialYearDAO financialYearDAO) {
        EgBill bill = new EgBill();
        bill.setBillNo(billObj.getReferenceNumber());
        bill.setBoundaryNum(Integer.valueOf(billObj.getBoundaryNum().intValue()));
        bill.setTransanctionReferenceNumber(billObj.getTransanctionReferenceNumber());
        bill.setBoundaryType(billObj.getBoundaryType());
        bill.setCitizenAddress(billObj.getBillAddress());
        bill.setCitizenName(billObj.getBillPayee());
        bill.setCollModesNotAllowed(billObj.getCollModesNotAllowed());
        bill.setDepartmentCode(billObj.getDepartmentCode());
        bill.setEgBillType(billObj.getBillType());
        bill.setFunctionaryCode(billObj.getFunctionaryCode());
        bill.setFundCode(billObj.getFundCode());
        bill.setFundSourceCode(billObj.getFundSourceCode());
        bill.setIssueDate(new Date());
        bill.setLastDate(billObj.getBillLastDueDate());
        bill.setModule(billObj.getModule());
        bill.setOverrideAccountHeadsAllowed(billObj.getOverrideAccountHeadsAllowed());
        bill.setPartPaymentAllowed(Boolean.TRUE);
        bill.setServiceCode(billObj.getServiceCode());
        bill.setIs_Cancelled("N");
        bill.setIs_History("N");
        bill.setModifiedDate(new Date());
        bill.setTotalAmount(billObj.getTotalAmount());
        bill.setUserId(billObj.getUserId());
        bill.setCreateDate(new Date());
        EgDemand currentDemand = billObj.getCurrentDemand();
        bill.setEgDemand(currentDemand);
        bill.setDescription(billObj.getDescription());
        bill.setDisplayMessage(billObj.getDisplayMessage());
        bill.setEmailId(billObj.getEmailId());
        if (currentDemand != null && currentDemand.getMinAmtPayable() != null) {
            bill.setMinAmtPayable(currentDemand.getMinAmtPayable());
        } else {
            bill.setMinAmtPayable(BigDecimal.ZERO);
        }
        List<EgBillDetails> bd = this.connectionBillService.getBilldetails(billObj);
        for (EgBillDetails billdetails : bd) {
            bill.addEgBillDetails(billdetails);
            billdetails.setEgBill(bill);
            billdetails.setPurpose(this.getPurpose(billdetails).toString());
        }
        bill.setConsumerId(billObj.getConsumerId());
        bill.setCallBackForApportion(Boolean.TRUE);
        return bill;
    }
}

