/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service.collection;

import java.math.BigDecimal;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.dao.EgDemandDao;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.AbstractBillable;
import org.egov.demand.model.EgBillType;
import org.egov.demand.model.EgDemand;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.BoundaryDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxUtils;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Scope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
@Scope(value="prototype")
public class WaterConnectionBillable
extends AbstractBillable
implements Billable {
    private static final String DISPLAY_MESSAGE = "Water Charge Collection";
    private WaterConnectionDetails WaterConnectionDetails;
    private AssessmentDetails assessmentDetails;
    private Long userId;
    private EgBillType billType;
    private Boolean isCallbackForApportion = Boolean.FALSE;
    private String referenceNumber;
    private String transanctionReferenceNumber;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private EgDemandDao egDemandDAO;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private ConnectionDemandService connectionDemandService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private AppConfigValueService appConfigValuesService;

    public String getBillPayee() {
        return this.buildOwnerFullName(this.getAssessmentDetails().getOwnerNames());
    }

    public String getBillAddress() {
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(this.getWaterConnectionDetails().getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ACTIVE);
        return this.buildAddressDetails(assessmentDetails);
    }

    public EgDemand getCurrentDemand() {
        return this.waterTaxUtils.getCurrentDemand(this.getWaterConnectionDetails()).getDemand();
    }

    public String getEmailId() {
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(this.getWaterConnectionDetails().getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_MOBILE_EMAIL, BasicPropertyStatus.ACTIVE);
        return assessmentDetails.getPrimaryEmail();
    }

    public List<EgDemand> getAllDemands() {
        List<EgDemand> demands = this.waterTaxUtils.getAllDemand(this.getWaterConnectionDetails());
        return demands;
    }

    public EgBillType getBillType() {
        if (this.billType == null) {
            this.billType = this.egBillDAO.getBillTypeByCode("AUTO");
        }
        return this.billType;
    }

    public Date getBillLastDueDate() {
        return new DateTime().plusMonths(1).toDate();
    }

    public Long getBoundaryNum() {
        return this.getAssessmentDetails().getBoundaryDetails().getWardNumber();
    }

    public String getBoundaryType() {
        return "Ward";
    }

    public String getDepartmentCode() {
        AppConfigValues appConfigValue = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Water Tax Management", "DEPTCODEFORGENERATEBILL").get(0);
        return appConfigValue != null ? appConfigValue.getValue().trim() : null;
    }

    public BigDecimal getFunctionaryCode() {
        AppConfigValues appConfigValue = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Water Tax Management", "FUNCTIONARYCODEFORGENERATEBILL").get(0);
        return new BigDecimal(appConfigValue != null ? appConfigValue.getValue() : "0");
    }

    public String getFundCode() {
        AppConfigValues appConfigValue = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Water Tax Management", "FUNDCODEFORGENERATEBILL").get(0);
        return appConfigValue != null ? appConfigValue.getValue() : null;
    }

    public String getFundSourceCode() {
        AppConfigValues appConfigValue = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Water Tax Management", "FUNDSOURCECODEFORGENERATEBILL").get(0);
        return appConfigValue != null ? appConfigValue.getValue() : null;
    }

    public Date getIssueDate() {
        return new Date();
    }

    public Date getLastDate() {
        return this.getBillLastDueDate();
    }

    public Module getModule() {
        return this.moduleService.getModuleByName("Water Tax Management");
    }

    public Boolean getOverrideAccountHeadsAllowed() {
        return false;
    }

    public Boolean getPartPaymentAllowed() {
        if (this.getWaterConnectionDetails().getConnectionStatus() != null && this.getWaterConnectionDetails().getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE)) {
            return true;
        }
        return false;
    }

    public String getServiceCode() {
        if (this.getWaterConnectionDetails().getStatus().getCode().equalsIgnoreCase("ESTIMATIONNOTICEGENERATED")) {
            return ((AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Water Tax Management", "ESTSERVICECODEFORGENERATEBILL").get(0)).getValue();
        }
        return ((AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKey("Water Tax Management", "SERVICECODEFORGENERATEBILL").get(0)).getValue();
    }

    public BigDecimal getTotalAmount() {
        EgDemand currentDemand = this.getCurrentDemand();
        List<Object> instVsAmt = this.connectionDemandService.getDmdCollAmtInstallmentWise(currentDemand);
        BigDecimal balance = BigDecimal.ZERO;
        for (Object object : instVsAmt) {
            Object[] ddObject = (Object[])object;
            BigDecimal dmdAmt = new BigDecimal((Double)ddObject[2]);
            BigDecimal collAmt = BigDecimal.ZERO;
            if (ddObject[2] != null) {
                collAmt = new BigDecimal((Double)ddObject[3]);
            }
            balance = balance.add(dmdAmt.subtract(collAmt));
        }
        return balance;
    }

    public Long getUserId() {
        return this.userId;
    }

    public String getDescription() {
        if (null != this.getWaterConnectionDetails().getConnection().getConsumerCode()) {
            return "Water Charge H.S.C No: " + this.getWaterConnectionDetails().getConnection().getConsumerCode();
        }
        return "Water Charge Application Number: " + this.getWaterConnectionDetails().getApplicationNumber();
    }

    public String getDisplayMessage() {
        return DISPLAY_MESSAGE;
    }

    public String getCollModesNotAllowed() {
        StringBuilder collectionModesNotAllowed = new StringBuilder();
        collectionModesNotAllowed.append("bankchallan");
        return collectionModesNotAllowed.toString();
    }

    public String getConsumerId() {
        return this.getWaterConnectionDetails().getApplicationNumber();
    }

    public Boolean isCallbackForApportion() {
        if (this.getWaterConnectionDetails().getConnectionStatus() != null && this.getWaterConnectionDetails().getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE)) {
            this.isCallbackForApportion = Boolean.TRUE;
            return this.isCallbackForApportion;
        }
        this.isCallbackForApportion = Boolean.FALSE;
        return this.isCallbackForApportion;
    }

    public void setCallbackForApportion(Boolean b) {
        this.isCallbackForApportion = b;
    }

    public WaterConnectionDetails getWaterConnectionDetails() {
        return this.WaterConnectionDetails;
    }

    public void setWaterConnectionDetails(WaterConnectionDetails waterConnectionDetails) {
        this.WaterConnectionDetails = waterConnectionDetails;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public void setBillType(EgBillType billType) {
        this.billType = billType;
    }

    public String buildOwnerFullName(Set<OwnerName> ownerSet) {
        if (ownerSet == null) {
            throw new ApplicationRuntimeException("Property Owner set is null...");
        }
        String ownerFullName = "";
        HashSet<String> ownerNameSet = new HashSet<String>();
        for (OwnerName propOwnerInfo : ownerSet) {
            if (propOwnerInfo.getOwnerName() == null || propOwnerInfo.getOwnerName().trim().equals("") || ownerNameSet.contains(propOwnerInfo.getOwnerName().trim())) continue;
            if (!ownerFullName.trim().equals("") && !ownerFullName.equals("")) {
                ownerFullName = ownerFullName + ", ";
            }
            ownerNameSet.add(propOwnerInfo.getOwnerName().trim());
            ownerFullName = propOwnerInfo.getOwnerName() == null ? "" : propOwnerInfo.getOwnerName();
        }
        return ownerFullName;
    }

    public String buildAddressDetails(AssessmentDetails assessmentDetails) {
        BoundaryDetails boundaryDetails = assessmentDetails.getBoundaryDetails();
        StringBuilder address = new StringBuilder();
        if (assessmentDetails.getPropertyAddress() != null && !"".equals(assessmentDetails.getPropertyAddress())) {
            address.append(assessmentDetails.getPropertyAddress());
        } else {
            if (boundaryDetails.getZoneName() != null) {
                address.append(boundaryDetails.getZoneName());
            }
            if (boundaryDetails.getWardName() != null) {
                address.append(", ").append(boundaryDetails.getWardName());
            }
            if (boundaryDetails.getLocalityName() != null) {
                address.append(", ").append(boundaryDetails.getLocalityName());
            }
            if (boundaryDetails.getBlockName() != null) {
                address.append(", ").append(boundaryDetails.getBlockName());
            }
            if (boundaryDetails.getStreetName() != null) {
                address.append(", ").append(boundaryDetails.getStreetName());
            }
        }
        return address.toString();
    }

    public AssessmentDetails getAssessmentDetails() {
        return this.assessmentDetails;
    }

    public void setAssessmentDetails(AssessmentDetails assessmentDetails) {
        this.assessmentDetails = assessmentDetails;
    }

    public String getReferenceNumber() {
        return this.referenceNumber;
    }

    public void setReferenceNumber(String referenceNumber) {
        this.referenceNumber = referenceNumber;
    }

    public String getTransanctionReferenceNumber() {
        return this.transanctionReferenceNumber;
    }

    public void setTransanctionReferenceNumber(String transanctionReferenceNumber) {
        this.transanctionReferenceNumber = transanctionReferenceNumber;
    }
}

