/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.math.BigInteger;
import java.text.ParseException;
import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.wtms.application.entity.DefaultersReport;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DefaultersWTReportService {
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<DefaultersReport> getDefaultersReportDetails(String fromAmount, String toAmount, String ward, String topDefaulters, int startsFrom, int maxResults) throws ParseException {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select dcbinfo.hscno as \"hscNo\", dcbinfo.username as \"ownerName\",wardboundary.name as \"wardName\",dcbinfo.houseno as \"houseNo\" , localboundary.localname as \"locality\", dcbinfo.mobileno as \"mobileNumber\", dcbinfo.arr_balance as \"arrearsDue\" ,  dcbinfo.curr_balance as \"currentDue\" , dcbinfo.arr_balance+dcbinfo.curr_balance as \"totalDue\"  from egwtr_mv_dcb_view dcbinfo INNER JOIN eg_boundary wardboundary on dcbinfo.wardid = wardboundary.id INNER JOIN eg_boundary localboundary on dcbinfo.locality = localboundary.id");
        if (Double.parseDouble(toAmount) == 0.0) {
            queryStr.append(" where dcbinfo.arr_balance+dcbinfo.curr_balance >" + fromAmount);
        } else {
            queryStr.append(" where dcbinfo.arr_balance+dcbinfo.curr_balance >" + fromAmount + " and dcbinfo.arr_balance+dcbinfo.curr_balance <" + toAmount);
        }
        queryStr.append(" and dcbinfo.connectionstatus = 'ACTIVE'");
        if (ward != null && !ward.isEmpty()) {
            queryStr.append(" and wardboundary.name = '" + ward + "'");
        }
        if (!topDefaulters.isEmpty()) {
            queryStr.append(" order by dcbinfo.arr_balance+dcbinfo.curr_balance desc limit " + topDefaulters);
        }
        SQLQuery finalQuery = this.getCurrentSession().createSQLQuery(queryStr.toString());
        finalQuery.setFirstResult(startsFrom);
        finalQuery.setMaxResults(maxResults);
        finalQuery.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(DefaultersReport.class));
        return finalQuery.list();
    }

    public long getTotalCount(String fromAmount, String toAmount, String ward, String topDefaulters) throws ParseException {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select count(dcbinfo.hscno) from egwtr_mv_dcb_view dcbinfo INNER JOIN eg_boundary wardboundary on dcbinfo.wardid = wardboundary.id INNER JOIN eg_boundary localboundary on dcbinfo.locality = localboundary.id");
        if (Double.parseDouble(toAmount) == 0.0) {
            queryStr.append(" where dcbinfo.arr_balance+dcbinfo.curr_balance >" + fromAmount);
        } else {
            queryStr.append(" where dcbinfo.arr_balance+dcbinfo.curr_balance >" + fromAmount + " and dcbinfo.arr_balance+dcbinfo.curr_balance <" + toAmount);
        }
        queryStr.append(" and dcbinfo.connectionstatus = 'ACTIVE'");
        if (ward != null && !ward.isEmpty()) {
            queryStr.append(" and wardboundary.name = '" + ward + "'");
        }
        if (!topDefaulters.isEmpty()) {
            queryStr.append(" order by dcbinfo.arr_balance+dcbinfo.curr_balance desc limit " + topDefaulters);
        }
        SQLQuery finalQuery = this.getCurrentSession().createSQLQuery(queryStr.toString());
        Long count = ((BigInteger)finalQuery.uniqueResult()).longValue();
        return count;
    }
}

