/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.text.ParseException;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.wtms.application.entity.DataEntryConnectionReport;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DataEntryConnectionReportService {
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public SQLQuery getDataEntryConnectionReportDetails(String ward) throws ParseException {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select dcbinfo.hscno as \"hscNo\", dcbinfo.propertyid as \"assessmentNo\", dcbinfo.username as \"ownerName\", zoneboundary.name as \"zone\", wardboundary.name as \"revenueWard\",blockboundary.name as \"block\",localboundary.localname as \"locality\",dcbinfo.address as \"address\" , dcbinfo.mobileno as \"mobileNumber\", dcbinfo.watersource as \"waterSource\" ,  dcbinfo.propertytype as \"propertyType\" , dcbinfo.applicationtype as \"applicationType\", dcbinfo.connectiontype as \"connectionType\",  dcbinfo.usagetype as \"usageType\" , dcbinfo.categorytype as \"category\", dcbinfo.pipesize as \"pipeSizeInInch\",  dcbinfo.aadharno as \"aadharNumber\" ,  dcbinfo.numberofperson as \"noOfPersons\" , dcbinfo.numberofrooms as \"noOfRooms\" , dcbinfo.sumpcapacity as \"sumpCapacity\" ,  dcbinfo.executiondate as \"connectionDate\"  ,dcbinfo.arr_balance+dcbinfo.curr_balance as \"waterTaxDue\" , dcbinfo.pt_firsthalf_demand + dcbinfo.pt_secondhalf_demand - dcbinfo.pt_firsthalf_collection - dcbinfo.pt_secondhalf_collection as \"propertyTaxDue\" from egwtr_mv_dcb_view dcbinfo INNER JOIN eg_boundary localboundary on dcbinfo.locality = localboundary.id INNER JOIN eg_boundary zoneboundary on dcbinfo.zoneid = zoneboundary.id INNER JOIN eg_boundary wardboundary on dcbinfo.wardid = wardboundary.id  INNER JOIN eg_boundary blockboundary on dcbinfo.block = blockboundary.id");
        queryStr.append(" where dcbinfo.connectionstatus = 'ACTIVE' and dcbinfo.legacy = true and dcbinfo.approvalnumber IS NULL  and dcbinfo.connectiontype = 'NON_METERED' ");
        if (ward != null && !ward.isEmpty()) {
            queryStr.append(" and wardboundary.name = '" + ward + "'");
        }
        SQLQuery finalQuery = this.getCurrentSession().createSQLQuery(queryStr.toString());
        finalQuery.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(DataEntryConnectionReport.class));
        return finalQuery;
    }
}

