/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.entity;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import javax.validation.ValidationException;
import org.egov.search.domain.Filter;
import org.egov.search.domain.Filters;
import org.jboss.logging.Logger;

public class DailyWTCollectionReportSearch {
    private static final Logger logger = Logger.getLogger(DailyWTCollectionReportSearch.class);
    private String fromDate;
    private String toDate;
    SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
    SimpleDateFormat dtft = new SimpleDateFormat("dd/MM/yyyy");
    private List<String> consumerCode = new ArrayList<String>();
    private String collectionMode;
    private String collectionOperator;
    private String revenueWard;
    private String searchText;
    private String ulbName;
    private String status;

    public List<String> getConsumerCode() {
        return this.consumerCode;
    }

    public void setConsumerCode(List<String> consumerCode) {
        this.consumerCode = consumerCode;
    }

    public void setFromDate(String fromDate) {
        if (null != fromDate) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Date Range From start.. :" + this.ft.format(this.dtft.parse(fromDate))));
                }
                this.fromDate = this.ft.format(this.dtft.parse(fromDate));
            }
            catch (ParseException e) {
                throw new ValidationException(e.getMessage());
            }
        }
    }

    public void setToDate(String toDate) {
        Calendar cal = Calendar.getInstance();
        if (null != toDate) {
            try {
                cal.setTime(this.dtft.parse(toDate));
                cal.add(6, 1);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Date Range Till .. :" + this.ft.format(cal.getTime())));
                }
                this.toDate = this.ft.format(cal.getTime());
            }
            catch (ParseException e) {
                throw new ValidationException(e.getMessage());
            }
        }
    }

    public String getFromDate() {
        return this.fromDate;
    }

    public String getToDate() {
        return this.toDate;
    }

    public String getCollectionMode() {
        return this.collectionMode;
    }

    public void setCollectionMode(String collectionMode) {
        this.collectionMode = collectionMode;
    }

    public String getCollectionOperator() {
        return this.collectionOperator;
    }

    public void setCollectionOperator(String collectionOperator) {
        this.collectionOperator = collectionOperator;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getRevenueWard() {
        return this.revenueWard;
    }

    public void setRevenueWard(String revenueWard) {
        this.revenueWard = revenueWard;
    }

    public String getSearchText() {
        return this.searchText;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public String getUlbName() {
        return this.ulbName;
    }

    public void setUlbName(String ulbName) {
        this.ulbName = ulbName;
    }

    public Filters searchCollectionFilters() {
        ArrayList<Filter> andFilters = new ArrayList<Filter>(0);
        andFilters.add(Filter.termsStringFilter((String)"clauses.cityname", (String[])new String[]{this.ulbName}));
        andFilters.add(Filter.termsStringFilter((String)"clauses.channel", (String[])new String[]{this.collectionMode}));
        andFilters.add(Filter.termsStringFilter((String)"clauses.receiptcreator", (String[])new String[]{this.collectionOperator}));
        andFilters.add(Filter.termsStringFilter((String)"clauses.billingservice", (String[])new String[]{"Water Tax"}));
        andFilters.add(Filter.termsStringFilter((String)"clauses.status", (String[])new String[]{this.status}));
        if (!this.consumerCode.isEmpty()) {
            String[] consumerCodes = this.consumerCode.toArray(new String[this.consumerCode.size()]);
            andFilters.add(Filter.termsStringFilter((String)"common.consumercode", (String[])consumerCodes));
        }
        andFilters.add(Filter.rangeFilter((String)"searchable.receiptdate", (String)this.fromDate, (String)this.toDate));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"finished filters");
        }
        logger.info((Object)("$$$$$$$$$$$$$$$$ Filters : " + andFilters));
        return Filters.withAndFilters(andFilters);
    }

    public Filters searchConnectionForWardFilters() {
        ArrayList<Filter> andFilters = new ArrayList<Filter>(0);
        andFilters.add(Filter.termsStringFilter((String)"clauses.ulbname", (String[])new String[]{this.ulbName}));
        andFilters.add(Filter.termsStringFilter((String)"clauses.ward", (String[])new String[]{this.revenueWard}));
        return Filters.withAndFilters(andFilters);
    }

    public String searchQuery() {
        return this.searchText;
    }
}

