/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.service.es;

import java.math.BigDecimal;
import java.util.Iterator;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.entity.es.WaterChargeDocument;
import org.egov.wtms.repository.es.WaterChargeDocumentRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WaterChargeDocumentService {
    private final WaterChargeDocumentRepository waterChargeIndexRepository;
    @Autowired
    private CityService cityService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private ConnectionDemandService connectionDemandService;

    @Autowired
    public WaterChargeDocumentService(WaterChargeDocumentRepository waterChargeIndexRepository) {
        this.waterChargeIndexRepository = waterChargeIndexRepository;
    }

    public WaterChargeDocument createWaterChargeIndex(WaterConnectionDetails waterConnectionDetails, AssessmentDetails assessmentDetails, BigDecimal amountTodisplayInIndex) {
        Boundary adminBoundary;
        Iterator ownerNameItr = assessmentDetails.getOwnerNames().iterator();
        Long monthlyRate = null;
        String consumername = "";
        String aadharNumber = "";
        String mobilNumber = "";
        GeoPoint wardlocation = null;
        GeoPoint propertylocation = null;
        this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        monthlyRate = this.connectionDemandService.getWaterRatesDetailsForDemandUpdate(waterConnectionDetails) != null && this.connectionDemandService.getWaterRatesDetailsForDemandUpdate(waterConnectionDetails).getMonthlyRate() != null ? Long.valueOf(new BigDecimal(this.connectionDemandService.getWaterRatesDetailsForDemandUpdate(waterConnectionDetails).getMonthlyRate()).longValue()) : Long.valueOf(BigDecimal.ZERO.longValue());
        if (ownerNameItr != null && ownerNameItr.hasNext()) {
            ((OwnerName)ownerNameItr.next()).getMobileNumber();
        }
        if ((ownerNameItr = assessmentDetails.getOwnerNames().iterator()).hasNext()) {
            OwnerName ownerName = (OwnerName)ownerNameItr.next();
            consumername = ownerName.getOwnerName();
            mobilNumber = ownerName.getMobileNumber();
            String string = aadharNumber = ownerName.getAadhaarNumber() != null ? ownerName.getAadhaarNumber() : "";
            while (ownerNameItr.hasNext()) {
                OwnerName multipleOwner = (OwnerName)ownerNameItr.next();
                consumername = consumername.concat(",".concat(multipleOwner.getOwnerName()));
                aadharNumber = aadharNumber.concat(",".concat(multipleOwner.getAadhaarNumber() != null ? multipleOwner.getAadhaarNumber() : ""));
            }
        }
        if (assessmentDetails.getLatitude() != 0.0 && assessmentDetails.getLongitude() != 0.0) {
            propertylocation = new GeoPoint(assessmentDetails.getLatitude(), assessmentDetails.getLongitude());
        }
        if (assessmentDetails.getBoundaryDetails().getAdminWardId() != null && (adminBoundary = this.boundaryService.getBoundaryById(assessmentDetails.getBoundaryDetails().getAdminWardId())).getLatitude() != null && adminBoundary.getLongitude() != null) {
            wardlocation = new GeoPoint((double)adminBoundary.getLatitude().floatValue(), (double)adminBoundary.getLongitude().floatValue());
        }
        Map cityInfo = this.cityService.cityDataAsMap();
        WaterChargeDocument waterChargeIndex = WaterChargeDocument.builder().withZone(assessmentDetails.getBoundaryDetails().getZoneName()).withWard(assessmentDetails.getBoundaryDetails().getWardName()).withAdminward(assessmentDetails.getBoundaryDetails().getAdminWardName()).withDoorNo(assessmentDetails.getHouseNo()).withTotaldue(assessmentDetails.getPropertyDetails().getTaxDue().longValue()).withIslegacy(waterConnectionDetails.getLegacy()).withGrade(StringUtils.defaultString((String)((String)cityInfo.get("cityGrade")))).withRegionname(StringUtils.defaultString((String)((String)cityInfo.get("cityRegion")))).withClosureType(waterConnectionDetails.getCloseConnectionType() != null ? waterConnectionDetails.getCloseConnectionType() : "").withLocality(assessmentDetails.getBoundaryDetails().getLocalityName() != null ? assessmentDetails.getBoundaryDetails().getLocalityName() : "").withPropertyid(waterConnectionDetails.getConnection().getPropertyIdentifier()).withApplicationcode(waterConnectionDetails.getApplicationType().getCode()).withCreatedDate(waterConnectionDetails.getExecutionDate()).withMobileNumber(mobilNumber).withStatus(waterConnectionDetails.getConnectionStatus().name()).withDistrictName(StringUtils.defaultString((String)((String)cityInfo.get("districtName")))).withConnectiontype(waterConnectionDetails.getConnectionType().name()).withWaterTaxDue(amountTodisplayInIndex.longValue()).withUsage(waterConnectionDetails.getUsageType().getCode()).withConsumerCode(waterConnectionDetails.getConnection().getConsumerCode()).withWatersource(waterConnectionDetails.getWaterSource().getWaterSourceType()).withPropertytype(waterConnectionDetails.getPropertyType().getName()).withCategory(waterConnectionDetails.getCategory().getName()).withUlbname(StringUtils.defaultString((String)((String)cityInfo.get("cityname")))).withSumpcapacity(waterConnectionDetails.getSumpCapacity()).withPipesize(waterConnectionDetails.getPipeSize().getCode()).withNumberOfPerson(waterConnectionDetails.getNumberOfPerson() != null ? Long.valueOf(waterConnectionDetails.getNumberOfPerson().intValue()) : 0L).withCurrentDue(this.waterConnectionDetailsService.getTotalAmountTillCurrentFinYear(waterConnectionDetails).subtract(this.waterConnectionDetailsService.getTotalAmountTillPreviousFinYear(waterConnectionDetails)).longValue()).withArrearsDue(this.waterConnectionDetailsService.getTotalAmountTillPreviousFinYear(waterConnectionDetails).longValue()).withCurrentDemand(this.waterConnectionDetailsService.getTotalDemandTillCurrentFinYear(waterConnectionDetails).subtract(this.waterConnectionDetailsService.getArrearsDemand(waterConnectionDetails)).longValue()).withArrearsDemand(this.waterConnectionDetailsService.getArrearsDemand(waterConnectionDetails).longValue()).withMonthlyRate(monthlyRate).withConsumername(consumername).withAadhaarnumber(aadharNumber).withWardlocation(wardlocation).withPropertylocation(propertylocation).build();
        this.createWaterChargeDocument(waterChargeIndex);
        return waterChargeIndex;
    }

    @Transactional
    public WaterChargeDocument createWaterChargeDocument(WaterChargeDocument waterChargeIndex) {
        this.waterChargeIndexRepository.save(waterChargeIndex);
        return waterChargeIndex;
    }
}

