/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.service.es;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.egov.infra.elasticsearch.entity.ApplicationIndex;
import org.egov.wtms.repository.es.ApplicationSearchRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ApplicationSearchService {
    private final ApplicationSearchRepository applicationSearchRepository;

    @Autowired
    public ApplicationSearchService(ApplicationSearchRepository applicationSearchRepository) {
        this.applicationSearchRepository = applicationSearchRepository;
    }

    public ApplicationIndex load(Long id) {
        return (ApplicationIndex)this.applicationSearchRepository.getOne(id);
    }

    public List<ApplicationIndex> findApplicationIndexModules() {
        return this.applicationSearchRepository.findApplicationIndexModules();
    }

    public List<ApplicationIndex> getSourceList() {
        return this.applicationSearchRepository.getSourceList();
    }

    public List<ApplicationIndex> findApplicationIndexApplicationTypes(String moduleName) {
        return this.applicationSearchRepository.findAllApplicationTypes(moduleName);
    }

    public Map<String, String> getApplicationStatusMap() {
        LinkedHashMap<String, String> connectionTypeMap = new LinkedHashMap<String, String>(0);
        connectionTypeMap.put("Open".toString(), "Open");
        connectionTypeMap.put("Closed".toString(), "Closed");
        connectionTypeMap.put("All".toString(), "All");
        return connectionTypeMap;
    }
}

