/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.service;

import java.util.List;
import org.egov.wtms.masters.entity.PropertyType;
import org.egov.wtms.masters.entity.UsageType;
import org.egov.wtms.masters.entity.WaterPropertyUsage;
import org.egov.wtms.masters.repository.WaterPropertyUsageRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WaterPropertyUsageService {
    private final WaterPropertyUsageRepository waterPropertyUsageRepository;

    @Autowired
    public WaterPropertyUsageService(WaterPropertyUsageRepository waterPropertyUsageRepository) {
        this.waterPropertyUsageRepository = waterPropertyUsageRepository;
    }

    public WaterPropertyUsage findOne(Long waterPropertyUsageId) {
        return (WaterPropertyUsage)((Object)this.waterPropertyUsageRepository.findOne(waterPropertyUsageId));
    }

    @Transactional
    public WaterPropertyUsage createWaterPropertyUsage(WaterPropertyUsage waterPropertyUsage) {
        waterPropertyUsage.setActive(true);
        return (WaterPropertyUsage)((Object)this.waterPropertyUsageRepository.save((Object)waterPropertyUsage));
    }

    @Transactional
    public void updateWaterPropertyUsage(WaterPropertyUsage waterPropertyUsage) {
        this.waterPropertyUsageRepository.save((Object)waterPropertyUsage);
    }

    public WaterPropertyUsage findByPropertyTypecodeAndUsageTypecode(String propertyType, String usageTypeCode) {
        return this.waterPropertyUsageRepository.findByPropertyType_codeAndUsageType_code(propertyType, usageTypeCode);
    }

    public WaterPropertyUsage findByPropertyTypeAndUsageType(PropertyType propertyType, UsageType usagetype) {
        return this.waterPropertyUsageRepository.findByPropertyTypeAndUsageType(propertyType, usagetype);
    }

    public List<WaterPropertyUsage> findAll() {
        return this.waterPropertyUsageRepository.findAll(new Sort(Sort.Direction.DESC, new String[]{"id"}));
    }

    public List<WaterPropertyUsage> findAllByPropertyTypeAndUsageType(PropertyType propertyType, UsageType usagetype) {
        return this.waterPropertyUsageRepository.findAllByPropertyTypeAndUsageType(propertyType, usagetype);
    }

    public List<WaterPropertyUsage> getActivePropertyTypeAndUsageType() {
        return this.waterPropertyUsageRepository.findByActiveTrueOrderByIdAsc();
    }
}

