/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.service;

import java.util.Date;
import java.util.List;
import org.egov.wtms.masters.entity.ConnectionCategory;
import org.egov.wtms.masters.entity.DonationDetails;
import org.egov.wtms.masters.entity.DonationHeader;
import org.egov.wtms.masters.entity.PipeSize;
import org.egov.wtms.masters.entity.PropertyType;
import org.egov.wtms.masters.entity.UsageType;
import org.egov.wtms.masters.repository.DonationDetailsRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class DonationDetailsService {
    private final DonationDetailsRepository donationDetailsRepository;

    @Autowired
    public DonationDetailsService(DonationDetailsRepository donationDetailsRepository) {
        this.donationDetailsRepository = donationDetailsRepository;
    }

    public DonationDetails findBy(Long donationDetailsId) {
        return (DonationDetails)((Object)this.donationDetailsRepository.findOne(donationDetailsId));
    }

    @Transactional
    public DonationDetails persistDonationDetails(DonationDetails donationDetails) {
        return (DonationDetails)((Object)this.donationDetailsRepository.save((Object)donationDetails));
    }

    public DonationDetails load(Long id) {
        return (DonationDetails)((Object)this.donationDetailsRepository.getOne(id));
    }

    public DonationDetails findByDonationHeader(DonationHeader donationHeader) {
        return this.donationDetailsRepository.findByDonationHeader(donationHeader);
    }

    public List<DonationDetails> findAll() {
        return this.donationDetailsRepository.findAll(new Sort(Sort.Direction.DESC, new String[]{"donationHeader.propertyType", "donationHeader.category", "donationHeader.usageType", "donationHeader.minPipeSize"}));
    }

    public DonationDetails findDonationDetailsByPropertyAndCategoryAndUsageandPipeSize(PropertyType propertyType, ConnectionCategory categoryType, UsageType usageType, PipeSize minPipeSize) {
        return this.donationDetailsRepository.findDonationDetailsByPropertyAndCategoryAndUsageandPipeSize(propertyType, categoryType, usageType, minPipeSize);
    }

    public DonationDetails findByDonationHeaderAndFromDateAndToDate(DonationHeader donationHeader, Date fromDate, Date toDate) {
        return this.donationDetailsRepository.findByDonationHeaderAndFromDateAndToDate(donationHeader, fromDate, toDate);
    }
}

