/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.entity;

import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.infra.persistence.validator.annotation.CompositeUnique;
import org.egov.wtms.masters.entity.PropertyType;
import org.egov.wtms.masters.entity.UsageType;
import org.hibernate.envers.AuditOverride;
import org.hibernate.envers.AuditOverrides;
import org.hibernate.envers.Audited;

@Entity
@Table(name="egwtr_property_usage")
@CompositeUnique(fields={"usageType", "propertyType"}, enableDfltMsg=true, message="{waterpropertyusage.validity.exist}")
@SequenceGenerator(name="SEQ_EGWTR_PROPERTY_USAGE", sequenceName="SEQ_EGWTR_PROPERTY_USAGE", allocationSize=1)
@AuditOverrides(value={@AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedBy"), @AuditOverride(forClass=AbstractAuditable.class, name="lastModifiedDate")})
public class WaterPropertyUsage
extends AbstractAuditable {
    private static final long serialVersionUID = 8604331107634946265L;
    public static final String SEQ_PROPERTY_USAGE = "SEQ_EGWTR_PROPERTY_USAGE";
    @Id
    @GeneratedValue(generator="SEQ_EGWTR_PROPERTY_USAGE", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @ManyToOne
    @JoinColumn(name="usagetype")
    @Audited
    private UsageType usageType;
    @NotNull
    @ManyToOne
    @JoinColumn(name="propertytype")
    @Audited
    private PropertyType propertyType;
    @Audited
    private boolean active;

    public PropertyType getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(PropertyType propertyType) {
        this.propertyType = propertyType;
    }

    public Long getId() {
        return this.id;
    }

    protected void setId(Long id) {
        this.id = id;
    }

    public UsageType getUsageType() {
        return this.usageType;
    }

    public void setUsageType(UsageType usageType) {
        this.usageType = usageType;
    }

    public boolean isActive() {
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }
}

