/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.entity.es;

import com.fasterxml.jackson.annotation.JsonFormat;
import java.util.Date;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.springframework.data.annotation.Id;
import org.springframework.data.elasticsearch.annotations.DateFormat;
import org.springframework.data.elasticsearch.annotations.Document;
import org.springframework.data.elasticsearch.annotations.Field;
import org.springframework.data.elasticsearch.annotations.FieldIndex;
import org.springframework.data.elasticsearch.annotations.FieldType;
import org.springframework.data.elasticsearch.annotations.GeoPointField;
import org.springframework.data.elasticsearch.core.geo.GeoPoint;

@Document(indexName="waterchargeconsumer", type="waterchargeconsumer")
public class WaterChargeDocument {
    @JsonFormat(shape=JsonFormat.Shape.STRING, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    @Field(type=FieldType.Date, format=DateFormat.date_optional_time, pattern="yyyy-MM-dd'T'HH:mm:ss.SSS'Z'")
    private Date createdDate;
    @Field(index=FieldIndex.not_analyzed)
    @GeoPointField
    private GeoPoint wardlocation;
    @Field(index=FieldIndex.not_analyzed)
    @GeoPointField
    private GeoPoint propertylocation;
    @Id
    private String id;
    @Field(type=FieldType.String)
    private String closureType;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String waterSource;
    @Field(type=FieldType.Boolean)
    private boolean isLegacy;
    @Field(type=FieldType.Long)
    private Long sumpCapacity;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String mobileNumber;
    @Field(type=FieldType.Long)
    private Long numberOfPerson;
    @Field(type=FieldType.Long)
    private Long totalDue;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String usage;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String propertyType;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String ulbName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String consumerCode;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String ward;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String applicationCode;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String districtName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String zone;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String adminWard;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String grade;
    @Field(type=FieldType.String)
    private String bpaid;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String regionName;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String pipeSize;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String doorNo;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String category;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String connectionType;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String propertyId;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String status;
    @Field(type=FieldType.Long)
    private Long monthlyRate;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String aadhaarNumber;
    @Field(type=FieldType.Long)
    private Long waterTaxDue;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String locality;
    @Field(type=FieldType.Long)
    private Long arrearsDue;
    @Field(type=FieldType.String, index=FieldIndex.not_analyzed)
    private String consumerName;
    @Field(type=FieldType.Long)
    private Long currentDue;
    @Field(type=FieldType.Long)
    private Long arrearsDemand;
    @Field(type=FieldType.Long)
    private Long currentDemand;

    public static Builder builder() {
        return new Builder();
    }

    public Date getCreatedDate() {
        return this.createdDate;
    }

    public void setCreatedDate(Date createdDate) {
        this.createdDate = createdDate;
    }

    public String getBpaid() {
        return this.bpaid;
    }

    public void setBpaid(String bpaid) {
        this.bpaid = bpaid;
    }

    public String getZone() {
        return this.zone;
    }

    public void setZone(String zone) {
        this.zone = zone;
    }

    public String getGrade() {
        return this.grade;
    }

    public void setGrade(String grade) {
        this.grade = grade;
    }

    public String getDoorNo() {
        return this.doorNo;
    }

    public void setDoorNo(String doorNo) {
        this.doorNo = doorNo;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public Long getMonthlyRate() {
        return this.monthlyRate;
    }

    public void setMonthlyRate(Long monthlyRate) {
        this.monthlyRate = monthlyRate;
    }

    public Long getWaterTaxDue() {
        return this.waterTaxDue;
    }

    public void setWaterTaxDue(Long waterTaxDue) {
        this.waterTaxDue = waterTaxDue;
    }

    public String getLocality() {
        return this.locality;
    }

    public void setLocality(String locality) {
        this.locality = locality;
    }

    public Long getArrearsDue() {
        return this.arrearsDue;
    }

    public void setArrearsDue(Long arrearsDue) {
        this.arrearsDue = arrearsDue;
    }

    public Long getCurrentDue() {
        return this.currentDue;
    }

    public void setCurrentDue(Long currentDue) {
        this.currentDue = currentDue;
    }

    public Long getArrearsDemand() {
        return this.arrearsDemand;
    }

    public void setArrearsDemand(Long arrearsDemand) {
        this.arrearsDemand = arrearsDemand;
    }

    public Long getCurrentDemand() {
        return this.currentDemand;
    }

    public void setCurrentDemand(Long currentDemand) {
        this.currentDemand = currentDemand;
    }

    public String getId() {
        return ApplicationThreadLocals.getCityCode() + "-" + this.consumerCode;
    }

    public String setId() {
        return this.id;
    }

    public String getClosureType() {
        return this.closureType;
    }

    public void setClosureType(String closureType) {
        this.closureType = closureType;
    }

    public String getWaterSource() {
        return this.waterSource;
    }

    public void setWaterSource(String waterSource) {
        this.waterSource = waterSource;
    }

    public boolean isLegacy() {
        return this.isLegacy;
    }

    public void setIsLegacy(boolean isLegacy) {
        this.isLegacy = isLegacy;
    }

    public Long getSumpCapacity() {
        return this.sumpCapacity;
    }

    public void setSumpCapacity(Long sumpCapacity) {
        this.sumpCapacity = sumpCapacity;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public Long getNumberOfPerson() {
        return this.numberOfPerson;
    }

    public void setNumberOfPerson(Long numberOfPerson) {
        this.numberOfPerson = numberOfPerson;
    }

    public Long getTotalDue() {
        return this.totalDue;
    }

    public void setTotalDue(Long totalDue) {
        this.totalDue = totalDue;
    }

    public String getUsage() {
        return this.usage;
    }

    public void setUsage(String usage) {
        this.usage = usage;
    }

    public String getPropertyType() {
        return this.propertyType;
    }

    public void setPropertyType(String propertyType) {
        this.propertyType = propertyType;
    }

    public String getUlbName() {
        return this.ulbName;
    }

    public void setUlbName(String ulbName) {
        this.ulbName = ulbName;
    }

    public String getConsumerCode() {
        return this.consumerCode;
    }

    public void setConsumerCode(String consumerCode) {
        this.consumerCode = consumerCode;
    }

    public String getWard() {
        return this.ward;
    }

    public void setWard(String ward) {
        this.ward = ward;
    }

    public String getApplicationCode() {
        return this.applicationCode;
    }

    public void setApplicationCode(String applicationCode) {
        this.applicationCode = applicationCode;
    }

    public String getDistrictName() {
        return this.districtName;
    }

    public void setDistrictName(String districtName) {
        this.districtName = districtName;
    }

    public String getAdminWard() {
        return this.adminWard;
    }

    public void setAdminWard(String adminWard) {
        this.adminWard = adminWard;
    }

    public String getRegionName() {
        return this.regionName;
    }

    public void setRegionName(String regionName) {
        this.regionName = regionName;
    }

    public String getPipeSize() {
        return this.pipeSize;
    }

    public void setPipeSize(String pipeSize) {
        this.pipeSize = pipeSize;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    public String getPropertyId() {
        return this.propertyId;
    }

    public void setPropertyId(String propertyId) {
        this.propertyId = propertyId;
    }

    public String getAadhaarNumber() {
        return this.aadhaarNumber;
    }

    public void setAadhaarNumber(String aadhaarNumber) {
        this.aadhaarNumber = aadhaarNumber;
    }

    public String getConsumerName() {
        return this.consumerName;
    }

    public void setConsumerName(String consumerName) {
        this.consumerName = consumerName;
    }

    public GeoPoint getWardlocation() {
        return this.wardlocation;
    }

    public void setWardlocation(GeoPoint wardlocation) {
        this.wardlocation = wardlocation;
    }

    public GeoPoint getPropertylocation() {
        return this.propertylocation;
    }

    public void setPropertylocation(GeoPoint propertylocation) {
        this.propertylocation = propertylocation;
    }

    public static final class Builder {
        private String aadhaarNumber;
        private String adminWard;
        private String applicationCode;
        private Long arrearsDemand;
        private Long arrearsDue;
        private Long waterTaxDue;
        private Long totalDue;
        private String status;
        private String category;
        private String closureType;
        private String connectionType;
        private String consumerCode;
        private String consumerName;
        private Date createdDate;
        private Long currentDemand;
        private Long currentDue;
        private String doorNo;
        private String districtName;
        private String ulbName;
        private String grade;
        private Boolean isLegacy;
        private Long sumpCapacity;
        private Long numberOfPerson;
        private String zone;
        private String regionName;
        private String pipeSize;
        private String propertyId;
        private Long monthlyRate;
        private String mobileNumber;
        private String locality;
        private String propertyType;
        private String waterSource;
        private String ward;
        private String usage;
        private GeoPoint wardLocation;
        private GeoPoint propertyLocation;

        private Builder() {
        }

        public Builder withWardlocation(GeoPoint wardlocation) {
            this.wardLocation = wardlocation;
            return this;
        }

        public Builder withPropertylocation(GeoPoint propertylocation) {
            this.propertyLocation = propertylocation;
            return this;
        }

        public Builder withAadhaarnumber(String aadharNumber) {
            this.aadhaarNumber = aadharNumber;
            return this;
        }

        public Builder withUsage(String usage) {
            this.usage = usage;
            return this;
        }

        public Builder withAdminward(String adminward) {
            this.adminWard = adminward;
            return this;
        }

        public Builder with(String aapplicationcode) {
            this.applicationCode = aapplicationcode;
            return this;
        }

        public Builder withApplicationcode(String aapplicationcode) {
            this.applicationCode = aapplicationcode;
            return this;
        }

        public Builder withSumpcapacity(Long sumpcapacity) {
            this.sumpCapacity = sumpcapacity;
            return this;
        }

        public Builder withArrearsDemand(Long arrearsDemand) {
            this.arrearsDemand = arrearsDemand;
            return this;
        }

        public Builder withArrearsDue(Long arrearsDue) {
            this.arrearsDue = arrearsDue;
            return this;
        }

        public Builder withWaterTaxDue(Long waterTaxDue) {
            this.waterTaxDue = waterTaxDue;
            return this;
        }

        public Builder withTotaldue(Long totaldue) {
            this.totalDue = totaldue;
            return this;
        }

        public Builder withStatus(String status) {
            this.status = status;
            return this;
        }

        public Builder withCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder withClosureType(String closureType) {
            this.closureType = closureType;
            return this;
        }

        public Builder withConnectiontype(String connectiontype) {
            this.connectionType = connectiontype;
            return this;
        }

        public Builder withConsumerCode(String consumerCode) {
            this.consumerCode = consumerCode;
            return this;
        }

        public Builder withConsumername(String consumername) {
            this.consumerName = consumername;
            return this;
        }

        public Builder withCurrentDemand(Long currentDemand) {
            this.currentDemand = currentDemand;
            return this;
        }

        public Builder withCreatedDate(Date createdDate) {
            this.createdDate = createdDate;
            return this;
        }

        public Builder withCurrentDue(Long currentDue) {
            this.currentDue = currentDue;
            return this;
        }

        public Builder withDistrictName(String districtname) {
            this.districtName = districtname;
            return this;
        }

        public Builder withDoorNo(String doorNo) {
            this.doorNo = doorNo;
            return this;
        }

        public Builder withGrade(String grade) {
            this.grade = grade;
            return this;
        }

        public Builder withNumberOfPerson(Long numberofperson) {
            this.numberOfPerson = numberofperson;
            return this;
        }

        public Builder withMobileNumber(String mobilenumber) {
            this.mobileNumber = mobilenumber;
            return this;
        }

        public Builder withMonthlyRate(Long monthlyRate) {
            this.monthlyRate = monthlyRate;
            return this;
        }

        public Builder withRegionname(String regionname) {
            this.regionName = regionname;
            return this;
        }

        public Builder withIslegacy(Boolean islegacy) {
            this.isLegacy = islegacy;
            return this;
        }

        public Builder withLocality(String locality) {
            this.locality = locality;
            return this;
        }

        public Builder withPropertyid(String propertyid) {
            this.propertyId = propertyid;
            return this;
        }

        public Builder withPropertytype(String propertytype) {
            this.propertyType = propertytype;
            return this;
        }

        public Builder withPipesize(String pipesize) {
            this.pipeSize = pipesize;
            return this;
        }

        public Builder withUlbname(String ulbname) {
            this.ulbName = ulbname;
            return this;
        }

        public Builder withWatersource(String watersource) {
            this.waterSource = watersource;
            return this;
        }

        public Builder withZone(String zone) {
            this.zone = zone;
            return this;
        }

        public Builder withWard(String ward) {
            this.ward = ward;
            return this;
        }

        public Builder withWard(Long waterTaxDue) {
            this.waterTaxDue = waterTaxDue;
            return this;
        }

        public WaterChargeDocument build() {
            WaterChargeDocument waterChargeIndex = new WaterChargeDocument();
            waterChargeIndex.setWardlocation(this.wardLocation);
            waterChargeIndex.setPropertylocation(this.propertyLocation);
            waterChargeIndex.setAadhaarNumber(this.aadhaarNumber);
            waterChargeIndex.setAdminWard(this.adminWard);
            waterChargeIndex.setApplicationCode(this.applicationCode);
            waterChargeIndex.setArrearsDemand(this.arrearsDemand);
            waterChargeIndex.setArrearsDue(this.arrearsDue);
            waterChargeIndex.setWaterTaxDue(this.waterTaxDue);
            waterChargeIndex.setTotalDue(this.totalDue);
            waterChargeIndex.setStatus(this.status);
            waterChargeIndex.setCategory(this.category);
            waterChargeIndex.setClosureType(this.closureType);
            waterChargeIndex.setConnectionType(this.connectionType);
            waterChargeIndex.setConsumerCode(this.consumerCode);
            waterChargeIndex.setConsumerName(this.consumerName);
            waterChargeIndex.setCreatedDate(this.createdDate);
            waterChargeIndex.setCurrentDemand(this.currentDemand);
            waterChargeIndex.setCurrentDue(this.currentDue);
            waterChargeIndex.setDistrictName(this.districtName);
            waterChargeIndex.setDoorNo(this.doorNo);
            waterChargeIndex.setPipeSize(this.pipeSize);
            waterChargeIndex.setNumberOfPerson(this.numberOfPerson);
            waterChargeIndex.setCreatedDate(this.createdDate);
            waterChargeIndex.setUlbName(this.ulbName);
            waterChargeIndex.setGrade(this.grade);
            waterChargeIndex.setUsage(this.usage);
            waterChargeIndex.setIsLegacy(this.isLegacy);
            waterChargeIndex.setLocality(this.locality);
            waterChargeIndex.setPropertyId(this.propertyId);
            waterChargeIndex.setPropertyType(this.propertyType);
            waterChargeIndex.setRegionName(this.regionName);
            waterChargeIndex.setMobileNumber(this.mobileNumber);
            waterChargeIndex.setMonthlyRate(this.monthlyRate);
            waterChargeIndex.setSumpCapacity(this.sumpCapacity);
            waterChargeIndex.setWaterSource(this.waterSource);
            waterChargeIndex.setWard(this.ward);
            waterChargeIndex.setZone(this.zone);
            return waterChargeIndex;
        }
    }
}

