/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.entity;

import java.math.BigDecimal;
import java.util.Date;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.SequenceGenerator;
import javax.persistence.Table;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.egov.infra.persistence.entity.AbstractAuditable;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.hibernate.validator.constraints.Length;
import org.hibernate.validator.constraints.SafeHtml;

@Entity
@Table(name="egwtr_legacy_receipts")
@SequenceGenerator(name="seq_egwtr_legacy_receipts", sequenceName="seq_egwtr_legacy_receipts", allocationSize=1)
public class LegacyReceipts
extends AbstractAuditable {
    private static final long serialVersionUID = 8604331107634946265L;
    public static final String SEQ_LEGACY_RECEIPTS = "seq_egwtr_legacy_receipts";
    @Id
    @GeneratedValue(generator="seq_egwtr_legacy_receipts", strategy=GenerationType.SEQUENCE)
    private Long id;
    @NotNull
    @ManyToOne
    @JoinColumn(name="connectiondetails")
    private WaterConnectionDetails waterConnectionDetails;
    private String bookNumber;
    @NotNull
    @SafeHtml
    @Length(max=50)
    private String receiptNumber;
    @NotNull
    @Temporal(value=TemporalType.DATE)
    private Date receiptDate;
    @Temporal(value=TemporalType.DATE)
    private Date fromDate;
    @Temporal(value=TemporalType.DATE)
    private Date toDate;
    @NotNull
    @Min(value=1L)
    private BigDecimal amount;

    public Long getId() {
        return this.id;
    }

    protected void setId(Long id) {
        this.id = id;
    }

    public WaterConnectionDetails getWaterConnectionDetails() {
        return this.waterConnectionDetails;
    }

    public void setWaterConnectionDetails(WaterConnectionDetails waterConnectionDetails) {
        this.waterConnectionDetails = waterConnectionDetails;
    }

    public String getBookNumber() {
        return this.bookNumber;
    }

    public void setBookNumber(String bookNumber) {
        this.bookNumber = bookNumber;
    }

    public String getReceiptNumber() {
        return this.receiptNumber;
    }

    public void setReceiptNumber(String receiptNumber) {
        this.receiptNumber = receiptNumber;
    }

    public Date getReceiptDate() {
        return this.receiptDate;
    }

    public void setReceiptDate(Date receiptDate) {
        this.receiptDate = receiptDate;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public BigDecimal getAmount() {
        return this.amount;
    }

    public void setAmount(BigDecimal amount) {
        this.amount = amount;
    }
}

