/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.utils;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import org.egov.commons.EgwStatus;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.demand.model.EgDemand;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.eis.service.DesignationService;
import org.egov.eis.service.PositionMasterService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.messaging.MessagingService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.State;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.entity.WaterDemandConnection;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterDemandConnectionService;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.context.i18n.LocaleContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.web.bind.annotation.ModelAttribute;

@Service
public class WaterTaxUtils {
    @Qualifier(value="entityQueryService")
    @Autowired
    private PersistenceService entityQueryService;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private CityService cityService;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private PositionMasterService positionMasterService;
    @Autowired
    private MessagingService messagingService;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource wcmsMessageSource;
    @Autowired
    private UserService userService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private WaterDemandConnectionService waterDemandConnectionService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private InstallmentDao installmentDao;

    public List<AppConfigValues> getAppConfigValueByModuleNameAndKeyName(String moduleName, String keyName) {
        List appconfigValuesList = this.appConfigValuesService.getConfigValuesByModuleAndKey(moduleName, keyName);
        return appconfigValuesList;
    }

    public Boolean isSmsEnabled() {
        AppConfigValues appConfigValue = this.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", "SENDSMSFORWATERTAX").get(0);
        return "YES".equalsIgnoreCase(appConfigValue.getValue());
    }

    public String getDepartmentForWorkFlow() {
        String department = "";
        List<AppConfigValues> appConfigValue = this.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", "DEPARTMENTFORWORKFLOW");
        if (null != appConfigValue && !appConfigValue.isEmpty()) {
            department = appConfigValue.get(0).getValue();
        }
        return department;
    }

    public String getDesignationForThirdPartyUser() {
        String designation = "";
        List<AppConfigValues> appConfigValue = this.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", "CLERKDESIGNATIONFORCSCOPERATOR");
        if (null != appConfigValue && !appConfigValue.isEmpty()) {
            designation = appConfigValue.get(0).getValue();
        }
        return designation;
    }

    public List<AppConfigValues> getThirdPartyUserRoles() {
        List<AppConfigValues> appConfigValueList = this.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", "ROLEFORNONEMPLOYEEINWATERTAX");
        return !appConfigValueList.isEmpty() ? appConfigValueList : null;
    }

    public List<AppConfigValues> getUserRolesForLoggedInUser() {
        List appConfigValueList = this.appConfigValuesService.getConfigValuesByModuleAndKeyByValueAsc("Water Tax Management", "RolesForSearchWAterTaxConnection");
        return !appConfigValueList.isEmpty() ? appConfigValueList : null;
    }

    public Boolean getAppconfigValueForSchedulearEnabled() {
        Boolean schedularEnabled = Boolean.FALSE;
        AppConfigValues appConfigValueObj = (AppConfigValues)this.appConfigValuesService.getConfigValuesByModuleAndKeyByValueAsc("Water Tax Management", "ENABLEBILLSCHEDULAR").get(0);
        if (appConfigValueObj != null && appConfigValueObj.getValue() != null && appConfigValueObj.getValue().equals("YES")) {
            schedularEnabled = Boolean.TRUE;
        }
        return schedularEnabled;
    }

    public Boolean getCurrentUserRole(User currentUser) {
        Boolean applicationByOthers = false;
        block0: for (Role userrole : currentUser.getRoles()) {
            for (AppConfigValues appconfig : this.getThirdPartyUserRoles()) {
                if (userrole == null || !userrole.getName().equals(appconfig.getValue())) continue;
                applicationByOthers = true;
                continue block0;
            }
        }
        return applicationByOthers;
    }

    public Boolean isMeesevaUser(User user) {
        for (Role role : user.getRoles()) {
            if (role == null || !role.getName().equalsIgnoreCase("MeeSeva Operator")) continue;
            return true;
        }
        return false;
    }

    public Boolean isEmailEnabled() {
        AppConfigValues appConfigValue = this.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", "SENDEMAILFORWATERTAX").get(0);
        return "YES".equalsIgnoreCase(appConfigValue.getValue());
    }

    public Boolean isNewConnectionAllowedIfPTDuePresent() {
        AppConfigValues appConfigValue = this.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", "NEWCONNECTIONALLOWEDIFPTDUE").get(0);
        return "YES".equalsIgnoreCase(appConfigValue.getValue());
    }

    public Boolean isMultipleNewConnectionAllowedForPID() {
        AppConfigValues appConfigValue = this.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", "MULTIPLENEWCONNECTIONFORPID").get(0);
        return "YES".equalsIgnoreCase(appConfigValue.getValue());
    }

    public Boolean isConnectionAllowedIfWTDuePresent(String connectionType) {
        Boolean isAllowed = false;
        List<AppConfigValues> appConfigValue = this.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", connectionType);
        if (null != appConfigValue && !appConfigValue.isEmpty()) {
            return "YES".equalsIgnoreCase(appConfigValue.get(0).getValue());
        }
        return isAllowed;
    }

    public String documentRequiredForBPLCategory() {
        String documentName = null;
        List<AppConfigValues> appConfigValue = this.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", "DOCUMENTREQUIREDFORBPL");
        if (appConfigValue != null && !appConfigValue.isEmpty()) {
            documentName = appConfigValue.get(0).getValue();
        }
        return documentName;
    }

    public String getMunicipalityName() {
        return ApplicationThreadLocals.getMunicipalityName();
    }

    public String getCityCode() {
        return this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName()).getCode();
    }

    public String smsAndEmailBodyByCodeAndArgsForRejection(String code, String approvalComment, String applicantName) {
        Locale locale = LocaleContextHolder.getLocale();
        String smsMsg = this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, approvalComment, this.getMunicipalityName()}, locale);
        return smsMsg;
    }

    public String emailBodyforApprovalEmailByCodeAndArgs(String code, WaterConnectionDetails waterConnectionDetails, String applicantName) {
        Locale locale = LocaleContextHolder.getLocale();
        String smsMsg = this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicantName, waterConnectionDetails.getApplicationNumber(), waterConnectionDetails.getConnection().getConsumerCode(), this.getMunicipalityName()}, locale);
        return smsMsg;
    }

    public String emailSubjectforEmailByCodeAndArgs(String code, String applicationNumber) {
        Locale locale = LocaleContextHolder.getLocale();
        String emailSubject = this.wcmsMessageSource.getMessage(code, (Object[])new String[]{applicationNumber}, locale);
        return emailSubject;
    }

    public void sendSMSOnWaterConnection(String mobileNumber, String smsBody) {
        this.messagingService.sendSMS(mobileNumber, smsBody);
    }

    public void sendEmailOnWaterConnection(String email, String emailBody, String emailSubject) {
        this.messagingService.sendEmail(email, emailSubject, emailBody);
    }

    public Position getCityLevelCommissionerPosition(String commissionerDesgn, String assessmentNumber) {
        String[] degnName = commissionerDesgn.split(",");
        if (degnName.length > 1) {
            // empty if block
        }
        Designation desgnObj = this.designationService.getDesignationByName(commissionerDesgn);
        if (commissionerDesgn.equals("Commissioner")) {
            Department deptObj = this.departmentService.getDepartmentByName("Administration");
            List assignlist = null;
            assignlist = this.assignmentService.getAssignmentsByDeptDesigAndDates(deptObj.getId(), desgnObj.getId(), new Date(), new Date());
            if (assignlist.isEmpty()) {
                assignlist = this.assignmentService.getAllPositionsByDepartmentAndDesignationForGivenRange(null, desgnObj.getId(), new Date());
            }
            if (assignlist.isEmpty()) {
                assignlist = this.assignmentService.getAllActiveAssignments(desgnObj.getId());
            }
            return ((Assignment)assignlist.get(0)).getPosition();
        }
        Position userPosition = this.getZonalLevelClerkForLoggedInUser(assessmentNumber);
        return userPosition;
    }

    public String getApproverUserName(Long approvalPosition) {
        Assignment assignment = null;
        if (approvalPosition != null) {
            assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(approvalPosition, new Date());
        }
        return assignment != null ? assignment.getEmployee().getUsername() : "";
    }

    public String getApproverName(Long approvalPosition) {
        Assignment assignment = null;
        List<Object> asignList = null;
        if (approvalPosition != null) {
            assignment = this.assignmentService.getPrimaryAssignmentForPositionAndDate(approvalPosition, new Date());
        }
        if (assignment != null) {
            asignList = new ArrayList<Assignment>();
            asignList.add(assignment);
        } else if (assignment == null) {
            asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
        }
        return !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getEmployee().getName() : "";
    }

    public EgwStatus getStatusByCodeAndModuleType(String code, String moduleName) {
        return (EgwStatus)this.persistenceService.find("from EgwStatus where moduleType=? and code=?", new Object[]{moduleName, code});
    }

    public Long getApproverPosition(String designationName, WaterConnectionDetails waterConnectionDetails) {
        List stateHistoryList = waterConnectionDetails.getStateHistory();
        Long approverPosition = 0L;
        String[] desgnArray = designationName.split(",");
        User currentUser = null;
        if (stateHistoryList != null && !stateHistoryList.isEmpty()) {
            currentUser = this.userService.getUserById(waterConnectionDetails.getCreatedBy().getId());
            if (currentUser != null && waterConnectionDetails.getLegacy().equals(true)) {
                for (Role userrole : currentUser.getRoles()) {
                    if (!userrole.getName().equals("Super User")) continue;
                    Position positionuser = this.getZonalLevelClerkForLoggedInUser(waterConnectionDetails.getConnection().getPropertyIdentifier());
                    approverPosition = positionuser.getId();
                    break;
                }
            } else {
                for (StateHistory stateHistory : stateHistoryList) {
                    if (stateHistory.getOwnerPosition() == null) continue;
                    List assignmentList = this.assignmentService.getAssignmentsForPosition(stateHistory.getOwnerPosition().getId(), new Date());
                    Iterator iterator = assignmentList.iterator();
                    block2: while (iterator.hasNext()) {
                        Assignment assgn = (Assignment)iterator.next();
                        for (String str : desgnArray) {
                            if (!assgn.getDesignation().getName().equalsIgnoreCase(str)) continue;
                            approverPosition = stateHistory.getOwnerPosition().getId();
                            continue block2;
                        }
                    }
                }
                if (approverPosition == 0L) {
                    State stateObj = waterConnectionDetails.getState();
                    List assignmentList = this.assignmentService.getAssignmentsForPosition(stateObj.getOwnerPosition().getId(), new Date());
                    for (Assignment assgn : assignmentList) {
                        if (!assgn.getDesignation().getName().equalsIgnoreCase(designationName)) continue;
                        approverPosition = stateObj.getOwnerPosition().getId();
                        break;
                    }
                }
            }
        } else {
            currentUser = this.userService.getUserById(waterConnectionDetails.getCreatedBy().getId());
            if (currentUser != null && waterConnectionDetails.getLegacy().equals(true)) {
                for (Role userrole : currentUser.getRoles()) {
                    if (!userrole.getName().equals("Super User")) continue;
                    Position positionuser = this.getZonalLevelClerkForLoggedInUser(waterConnectionDetails.getConnection().getPropertyIdentifier());
                    approverPosition = positionuser.getId();
                    break;
                }
            } else {
                Position posObjToClerk = this.positionMasterService.getCurrentPositionForUser(waterConnectionDetails.getCreatedBy().getId());
                approverPosition = posObjToClerk.getId();
            }
        }
        return approverPosition;
    }

    public Position getZonalLevelClerkForLoggedInUser(String asessmentNumber) {
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(asessmentNumber, PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
        Assignment assignmentObj = null;
        Boundary boundaryObj = this.boundaryService.getBoundaryById(assessmentDetails.getBoundaryDetails().getAdminWardId());
        assignmentObj = this.getUserPositionByZone(asessmentNumber, assessmentDetails, boundaryObj);
        return assignmentObj != null ? assignmentObj.getPosition() : null;
    }

    public Assignment getUserPositionByZone(String asessmentNumber, AssessmentDetails assessmentDetails, Boundary boundaryObj) {
        String designationStr = this.getDesignationForThirdPartyUser();
        String departmentStr = this.getDepartmentForWorkFlow();
        String[] department = departmentStr.split(",");
        String[] designation = designationStr.split(",");
        List assignment = new ArrayList();
        for (String dept : department) {
            for (String desg : designation) {
                assignment = this.assignmentService.findByDepartmentDesignationAndBoundary(this.departmentService.getDepartmentByName(dept).getId(), this.designationService.getDesignationByName(desg).getId(), boundaryObj.getId());
                if (!assignment.isEmpty()) break;
            }
            if (!assignment.isEmpty()) break;
        }
        return !assignment.isEmpty() ? (Assignment)assignment.get(0) : null;
    }

    @ModelAttribute(value="checkOperator")
    public Boolean checkCollectionOperatorRole() {
        User userObj;
        Boolean isCSCOperator = false;
        if (ApplicationThreadLocals.getUserId() != null && (userObj = this.userService.getUserById(ApplicationThreadLocals.getUserId())) != null) {
            for (Role role : userObj.getRoles()) {
                if (role == null || !role.getName().contains("Collection Operator")) continue;
                isCSCOperator = true;
                break;
            }
        }
        return isCSCOperator;
    }

    public List<Installment> getInstallmentListByStartDate(Date startDate) {
        return this.entityQueryService.findAllByNamedQuery("INSTALLMENTLISTBY_MODULE_AND_STARTYEAR", new Object[]{startDate, startDate, "Property Tax"});
    }

    public List<Installment> getInstallmentsForCurrYear(Date currDate) {
        Module module = this.moduleService.getModuleByName("Property Tax");
        List installments = this.installmentDao.getAllInstallmentsByModuleAndStartDate(module, currDate);
        return installments;
    }

    public Double waterConnectionDue(long parentId) {
        BigDecimal waterTaxDueforParent = BigDecimal.ZERO;
        List<WaterConnectionDetails> waterConnectionDetails = this.waterConnectionDetailsService.getAllConnectionDetailsByParentConnection(parentId);
        for (WaterConnectionDetails waterconnectiondetails : waterConnectionDetails) {
            waterTaxDueforParent = waterTaxDueforParent.add(this.waterConnectionDetailsService.getTotalAmount(waterconnectiondetails));
        }
        return waterTaxDueforParent.doubleValue();
    }

    public WaterDemandConnection getCurrentDemand(WaterConnectionDetails waterConnectionDetails) {
        WaterDemandConnection waterdemandConnection = new WaterDemandConnection();
        List<WaterDemandConnection> waterDemandConnectionList = this.waterDemandConnectionService.findByWaterConnectionDetails(waterConnectionDetails);
        for (WaterDemandConnection waterDemandConnection : waterDemandConnectionList) {
            if (!waterDemandConnection.getDemand().getIsHistory().equalsIgnoreCase("N")) continue;
            waterdemandConnection = waterDemandConnection;
            break;
        }
        return waterdemandConnection;
    }

    public List<EgDemand> getAllDemand(WaterConnectionDetails waterConnectionDetails) {
        ArrayList<EgDemand> demandList = new ArrayList<EgDemand>();
        List<WaterDemandConnection> waterDemandConnectionList = this.waterDemandConnectionService.findByWaterConnectionDetails(waterConnectionDetails);
        for (WaterDemandConnection waterDemandConnection : waterDemandConnectionList) {
            demandList.add(waterDemandConnection.getDemand());
        }
        return demandList;
    }

    public Boolean getCitizenUserRole() {
        Boolean citizenrole = Boolean.FALSE;
        if (ApplicationThreadLocals.getUserId() != null) {
            User currentUser = this.userService.getUserById(ApplicationThreadLocals.getUserId());
            if (currentUser.getRoles().isEmpty() && this.securityUtils.getCurrentUser().getUsername().equals("anonymous")) {
                citizenrole = Boolean.TRUE;
            }
            for (Role userrole : currentUser.getRoles()) {
                if (userrole == null || !userrole.getName().equals("Citizen")) continue;
                citizenrole = Boolean.TRUE;
                break;
            }
        } else {
            citizenrole = Boolean.TRUE;
        }
        return citizenrole;
    }

    public Boolean isDigitalSignatureEnabled() {
        List<AppConfigValues> appConfigValue = this.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", "ENABLEDIGITALSIGNATURE");
        if (null != appConfigValue && !appConfigValue.isEmpty()) {
            return "YES".equalsIgnoreCase(appConfigValue.get(0).getValue());
        }
        return false;
    }
}

