/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.service;

import java.util.ArrayList;
import java.util.List;
import org.egov.wtms.masters.entity.PropertyType;
import org.egov.wtms.masters.repository.PropertyTypeRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class PropertyTypeService {
    private final PropertyTypeRepository propertyTypeRepository;

    @Autowired
    public PropertyTypeService(PropertyTypeRepository propertyTypeRepository) {
        this.propertyTypeRepository = propertyTypeRepository;
    }

    public PropertyType findBy(Long propertyTypeId) {
        return (PropertyType)((Object)this.propertyTypeRepository.findOne(propertyTypeId));
    }

    @Transactional
    public PropertyType createPropertyType(PropertyType propertyType) {
        return (PropertyType)((Object)this.propertyTypeRepository.save((Object)propertyType));
    }

    @Transactional
    public void updatePropertyType(PropertyType propertyType) {
        this.propertyTypeRepository.save((Object)propertyType);
    }

    public List<PropertyType> findAll() {
        return this.propertyTypeRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"name"}));
    }

    public List<PropertyType> findAllByNameLike(String name) {
        return this.propertyTypeRepository.findByNameContainingIgnoreCase(name);
    }

    public PropertyType findByName(String name) {
        return this.propertyTypeRepository.findByName(name);
    }

    public PropertyType load(Long id) {
        return (PropertyType)((Object)this.propertyTypeRepository.getOne(id));
    }

    public Page<PropertyType> getListOfPropertyTypes(Integer pageNumber, Integer pageSize) {
        PageRequest pageable = new PageRequest(pageNumber - 1, pageSize.intValue(), Sort.Direction.ASC, new String[]{"name"});
        return this.propertyTypeRepository.findAll((Pageable)pageable);
    }

    public PropertyType findByCode(String code) {
        return this.propertyTypeRepository.findByCode(code);
    }

    public List<PropertyType> getAllActivePropertyTypes() {
        return this.propertyTypeRepository.findByActiveTrueOrderByNameAsc();
    }

    public List<PropertyType> getPropertyTypeListForRest() {
        List<PropertyType> propertyTypeList = this.propertyTypeRepository.findByActiveTrueOrderByNameAsc();
        ArrayList<PropertyType> prepareListForRest = new ArrayList<PropertyType>(0);
        for (PropertyType propertyType : propertyTypeList) {
            PropertyType propertyTypeRest = new PropertyType();
            propertyTypeRest.setCode(propertyType.getCode());
            propertyTypeRest.setName(propertyType.getName());
            propertyTypeRest.setConnectionEligibility(propertyType.getConnectionEligibility());
            propertyTypeRest.setActive(propertyType.isActive());
            prepareListForRest.add(propertyTypeRest);
        }
        return prepareListForRest;
    }
}

