/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.math.BigDecimal;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.repository.WaterConnectionDetailsRepository;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.workflow.ApplicationWorkflowCustomDefaultImpl;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CloserConnectionService {
    @Autowired
    private WaterConnectionDetailsRepository waterConnectionDetailsRepository;
    @Autowired
    @Qualifier(value="parentMessageSource")
    private MessageSource wcmsMessageSource;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    public static final String CHANGEOFUSEALLOWEDIFWTDUE = "CHANGEOFUSEALLOWEDIFWTDUE";

    public String validateChangeOfUseConnection(WaterConnectionDetails parentWaterConnectionDetail) {
        String validationMessage = "";
        String propertyID = parentWaterConnectionDetail.getConnection().getPropertyIdentifier();
        WaterConnectionDetails inWorkflow = this.waterConnectionDetailsRepository.getConnectionDetailsInWorkflow(propertyID, ConnectionStatus.INPROGRESS);
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(propertyID, PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
        if (parentWaterConnectionDetail.getConnectionStatus().equals((Object)ConnectionStatus.HOLDING)) {
            validationMessage = this.wcmsMessageSource.getMessage("err.validate.primary.connection.holding", (Object[])new String[]{parentWaterConnectionDetail.getConnection().getConsumerCode(), propertyID}, null);
        } else if (parentWaterConnectionDetail.getConnectionStatus().equals((Object)ConnectionStatus.DISCONNECTED)) {
            validationMessage = this.wcmsMessageSource.getMessage("err.validate.primary.connection.disconnected", (Object[])new String[]{parentWaterConnectionDetail.getConnection().getConsumerCode(), propertyID}, null);
        } else if (null != assessmentDetails.getErrorDetails() && null != assessmentDetails.getErrorDetails().getErrorCode()) {
            validationMessage = assessmentDetails.getErrorDetails().getErrorMessage();
        } else if (null != assessmentDetails.getPropertyDetails() && null != assessmentDetails.getPropertyDetails().getTaxDue() && assessmentDetails.getPropertyDetails().getTaxDue().doubleValue() > 0.0) {
            if (!this.waterTaxUtils.isNewConnectionAllowedIfPTDuePresent().booleanValue()) {
                validationMessage = this.wcmsMessageSource.getMessage("err.validate.property.taxdue", (Object[])new String[]{assessmentDetails.getPropertyDetails().getTaxDue().toString(), parentWaterConnectionDetail.getConnection().getPropertyIdentifier(), "Closure"}, null);
            }
        } else if (!this.waterTaxUtils.isConnectionAllowedIfWTDuePresent(CHANGEOFUSEALLOWEDIFWTDUE).booleanValue()) {
            BigDecimal waterTaxDueforParent = this.waterConnectionDetailsService.getCurrentDue(parentWaterConnectionDetail);
            if (waterTaxDueforParent.doubleValue() > 0.0) {
                validationMessage = this.wcmsMessageSource.getMessage("err.closure.connection.watertaxdue", null, null);
            }
        } else if (null != inWorkflow) {
            validationMessage = this.wcmsMessageSource.getMessage("err.validate.closeconnection.application.inprocess", (Object[])new String[]{parentWaterConnectionDetail.getConnection().getConsumerCode(), inWorkflow.getApplicationNumber()}, null);
        }
        return validationMessage;
    }

    @Transactional
    public WaterConnectionDetails updatecloserConnection(WaterConnectionDetails waterConnectionDetails, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, String sourceChannel) {
        this.waterConnectionDetailsService.applicationStatusChange(waterConnectionDetails, workFlowAction, "", sourceChannel);
        WaterConnectionDetails savedwaterConnectionDetails = (WaterConnectionDetails)((Object)this.waterConnectionDetailsRepository.saveAndFlush((Object)waterConnectionDetails));
        ApplicationWorkflowCustomDefaultImpl applicationWorkflowCustomDefaultImpl = this.waterConnectionDetailsService.getInitialisedWorkFlowBean();
        applicationWorkflowCustomDefaultImpl.createCommonWorkflowTransition(savedwaterConnectionDetails, approvalPosition, approvalComent, additionalRule, workFlowAction);
        this.waterConnectionDetailsService.updateIndexes(savedwaterConnectionDetails, sourceChannel);
        return savedwaterConnectionDetails;
    }
}

