/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.masters.service;

import java.util.List;
import org.egov.wtms.masters.entity.PipeSize;
import org.egov.wtms.masters.entity.UsageType;
import org.egov.wtms.masters.entity.WaterRatesHeader;
import org.egov.wtms.masters.entity.WaterSource;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.egov.wtms.masters.repository.WaterRatesHeaderRepository;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WaterRatesHeaderService {
    private final WaterRatesHeaderRepository waterRatesHeaderRepository;

    @Autowired
    public WaterRatesHeaderService(WaterRatesHeaderRepository waterRatesHeaderRepository) {
        this.waterRatesHeaderRepository = waterRatesHeaderRepository;
    }

    public WaterRatesHeader findBy(Long waterRatesHeaderId) {
        return (WaterRatesHeader)((Object)this.waterRatesHeaderRepository.findOne(waterRatesHeaderId));
    }

    @Transactional
    public void createWaterRatesHeader(WaterRatesHeader waterRatesHeader) {
        this.waterRatesHeaderRepository.save((Object)waterRatesHeader);
    }

    @Transactional
    public void updateWaterRatesHeader(WaterRatesHeader waterRatesHeader) {
        this.waterRatesHeaderRepository.save((Object)waterRatesHeader);
    }

    public List<WaterRatesHeader> findAll() {
        return this.waterRatesHeaderRepository.findAll(new Sort(Sort.Direction.DESC, new String[]{"connectionType", "usageType", "waterSource", "pipeSize"}));
    }

    public List<WaterRatesHeader> findAllByConnectionType(ConnectionType connectionType) {
        return this.waterRatesHeaderRepository.findAllByConnectionType(connectionType);
    }

    public List<WaterRatesHeader> findAllByUsageType(UsageType usageType) {
        return this.waterRatesHeaderRepository.findAllByUsageType(usageType);
    }

    public List<WaterRatesHeader> findAllByWaterSource(WaterSource waterSource) {
        return this.waterRatesHeaderRepository.findAllByWaterSource(waterSource);
    }

    public WaterRatesHeader load(Long id) {
        return (WaterRatesHeader)((Object)this.waterRatesHeaderRepository.getOne(id));
    }

    public List<WaterRatesHeader> findByConnectionTypeAndUsageTypeAndWaterSourceAndPipeSize(ConnectionType connectionType, UsageType usageType, WaterSource waterSource, PipeSize pipeSize) {
        return this.waterRatesHeaderRepository.findByConnectionTypeAndUsageTypeAndWaterSourceAndPipeSize(connectionType, usageType, waterSource, pipeSize);
    }
}

