/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.integration;

import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Scope;

@Scope(value="prototype")
public class WaterChargesThirdPartyService {
    public WaterConnectionDetails waterConnectionDetails;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    private final WaterConnectionDetailsService waterConnectionDetailsService;

    @Autowired
    public WaterChargesThirdPartyService(WaterConnectionDetailsService waterConnectionDetailsService) {
        this.waterConnectionDetailsService = waterConnectionDetailsService;
    }

    public byte[] getEstimationNotice(String applicationNo) throws IOException {
        if (StringUtils.isNotBlank((CharSequence)applicationNo)) {
            this.waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(applicationNo);
        }
        if (this.waterConnectionDetails != null && this.waterConnectionDetails.getFileStore() != null) {
            FileStoreMapper fsm = this.waterConnectionDetails.getFileStore();
            File file = this.fileStoreService.fetch(fsm, "WTMS");
            return FileUtils.readFileToByteArray((File)file);
        }
        return null;
    }

    public Map<String, String> validateWaterConnectionStatus(String applicationNo) {
        this.waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(applicationNo);
        HashMap<String, String> statusCommentsMap = new HashMap<String, String>();
        if (this.waterConnectionDetails.getStatus().getCode().equals("CREATED") || this.waterConnectionDetails.getStatus().getCode().equals("VERIFIED") || this.waterConnectionDetails.getStatus().getCode().equals("ESTIMATIONNOTICEGENERATED") || this.waterConnectionDetails.getStatus().getCode().equals("ESTIMATIONAMOUNTPAID")) {
            statusCommentsMap.put("status", "OPEN");
            statusCommentsMap.put("comments", this.waterConnectionDetails.getState().getComments());
            statusCommentsMap.put("updatedBy", this.waterConnectionDetails.getState().getLastModifiedBy().getName());
        } else if (this.waterConnectionDetails.getStatus().getCode().equals("SANCTIONED")) {
            statusCommentsMap.put("status", "APPROVED");
            statusCommentsMap.put("comments", this.waterConnectionDetails.getState().getComments());
            statusCommentsMap.put("updatedBy", this.waterConnectionDetails.getState().getLastModifiedBy().getName());
        } else if (this.waterConnectionDetails.getStatus().getCode().equals("CANCELLED")) {
            statusCommentsMap.put("status", "Rejected");
            statusCommentsMap.put("comments", this.waterConnectionDetails.getState().getComments());
            statusCommentsMap.put("updatedBy", this.waterConnectionDetails.getState().getLastModifiedBy().getName());
        }
        return statusCommentsMap;
    }
}

