/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.elasticSearch.entity;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import org.egov.search.domain.Filter;
import org.egov.search.domain.Filters;
import org.jboss.logging.Logger;

public class ApplicationSearchRequest {
    private String searchText;
    private String moduleName;
    private String applicationType;
    private String applicationNumber;
    private String consumerCode;
    private String applicantName;
    private String mobileNumber;
    private String fromDate;
    private String toDate;
    private String ulbName;
    private String source;
    SimpleDateFormat ft = new SimpleDateFormat("yyyy-MM-dd");
    SimpleDateFormat dtft = new SimpleDateFormat("dd/MM/yyyy");
    private static final Logger logger = Logger.getLogger(ApplicationSearchRequest.class);

    public void setFromDate(String fromDate) {
        if (null != fromDate) {
            try {
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Date Range From start.. :" + this.ft.format(this.dtft.parse(fromDate))));
                }
                this.fromDate = this.ft.format(this.dtft.parse(fromDate));
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public void setToDate(String toDate) {
        Calendar cal = Calendar.getInstance();
        if (null != toDate) {
            try {
                cal.setTime(this.dtft.parse(toDate));
                cal.add(6, 1);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("Date Range Till .. :" + this.ft.format(cal.getTime())));
                }
                this.toDate = this.ft.format(cal.getTime());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
        }
    }

    public String getModuleName() {
        return this.moduleName;
    }

    public void setModuleName(String moduleName) {
        this.moduleName = moduleName;
    }

    public String getApplicationType() {
        return this.applicationType;
    }

    public void setApplicationType(String applicationType) {
        this.applicationType = applicationType;
    }

    public String getApplicationNumber() {
        return this.applicationNumber;
    }

    public void setApplicationNumber(String applicationNumber) {
        this.applicationNumber = applicationNumber;
    }

    public String getConsumerCode() {
        return this.consumerCode;
    }

    public void setConsumerCode(String consumerCode) {
        this.consumerCode = consumerCode;
    }

    public String getApplicantName() {
        return this.applicantName;
    }

    public void setApplicantName(String applicantName) {
        this.applicantName = applicantName;
    }

    public String getMobileNumber() {
        return this.mobileNumber;
    }

    public void setMobileNumber(String mobileNumber) {
        this.mobileNumber = mobileNumber;
    }

    public String getFromDate() {
        return this.fromDate;
    }

    public String getToDate() {
        return this.toDate;
    }

    public String getUlbName() {
        return this.ulbName;
    }

    public void setUlbName(String ulbName) {
        this.ulbName = ulbName;
    }

    public void setSearchText(String searchText) {
        this.searchText = searchText;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public Filters searchFilters() {
        ArrayList<Filter> andFilters = new ArrayList<Filter>(0);
        andFilters.add(Filter.termsStringFilter((String)"clauses.ulbname", (String[])new String[]{this.ulbName}));
        andFilters.add(Filter.queryStringFilter((String)"searchable.applicationnumber", (String)this.applicationNumber));
        andFilters.add(Filter.termsStringFilter((String)"clauses.modulename", (String[])new String[]{this.moduleName}));
        andFilters.add(Filter.termsStringFilter((String)"clauses.applicationtype", (String[])new String[]{this.applicationType}));
        andFilters.add(Filter.termsStringFilter((String)"clauses.channel", (String[])new String[]{this.source}));
        andFilters.add(Filter.queryStringFilter((String)"searchable.applicantname", (String)this.applicantName));
        andFilters.add(Filter.queryStringFilter((String)"searchable.consumercode", (String)this.consumerCode));
        andFilters.add(Filter.queryStringFilter((String)"searchable.mobilenumber", (String)this.mobileNumber));
        andFilters.add(Filter.rangeFilter((String)"searchable.applicationdate", (String)this.fromDate, (String)this.toDate));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"finished filters");
        }
        logger.info((Object)("$$$$$$$$$$$$$$$$ Filters : " + andFilters));
        return Filters.withAndFilters(andFilters);
    }

    public String searchQuery() {
        return this.searchText;
    }
}

