/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service.collection;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang3.time.DateUtils;
import org.egov.commons.Installment;
import org.egov.demand.dao.DemandGenericDao;
import org.egov.demand.dao.EgBillDao;
import org.egov.demand.interfaces.BillServiceInterface;
import org.egov.demand.interfaces.Billable;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgBillDetails;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.collection.DemandComparatorByOrderId;
import org.egov.wtms.application.service.collection.WaterConnectionBillable;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.egov.wtms.utils.WaterTaxUtils;
import org.egov.wtms.utils.constants.WaterTaxConstants;
import org.hibernate.Session;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ConnectionBillService
extends BillServiceInterface {
    private static final String STRING_WCMS_FUCNTION_CODE = "5100";
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private EgBillDao egBillDAO;
    @Autowired
    private ApplicationContext context;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private ConnectionDemandService connectionDemandService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private DemandGenericDao demandGenericDAO;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public List<EgBillDetails> getBilldetails(Billable billObj) {
        ArrayList<EgBillDetails> billDetails = new ArrayList<EgBillDetails>();
        EgDemand demand = billObj.getCurrentDemand();
        Date currentDate = new Date();
        HashMap installmentWise = new HashMap();
        TreeSet<Installment> sortedInstallmentSet = new TreeSet<Installment>();
        DemandComparatorByOrderId demandComparatorByOrderId = new DemandComparatorByOrderId();
        ArrayList orderedDetailsList = new ArrayList();
        Installment currInstallment = this.connectionDemandService.getCurrentInstallment("Water Tax Management", "Yearly", new Date());
        new TreeMap();
        for (EgDemandDetails egDemandDetails : demand.getEgDemandDetails()) {
            Installment installment = egDemandDetails.getEgDemandReason().getEgInstallmentMaster();
            if (installmentWise.get(installment) == null) {
                ArrayList<EgDemandDetails> detailsList = new ArrayList<EgDemandDetails>();
                detailsList.add(egDemandDetails);
                installmentWise.put(egDemandDetails.getEgDemandReason().getEgInstallmentMaster(), detailsList);
                sortedInstallmentSet.add(installment);
                continue;
            }
            ((List)installmentWise.get(egDemandDetails.getEgDemandReason().getEgInstallmentMaster())).add(egDemandDetails);
        }
        for (Installment installment : sortedInstallmentSet) {
            List installmentWiseDetails = (List)installmentWise.get(installment);
            Collections.sort(installmentWiseDetails, demandComparatorByOrderId);
            orderedDetailsList.addAll(installmentWiseDetails);
        }
        int i = 1;
        for (EgDemandDetails demandDetail : orderedDetailsList) {
            EgDemandReason reason = demandDetail.getEgDemandReason();
            Installment installment = demandDetail.getEgDemandReason().getEgInstallmentMaster();
            if (!demandDetail.getEgDemandReason().getEgDemandReasonMaster().getIsDebit().equalsIgnoreCase("N") || demandDetail.getAmount().compareTo(demandDetail.getAmtCollected()) <= 0) continue;
            EgBillDetails billdetail = new EgBillDetails();
            if (demandDetail.getAmount() != null) {
                billdetail.setDrAmount(BigDecimal.ZERO);
                billdetail.setCrAmount(demandDetail.getAmount().subtract(demandDetail.getAmtCollected()));
            }
            LOGGER.info((Object)("demandDetail.getEgDemandReason()" + demandDetail.getEgDemandReason().getEgDemandReasonMaster().getReasonMaster() + " glcodeerror" + demandDetail.getEgDemandReason().getGlcodeId()));
            billdetail.setGlcode(demandDetail.getEgDemandReason().getGlcodeId().getGlcode());
            billdetail.setEgDemandReason(demandDetail.getEgDemandReason());
            billdetail.setAdditionalFlag(Integer.valueOf(1));
            billdetail.setCreateDate(currentDate);
            billdetail.setModifiedDate(currentDate);
            billdetail.setOrderNo(Integer.valueOf(i++));
            billdetail.setDescription(reason.getEgDemandReasonMaster().getReasonMaster() + " - " + installment.getDescription() + " # " + billObj.getCurrentDemand().getEgInstallmentMaster().getDescription());
            billdetail.setFunctionCode(STRING_WCMS_FUCNTION_CODE);
            if (currInstallment != null && installment.getFromDate().before(currInstallment.getToDate())) {
                billdetail.setAdditionalFlag(Integer.valueOf(1));
            } else {
                billdetail.setAdditionalFlag(Integer.valueOf(0));
            }
            billDetails.add(billdetail);
        }
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.getWaterConnectionDetailsByDemand(demand);
        if (waterConnectionDetails != null && waterConnectionDetails.getConnectionType().equals((Object)ConnectionType.NON_METERED)) {
            HashMap<String, Installment> currInstallments = new HashMap<String, Installment>();
            List<Installment> currInstallmentList = this.waterTaxUtils.getInstallmentsForCurrYear(new Date());
            currInstallments.put("Current 1st Half", currInstallmentList.get(0));
            if (currInstallmentList.size() > 0) {
                currInstallments.put("Current 2nd Half", currInstallmentList.get(1));
            }
            Date advanceStartDate = DateUtils.addYears((Date)((Installment)currInstallments.get("Current 1st Half")).getFromDate(), (int)1);
            List<Installment> advanceInstallments = this.getAdvanceInstallmentsList(advanceStartDate);
            HashMap<String, Integer> orderMap = this.generateOrderForDemandDetails(demand.getEgDemandDetails(), billObj, advanceInstallments, currInstallments);
            BigDecimal currentInstDemand = BigDecimal.ZERO;
            for (EgDemandDetails dmdDet : demand.getEgDemandDetails()) {
                if (!dmdDet.getInstallmentStartDate().equals(((Installment)currInstallments.get("Current 2nd Half")).getFromDate())) continue;
                currentInstDemand = currentInstDemand.add(dmdDet.getAmount());
            }
            this.createAdvanceBillDetails(billDetails, currentInstDemand, orderMap, demand, billObj, advanceInstallments, (Installment)currInstallments.get("Current 2nd Half"));
        }
        return billDetails;
    }

    private void createAdvanceBillDetails(List<EgBillDetails> billDetails, BigDecimal currentInstallmentDemand, HashMap<String, Integer> orderMap, EgDemand demand, Billable billable, List<Installment> advanceInstallments, Installment dmdDetInstallment) {
        BigDecimal advanceCollection = this.demandGenericDAO.getBalanceByDmdMasterCodeInst(demand, "WTADVANCE", this.moduleService.getModuleByName("Water Tax Management"), dmdDetInstallment);
        if (advanceCollection.compareTo(BigDecimal.ZERO) < 0) {
            advanceCollection = advanceCollection.abs();
        }
        BigDecimal partiallyCollectedAmount = BigDecimal.ZERO;
        if (currentInstallmentDemand.compareTo(BigDecimal.ZERO) > 0) {
            partiallyCollectedAmount = advanceCollection.remainder(currentInstallmentDemand);
        }
        Integer noOfAdvancesPaid = advanceCollection.subtract(partiallyCollectedAmount).divide(currentInstallmentDemand).intValue();
        LOGGER.debug((Object)("getBilldetails - advanceCollection = " + advanceCollection + ", noOfAdvancesPaid=" + noOfAdvancesPaid));
        Installment installment = null;
        int j = billDetails.size() + 1;
        if (noOfAdvancesPaid < WaterTaxConstants.MAX_ADVANCES_ALLOWED) {
            for (int i = noOfAdvancesPaid.intValue(); i < advanceInstallments.size(); ++i) {
                installment = advanceInstallments.get(i);
                EgDemandReason reasonmaster = this.connectionDemandService.getDemandReasonByCodeAndInstallment("WTADVANCE", installment);
                EgBillDetails billdetail = new EgBillDetails();
                billdetail.setDrAmount(BigDecimal.ZERO);
                billdetail.setCrAmount(currentInstallmentDemand);
                billdetail.setGlcode("3504106");
                billdetail.setEgDemandReason(reasonmaster);
                billdetail.setCreateDate(new Date());
                billdetail.setModifiedDate(new Date());
                j = billDetails.size() + 1;
                billdetail.setOrderNo(Integer.valueOf(j));
                billdetail.setDescription(reasonmaster.getEgDemandReasonMaster().getReasonMaster() + " - " + installment.getDescription());
                billdetail.setFunctionCode(STRING_WCMS_FUCNTION_CODE);
                billdetail.setAdditionalFlag(Integer.valueOf(0));
                billDetails.add(billdetail);
            }
        } else {
            LOGGER.debug((Object)"getBillDetails - All advances are paid...");
        }
    }

    public void cancelBill() {
    }

    public EgBill updateBillWithLatest(Long billId) {
        LOGGER.debug((Object)("updateBillWithLatest billId " + billId));
        EgBill bill = this.egBillDAO.findById(billId, false);
        LOGGER.debug((Object)("updateBillWithLatest old bill " + bill));
        if (bill == null) {
            throw new ApplicationRuntimeException("No bill found with bill reference no :" + billId);
        }
        bill.getEgBillDetails().clear();
        WaterConnectionBillable waterConnectionBillable = (WaterConnectionBillable)((Object)this.context.getBean("waterConnectionBillable"));
        waterConnectionBillable.setWaterConnectionDetails(this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCodeAndStatus(bill.getConsumerId().trim().toUpperCase(), ConnectionStatus.ACTIVE));
        List<EgBillDetails> egBillDetails = this.getBilldetails(waterConnectionBillable);
        for (EgBillDetails billDetail : egBillDetails) {
            bill.addEgBillDetails(billDetail);
            billDetail.setEgBill(bill);
        }
        LOGGER.debug((Object)("Bill update with bill details for water charges " + bill.getConsumerId() + " as billdetails " + egBillDetails));
        return bill;
    }

    public List<Installment> getAdvanceInstallmentsList(Date startDate) {
        ArrayList<Installment> advanceInstallments = new ArrayList();
        String query = "select inst from Installment inst where inst.module.name = 'Property Tax' and inst.fromDate >= :startdate order by inst.fromDate asc ";
        advanceInstallments = ((Session)this.entityManager.unwrap(Session.class)).createQuery("select inst from Installment inst where inst.module.name = 'Property Tax' and inst.fromDate >= :startdate order by inst.fromDate asc ").setParameter("startdate", (Object)startDate).setMaxResults(WaterTaxConstants.MAX_ADVANCES_ALLOWED.intValue()).list();
        return advanceInstallments;
    }

    public HashMap<String, Integer> generateOrderForDemandDetails(Set<EgDemandDetails> demandDetails, Billable billable, List<Installment> advanceInstallments, Map<String, Installment> currInstallments) {
        TreeMap<Date, String> instReasonMap = new TreeMap<Date, String>();
        HashMap<String, Integer> orderMap = new HashMap<String, Integer>();
        Date key = null;
        DateTime dateTime = null;
        for (Installment inst : advanceInstallments) {
            dateTime = new DateTime((Object)inst.getInstallmentYear());
            key = this.getOrder(inst.getInstallmentYear(), WaterTaxConstants.DEMAND_REASON_ORDER_MAP.get("WTADVANCE"));
            instReasonMap.put(key, dateTime.getMonthOfYear() + "/" + dateTime.getYear() + "-" + "WTADVANCE");
        }
        int order = 1;
        LinkedHashMap installmentAndReason = new LinkedHashMap();
        for (Map.Entry entry : instReasonMap.entrySet()) {
            String[] split = ((String)entry.getValue()).split("-");
            if (installmentAndReason.get(split[0]) == null) {
                HashMap reason = new HashMap();
                reason.put(split[1], entry.getValue());
                installmentAndReason.put(split[0], reason);
                continue;
            }
            ((Map)installmentAndReason.get(split[0])).put(split[1], entry.getValue());
        }
        for (String installmentYear : installmentAndReason.keySet()) {
            for (String reasonCode : WaterTaxConstants.ORDERED_DEMAND_RSNS_LIST) {
                if (((Map)installmentAndReason.get(installmentYear)).get(reasonCode) == null) continue;
                orderMap.put((String)((Map)installmentAndReason.get(installmentYear)).get(reasonCode), order++);
            }
        }
        return orderMap;
    }

    public Date getOrder(Date date, int reasonOrder) {
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(date);
        calendar.add(5, reasonOrder);
        return calendar.getTime();
    }
}

