/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.util.List;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.demand.model.EgDemand;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.entity.WaterDemandConnection;
import org.egov.wtms.application.repository.WaterDemandConnectionRepository;
import org.hibernate.Session;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class WaterDemandConnectionService {
    protected WaterDemandConnectionRepository waterDemandConnectionRepository;
    private static final Logger LOG = LoggerFactory.getLogger(WaterDemandConnectionService.class);
    @PersistenceContext
    private EntityManager entityManager;

    @Autowired
    public WaterDemandConnectionService(WaterDemandConnectionRepository waterDemandConnectionRepository) {
        this.waterDemandConnectionRepository = waterDemandConnectionRepository;
    }

    public List<WaterDemandConnection> findByWaterConnectionDetails(WaterConnectionDetails waterConnectionDetails) {
        return this.waterDemandConnectionRepository.findByWaterConnectionDetails(waterConnectionDetails);
    }

    public List<WaterDemandConnection> findAll() {
        return this.waterDemandConnectionRepository.findAll(new Sort(Sort.Direction.ASC, new String[]{"id"}));
    }

    public WaterDemandConnection load(Long id) {
        return (WaterDemandConnection)((Object)this.waterDemandConnectionRepository.getOne(id));
    }

    public WaterDemandConnection findByWaterConnectionDetailsAndDemand(WaterConnectionDetails waterConnectionDetails, EgDemand demand) {
        return this.waterDemandConnectionRepository.findByWaterConnectionDetailsAndDemand(waterConnectionDetails, demand);
    }

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    @Transactional
    public WaterDemandConnection createWaterDemandConnection(WaterDemandConnection waterDemandConnection) {
        return (WaterDemandConnection)((Object)this.waterDemandConnectionRepository.save((Object)waterDemandConnection));
    }

    @Transactional
    public void updateWaterDemandConnection(WaterDemandConnection waterDemandConnection) {
        this.waterDemandConnectionRepository.save((Object)waterDemandConnection);
    }
}

