/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class NewConnectionService {
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private ResourceBundleMessageSource messageSource;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;

    public String checkConnectionPresentForProperty(String propertyID) {
        WaterConnectionDetails waterConnectionDetails;
        String validationMessage = "";
        if (!this.waterTaxUtils.isMultipleNewConnectionAllowedForPID().booleanValue() && (waterConnectionDetails = this.waterConnectionDetailsService.getPrimaryConnectionDetailsByPropertyIdentifier(propertyID)) != null) {
            if (waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE)) {
                validationMessage = this.messageSource.getMessage("err.validate.newconnection.active", (Object[])new String[]{waterConnectionDetails.getConnection().getConsumerCode(), propertyID}, null);
            } else if (waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.INPROGRESS)) {
                validationMessage = this.messageSource.getMessage("err.validate.newconnection.application.inprocess", (Object[])new String[]{propertyID, waterConnectionDetails.getApplicationNumber()}, null);
            } else if (waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.DISCONNECTED)) {
                validationMessage = this.messageSource.getMessage("err.validate.newconnection.disconnected", (Object[])new String[]{waterConnectionDetails.getConnection().getConsumerCode(), propertyID}, null);
            } else if (waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.CLOSED)) {
                validationMessage = this.messageSource.getMessage("err.validate.newconnection.closed", (Object[])new String[]{waterConnectionDetails.getConnection().getConsumerCode(), propertyID}, null);
            } else if (waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.HOLDING)) {
                validationMessage = this.messageSource.getMessage("err.validate.newconnection.holding", (Object[])new String[]{waterConnectionDetails.getConnection().getConsumerCode(), propertyID}, null);
            }
        }
        return validationMessage;
    }

    public String checkValidPropertyAssessmentNumber(String asessmentNumber) {
        String errorMessage = "";
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(asessmentNumber, PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ACTIVE);
        errorMessage = this.validateProperty(assessmentDetails);
        if (errorMessage.isEmpty()) {
            errorMessage = this.validatePTDue(asessmentNumber, assessmentDetails);
        }
        return errorMessage;
    }

    public String checkValidPropertyForDataEntry(String asessmentNumber) {
        String errorMessage = "";
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(asessmentNumber, PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ACTIVE);
        errorMessage = this.validateProperty(assessmentDetails);
        return errorMessage;
    }

    private String validateProperty(AssessmentDetails assessmentDetails) {
        String errorMessage = "";
        if (assessmentDetails.getErrorDetails() != null && assessmentDetails.getErrorDetails().getErrorCode() != null) {
            errorMessage = assessmentDetails.getErrorDetails().getErrorMessage();
        }
        return errorMessage;
    }

    private String validatePTDue(String asessmentNumber, AssessmentDetails assessmentDetails) {
        String errorMessage = "";
        if (assessmentDetails.getPropertyDetails() != null && assessmentDetails.getPropertyDetails().getTaxDue() != null && assessmentDetails.getPropertyDetails().getTaxDue().doubleValue() > 0.0 && !this.waterTaxUtils.isNewConnectionAllowedIfPTDuePresent().booleanValue()) {
            errorMessage = this.messageSource.getMessage("err.validate.property.taxdue", (Object[])new String[]{assessmentDetails.getPropertyDetails().getTaxDue().toString(), asessmentNumber, "new"}, null);
        }
        return errorMessage;
    }
}

