/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.text.ParseException;
import java.util.List;
import org.apache.log4j.Logger;
import org.egov.demand.model.EgBill;
import org.egov.infstr.services.PersistenceService;
import org.egov.wtms.application.entity.GenerateConnectionBill;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.hibernate.SQLQuery;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class GenerateConnectionBillService {
    @Qualifier(value="entityQueryService")
    @Autowired
    private PersistenceService entityQueryService;
    private static final Logger LOGGER = Logger.getLogger(GenerateConnectionBillService.class);

    public List<GenerateConnectionBill> getBillReportDetails(String zone, String ward, String propertyType, String applicationType, String connectionType, String consumerCode, String houseNumber, String assessmentNumber) throws ParseException {
        long startTime = System.currentTimeMillis();
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select dcbinfo.hscno as \"hscNo\", dcbinfo.username as \"ownerName\",dcbinfo.propertyid as \"assessmentNo\",dcbinfo.houseno as \"houseNumber\" , localboundary.localname as \"locality\", dcbinfo.applicationtype as \"applicationType\" ,  dcbinfo.connectiontype as  \"connectionType\" from egwtr_mv_dcb_view dcbinfo INNER JOIN eg_boundary wardboundary on dcbinfo.wardid = wardboundary.id INNER JOIN eg_boundary localboundary on dcbinfo.locality = localboundary.id  INNER JOIN eg_boundary zoneboundary on dcbinfo.zoneid = zoneboundary.id ");
        queryStr.append(" where dcbinfo.connectionstatus = '" + ConnectionStatus.ACTIVE.toString() + "' ");
        if (ward != null && !ward.isEmpty()) {
            queryStr.append(" and wardboundary.name = '" + ward + "'");
        }
        if (zone != null && !zone.isEmpty()) {
            queryStr.append(" and zoneboundary.name = '" + zone + "'");
        }
        if (consumerCode != null && !consumerCode.isEmpty()) {
            queryStr.append(" and dcbinfo.hscno = '" + consumerCode + "'");
        }
        if (assessmentNumber != null && !assessmentNumber.isEmpty()) {
            queryStr.append(" and dcbinfo.propertyid = '" + assessmentNumber + "'");
        }
        if (houseNumber != null && !houseNumber.isEmpty()) {
            queryStr.append(" and dcbinfo.houseno = '" + houseNumber + "'");
        }
        if (connectionType != null && !connectionType.isEmpty()) {
            queryStr.append(" and dcbinfo.connectiontype = '" + connectionType + "'");
        }
        if (applicationType != null && !applicationType.isEmpty()) {
            queryStr.append(" and dcbinfo.applicationtype = '" + applicationType + "'");
        }
        if (propertyType != null && !propertyType.isEmpty()) {
            queryStr.append(" and dcbinfo.propertytype = '" + propertyType + "'");
        }
        SQLQuery finalQuery = this.entityQueryService.getSession().createSQLQuery(queryStr.toString());
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("GenerateConnectionBill -- Search Result " + queryStr.toString()));
        }
        finalQuery.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(GenerateConnectionBill.class));
        List generateConnectionBillList = finalQuery.list();
        long endTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("GenerateBill | SearchResult | Time taken(ms) " + (endTime - startTime)));
            LOGGER.debug((Object)"Exit from SearchResult method");
        }
        return generateConnectionBillList;
    }

    public List<GenerateConnectionBill> getBillData(List<GenerateConnectionBill> generateConnectionBillList) {
        for (GenerateConnectionBill connectionbill : generateConnectionBillList) {
            EgBill egbill = this.getBIll(connectionbill.getHscNo());
            if (egbill == null) continue;
            connectionbill.setBillNo(egbill.getBillNo());
            connectionbill.setBillDate(egbill.getIssueDate().toString());
        }
        return generateConnectionBillList;
    }

    public EgBill getBIll(String consumerCode) {
        String query = " select bill From EgBill bill,EgBillType billtype,WaterConnection conn,WaterConnectionDetails connDet,EgwStatus status,WaterDemandConnection conndem  , EgDemand demd where billtype.id=bill.egBillType and billtype.code='MANUAL' and bill.consumerId = conn.consumerCode and conn.id=connDet.connection and connDet.id=conndem.waterConnectionDetails and bill.egDemand=conndem.demand and connDet.connectionType='NON_METERED' and  bill.egDemand=conndem.demand and demd.isHistory = 'N' and connDet.connectionStatus='ACTIVE' and connDet.status=status.id and status.moduletype='WATERTAXAPPLICATION' and status.code='SANCTIONED' and conn.consumerCode = ? ";
        EgBill egBill = (EgBill)this.entityQueryService.find(" select bill From EgBill bill,EgBillType billtype,WaterConnection conn,WaterConnectionDetails connDet,EgwStatus status,WaterDemandConnection conndem  , EgDemand demd where billtype.id=bill.egBillType and billtype.code='MANUAL' and bill.consumerId = conn.consumerCode and conn.id=connDet.connection and connDet.id=conndem.waterConnectionDetails and bill.egDemand=conndem.demand and connDet.connectionType='NON_METERED' and  bill.egDemand=conndem.demand and demd.isHistory = 'N' and connDet.connectionStatus='ACTIVE' and connDet.status=status.id and status.moduletype='WATERTAXAPPLICATION' and status.code='SANCTIONED' and conn.consumerCode = ? ", new Object[]{consumerCode});
        return egBill;
    }

    public List<Long> getDocuments(String consumerCode, String applicationType) {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select filestore.filestoreid from eg_filestoremap filestore,egwtr_documents conndoc,egwtr_application_documents appD,egwtr_connectiondetails conndet,egwtr_connection  conn , egwtr_demand_connection demcon ,eg_demand dem,eg_bill bill, eg_bill_type billtype,egwtr_document_names docName where filestore.id=conndoc.filestoreid and conndet.connection=conn.id and conndet.id=appD.connectiondetailsid and appD.documentnamesid=docName.id and  bill.id_demand =demcon.demand and billtype.id = bill.id_bill_type and conndoc.applicationdocumentsid=appD.id   and  demcon.connectiondetails=conndet.id and demcon.demand = dem.id and appD.documentnumber=bill.bill_no  and billtype.code='MANUAL' and dem.is_history ='N' and  docName.documentname='DemandBill'  ");
        queryStr.append(" and conn.consumercode=  '" + consumerCode + "'");
        queryStr.append(" and docName.applicationtype in(select id from egwtr_application_type where code = '" + applicationType + "' )");
        SQLQuery finalQuery = this.entityQueryService.getSession().createSQLQuery(queryStr.toString());
        List waterChargesDocumentsList = finalQuery.list();
        return waterChargesDocumentsList;
    }
}

