/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.text.ParseException;
import java.util.ArrayList;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.egov.dcb.bean.DCBDisplayInfo;
import org.egov.wtms.application.entity.WaterChargesReceiptInfo;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class CurrentDcbService {
    @PersistenceContext
    private EntityManager entityManager;

    public Session getCurrentSession() {
        return (Session)this.entityManager.unwrap(Session.class);
    }

    public DCBDisplayInfo getDcbDispInfo() {
        DCBDisplayInfo dcbDispInfo = new DCBDisplayInfo();
        ArrayList<String> reasonMasterCodes = new ArrayList<String>(0);
        ArrayList reasonCategoryCodes = new ArrayList(0);
        reasonMasterCodes.add("WTAXCHARGES");
        dcbDispInfo.setReasonCategoryCodes(reasonCategoryCodes);
        dcbDispInfo.setReasonMasterCodes(reasonMasterCodes);
        return dcbDispInfo;
    }

    public SQLQuery getMigratedReceipttDetails(String consumerNumber) throws ParseException {
        StringBuilder queryStr = new StringBuilder();
        queryStr.append("select distinct(i_bookno) as \"bookNumber\", i_ctrrcptno as \"receiptNumber\",dt_ctrrcptdt as \"receiptDate\",dt_paidfrmprddt as \"fromDate\",dt_paidtoprddt as \"toDate\",d_crr+d_arr as \"receiptAmount\" from wt_wtchrgrcpt_tbl where i_csmrno =" + consumerNumber + " order by dt_ctrrcptdt desc");
        SQLQuery finalQuery = this.getCurrentSession().createSQLQuery(queryStr.toString());
        finalQuery.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(WaterChargesReceiptInfo.class));
        return finalQuery;
    }
}

