/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.application.service;

import java.math.BigDecimal;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.utils.ApplicationNumberGenerator;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.repository.WaterConnectionDetailsRepository;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterConnectionSmsAndEmailService;
import org.egov.wtms.application.workflow.ApplicationWorkflowCustomDefaultImpl;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.service.ApplicationProcessTimeService;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@Transactional(readOnly=true)
public class ChangeOfUseService {
    @Autowired
    private WaterConnectionDetailsRepository waterConnectionDetailsRepository;
    @Autowired
    private ResourceBundleMessageSource messageSource;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private UserService userService;
    @Autowired
    private ApplicationNumberGenerator applicationNumberGenerator;
    @Autowired
    private ApplicationProcessTimeService applicationProcessTimeService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private WaterConnectionSmsAndEmailService waterConnectionSmsAndEmailService;
    public static final String CHANGEOFUSEALLOWEDIFWTDUE = "CHANGEOFUSEALLOWEDIFWTDUE";

    public String validateChangeOfUseConnection(WaterConnectionDetails parentWaterConnectionDetail) {
        String validationMessage = "";
        String propertyID = parentWaterConnectionDetail.getConnection().getPropertyIdentifier();
        String consumerCode = parentWaterConnectionDetail.getConnection().getConsumerCode();
        WaterConnectionDetails inWorkflow = this.waterConnectionDetailsRepository.findByConnection_ConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.INPROGRESS);
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(propertyID, PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ACTIVE);
        if (parentWaterConnectionDetail.getConnectionStatus().equals((Object)ConnectionStatus.HOLDING)) {
            validationMessage = this.messageSource.getMessage("err.validate.primary.connection.holding", (Object[])new String[]{parentWaterConnectionDetail.getConnection().getConsumerCode(), propertyID}, null);
        } else if (parentWaterConnectionDetail.getConnectionStatus().equals((Object)ConnectionStatus.DISCONNECTED)) {
            validationMessage = this.messageSource.getMessage("err.validate.primary.connection.disconnected", (Object[])new String[]{parentWaterConnectionDetail.getConnection().getConsumerCode(), propertyID}, null);
        } else if (null != assessmentDetails.getErrorDetails() && null != assessmentDetails.getErrorDetails().getErrorCode()) {
            validationMessage = assessmentDetails.getErrorDetails().getErrorMessage();
        } else if (null != inWorkflow) {
            validationMessage = this.messageSource.getMessage("err.validate.changeofUse.application.inprocess", (Object[])new String[]{parentWaterConnectionDetail.getConnection().getConsumerCode(), inWorkflow.getApplicationNumber()}, null);
        } else {
            if (null != assessmentDetails.getPropertyDetails() && null != assessmentDetails.getPropertyDetails().getTaxDue() && assessmentDetails.getPropertyDetails().getTaxDue().doubleValue() > 0.0 && !this.waterTaxUtils.isNewConnectionAllowedIfPTDuePresent().booleanValue()) {
                validationMessage = this.messageSource.getMessage("err.validate.property.taxdue", (Object[])new String[]{assessmentDetails.getPropertyDetails().getTaxDue().toString(), parentWaterConnectionDetail.getConnection().getPropertyIdentifier(), "changeOfUsage"}, null);
            }
            if (!this.waterTaxUtils.isConnectionAllowedIfWTDuePresent(CHANGEOFUSEALLOWEDIFWTDUE).booleanValue()) {
                BigDecimal waterTaxDueforParent = this.waterConnectionDetailsService.getCurrentDue(parentWaterConnectionDetail);
                if (waterTaxDueforParent.doubleValue() > 0.0) {
                    validationMessage = validationMessage.equalsIgnoreCase("") ? this.messageSource.getMessage("err.validate.primary.connection.wtdue.forchangeofuse", null, null) : validationMessage + " and " + this.messageSource.getMessage("err.validate.primary.connection.wtdue.forchangeofuse", null, null);
                }
                if (parentWaterConnectionDetail.getConnection().getId() != null && this.waterTaxUtils.waterConnectionDue(parentWaterConnectionDetail.getConnection().getId()) > 0.0) {
                    validationMessage = validationMessage.equalsIgnoreCase("") ? this.messageSource.getMessage("err.validate.additional.connection.wtdue.forchangeofuse", null, null) : validationMessage + " and " + this.messageSource.getMessage("err.validate.additional.connection.wtdue.forchangeofuse", null, null);
                }
            }
        }
        return validationMessage;
    }

    @Transactional
    public WaterConnectionDetails createChangeOfUseApplication(WaterConnectionDetails changeOfUse, Long approvalPosition, String approvalComent, String additionalRule, String workFlowAction, String sourceChannel) {
        WaterConnectionDetails savedChangeOfUse;
        Integer appProcessTime;
        if (changeOfUse.getApplicationNumber() == null) {
            changeOfUse.setApplicationNumber(this.applicationNumberGenerator.generate());
        }
        if ((appProcessTime = this.applicationProcessTimeService.getApplicationProcessTime(changeOfUse.getApplicationType(), changeOfUse.getCategory())) != null) {
            changeOfUse.setDisposalDate(this.waterConnectionDetailsService.getDisposalDate(changeOfUse, appProcessTime));
        }
        if (this.userService.getUserById((savedChangeOfUse = (WaterConnectionDetails)((Object)this.waterConnectionDetailsRepository.save((Object)changeOfUse))).getCreatedBy().getId()).getUsername().equals("anonymous")) {
            ApplicationThreadLocals.setUserId((Long)Long.valueOf("40"));
            savedChangeOfUse.setCreatedBy(this.userService.getUserById(ApplicationThreadLocals.getUserId()));
        }
        ApplicationWorkflowCustomDefaultImpl applicationWorkflowCustomDefaultImpl = this.waterConnectionDetailsService.getInitialisedWorkFlowBean();
        applicationWorkflowCustomDefaultImpl.createCommonWorkflowTransition(savedChangeOfUse, approvalPosition, approvalComent, additionalRule, workFlowAction);
        this.waterConnectionDetailsService.updateIndexes(savedChangeOfUse, sourceChannel);
        this.waterConnectionSmsAndEmailService.sendSmsAndEmail(changeOfUse, workFlowAction);
        return savedChangeOfUse;
    }
}

