/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.reports;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.List;
import org.egov.works.reports.entity.WorkProgressRegister;
import org.egov.works.reports.entity.WorkProgressRegisterSearchRequest;
import org.egov.works.reports.service.WorkProgressRegisterService;
import org.egov.works.web.adaptor.WorkProgressRegisterJsonAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class AjaxWorkProgressRegisterController {
    @Autowired
    private WorkProgressRegisterService workProgressRegisterService;
    @Autowired
    private WorkProgressRegisterJsonAdaptor workProgressRegisterJsonAdaptor;

    @RequestMapping(value={"/ajax-wincodestosearchworkprogressregister"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> getChildBoundariesById(@RequestParam String code) {
        return this.workProgressRegisterService.findWorkIdentificationNumbersToSearchLineEstimatesForLoa(code);
    }

    @RequestMapping(value={"/ajax-workprogressregister"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String showSearchWorkProgressRegister(Model model, @ModelAttribute WorkProgressRegisterSearchRequest workProgressRegisterSearchRequest) {
        List workProgressRegisters = this.workProgressRegisterService.searchWorkProgressRegister(workProgressRegisterSearchRequest);
        String result = "{ \"data\":" + this.toSearchContractorBillJson((Object)workProgressRegisters) + "}";
        return result;
    }

    public Object toSearchContractorBillJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorkProgressRegister.class, (Object)this.workProgressRegisterJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }
}

