/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.lineestimate;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.CChartOfAccountDetail;
import org.egov.commons.dao.EgwTypeOfWorkHibernateDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.egf.budget.model.BudgetControlType;
import org.egov.egf.budget.service.BudgetControlTypeService;
import org.egov.eis.service.DesignationService;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.pims.commons.Designation;
import org.egov.services.masters.SchemeService;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.entity.enums.Beneficiary;
import org.egov.works.lineestimate.entity.enums.WorkCategory;
import org.egov.works.lineestimate.service.LineEstimateDetailService;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.master.service.LineEstimateUOMService;
import org.egov.works.master.service.ModeOfAllotmentService;
import org.egov.works.master.service.NatureOfWorkService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/lineestimate"})
public class CreateSpillOverLineEstimateController {
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private FundHibernateDAO fundHibernateDAO;
    @Autowired
    private SchemeService schemeService;
    @Autowired
    private NatureOfWorkService natureOfWorkService;
    @Autowired
    private EgwTypeOfWorkHibernateDAO egwTypeOfWorkHibernateDAO;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private DesignationService designationService;
    @Autowired
    private BudgetDetailsDAO budgetDetailsDAO;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private AppConfigValueService appConfigValuesService;
    @Autowired
    private BudgetControlTypeService budgetControlTypeService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private LineEstimateDetailService lineEstimateDetailService;
    @Autowired
    private ModeOfAllotmentService modeOfAllotmentService;
    @Autowired
    private LineEstimateUOMService lineEstimateUOMService;

    @RequestMapping(value={"/newspilloverform"}, method={RequestMethod.GET})
    public String showNewSpillOverLineEstimateForm(@ModelAttribute(value="lineEstimate") LineEstimate lineEstimate, Model model) throws ApplicationException {
        model.addAttribute("hiddenfields", (Object)this.lineEstimateService.getLineEstimateHiddenFields());
        model.addAttribute("workdetailsadd", (Object)("yes".equalsIgnoreCase(this.lineEstimateService.getLineEstimateMultipleWorkDetailsAllowed()) ? Boolean.TRUE : Boolean.FALSE));
        this.setDropDownValues(model);
        List departments = this.lineEstimateService.getUserDepartments(this.securityUtils.getCurrentUser());
        if (departments != null && !departments.isEmpty()) {
            lineEstimate.setExecutingDepartment((Department)departments.get(0));
        }
        model.addAttribute("lineEstimate", (Object)lineEstimate);
        model.addAttribute("mode", null);
        return "spillOverLineEstimate-form";
    }

    @RequestMapping(value={"/create-spillover"}, method={RequestMethod.POST})
    public String create(@ModelAttribute(value="lineEstimate") LineEstimate lineEstimate, Model model, BindingResult errors, @RequestParam(value="file") MultipartFile[] files, RedirectAttributes redirectAttributes, HttpServletRequest request, BindingResult resultBinder) throws ApplicationException, IOException {
        model.addAttribute("hiddenfields", (Object)this.lineEstimateService.getLineEstimateHiddenFields());
        model.addAttribute("workdetailsadd", (Object)("yes".equalsIgnoreCase(this.lineEstimateService.getLineEstimateMultipleWorkDetailsAllowed()) ? Boolean.TRUE : Boolean.FALSE));
        this.validateLineEstimate(lineEstimate, errors);
        this.validateLineEstimateDetails(lineEstimate, errors);
        this.validateAdminSanctionDetail(lineEstimate, errors);
        this.validateTechSanctionDetails(lineEstimate, errors);
        if (!BudgetControlType.BudgetCheckOption.NONE.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue())) {
            this.validateBudgetAmount(lineEstimate, errors);
        }
        this.validateBudgetHead(lineEstimate, errors);
        if (errors.hasErrors()) {
            this.setDropDownValues(model);
            model.addAttribute("mode", null);
            model.addAttribute("designation", (Object)request.getParameter("designation"));
            model.addAttribute("hiddenfields", (Object)this.lineEstimateService.getLineEstimateHiddenFields());
            model.addAttribute("workdetailsadd", (Object)("yes".equalsIgnoreCase(this.lineEstimateService.getLineEstimateMultipleWorkDetailsAllowed()) ? Boolean.TRUE : Boolean.FALSE));
            return "spillOverLineEstimate-form";
        }
        LineEstimate newLineEstimate = this.lineEstimateService.createSpillOver(lineEstimate, files);
        return "redirect:/lineestimate/spillover-lineestimate-success?lineEstimateNumber=" + newLineEstimate.getLineEstimateNumber();
    }

    private void validateBudgetHead(LineEstimate lineEstimate, BindingResult errors) {
        if (lineEstimate.getBudgetHead() != null) {
            Boolean check = false;
            ArrayList accountDetails = new ArrayList();
            accountDetails.addAll(lineEstimate.getBudgetHead().getMaxCode().getChartOfAccountDetails());
            for (CChartOfAccountDetail detail : accountDetails) {
                if (detail.getDetailTypeId() == null || !detail.getDetailTypeId().getName().equalsIgnoreCase("PROJECTCODE")) continue;
                check = true;
            }
            if (!check.booleanValue()) {
                errors.reject("error.budgethead.validate", "error.budgethead.validate");
            }
        }
    }

    private void validateLineEstimateDetails(LineEstimate lineEstimate, BindingResult errors) {
        Integer index = 0;
        for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
            LineEstimate councilResolutionNumber;
            LineEstimateDetails estimateNumber = this.lineEstimateDetailService.getLineEstimateDetailsByEstimateNumber(led.getEstimateNumber());
            if (lineEstimate.getCouncilResolutionNumber() != null && (councilResolutionNumber = this.lineEstimateService.getLineEstimateByCouncilResolutionNumber(lineEstimate.getCouncilResolutionNumber())) != null) {
                errors.rejectValue("lineEstimateDetails[" + index + "].lineEstimate.councilResolutionNumber", "error.councilresolutionnumber.unique");
            }
            LineEstimateDetails workIdentificationNumber = this.lineEstimateDetailService.getLineEstimateDetailsByProjectCode(led.getProjectCode().getCode());
            if (estimateNumber != null) {
                errors.rejectValue("lineEstimateDetails[" + index + "].estimateNumber", "error.estimatenumber.unique");
            }
            if (workIdentificationNumber != null) {
                errors.rejectValue("lineEstimateDetails[" + index + "].projectCode.code", "error.win.unique");
            }
            if (led.getActualEstimateAmount() != null && led.getActualEstimateAmount().signum() != 1) {
                errors.rejectValue("lineEstimateDetails[" + index + "].actualEstimateAmount", "error.actualestimateamount.required");
            }
            if (led.getEstimateAmount().compareTo(led.getActualEstimateAmount()) == -1) {
                errors.rejectValue("lineEstimateDetails[" + index + "].actualEstimateAmount", "error.actualamount");
            }
            Integer n = index;
            Integer n2 = index = Integer.valueOf(index + 1);
        }
    }

    private void validateTechSanctionDetails(LineEstimate lineEstimate, BindingResult errors) {
        LineEstimate existingLineEstimate;
        if (lineEstimate.getTechnicalSanctionDate() == null) {
            errors.rejectValue("technicalSanctionDate", "error.techdate.notnull");
        }
        if (lineEstimate.getTechnicalSanctionDate() != null && lineEstimate.getTechnicalSanctionDate().before(lineEstimate.getAdminSanctionDate())) {
            errors.rejectValue("technicalSanctionDate", "error.technicalsanctiondate");
        }
        if (lineEstimate.getTechnicalSanctionNumber() == null) {
            errors.rejectValue("technicalSanctionNumber", "error.technumber.notnull");
        }
        if (lineEstimate.getTechnicalSanctionNumber() != null && (existingLineEstimate = this.lineEstimateService.getLineEstimateByTechnicalSanctionNumber(lineEstimate.getTechnicalSanctionNumber())) != null) {
            errors.rejectValue("technicalSanctionNumber", "error.technumber.unique");
        }
    }

    private void validateAdminSanctionDetail(LineEstimate lineEstimate, BindingResult errors) {
        LineEstimate checkLineEstimate;
        if (lineEstimate.getAdminSanctionDate() != null && lineEstimate.getAdminSanctionDate().before(lineEstimate.getLineEstimateDate())) {
            errors.rejectValue("adminSanctionDate", "error.adminsanctiondate");
        }
        if (lineEstimate.getCouncilResolutionDate() != null && lineEstimate.getCouncilResolutionDate().before(lineEstimate.getLineEstimateDate())) {
            errors.rejectValue("councilResolutionDate", "error.councilresolutiondate");
        }
        if (StringUtils.isBlank((CharSequence)lineEstimate.getAdminSanctionNumber())) {
            errors.rejectValue("adminSanctionNumber", "error.adminsanctionnumber.notnull");
        }
        if (StringUtils.isBlank((CharSequence)lineEstimate.getAdminSanctionBy())) {
            errors.rejectValue("adminSanctionBy", "error.adminsanctionby.notnull");
        }
        if (lineEstimate.getAdminSanctionNumber() != null && (checkLineEstimate = this.lineEstimateService.getLineEstimateByAdminSanctionNumber(lineEstimate.getAdminSanctionNumber())) != null) {
            errors.rejectValue("adminSanctionNumber", "error.adminsanctionnumber.unique");
        }
    }

    private void setDropDownValues(Model model) {
        model.addAttribute("funds", (Object)this.fundHibernateDAO.findAllActiveFunds());
        model.addAttribute("schemes", (Object)this.schemeService.findAll());
        model.addAttribute("departments", (Object)this.lineEstimateService.getUserDepartments(this.securityUtils.getCurrentUser()));
        model.addAttribute("workCategory", (Object)WorkCategory.values());
        model.addAttribute("beneficiary", (Object)Beneficiary.values());
        model.addAttribute("modeOfAllotment", (Object)this.modeOfAllotmentService.findAll());
        model.addAttribute("lineEstimateUOMs", (Object)this.lineEstimateUOMService.findAll());
        model.addAttribute("typeOfWork", (Object)this.egwTypeOfWorkHibernateDAO.getTypeOfWorkForPartyTypeContractor());
        model.addAttribute("natureOfWork", (Object)this.natureOfWorkService.findAll());
        model.addAttribute("locations", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Locality", "LOCATION"));
        ArrayList<Designation> designations = new ArrayList<Designation>();
        List configValues = this.appConfigValuesService.getConfigValuesByModuleAndKey("Works Management", "DESIGNATION_TECHSANCTION_AUTHORITY");
        for (AppConfigValues value : configValues) {
            designations.add(this.designationService.getDesignationByName(value.getValue()));
        }
        model.addAttribute("designations", designations);
    }

    @RequestMapping(value={"/spillover-lineestimate-success"}, method={RequestMethod.GET})
    public ModelAndView successView(@RequestParam(value="lineEstimateNumber") String lineEstimateNumber, Model model) {
        LineEstimate lineEstimate = this.lineEstimateService.getLineEstimateByLineEstimateNumber(lineEstimateNumber);
        model.addAttribute("message", (Object)this.messageSource.getMessage("msg.spillover.lineestimate.success", (Object[])new String[]{lineEstimate.getLineEstimateNumber(), lineEstimate.getAdminSanctionNumber(), lineEstimate.getTechnicalSanctionNumber()}, null));
        return new ModelAndView("lineestimate-success");
    }

    private void validateBudgetAmount(LineEstimate lineEstimate, BindingResult errors) {
        block5: {
            ArrayList<Long> budgetheadid = new ArrayList<Long>();
            budgetheadid.add(lineEstimate.getBudgetHead().getId());
            try {
                BigDecimal budgetAvailable = this.budgetDetailsDAO.getPlanningBudgetAvailable(this.lineEstimateService.getCurrentFinancialYear(new Date()).getId(), Integer.valueOf(Integer.parseInt(lineEstimate.getExecutingDepartment().getId().toString())), lineEstimate.getFunction().getId(), null, lineEstimate.getScheme() == null ? null : Integer.valueOf(Integer.parseInt(lineEstimate.getScheme().getId().toString())), lineEstimate.getSubScheme() == null ? null : Integer.valueOf(Integer.parseInt(lineEstimate.getSubScheme().getId().toString())), null, budgetheadid, Integer.valueOf(Integer.parseInt(lineEstimate.getFund().getId().toString())));
                BigDecimal totalAppropriationAmount = BigDecimal.ZERO;
                for (LineEstimateDetails led : lineEstimate.getLineEstimateDetails()) {
                    if (lineEstimate.isBillsCreated() && led.getGrossAmountBilled() != null) {
                        totalAppropriationAmount = totalAppropriationAmount.add(led.getEstimateAmount().subtract(led.getGrossAmountBilled()));
                        continue;
                    }
                    totalAppropriationAmount = totalAppropriationAmount.add(led.getEstimateAmount());
                }
                if (BudgetControlType.BudgetCheckOption.MANDATORY.toString().equalsIgnoreCase(this.budgetControlTypeService.getConfigValue()) && budgetAvailable.compareTo(totalAppropriationAmount) == -1) {
                    errors.reject("error.budgetappropriation.amount", (Object[])new String[]{budgetAvailable.toString(), totalAppropriationAmount.toString()}, null);
                }
            }
            catch (ValidationException e) {
                Iterator iterator = e.getErrors().iterator();
                if (!iterator.hasNext()) break block5;
                ValidationError error = (ValidationError)iterator.next();
                throw new ApplicationRuntimeException(error.getKey());
            }
        }
    }

    private void validateLineEstimate(LineEstimate lineEstimate, BindingResult errors) {
        if (!this.lineEstimateService.getLineEstimateHiddenFields().contains("subject") && lineEstimate.getSubject() == null) {
            errors.reject("error.subject.required", "error.subject.required");
        }
        if (!this.lineEstimateService.getLineEstimateHiddenFields().contains("description") && lineEstimate.getDescription() == null) {
            errors.reject("error.description.required", "error.description.required");
        }
    }
}

