/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.milestone.entity.Milestone;
import org.egov.works.milestone.entity.MilestoneActivity;
import org.egov.works.milestone.entity.TrackMilestoneActivity;
import org.egov.works.models.workorder.WorkOrder;
import org.springframework.stereotype.Component;

@Component
public class TrackMilestoneJsonAdaptor
implements JsonSerializer<Milestone> {
    public JsonElement serialize(Milestone milestone, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        SimpleDateFormat sdf2 = new SimpleDateFormat("yyyy-MM-dd");
        DecimalFormat df = new DecimalFormat("0.00");
        if (milestone != null) {
            JsonArray jsonArray;
            if (milestone.getWorkOrderEstimate().getEstimate().getLineEstimateDetails() != null) {
                LineEstimateDetails led = milestone.getWorkOrderEstimate().getEstimate().getLineEstimateDetails();
                jsonObject.addProperty("estimateNumber", led.getEstimateNumber());
                jsonObject.addProperty("lineEstimateDate", sdf.format(led.getLineEstimate().getLineEstimateDate()));
                jsonObject.addProperty("nameOfWork", led.getNameOfWork());
                jsonObject.addProperty("projectCode", led.getProjectCode().getCode());
                jsonObject.addProperty("typeOfWork", led.getLineEstimate().getTypeOfWork().getDescription().toString());
                if (led.getLineEstimate().getSubTypeOfWork() != null) {
                    jsonObject.addProperty("subTypeOfWork", led.getLineEstimate().getSubTypeOfWork().getDescription().toString());
                }
                jsonObject.addProperty("lineEstimateCreatedBy", led.getLineEstimate().getCreatedBy().getName());
                jsonObject.addProperty("department", led.getLineEstimate().getExecutingDepartment().getName());
            } else {
                jsonObject.addProperty("estimateNumber", "");
                jsonObject.addProperty("lineEstimateDate", "");
                jsonObject.addProperty("nameOfWork", "");
                jsonObject.addProperty("projectCode", "");
                jsonObject.addProperty("typeOfWork", "");
                jsonObject.addProperty("subTypeOfWork", "");
                jsonObject.addProperty("lineEstimateCreatedBy", "");
                jsonObject.addProperty("department", "");
            }
            if (milestone.getWorkOrderEstimate().getWorkOrder() != null) {
                WorkOrder workOrder = milestone.getWorkOrderEstimate().getWorkOrder();
                jsonObject.addProperty("workOrderNumber", workOrder.getWorkOrderNumber());
                jsonObject.addProperty("workOrderId", (Number)workOrder.getId());
                jsonObject.addProperty("workOrderAmount", df.format(workOrder.getWorkOrderAmount()));
                jsonObject.addProperty("workOrderDate", sdf.format(workOrder.getWorkOrderDate()));
                jsonObject.addProperty("contractorName", workOrder.getContractor().getName());
            } else {
                jsonObject.addProperty("workOrderNumber", "");
                jsonObject.addProperty("workOrderId", "");
                jsonObject.addProperty("workOrderAmount", "");
                jsonObject.addProperty("workOrderDate", "");
                jsonObject.addProperty("contractorName", "");
            }
            if (!milestone.getActivities().isEmpty()) {
                jsonArray = new JsonArray();
                for (MilestoneActivity ma : milestone.getActivities()) {
                    JsonObject child = new JsonObject();
                    child.addProperty("stageOrderNumber", (Number)ma.getStageOrderNo());
                    child.addProperty("description", ma.getDescription());
                    child.addProperty("percentage", (Number)ma.getPercentage());
                    child.addProperty("scheduleStartDate", sdf.format(ma.getScheduleStartDate()));
                    child.addProperty("scheduleEndDate", sdf.format(ma.getScheduleEndDate()));
                    child.addProperty("hiddenScheduleStartDate", sdf2.format(ma.getScheduleStartDate()));
                    child.addProperty("hiddenScheduleEndDate", sdf2.format(ma.getScheduleEndDate()));
                    jsonArray.add((JsonElement)child);
                }
                jsonObject.add("activities", (JsonElement)jsonArray);
            } else {
                jsonObject.add("activities", (JsonElement)new JsonArray());
            }
            if (!milestone.getTrackMilestone().isEmpty()) {
                jsonObject.addProperty("mode", "update");
                jsonArray = new JsonArray();
                for (MilestoneActivity ma : milestone.getTrackMilestone()) {
                    for (TrackMilestoneActivity tma : ma.getActivities()) {
                        JsonObject child = new JsonObject();
                        child.addProperty("currentStatus", tma.getStatus());
                        child.addProperty("completedPercentage", (Number)tma.getCompletedPercentage());
                        if (tma.getCompletionDate() != null) {
                            child.addProperty("completionDate", sdf.format(tma.getCompletionDate()));
                        }
                        child.addProperty("reasonForDelay", tma.getRemarks());
                        jsonArray.add((JsonElement)child);
                    }
                }
                jsonObject.add("trackMilestoneActivities", (JsonElement)jsonArray);
            } else {
                jsonObject.addProperty("mode", "create");
                jsonObject.add("trackMilestoneActivities", (JsonElement)new JsonArray());
            }
            jsonObject.addProperty("id", (Number)milestone.getId());
        }
        return jsonObject;
    }
}

