/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.models.workorder.WorkOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SearchLetterOfAcceptanceToCreateContractorBillJson
implements JsonSerializer<WorkOrder> {
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;

    public JsonElement serialize(WorkOrder workOrder, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (workOrder != null) {
            if (workOrder.getWorkOrderNumber() != null) {
                jsonObject.addProperty("workOrderNumber", workOrder.getWorkOrderNumber());
            } else {
                jsonObject.addProperty("workOrderNumber", "");
            }
            if (workOrder.getWorkOrderDate() != null) {
                jsonObject.addProperty("workOrderDate", workOrder.getWorkOrderDate().toString());
            } else {
                jsonObject.addProperty("workOrderDate", "");
            }
            if (workOrder.getContractor() != null) {
                jsonObject.addProperty("contractor", workOrder.getContractor().getName());
                jsonObject.addProperty("contractorcode", workOrder.getContractor().getCode());
            } else {
                jsonObject.addProperty("contractor", "");
                jsonObject.addProperty("contractorcode", "");
            }
            if (workOrder.getEstimateNumber() != null) {
                jsonObject.addProperty("estimateNumber", workOrder.getEstimateNumber());
                LineEstimateDetails led = this.lineEstimateService.findByEstimateNumber(workOrder.getEstimateNumber());
                String nameOfWork = led.getNameOfWork();
                jsonObject.addProperty("nameOfWork", nameOfWork);
                String workIdentificationNumber = led.getProjectCode().getCode();
                jsonObject.addProperty("workIdentificationNumber", workIdentificationNumber);
            } else {
                jsonObject.addProperty("estimateNumber", "");
            }
            jsonObject.addProperty("isMileStoneCreated", Boolean.valueOf(this.letterOfAcceptanceService.checkIfMileStonesCreated(workOrder)));
            jsonObject.addProperty("workOrderAmount", (Number)workOrder.getWorkOrderAmount());
            jsonObject.addProperty("id", (Number)workOrder.getId());
        }
        return jsonObject;
    }
}

