/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.reports;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.dao.FunctionHibernateDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.utils.EgovPaginatedList;
import org.egov.infstr.search.SearchQuerySQL;
import org.egov.infstr.services.Page;
import org.egov.model.budget.BudgetGroup;
import org.egov.pims.service.PersonalInformationService;
import org.egov.works.services.WorkProgressAbstractReportService;
import org.egov.works.services.WorksService;
import org.egov.works.web.actions.estimate.AjaxEstimateAction;
import org.egov.works.web.actions.reports.AjaxWorkProgressAction;
import org.egov.works.web.actions.reports.CommonDrillDownReportBean;
import org.egov.works.web.actions.reports.ContractorwiseReportBean;
import org.hibernate.SQLQuery;
import org.springframework.beans.factory.annotation.Autowired;

@Results(value={@Result(name={"PDF"}, type="stream", location="reportInputStream", params={"inputName", "contractorwiseAbstractReport", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=ContractorwiseAbstractReport.pdf"}), @Result(name={"XLS"}, type="stream", location="reportInputStream", params={"inputName", "contractorwiseAbstractReport", "contentType", "application/xls", "contentDisposition", "no-cache;filename=ContractorwiseAbstractReport.xls"}), @Result(name={"estimateXLS"}, type="stream", location="reportInputStream", params={"inputName", "contractorwiseReport_Estimates", "contentType", "application/xls", "contentDisposition", "no-cache;filename=ContractorwiseReport_Estimates.xls"}), @Result(name={"estimatePDF"}, type="stream", location="reportInputStream", params={"inputName", "contractorwiseReport_Estimates", "contentType", "application/pdf", "contentDisposition", "no-cache;filename=ContractorwiseReport_Estimates.pdf"})})
@ParentPackage(value="egov")
public class ContractorwiseAbstractReportAction
extends BaseFormAction {
    private static final long serialVersionUID = 6545841427307931948L;
    private static final Logger LOGGER = Logger.getLogger(ContractorwiseAbstractReportAction.class);
    private static final String DEPT_WISE = "deptwise";
    private String finYearId;
    private String finYearRange;
    private Date fromDate;
    private Date toDate;
    private Integer executingDepartment = -1;
    private Integer worksType = -1;
    private Integer worksSubType = -1;
    private Integer fund = -1;
    private Integer function = -1;
    private Integer scheme = -1;
    private Integer subScheme = -1;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private FundHibernateDAO fundDao;
    @Autowired
    private FunctionHibernateDAO functionHibDao;
    @Autowired
    private FinancialYearHibernateDAO finHibernateDao;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    private static final String BUDGET_HEADS_APPCONFIG_KEY = "WORK_PROGRESS_ABSTRACT_RPT2_BUDGT_HEADS";
    private String budgetHeadsAppConfValue = null;
    private WorksService worksService;
    private List<String> dropDownBudgetHeads;
    private String depositCodesAppConfValue = null;
    private static final String DEPOSITCODES_APPCONFIG_KEY = "WORK_PROGRESS_ABSTRACT_RPT2_DEPOSIT_CODES";
    private List<String> dropDownDepositCodes;
    private List<Long> allDepositCodes;
    private List<Long> allBudgetHeads;
    private String currentFinancialYearId;
    private String finYearRangeStr;
    private String subHeader;
    private String contractorName = "";
    private Long contractorId;
    private Long gradeId;
    private List<String> budgetHeads;
    private List<Long> budgetHeadIds;
    private List<Long> depositCodeIds;
    private BudgetDetailsDAO budgetDetailsDAO;
    private final SimpleDateFormat dateFormatter = new SimpleDateFormat("dd-MMM-yyyy", Locale.getDefault());
    private List<ContractorwiseReportBean> resultList = new LinkedList();
    private String resultStatus = "beforeSearch";
    public static final String PDF = "PDF";
    public static final String XLS = "XLS";
    private InputStream reportInputStream;
    private ReportService reportService;
    private final String JASPER_NAME = "contractorwiseAbstractReport";
    private String searchType = "";
    private EgovPaginatedList paginatedList;
    private Integer page = 1;
    private Integer pageSize = 30;
    private final List<CommonDrillDownReportBean> commonBeanList = new ArrayList();
    private List<Object> paramList;
    public WorkProgressAbstractReportService workProgressAbstractReportService;
    private String budgetHeadsStr;
    private String depositCodesStr;
    private String depositCodeIdsStr;
    private String budgetHeadIdsStr;
    private String reportMessage;

    public Object getModel() {
        return null;
    }

    public String beforeSearch() {
        return DEPT_WISE;
    }

    public void prepare() {
        super.prepare();
        List finYrList = this.worksService.getAllFinancialYearsForWorks();
        this.addDropdownData("finYearList", finYrList);
        this.addDropdownData("executingDepartmentList", this.getPersistenceService().findAllBy("from Department", new Object[0]));
        this.addDropdownData("worksTypeList", this.getPersistenceService().findAllBy("from EgwTypeOfWork etw1 where etw1.parentid is null", new Object[0]));
        AjaxEstimateAction ajaxEstimateAction = new AjaxEstimateAction();
        ajaxEstimateAction.setPersistenceService(this.getPersistenceService());
        ajaxEstimateAction.setAssignmentService(this.assignmentService);
        this.populateCategoryList(ajaxEstimateAction, this.getWorksType() == -1 ? false : this.getWorksType() != -1);
        this.addDropdownData("fundList", this.fundDao.findAllActiveIsLeafFunds());
        this.addDropdownData("functionList", this.functionHibDao.findAll());
        this.addDropdownData("schemeList", this.getPersistenceService().findAllBy("from Scheme sc where sc.isactive=true", new Object[0]));
        AjaxWorkProgressAction ajaxWorkProgressAction = new AjaxWorkProgressAction();
        this.populateSubSchemeList(ajaxWorkProgressAction, this.getScheme() != null);
        this.addDropdownData("budgetHeadList", this.getBudgetGroupsFromAppConfig());
        this.addDropdownData("depositCodeList", this.getDepositCodesFromAppConfig());
        this.addDropdownData("allDepositCodeCOAList", this.getPersistenceService().findAllBy("select distinct(fd.coa) from FinancialDetail fd where fd.abstractEstimate in ( select woe.estimate from WorkOrderEstimate woe where woe.workOrder.egwStatus.code='APPROVED' ) order by name  ", new Object[0]));
        this.addDropdownData("allBudgetHeadList", this.getPersistenceService().findAllBy("select distinct(fd.budgetGroup) from FinancialDetail fd where fd.abstractEstimate in ( select woe.estimate from WorkOrderEstimate woe where woe.workOrder.egwStatus.code='APPROVED' ) order by name  ", new Object[0]));
        CFinancialYear financialYear = this.finHibernateDao.getFinYearByDate(new Date());
        if (financialYear != null) {
            this.currentFinancialYearId = financialYear.getId().toString();
        }
        this.finYearRangeStr = this.generateFinYrList(finYrList);
        this.addDropdownData("gradeList", this.getPersistenceService().findAllBy("from ContractorGrade order by upper(grade)", new Object[0]));
        if (this.dropDownBudgetHeads != null && this.dropDownBudgetHeads.size() > 0) {
            this.generateBudgetHeads();
        }
        if (this.dropDownDepositCodes != null && this.dropDownDepositCodes.size() > 0) {
            this.generateDepositCodes();
        }
        if (this.allDepositCodes != null && this.allDepositCodes.size() > 0) {
            this.getDepositCodesFromAllDepositCodes();
        }
        if (this.allBudgetHeads != null && this.allBudgetHeads.size() > 0) {
            this.getBudgetHeadsFromAllBudgetHeads();
        }
        this.setBudgetHeadIdsAndDepositCodeIds();
    }

    private void setBudgetHeadIdsAndDepositCodeIds() {
        if (StringUtils.isNotBlank((String)this.budgetHeadsStr)) {
            this.budgetHeads = new ArrayList();
            this.budgetHeadIds = new ArrayList();
            this.workProgressAbstractReportService.setBudgetHeadsFromString(this.budgetHeadsStr, this.budgetHeads, this.budgetHeadIds);
        }
        if (StringUtils.isNotBlank((String)this.depositCodesStr)) {
            this.depositCodeIds = new ArrayList();
            this.workProgressAbstractReportService.setDepositCodesFromString(this.depositCodesStr, this.depositCodeIds);
        }
        if (StringUtils.isNotBlank((String)this.budgetHeadIdsStr)) {
            this.budgetHeads = new ArrayList();
            this.budgetHeadIds = new ArrayList();
            this.workProgressAbstractReportService.setBudgetHeadsFromIdString(this.budgetHeadIdsStr, this.budgetHeads, this.budgetHeadIds);
        }
        if (StringUtils.isNotBlank((String)this.depositCodeIdsStr)) {
            this.depositCodeIds = new ArrayList();
            this.workProgressAbstractReportService.setDepositCodesFromIdString(this.depositCodeIdsStr, this.depositCodeIds);
        }
    }

    private void formReportMessage() {
        String dateStr = (String)this.persistenceService.getSession().createSQLQuery(" select min(VIEW_TIMESTAMP) from EGW_WPREPORT_EST_WO_MVIEW ").list().get(0);
        this.reportMessage = this.getText("contractorwiseAbstractReport.data.message", new String[]{dateStr});
    }

    public String search() {
        this.resultStatus = "afterSearch";
        this.formReportMessage();
        String commonSearchFilter = this.constructSearchFilter();
        Map queryMap = this.generateQuery(commonSearchFilter);
        String query = (String)queryMap.get("query");
        String countQuery = (String)queryMap.get("count");
        LinkedList listWithRepeatedPramsForUnion = new LinkedList();
        listWithRepeatedPramsForUnion.addAll(this.paramList);
        listWithRepeatedPramsForUnion.addAll(this.paramList);
        listWithRepeatedPramsForUnion.addAll(this.paramList);
        listWithRepeatedPramsForUnion.addAll(this.paramList);
        if (this.searchType.equals("")) {
            SearchQuerySQL sqlQuery = new SearchQuerySQL(query, countQuery, listWithRepeatedPramsForUnion);
            Page resPage = sqlQuery.getPage(this.getPersistenceService(), this.page.intValue(), this.pageSize.intValue());
            this.paginatedList = new EgovPaginatedList(resPage, sqlQuery.getCount(this.getPersistenceService()));
            this.populateData(this.paginatedList.getList());
            if (this.paginatedList.getList() == null) {
                this.paginatedList.setList(this.resultList);
            } else {
                this.paginatedList.getList().clear();
                this.paginatedList.getList().addAll(this.resultList);
            }
        } else if (this.searchType.equalsIgnoreCase("report")) {
            List wholeQueryList = null;
            SQLQuery qry = this.getPersistenceService().getSession().createSQLQuery(query);
            for (int i = 0; i < listWithRepeatedPramsForUnion.size(); ++i) {
                qry.setParameter(i, listWithRepeatedPramsForUnion.get(i));
            }
            wholeQueryList = qry.list();
            this.populateData(wholeQueryList);
        }
        return DEPT_WISE;
    }

    public String viewEstimatePDF() {
        this.setSearchType("report");
        this.showEstimatesTakenUpDrillDown();
        HashMap<String, String> reportParams = new HashMap<String, String>();
        reportParams.put("subHeader", this.subHeader + "\n" + this.reportMessage);
        reportParams.put("mainHeader", this.getText("contractorwiseAbstractReport.showTakenUpEst") + this.getContractorName());
        ReportRequest reportRequest = new ReportRequest("contractorwiseReport_Estimates", (Collection)this.commonBeanList, reportParams);
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.reportInputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        return "estimatePDF";
    }

    public String viewEstimateXLS() {
        this.setSearchType("report");
        this.showEstimatesTakenUpDrillDown();
        HashMap<String, String> reportParams = new HashMap<String, String>();
        reportParams.put("subHeader", this.subHeader + "\n" + this.reportMessage);
        reportParams.put("mainHeader", this.getText("contractorwiseAbstractReport.showTakenUpEst") + this.getContractorName());
        ReportRequest reportRequest = new ReportRequest("contractorwiseReport_Estimates", (Collection)this.commonBeanList, reportParams);
        reportRequest.setReportFormat(ReportFormat.XLS);
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.reportInputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        return "estimateXLS";
    }

    private String getTakenUpQuery(String commonSearchCriteriaQueryStr, String finalBillType) {
        StringBuffer query = new StringBuffer(" SELECT WORK_ORDER_CONTRACTOR_ID,WORK_ORDER_CONTRACTOR_NAME,WORK_ORDER_CONTRACTOR_CODE,  SUM(EST_COUNT) TAKEN_UP_EST_COUNT ,SUM(NVL(WORK_ORDER_WORKORDER_AMOUNT,0)) TAKEN_UP_WO_AMOUNT,  0 COMPLETED_EST_COUNT,0 COMPLETED_PYMT_RLSD,0 IN_PROGRESS_EST_COUNT,0 IN_PROGRESS_NEGO_VAL ,0 IN_PROGRESS_PYMT_RLSD,0 NOT_STARTED_EST_COUNT,0 NOT_STARTED_WO_AMT, SUM(NVL(REV_WO_TAKEN_UP_AMT,0)) REV_WO_TAKEN_UP_AMT_SUM, 0 REV_WO_IN_PROGRESS_NEG_VAL_SUM, 0 REV_WO_NOT_STARTED_AMT_SUM  FROM (select WORK_ORDER_CONTRACTOR_ID , WORK_ORDER_CONTRACTOR_NAME,  WORK_ORDER_CONTRACTOR_CODE, COUNT(DISTINCT(ABS_EST_ID)) EST_COUNT , WORK_ORDER_ID, WORK_ORDER_WORKORDER_AMOUNT,   (SELECT SUM(NVL(INNER_VIEW.WORK_ORDER_WORKORDER_AMOUNT,0)) FROM EGW_WPREPORT_EST_WO_MVIEW INNER_VIEW WHERE INNER_VIEW.WORK_ORDER_PARENTID = OUTER_VIEW.WORK_ORDER_ID) REV_WO_TAKEN_UP_AMT  from EGW_WPREPORT_EST_WO_MVIEW OUTER_VIEW ");
        query.append(" where ABS_EST_PARENTID IS NULL AND WORK_ORDER_STATUS_CODE = 'APPROVED' " + commonSearchCriteriaQueryStr + " group by WORK_ORDER_CONTRACTOR_ID, WORK_ORDER_CONTRACTOR_NAME ,  WORK_ORDER_CONTRACTOR_CODE,WORK_ORDER_ID,WORK_ORDER_WORKORDER_AMOUNT )  group by WORK_ORDER_CONTRACTOR_ID, WORK_ORDER_CONTRACTOR_NAME , WORK_ORDER_CONTRACTOR_CODE ");
        return query.toString();
    }

    private String getCompletedQuery(String commonSearchCriteriaQueryStr, String finalBillType) {
        StringBuffer query = new StringBuffer("");
        query.append(" SELECT WORK_ORDER_CONTRACTOR_ID,");
        query.append("  WORK_ORDER_CONTRACTOR_NAME ,");
        query.append("  WORK_ORDER_CONTRACTOR_CODE, 0 TAKEN_UP_EST_COUNT  ,0 TAKEN_UP_WO_AMOUNT,");
        query.append("  SUM(EST_COUNT) COMPLETED_EST_COUNT ,");
        query.append("  SUM(PYMT_RELEASED_AMT) COMPLETED_PYMT_RLSD , 0 IN_PROGRESS_EST_COUNT,0 IN_PROGRESS_NEGO_VAL,0 IN_PROGRESS_PYMT_RLSD,0 NOT_STARTED_EST_COUNT,0 NOT_STARTED_WO_AMT, 0 REV_WO_TAKEN_UP_AMT_SUM, 0 REV_WO_IN_PROGRESS_NEG_VAL_SUM, 0 REV_WO_NOT_STARTED_AMT_SUM ");
        query.append(" FROM");
        query.append("  (SELECT WORK_ORDER_CONTRACTOR_ID ,");
        query.append("    WORK_ORDER_CONTRACTOR_NAME ,");
        query.append("    WORK_ORDER_CONTRACTOR_CODE,");
        query.append("    WORK_ORDER_ID,");
        query.append("    COUNT(DISTINCT(ABS_EST_ID)) EST_COUNT ,");
        query.append("    (SELECT SUM(NVL(bill_view.PMT_RLSD_TO_CONTRACTOR_FOR_WO,0))");
        query.append("    FROM EGW_WPREPORT_EST_BILLS_MVIEW bill_view");
        query.append("    WHERE bill_view.BILL_REG_BILLTYPE='" + finalBillType + "'");
        query.append("    AND bill_view.WORK_ORDER_ID      =WO_VIEW.WORK_ORDER_ID");
        query.append("    AND bill_view.BILL_REG_BILLSTATUS='APPROVED'");
        query.append("    ) AS PYMT_RELEASED_AMT");
        query.append("  FROM EGW_WPREPORT_EST_WO_MVIEW WO_VIEW");
        query.append("  WHERE WORK_ORDER_STATUS_CODE = 'APPROVED'");
        query.append("  AND WORK_ORDER_ID           IN");
        query.append("    (SELECT bill_view.WORK_ORDER_ID");
        query.append("    FROM EGW_WPREPORT_EST_BILLS_MVIEW bill_view");
        query.append("    WHERE bill_view.BILL_REG_BILLTYPE='" + finalBillType + "'");
        query.append("    AND bill_view.WORK_ORDER_ID      =WO_VIEW.WORK_ORDER_ID");
        query.append("    AND bill_view.BILL_REG_BILLSTATUS='APPROVED'");
        query.append("    )");
        query.append("  AND ABS_EST_PARENTID IS NULL   " + commonSearchCriteriaQueryStr);
        query.append("  GROUP BY WORK_ORDER_CONTRACTOR_ID ,");
        query.append("    WORK_ORDER_CONTRACTOR_NAME ,");
        query.append("    WORK_ORDER_CONTRACTOR_CODE,");
        query.append("    WORK_ORDER_ID");
        query.append("  )");
        query.append(" GROUP BY WORK_ORDER_CONTRACTOR_ID,");
        query.append("  WORK_ORDER_CONTRACTOR_NAME ,");
        query.append("  WORK_ORDER_CONTRACTOR_CODE");
        return query.toString();
    }

    private String getInProgressQuery(String commonSearchCriteriaQueryStr, String finalBillType) {
        StringBuffer query = new StringBuffer("");
        query.append(" SELECT WORK_ORDER_CONTRACTOR_ID , WORK_ORDER_CONTRACTOR_NAME,");
        query.append(" WORK_ORDER_CONTRACTOR_CODE, 0 TAKEN_UP_EST_COUNT  ,0 TAKEN_UP_WO_AMOUNT, 0 COMPLETED_EST_COUNT,0 COMPLETED_PYMT_RLSD, SUM(EST_COUNT) IN_PROGRESS_EST_COUNT, ");
        query.append(" SUM(NVL(TENDER_RESP_NEGOTIATED_VALUE,0)) IN_PROGRESS_NEGO_VAL , SUM(PYMT_RELEASED_AMT) IN_PROGRESS_PYMT_RLSD , 0 NOT_STARTED_EST_COUNT,0 NOT_STARTED_WO_AMT, 0 REV_WO_TAKEN_UP_AMT_SUM, SUM(NVL(REV_WO_IN_PROGRESS_NEG_VAL,0)) REV_WO_IN_PROGRESS_NEG_VAL_SUM,0 REV_WO_NOT_STARTED_AMT_SUM  ");
        query.append(" FROM ");
        query.append(" (");
        query.append(" SELECT WORK_ORDER_CONTRACTOR_ID ,");
        query.append("  WORK_ORDER_CONTRACTOR_NAME ,");
        query.append("  WORK_ORDER_CONTRACTOR_CODE ,");
        query.append("  WORK_ORDER_ID,");
        query.append("  COUNT(DISTINCT(ABS_EST_ID)) EST_COUNT ,");
        query.append("  TENDER_RESP_NEGOTIATED_VALUE,");
        query.append("    (SELECT SUM(NVL(BILL_VIEW.PMT_RLSD_TO_CONTRACTOR_FOR_WO,0))");
        query.append("    FROM EGW_WPREPORT_EST_BILLS_MVIEW BILL_VIEW");
        query.append("    WHERE BILL_VIEW.WORK_ORDER_ID      =EST_VIEW.WORK_ORDER_ID");
        query.append("    AND BILL_VIEW.BILL_REG_BILLSTATUS='APPROVED'");
        query.append("    ) AS PYMT_RELEASED_AMT,  (SELECT SUM(NVL(INNER_VIEW.WORK_ORDER_WORKORDER_AMOUNT,0)) FROM EGW_WPREPORT_EST_WO_MVIEW INNER_VIEW WHERE INNER_VIEW.WORK_ORDER_PARENTID = EST_VIEW.WORK_ORDER_ID) REV_WO_IN_PROGRESS_NEG_VAL ");
        query.append(" FROM EGW_WPREPORT_EST_WO_MVIEW EST_VIEW");
        query.append(" WHERE WORK_ORDER_STATUS_CODE      = 'APPROVED'");
        query.append(" AND WO_LATEST_OFFLINE_STATUS_CODE = 'Work commenced'");
        query.append(" AND '" + finalBillType + "' NOT      IN");
        query.append("  (SELECT DISTINCT(BILL_VIEW.BILL_REG_BILLTYPE)");
        query.append("  FROM EGW_WPREPORT_EST_BILLS_MVIEW BILL_VIEW");
        query.append("  WHERE BILL_VIEW.WORK_ORDER_ID    = EST_VIEW.WORK_ORDER_ID");
        query.append("  AND BILL_VIEW.BILL_REG_BILLSTATUS='APPROVED'");
        query.append("  )");
        query.append(" AND EST_VIEW.TENDER_RESP_STATUS_CODE='APPROVED' ");
        query.append("  AND ABS_EST_PARENTID IS NULL   " + commonSearchCriteriaQueryStr);
        query.append(" GROUP BY WORK_ORDER_CONTRACTOR_ID ,");
        query.append("  WORK_ORDER_CONTRACTOR_NAME ,");
        query.append("  WORK_ORDER_CONTRACTOR_CODE,");
        query.append("  WORK_ORDER_ID,");
        query.append("  TENDER_RESP_NEGOTIATED_VALUE");
        query.append(" )");
        query.append(" GROUP BY WORK_ORDER_CONTRACTOR_ID ,");
        query.append("  WORK_ORDER_CONTRACTOR_NAME ,");
        query.append("  WORK_ORDER_CONTRACTOR_CODE");
        return query.toString();
    }

    private String getNotYetStartedQuery(String commonSearchCriteriaQueryStr, String finalBillType) {
        StringBuffer query = new StringBuffer("");
        query.append(" SELECT WORK_ORDER_CONTRACTOR_ID, WORK_ORDER_CONTRACTOR_NAME,");
        query.append(" WORK_ORDER_CONTRACTOR_CODE,  0 TAKEN_UP_EST_COUNT  ,0 TAKEN_UP_WO_AMOUNT, 0 COMPLETED_EST_COUNT,0 COMPLETED_PYMT_RLSD,  0 IN_PROGRESS_EST_COUNT, 0 IN_PROGRESS_NEGO_VAL, 0 IN_PROGRESS_PYMT_RLSD, ");
        query.append(" SUM(EST_COUNT) NOT_STARTED_EST_COUNT, SUM(NVL(WORK_ORDER_WORKORDER_AMOUNT,0)) NOT_STARTED_WO_AMT, 0 REV_WO_TAKEN_UP_AMT_SUM,0 REV_WO_IN_PROGRESS_NEG_VAL_SUM, SUM(NVL(REV_WO_NOT_STARTED_AMT,0)) REV_WO_NOT_STARTED_AMT_SUM ");
        query.append(" FROM(");
        query.append(" SELECT WORK_ORDER_CONTRACTOR_ID ,");
        query.append("  WORK_ORDER_CONTRACTOR_NAME ,");
        query.append("  WORK_ORDER_CONTRACTOR_CODE ,");
        query.append("  WORK_ORDER_ID,");
        query.append("  COUNT(DISTINCT(ABS_EST_ID)) EST_COUNT,");
        query.append("  WORK_ORDER_WORKORDER_AMOUNT, (SELECT SUM(NVL(INNER_VIEW.WORK_ORDER_WORKORDER_AMOUNT,0)) FROM EGW_WPREPORT_EST_WO_MVIEW INNER_VIEW WHERE INNER_VIEW.WORK_ORDER_PARENTID = OUTER_VIEW.WORK_ORDER_ID) REV_WO_NOT_STARTED_AMT ");
        query.append(" FROM EGW_WPREPORT_EST_WO_MVIEW OUTER_VIEW ");
        query.append(" WHERE (WO_LATEST_OFFLINE_STATUS_CODE!='Work commenced'");
        query.append(" OR WO_LATEST_OFFLINE_STATUS_CODE    IS NULL)");
        query.append(" AND WORK_ORDER_STATUS_CODE           = 'APPROVED' ");
        query.append(" AND ABS_EST_PARENTID IS NULL   " + commonSearchCriteriaQueryStr);
        query.append(" GROUP BY WORK_ORDER_CONTRACTOR_ID , ");
        query.append(" WORK_ORDER_CONTRACTOR_NAME ,");
        query.append(" WORK_ORDER_CONTRACTOR_CODE,");
        query.append(" WORK_ORDER_ID,");
        query.append(" WORK_ORDER_WORKORDER_AMOUNT ");
        query.append(" )");
        query.append(" GROUP BY WORK_ORDER_CONTRACTOR_ID , ");
        query.append(" WORK_ORDER_CONTRACTOR_NAME ,");
        query.append(" WORK_ORDER_CONTRACTOR_CODE");
        return query.toString();
    }

    private Map<String, String> generateQuery(String commonSearchCriteriaQueryStr) {
        String finalBillType = this.worksService.getWorksConfigValue("FinalBillType");
        String getTakenUpQuery = this.getTakenUpQuery(commonSearchCriteriaQueryStr, finalBillType);
        String getCompletedQuery = this.getCompletedQuery(commonSearchCriteriaQueryStr, finalBillType);
        String getInProgressQuery = this.getInProgressQuery(commonSearchCriteriaQueryStr, finalBillType);
        String getNotYetStartedQuery = this.getNotYetStartedQuery(commonSearchCriteriaQueryStr, finalBillType);
        String mainQuery = " select WORK_ORDER_CONTRACTOR_ID, WORK_ORDER_CONTRACTOR_NAME, WORK_ORDER_CONTRACTOR_CODE,  SUM(TAKEN_UP_EST_COUNT),SUM(TAKEN_UP_WO_AMOUNT),  SUM(COMPLETED_EST_COUNT),SUM(COMPLETED_PYMT_RLSD), SUM(IN_PROGRESS_EST_COUNT),SUM(IN_PROGRESS_NEGO_VAL), SUM(IN_PROGRESS_PYMT_RLSD),SUM(NOT_STARTED_EST_COUNT), SUM(NOT_STARTED_WO_AMT), SUM(NVL(REV_WO_TAKEN_UP_AMT_SUM,0)), SUM(NVL(REV_WO_IN_PROGRESS_NEG_VAL_SUM,0)), SUM(NVL(REV_WO_NOT_STARTED_AMT_SUM,0)) FROM ( " + getTakenUpQuery + " UNION " + getCompletedQuery + " UNION " + getInProgressQuery + " UNION " + getNotYetStartedQuery + " ) GROUP BY WORK_ORDER_CONTRACTOR_ID, WORK_ORDER_CONTRACTOR_NAME,WORK_ORDER_CONTRACTOR_CODE ";
        HashMap<String, String> returnMap = new HashMap<String, String>();
        returnMap.put("query", mainQuery.toString());
        returnMap.put("count", "Select count (*) from (" + mainQuery.toString() + ")");
        return returnMap;
    }

    private void populateData(List<Object[]> objResultList) {
        if (objResultList != null && objResultList.size() > 0) {
            this.populateBeanData(objResultList);
            this.populateBalanceInfo();
            this.populateContractorClass();
            if (this.searchType.equalsIgnoreCase("report")) {
                this.populateTotalRow();
            }
            this.convertAllAmountsToCrores();
        }
    }

    private void populateBeanData(List<Object[]> objResultList) {
        ContractorwiseReportBean bean = null;
        for (Object[] objArr : objResultList) {
            bean = new ContractorwiseReportBean();
            if (objArr[0] != null) {
                bean.setContractorId(Long.valueOf(((BigDecimal)objArr[0]).longValue()));
            }
            if (objArr[1] != null) {
                bean.setContractorName(objArr[1].toString());
            }
            if (objArr[2] != null) {
                bean.setContractorCode(objArr[2].toString());
            }
            if (objArr[3] != null) {
                bean.setTakenUpEstimateCount(Integer.valueOf(((BigDecimal)objArr[3]).intValue()));
            }
            if (objArr[4] != null) {
                bean.setTakenUpWOAmount((BigDecimal)objArr[4]);
            }
            if (objArr[5] != null) {
                bean.setCompletedEstimateCount(Integer.valueOf(((BigDecimal)objArr[5]).intValue()));
            }
            if (objArr[6] != null) {
                bean.setCompletedWOAmount((BigDecimal)objArr[6]);
            }
            if (objArr[7] != null) {
                bean.setInProgressEstimateCount(Integer.valueOf(((BigDecimal)objArr[7]).intValue()));
            }
            if (objArr[8] != null) {
                bean.setInProgressTenderNegotiatedAmt((BigDecimal)objArr[8]);
            }
            if (objArr[9] != null) {
                bean.setInProgressPaymentReleasedAmt((BigDecimal)objArr[9]);
            }
            if (objArr[10] != null) {
                bean.setNotYetStartedEstimateCount(Integer.valueOf(((BigDecimal)objArr[10]).intValue()));
            }
            if (objArr[11] != null) {
                bean.setNotYetStartedWOAmount((BigDecimal)objArr[11]);
            }
            if (objArr[12] != null) {
                bean.setTakenUpWOAmount(bean.getTakenUpWOAmount().add((BigDecimal)objArr[12]));
            }
            if (objArr[13] != null) {
                bean.setInProgressTenderNegotiatedAmt(bean.getInProgressTenderNegotiatedAmt().add((BigDecimal)objArr[13]));
            }
            if (objArr[14] != null) {
                bean.setNotYetStartedWOAmount(bean.getNotYetStartedWOAmount().add((BigDecimal)objArr[14]));
            }
            bean.setInProgressBalanceAmount(bean.getInProgressTenderNegotiatedAmt().subtract(bean.getInProgressPaymentReleasedAmt()));
            this.resultList.add(bean);
        }
    }

    private void populateBalanceInfo() {
        for (ContractorwiseReportBean bean : this.resultList) {
            bean.setBalanceAmount(bean.getInProgressTenderNegotiatedAmt().add(bean.getNotYetStartedWOAmount()));
            bean.setBalanceEstimateCount(Integer.valueOf(bean.getInProgressEstimateCount() + bean.getNotYetStartedEstimateCount()));
        }
    }

    private void convertAllAmountsToCrores() {
        for (ContractorwiseReportBean bean : this.resultList) {
            bean.setBalanceAmount(this.workProgressAbstractReportService.getRoundedOfAmount((Object)bean.getBalanceAmount(), 4));
            bean.setCompletedWOAmount(this.workProgressAbstractReportService.getRoundedOfAmount((Object)bean.getCompletedWOAmount(), 4));
            bean.setInProgressBalanceAmount(this.workProgressAbstractReportService.getRoundedOfAmount((Object)bean.getInProgressBalanceAmount(), 4));
            bean.setInProgressPaymentReleasedAmt(this.workProgressAbstractReportService.getRoundedOfAmount((Object)bean.getInProgressPaymentReleasedAmt(), 4));
            bean.setInProgressTenderNegotiatedAmt(this.workProgressAbstractReportService.getRoundedOfAmount((Object)bean.getInProgressTenderNegotiatedAmt(), 4));
            bean.setNotYetStartedWOAmount(this.workProgressAbstractReportService.getRoundedOfAmount((Object)bean.getNotYetStartedWOAmount(), 4));
            bean.setTakenUpWOAmount(this.workProgressAbstractReportService.getRoundedOfAmount((Object)bean.getTakenUpWOAmount(), 4));
        }
    }

    private void populateContractorClass() {
        LinkedList<Long> contractorIdList = new LinkedList<Long>();
        for (ContractorwiseReportBean bean : this.resultList) {
            contractorIdList.add(bean.getContractorId());
        }
        String contractorClassQry = " select cd.contractor_id,cg.grade from egw_contractor_detail cd,   egw_contractor_grade cg where cg.id= cd.contractor_grade_id and cd.contractor_id in (:contractorIdList) group by cd.contractor_id,cg.grade ";
        SQLQuery sqlQuery = this.getPersistenceService().getSession().createSQLQuery(" select cd.contractor_id,cg.grade from egw_contractor_detail cd,   egw_contractor_grade cg where cg.id= cd.contractor_grade_id and cd.contractor_id in (:contractorIdList) group by cd.contractor_id,cg.grade ");
        sqlQuery.setParameterList("contractorIdList", contractorIdList);
        List resultObjList = sqlQuery.list();
        if (resultObjList != null) {
            HashMap<String, String> contractorIdGradeMap = new HashMap<String, String>();
            String concGrade = null;
            for (Object[] objArr : resultObjList) {
                if (objArr[1] == null) continue;
                concGrade = (String)contractorIdGradeMap.get(objArr[0].toString());
                if (concGrade == null) {
                    contractorIdGradeMap.put(objArr[0].toString(), objArr[1].toString());
                    continue;
                }
                contractorIdGradeMap.put(objArr[0].toString(), concGrade + "," + objArr[1].toString());
            }
            for (String key : contractorIdGradeMap.keySet()) {
                for (ContractorwiseReportBean bean : this.resultList) {
                    if (Long.parseLong(key) != bean.getContractorId()) continue;
                    bean.setContractorClass((String)contractorIdGradeMap.get(key));
                }
            }
        }
    }

    private void populateTotalRow() {
        ContractorwiseReportBean totalBean = new ContractorwiseReportBean();
        totalBean.setContractorName("Total");
        for (ContractorwiseReportBean bean : this.resultList) {
            totalBean.setBalanceAmount(bean.getBalanceAmount().add(totalBean.getBalanceAmount()));
            totalBean.setBalanceEstimateCount(Integer.valueOf(bean.getBalanceEstimateCount() + totalBean.getBalanceEstimateCount()));
            totalBean.setCompletedEstimateCount(Integer.valueOf(bean.getCompletedEstimateCount() + totalBean.getCompletedEstimateCount()));
            totalBean.setCompletedWOAmount(bean.getCompletedWOAmount().add(totalBean.getCompletedWOAmount()));
            totalBean.setInProgressBalanceAmount(bean.getInProgressBalanceAmount().add(totalBean.getInProgressBalanceAmount()));
            totalBean.setInProgressEstimateCount(Integer.valueOf(bean.getInProgressEstimateCount() + totalBean.getInProgressEstimateCount()));
            totalBean.setInProgressPaymentReleasedAmt(bean.getInProgressPaymentReleasedAmt().add(totalBean.getInProgressPaymentReleasedAmt()));
            totalBean.setInProgressTenderNegotiatedAmt(bean.getInProgressTenderNegotiatedAmt().add(totalBean.getInProgressTenderNegotiatedAmt()));
            totalBean.setNotYetStartedEstimateCount(Integer.valueOf(bean.getNotYetStartedEstimateCount() + totalBean.getNotYetStartedEstimateCount()));
            totalBean.setNotYetStartedWOAmount(bean.getNotYetStartedWOAmount().add(totalBean.getNotYetStartedWOAmount()));
            totalBean.setTakenUpEstimateCount(Integer.valueOf(bean.getTakenUpEstimateCount() + totalBean.getTakenUpEstimateCount()));
            totalBean.setTakenUpWOAmount(bean.getTakenUpWOAmount().add(totalBean.getTakenUpWOAmount()));
        }
        this.resultList.add(totalBean);
    }

    public String generatePDF() {
        this.searchType = "report";
        this.search();
        ReportRequest reportRequest = new ReportRequest("contractorwiseAbstractReport", (Collection)this.resultList, this.getParamMap());
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.reportInputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        return PDF;
    }

    public String generateXLS() {
        this.searchType = "report";
        this.search();
        ReportRequest reportRequest = new ReportRequest("contractorwiseAbstractReport", (Collection)this.resultList, this.getParamMap());
        reportRequest.setReportFormat(ReportFormat.XLS);
        ReportOutput reportOutput = this.reportService.createReport(reportRequest);
        if (reportOutput != null && reportOutput.getReportOutputData() != null) {
            this.reportInputStream = new ByteArrayInputStream(reportOutput.getReportOutputData());
        }
        return XLS;
    }

    private Map<String, Object> getParamMap() {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        reportParams.put("reportTitle", this.getText("contractorwiseAbstractReport.title"));
        reportParams.put("subHeader", this.getSubHeader() + "\n" + this.reportMessage);
        return reportParams;
    }

    private String getTakenUpEstimateDrillDownQuery() {
        String searchConditions = this.constructSearchFilter();
        StringBuffer query = new StringBuffer(" select ABS_EST_ID,ABS_EST_ESTIMATE_NUMBER,ABS_EST_ESTIMATEDATE,ABS_EST_NAME,ABS_EST_WARD_NAME,ABS_EST_APPROVEDDATE,ABS_EST_VALUE_WITH_OH from EGW_WPREPORT_EST_WO_MVIEW ");
        query.append(" where  WORK_ORDER_STATUS_CODE = 'APPROVED' " + searchConditions + " order by ABS_EST_ESTIMATEDATE ");
        return query.toString();
    }

    public String showEstimatesTakenUpDrillDown() {
        this.formReportMessage();
        String query = this.getTakenUpEstimateDrillDownQuery();
        String countQuery = " select count (*) from ( " + query + ")";
        List resultBeanList = null;
        if (this.searchType.equals("")) {
            SearchQuerySQL sqlQuery = new SearchQuerySQL(query, countQuery, this.paramList);
            Page resPage = sqlQuery.getPage(this.getPersistenceService(), this.page.intValue(), this.pageSize.intValue());
            this.paginatedList = new EgovPaginatedList(resPage, sqlQuery.getCount(this.getPersistenceService()));
            resultBeanList = this.generateEstimateList(this.paginatedList.getList());
            if (this.paginatedList.getList() == null) {
                this.paginatedList.setList(resultBeanList);
            } else {
                this.paginatedList.getList().clear();
                this.paginatedList.getList().addAll(resultBeanList);
            }
        } else if (this.searchType.equalsIgnoreCase("report")) {
            List wholeQueryList = null;
            SQLQuery qry = this.getPersistenceService().getSession().createSQLQuery(query);
            for (int i = 0; i < this.paramList.size(); ++i) {
                qry.setParameter(i, this.paramList.get(i));
            }
            wholeQueryList = qry.list();
            resultBeanList = this.generateEstimateList(wholeQueryList);
            this.commonBeanList.addAll(resultBeanList);
        }
        return "showEstimatesForDrillDown";
    }

    private List<CommonDrillDownReportBean> generateEstimateList(List<Object[]> objArrList) {
        LinkedList<CommonDrillDownReportBean> beanList = new LinkedList<CommonDrillDownReportBean>();
        CommonDrillDownReportBean bean = null;
        BigDecimal amount = null;
        for (Object[] objArr : objArrList) {
            bean = new CommonDrillDownReportBean();
            bean.setEstimateId(Long.valueOf(((BigDecimal)objArr[0]).longValue()));
            bean.setEstNumber(objArr[1].toString());
            bean.setEstDate((Date)objArr[2]);
            bean.setEstName(objArr[3].toString());
            bean.setWardName(objArr[4].toString());
            bean.setEstApprovedDate((Date)objArr[5]);
            amount = (BigDecimal)objArr[6];
            if (amount != null) {
                bean.setEstAmount(new BigDecimal(amount.toString()).setScale(2, RoundingMode.HALF_UP));
            }
            beanList.add(bean);
        }
        return beanList;
    }

    private String constructSearchFilter() {
        StringBuffer queryBfr = new StringBuffer(1000);
        this.paramList = new LinkedList();
        if (this.fromDate != null && this.toDate != null) {
            queryBfr.append(" AND TRUNC(WORK_ORDER_APPROVEDDATE) between '" + this.dateFormatter.format(this.fromDate) + "' and '" + this.dateFormatter.format(this.toDate) + "' ");
        }
        if (this.fromDate != null && this.toDate == null) {
            queryBfr.append(" AND TRUNC(WORK_ORDER_APPROVEDDATE) >= '" + this.dateFormatter.format(this.fromDate) + "' ");
        }
        if (this.fromDate == null && this.toDate != null) {
            queryBfr.append(" AND TRUNC(WORK_ORDER_APPROVEDDATE) <= '" + this.dateFormatter.format(this.toDate) + "' ");
        }
        if (this.executingDepartment != null && this.executingDepartment != -1) {
            queryBfr.append(" AND ABS_EST_EXECUTINGDEPARTMENT=?");
            this.paramList.add(this.executingDepartment);
        }
        if (this.worksType != null && this.worksType != -1) {
            queryBfr.append(" AND ABS_EST_PARENT_CATEGORY=?");
            this.paramList.add(this.worksType);
        }
        if (this.worksSubType != null && this.worksSubType != -1) {
            queryBfr.append(" AND ABS_EST_CATEGORY=?");
            this.paramList.add(this.worksSubType);
        }
        if (this.fund != null && this.fund != -1) {
            queryBfr.append(" AND FIN_DETAILS_FUND_ID=? ");
            this.paramList.add(this.fund);
        }
        if (this.function != null && this.function != -1) {
            queryBfr.append(" AND FIN_DETAILS_FUNCTION_ID=?");
            this.paramList.add(this.function);
        }
        if (this.scheme != null && this.scheme != -1) {
            queryBfr.append(" AND FIN_DETAILS_SCHEME_ID=?");
            this.paramList.add(this.scheme);
        }
        if (this.subScheme != null && this.subScheme != -1) {
            queryBfr.append(" AND FIN_DETAILS_SUBSCHEME_ID=?");
            this.paramList.add(this.subScheme);
        }
        if (!(this.budgetHeads == null || this.budgetHeads.isEmpty() || this.budgetHeads.contains("-1") || ((String)this.budgetHeads.get(0)).equals("") || this.depositCodeIds == null || this.depositCodeIds.isEmpty())) {
            int i;
            queryBfr.append(" AND ( ");
            if (!(this.budgetHeads == null || this.budgetHeads.isEmpty() || this.budgetHeads.contains("-1") || ((String)this.budgetHeads.get(0)).equals(""))) {
                queryBfr.append("  FIN_DETAILS_BUDGETGROUP_ID in (");
                for (i = 0; i < this.budgetHeadIds.size(); ++i) {
                    if (i == 0) {
                        queryBfr.append(" ?");
                    } else {
                        queryBfr.append(" ,? ");
                    }
                    this.paramList.add(this.budgetHeadIds.get(i));
                }
                queryBfr.append(" ) ");
            }
            if (this.depositCodeIds != null && !this.depositCodeIds.isEmpty()) {
                queryBfr.append(" OR FIN_DETAILS_COA_ID in (");
                for (i = 0; i < this.depositCodeIds.size(); ++i) {
                    if (i == 0) {
                        queryBfr.append(" ?");
                    } else {
                        queryBfr.append(" ,? ");
                    }
                    this.paramList.add(this.depositCodeIds.get(i));
                }
                queryBfr.append(" ) ");
            }
            queryBfr.append("  ) ");
        } else {
            int i;
            if (!(this.budgetHeads == null || this.budgetHeads.isEmpty() || this.budgetHeads.contains("-1") || ((String)this.budgetHeads.get(0)).equals(""))) {
                queryBfr.append(" AND FIN_DETAILS_BUDGETGROUP_ID in (");
                for (i = 0; i < this.budgetHeadIds.size(); ++i) {
                    if (i == 0) {
                        queryBfr.append(" ?");
                    } else {
                        queryBfr.append(" ,? ");
                    }
                    this.paramList.add(this.budgetHeadIds.get(i));
                }
                queryBfr.append(" ) ");
            }
            if (this.depositCodeIds != null && !this.depositCodeIds.isEmpty()) {
                queryBfr.append(" AND FIN_DETAILS_COA_ID in (");
                for (i = 0; i < this.depositCodeIds.size(); ++i) {
                    if (i == 0) {
                        queryBfr.append(" ?");
                    } else {
                        queryBfr.append(" ,? ");
                    }
                    this.paramList.add(this.depositCodeIds.get(i));
                }
                queryBfr.append(" ) ");
            }
        }
        if (this.contractorId != null && this.contractorId != -1L && StringUtils.isNotBlank((String)this.contractorName)) {
            queryBfr.append(" AND WORK_ORDER_CONTRACTOR_ID=?");
            this.paramList.add(this.contractorId);
        } else if (StringUtils.isNotBlank((String)this.contractorName)) {
            queryBfr.append(" AND WORK_ORDER_CONTRACTOR_NAME like '%" + this.contractorName + "%'");
        }
        if (this.gradeId != null && this.gradeId != -1L) {
            queryBfr.append(" AND WORK_ORDER_CONTRACTOR_ID IN ( SELECT CONTRACTOR_ID FROM EGW_CONTRACTOR_DETAIL WHERE CONTRACTOR_GRADE_ID=? AND CONTRACTOR_ID=WORK_ORDER_CONTRACTOR_ID)");
            this.paramList.add(this.gradeId);
        }
        return queryBfr.toString();
    }

    private void generateBudgetHeads() {
        ArrayList coaList = new ArrayList();
        ArrayList budgetHeadList = new ArrayList();
        if (this.dropDownBudgetHeads.size() == 1 && ((String)this.dropDownBudgetHeads.get(0)).equalsIgnoreCase("All")) {
            String[] budgetHeadsFromAppConf;
            for (String element : budgetHeadsFromAppConf = this.budgetHeadsAppConfValue.split(",")) {
                coaList.addAll(this.chartOfAccountsHibernateDAO.getListOfDetailCode(element.split("-")[0]));
            }
            budgetHeadList.addAll(this.budgetDetailsDAO.getBudgetHeadForGlcodeList(coaList));
        }
        if (!((String)this.dropDownBudgetHeads.get(0)).equalsIgnoreCase("All")) {
            for (int i = 0; i < this.dropDownBudgetHeads.size(); ++i) {
                coaList.addAll(this.chartOfAccountsHibernateDAO.getListOfDetailCode(((String)this.dropDownBudgetHeads.get(i)).split("-")[0]));
            }
            budgetHeadList.addAll(this.budgetDetailsDAO.getBudgetHeadForGlcodeList(coaList));
        }
        ArrayList<Long> budgetHeadIdsLong = new ArrayList<Long>();
        ArrayList<String> budgetHeadIdStr = new ArrayList<String>();
        if (budgetHeadList != null && budgetHeadList.size() > 0) {
            for (BudgetGroup bdgtGrp : budgetHeadList) {
                budgetHeadIdStr.add(bdgtGrp.getId().toString());
                budgetHeadIdsLong.add(bdgtGrp.getId());
            }
        }
        this.budgetHeads = budgetHeadIdStr;
        this.budgetHeadIds = budgetHeadIdsLong;
    }

    private void generateDepositCodes() {
        ArrayList coaList = new ArrayList();
        if (this.dropDownDepositCodes.size() == 1 && ((String)this.dropDownDepositCodes.get(0)).equalsIgnoreCase("All")) {
            String[] depositCodesFromAppConf = this.depositCodesAppConfValue.split(",");
            for (String element : depositCodesFromAppConf) {
                coaList.addAll(this.chartOfAccountsHibernateDAO.getListOfDetailCode(element.split("-")[0]));
            }
        }
        if (!((String)this.dropDownDepositCodes.get(0)).equalsIgnoreCase("All")) {
            for (int i = 0; i < this.dropDownDepositCodes.size(); ++i) {
                coaList.addAll(this.chartOfAccountsHibernateDAO.getListOfDetailCode(((String)this.dropDownDepositCodes.get(i)).split("-")[0]));
            }
        }
        ArrayList<Long> depositCodeIdsLong = new ArrayList<Long>();
        if (coaList != null && coaList.size() > 0) {
            for (CChartOfAccounts coa : coaList) {
                depositCodeIdsLong.add(coa.getId());
            }
        }
        this.depositCodeIds = depositCodeIdsLong;
    }

    private void getBudgetHeadsFromAllBudgetHeads() {
        this.budgetHeadIds = this.allBudgetHeads;
        this.budgetHeads = new ArrayList();
        for (int i = 0; i < this.allBudgetHeads.size(); ++i) {
            this.budgetHeads.add(((Long)this.allBudgetHeads.get(i)).toString());
        }
    }

    private void getDepositCodesFromAllDepositCodes() {
        this.depositCodeIds = this.allDepositCodes;
    }

    private String generateFinYrList(List<CFinancialYear> finYrList) {
        Date todaysDate = new Date();
        StringBuffer finStrBfr = new StringBuffer();
        for (CFinancialYear yr : finYrList) {
            if (yr.getStartingDate().compareTo(todaysDate) <= 0 && yr.getEndingDate().compareTo(todaysDate) >= 0) {
                finStrBfr.append("id:" + yr.getId() + "--" + DateUtils.getFormattedDate((Date)yr.getStartingDate(), (String)"dd/MM/yyyy") + "--" + DateUtils.getFormattedDate((Date)todaysDate, (String)"dd/MM/yyyy"));
                continue;
            }
            finStrBfr.append("id:" + yr.getId() + "--" + DateUtils.getFormattedDate((Date)yr.getStartingDate(), (String)"dd/MM/yyyy") + "--" + DateUtils.getFormattedDate((Date)yr.getEndingDate(), (String)"dd/MM/yyyy"));
        }
        return finStrBfr.toString();
    }

    private List<String> getBudgetGroupsFromAppConfig() {
        ArrayList<String> budgetGrpStrList = new ArrayList<String>();
        budgetGrpStrList.add("All");
        this.budgetHeadsAppConfValue = this.worksService.getWorksConfigValue(BUDGET_HEADS_APPCONFIG_KEY);
        if (this.budgetHeadsAppConfValue != null) {
            for (String appValues : this.budgetHeadsAppConfValue.split(",")) {
                budgetGrpStrList.add(appValues);
            }
        }
        return budgetGrpStrList;
    }

    private List<String> getDepositCodesFromAppConfig() {
        ArrayList<String> glcodesStrList = new ArrayList<String>();
        glcodesStrList.add("All");
        this.depositCodesAppConfValue = this.worksService.getWorksConfigValue(DEPOSITCODES_APPCONFIG_KEY);
        if (this.depositCodesAppConfValue != null) {
            for (String appValues : this.depositCodesAppConfValue.split(",")) {
                glcodesStrList.add(appValues);
            }
        }
        return glcodesStrList;
    }

    private void populateCategoryList(AjaxEstimateAction ajaxEstimateAction, boolean categoryPopulated) {
        if (categoryPopulated) {
            ajaxEstimateAction.setCategory(Long.valueOf(this.getWorksType().longValue()));
            ajaxEstimateAction.subcategories();
            this.addDropdownData("worksSubTypeList", ajaxEstimateAction.getSubCategories());
        } else {
            this.addDropdownData("worksSubTypeList", Collections.emptyList());
        }
    }

    private void populateSubSchemeList(AjaxWorkProgressAction ajaxWorkProgressAction, boolean schemePopulated) {
        if (schemePopulated) {
            ajaxWorkProgressAction.setPersistenceService(this.getPersistenceService());
            ajaxWorkProgressAction.setSchemeId(this.getScheme());
            ajaxWorkProgressAction.loadSubSchemes();
            this.addDropdownData("subSchemeList", ajaxWorkProgressAction.getSubSchemes());
        } else {
            this.addDropdownData("subSchemeList", Collections.emptyList());
        }
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public Integer getExecutingDepartment() {
        return this.executingDepartment;
    }

    public Integer getWorksType() {
        return this.worksType;
    }

    public Integer getWorksSubType() {
        return this.worksSubType;
    }

    public Integer getFund() {
        return this.fund;
    }

    public Integer getFunction() {
        return this.function;
    }

    public Integer getScheme() {
        return this.scheme;
    }

    public Integer getSubScheme() {
        return this.subScheme;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public void setExecutingDepartment(Integer executingDepartment) {
        this.executingDepartment = executingDepartment;
    }

    public void setWorksType(Integer worksType) {
        this.worksType = worksType;
    }

    public void setWorksSubType(Integer worksSubType) {
        this.worksSubType = worksSubType;
    }

    public void setFund(Integer fund) {
        this.fund = fund;
    }

    public void setFunction(Integer function) {
        this.function = function;
    }

    public void setScheme(Integer scheme) {
        this.scheme = scheme;
    }

    public void setSubScheme(Integer subScheme) {
        this.subScheme = subScheme;
    }

    public void setPersonalInformationService(PersonalInformationService personalInformationService) {
    }

    public String getBudgetHeadsAppConfValue() {
        return this.budgetHeadsAppConfValue;
    }

    public void setBudgetHeadsAppConfValue(String budgetHeadsAppConfValue) {
        this.budgetHeadsAppConfValue = budgetHeadsAppConfValue;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public List<String> getDropDownBudgetHeads() {
        return this.dropDownBudgetHeads;
    }

    public void setDropDownBudgetHeads(List<String> dropDownBudgetHeads) {
        this.dropDownBudgetHeads = dropDownBudgetHeads;
    }

    public String getDepositCodesAppConfValue() {
        return this.depositCodesAppConfValue;
    }

    public void setDepositCodesAppConfValue(String depositCodesAppConfValue) {
        this.depositCodesAppConfValue = depositCodesAppConfValue;
    }

    public List<String> getDropDownDepositCodes() {
        return this.dropDownDepositCodes;
    }

    public void setDropDownDepositCodes(List<String> dropDownDepositCodes) {
        this.dropDownDepositCodes = dropDownDepositCodes;
    }

    public List<Long> getAllDepositCodes() {
        return this.allDepositCodes;
    }

    public void setAllDepositCodes(List<Long> allDepositCodes) {
        this.allDepositCodes = allDepositCodes;
    }

    public List<Long> getAllBudgetHeads() {
        return this.allBudgetHeads;
    }

    public void setAllBudgetHeads(List<Long> allBudgetHeads) {
        this.allBudgetHeads = allBudgetHeads;
    }

    public String getFinYearId() {
        return this.finYearId;
    }

    public void setFinYearId(String finYearId) {
        this.finYearId = finYearId;
    }

    public String getFinYearRange() {
        return this.finYearRange;
    }

    public void setFinYearRange(String finYearRange) {
        this.finYearRange = finYearRange;
    }

    public String getCurrentFinancialYearId() {
        return this.currentFinancialYearId;
    }

    public void setCurrentFinancialYearId(String currentFinancialYearId) {
        this.currentFinancialYearId = currentFinancialYearId;
    }

    public String getFinYearRangeStr() {
        return this.finYearRangeStr;
    }

    public String getSubHeader() {
        return this.subHeader;
    }

    public void setSubHeader(String subHeader) {
        this.subHeader = subHeader;
    }

    public String getContractorName() {
        return this.contractorName;
    }

    public Long getContractorId() {
        return this.contractorId;
    }

    public void setContractorName(String contractorName) {
        this.contractorName = contractorName;
    }

    public void setContractorId(Long contractorId) {
        this.contractorId = contractorId;
    }

    public Long getGradeId() {
        return this.gradeId;
    }

    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }

    public List<String> getBudgetHeads() {
        return this.budgetHeads;
    }

    public void setBudgetHeads(List<String> budgetHeads) {
        this.budgetHeads = budgetHeads;
    }

    public void setBudgetDetailsDAO(BudgetDetailsDAO budgetDetailsDAO) {
        this.budgetDetailsDAO = budgetDetailsDAO;
    }

    public List<ContractorwiseReportBean> getResultList() {
        return this.resultList;
    }

    public void setResultList(List<ContractorwiseReportBean> resultList) {
        this.resultList = resultList;
    }

    public String getResultStatus() {
        return this.resultStatus;
    }

    public InputStream getReportInputStream() {
        return this.reportInputStream;
    }

    public void setReportService(ReportService reportService) {
        this.reportService = reportService;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public List<CommonDrillDownReportBean> getCommonBeanList() {
        return this.commonBeanList;
    }

    public void setWorkProgressAbstractReportService(WorkProgressAbstractReportService workProgressAbstractReportService) {
        this.workProgressAbstractReportService = workProgressAbstractReportService;
    }

    public void setSearchType(String searchType) {
        this.searchType = searchType;
    }

    public EgovPaginatedList getPaginatedList() {
        return this.paginatedList;
    }

    public void setPaginatedList(EgovPaginatedList paginatedList) {
        this.paginatedList = paginatedList;
    }

    public String getBudgetHeadsStr() {
        return this.budgetHeadsStr;
    }

    public String getDepositCodesStr() {
        return this.depositCodesStr;
    }

    public String getDepositCodeIdsStr() {
        return this.depositCodeIdsStr;
    }

    public String getBudgetHeadIdsStr() {
        return this.budgetHeadIdsStr;
    }

    public void setBudgetHeadsStr(String budgetHeadsStr) {
        this.budgetHeadsStr = budgetHeadsStr;
    }

    public void setDepositCodesStr(String depositCodesStr) {
        this.depositCodesStr = depositCodesStr;
    }

    public void setDepositCodeIdsStr(String depositCodeIdsStr) {
        this.depositCodeIdsStr = depositCodeIdsStr;
    }

    public void setBudgetHeadIdsStr(String budgetHeadIdsStr) {
        this.budgetHeadIdsStr = budgetHeadIdsStr;
    }

    public String getReportMessage() {
        return this.reportMessage;
    }
}

