/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.lineestimate;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Set;
import org.codehaus.jackson.JsonGenerationException;
import org.codehaus.jackson.map.JsonMappingException;
import org.egov.commons.CFinancialYear;
import org.egov.commons.CFunction;
import org.egov.commons.EgwTypeOfWork;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.dao.EgwTypeOfWorkHibernateDAO;
import org.egov.commons.service.FinancialYearService;
import org.egov.commons.service.FunctionService;
import org.egov.dao.budget.BudgetDetailsHibernateDAO;
import org.egov.dao.budget.BudgetGroupDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CrossHierarchyService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.utils.JsonUtils;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.support.json.adapter.UserAdaptor;
import org.egov.model.budget.BudgetGroup;
import org.egov.services.masters.SchemeService;
import org.egov.utils.BudgetAccountType;
import org.egov.works.abstractestimate.entity.EstimatePhotographSearchRequest;
import org.egov.works.lineestimate.entity.LineEstimate;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.entity.LineEstimateForLoaSearchRequest;
import org.egov.works.lineestimate.entity.LineEstimateSearchRequest;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.master.service.NatureOfWorkService;
import org.egov.works.models.masters.NatureOfWork;
import org.egov.works.web.adaptor.LineEstimateForEstimatePhotographJsonAdaptor;
import org.egov.works.web.adaptor.LineEstimateForLOAJsonAdaptor;
import org.egov.works.web.adaptor.LineEstimateJsonAdaptor;
import org.egov.works.web.adaptor.SearchLineEstimateToCancelJSONAdaptor;
import org.egov.works.web.adaptor.SubSchemeAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/lineestimate"})
public class AjaxLineEstimateController {
    @Autowired
    private SchemeService schemeService;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private CrossHierarchyService crossHierarchyService;
    @Autowired
    private EgwTypeOfWorkHibernateDAO egwTypeOfWorkHibernateDAO;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private LineEstimateJsonAdaptor lineEstimateJsonAdaptor;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private UserService userService;
    @Autowired
    private SearchLineEstimateToCancelJSONAdaptor searchLineEstimateToCancelJSONAdaptor;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;
    @Autowired
    private FinancialYearService financialYearService;
    @Autowired
    private BudgetGroupDAO budgetGroupDAO;
    @Autowired
    private FunctionService functionService;
    @Autowired
    private BudgetDetailsHibernateDAO budgetDetailsHibernateDAO;
    @Autowired
    private NatureOfWorkService natureOfWorkService;
    @Autowired
    private LineEstimateForEstimatePhotographJsonAdaptor lineEstimateForEstimatePhotographJsonAdaptor;

    @RequestMapping(value={"/getsubschemesbyschemeid/{schemeId}"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getAllSubSchemesBySchemeId(Model model, @PathVariable String schemeId) throws IOException, NumberFormatException, ApplicationException {
        Scheme scheme = (Scheme)this.schemeService.findById((Serializable)Integer.valueOf(Integer.parseInt(schemeId)), false);
        Set subSchemes = scheme.getSubSchemes();
        String jsonResponse = JsonUtils.toJSON((Collection)subSchemes, SubScheme.class, SubSchemeAdaptor.class);
        return jsonResponse;
    }

    @RequestMapping(value={"/getfinancilyearbyid"}, method={RequestMethod.GET})
    @ResponseBody
    public CFinancialYear getFinancilYearById(@RequestParam(value="fyId") Long fyId) {
        CFinancialYear financialYear = new CFinancialYear();
        if (fyId != null) {
            financialYear = (CFinancialYear)this.financialYearService.findById((Serializable)fyId, false);
        }
        return financialYear;
    }

    @RequestMapping(value={"/ajax-getlocation"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Boundary> getChildBoundariesById(@RequestParam Long id) {
        return this.crossHierarchyService.getActiveChildBoundariesByParentId(id);
    }

    @RequestMapping(value={"/getsubtypeofwork"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<EgwTypeOfWork> getSubTypeOfWork(@RequestParam(value="id") Long id) {
        return this.egwTypeOfWorkHibernateDAO.getSubTypeOfWorkByParentId(id);
    }

    @RequestMapping(value={"/ajax-getward"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Boundary> findWard(@RequestParam(value="name") String name) {
        List boundaries = this.boundaryService.getBondariesByNameAndBndryTypeAndHierarchyType("Ward", "ADMINISTRATION", "%" + name);
        List cityBoundary = this.boundaryService.getBondariesByNameAndBndryTypeAndHierarchyType("City", "ADMINISTRATION", "%" + name + "%");
        boundaries.addAll(cityBoundary);
        return boundaries;
    }

    @RequestMapping(value={"/ajaxsearch"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxsearch(Model model, @ModelAttribute LineEstimateSearchRequest lineEstimateSearchRequest) {
        List searchResultList = this.lineEstimateService.searchLineEstimates(lineEstimateSearchRequest);
        String result = "{ \"data\":" + this.toSearchLineEstimateResultJson((Object)searchResultList) + "}";
        return result;
    }

    @RequestMapping(value={"/ajaxsearchlineestimatesforloa"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxSearchLineEstimatesForLOA(Model model, @ModelAttribute LineEstimateForLoaSearchRequest lineEstimateForLoaSearchRequest) {
        List searchResultList = this.lineEstimateService.searchLineEstimatesForLOA(lineEstimateForLoaSearchRequest);
        String result = "{ \"data\":" + this.toSearchLineEstimateForLOAResultJson((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchLineEstimateResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(LineEstimate.class, (Object)this.lineEstimateJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    public Object toSearchLineEstimateForLOAResultJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(LineEstimate.class, (Object)new LineEstimateForLOAJsonAdaptor()).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/lineEstimateNumbers"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findLineEstimateNumbers(@RequestParam String name) {
        return this.lineEstimateService.findLineEstimateNumbers(name);
    }

    @RequestMapping(value={"/lineEstimateNumbersForLoa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findEstimateNumbersForLoa(@RequestParam String name) {
        return this.lineEstimateService.findEstimateNumbersForLoa(name);
    }

    @RequestMapping(value={"/adminSanctionNumbers"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findAdminSanctionNumbers(@RequestParam String name) {
        return this.lineEstimateService.findAdminSanctionNumbers(name);
    }

    @RequestMapping(value={"/adminSanctionNumbersForLoa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findAdminSanctionNumbersForLoa(@RequestParam String name) {
        return this.lineEstimateService.findAdminSanctionNumbersForLoa(name);
    }

    @RequestMapping(value={"/workIdNumbersForLoa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findworkIdNumbersForLoa(@RequestParam String name) {
        return this.lineEstimateService.findWorkIdentificationNumbersToSearchLineEstimatesForLoa(name);
    }

    @RequestMapping(value={"/ajax-assignmentByDepartmentAndDesignation"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getAssignmentByDepartmentAndDesignation(@RequestParam(value="approvalDesignation") Long approvalDesignation, @RequestParam(value="approvalDepartment") Long approvalDepartment) throws JsonGenerationException, JsonMappingException, IOException, NumberFormatException, ApplicationException {
        ArrayList<User> users = new ArrayList<User>();
        List assignments = new ArrayList();
        if (approvalDepartment != null && approvalDepartment != 0L && approvalDepartment != -1L && approvalDesignation != null && approvalDesignation != 0L && approvalDesignation != -1L) {
            assignments = this.assignmentService.findAllAssignmentsByDeptDesigAndDates(approvalDepartment, approvalDesignation, new Date());
        }
        for (Assignment assignment : assignments) {
            users.add(this.userService.getUserById(assignment.getEmployee().getId()));
        }
        Gson jsonCreator = new GsonBuilder().registerTypeAdapter(User.class, (Object)new UserAdaptor()).create();
        return jsonCreator.toJson(users, new /* Unavailable Anonymous Inner Class!! */.getType());
    }

    @RequestMapping(value={"/ajaxsearchcreatedby"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getcreateByDepartment(@RequestParam(value="department") Long department) throws JsonGenerationException, JsonMappingException, IOException, NumberFormatException, ApplicationException {
        List users = this.lineEstimateService.getCreatedByUsersForCancelLineEstimateByDepartment(department);
        Gson jsonCreator = new GsonBuilder().registerTypeAdapter(User.class, (Object)new UserAdaptor()).create();
        return jsonCreator.toJson((Object)users, new /* Unavailable Anonymous Inner Class!! */.getType());
    }

    @RequestMapping(value={"/cancel/ajax-search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchLineEstimatesToCancel(Model model, @ModelAttribute LineEstimateSearchRequest lineEstimateSearchRequest) {
        List lineestimates = this.lineEstimateService.searchLineEstimatesToCancel(lineEstimateSearchRequest);
        String result = "{ \"data\":" + this.toSearchLineEstimatesToCancelJson((Object)lineestimates) + "}";
        return result;
    }

    public Object toSearchLineEstimatesToCancelJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(LineEstimate.class, (Object)this.searchLineEstimateToCancelJSONAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajax-checkifloascreated"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String checkIfLOAsCreated(@RequestParam Long lineEstimateId) {
        String estimateNumbers = this.lineEstimateService.checkIfLOAsCreated(lineEstimateId);
        String message = this.messageSource.getMessage("error.lineestimate.loa.created", (Object[])new String[]{estimateNumbers}, null);
        if (estimateNumbers.equals("")) {
            return "";
        }
        return message;
    }

    @RequestMapping(value={"/getbudgethead"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<BudgetGroup> getBudgetHeadByFunction(@RequestParam(value="fundId") Integer fundId, @RequestParam(value="departmentId") Long departmentId, @RequestParam(value="functionId") Long functionId, @RequestParam(value="natureOfWorkId") Long natureOfWorkId) {
        List<Object> budgetGroups = new ArrayList<BudgetGroup>();
        try {
            NatureOfWork natureOfWork = null;
            if (natureOfWorkId != null) {
                natureOfWork = this.natureOfWorkService.findById(natureOfWorkId);
            }
            String accountType = null;
            if (natureOfWork != null && natureOfWork.getExpenditureType().getValue().equalsIgnoreCase("CAPITAL")) {
                accountType = BudgetAccountType.CAPITAL_EXPENDITURE.toString();
            } else if (natureOfWork != null && natureOfWork.getExpenditureType().getValue().equalsIgnoreCase("REVENUE")) {
                accountType = BudgetAccountType.REVENUE_EXPENDITURE.toString();
            }
            budgetGroups = this.budgetGroupDAO.getBudgetGroupsByFundFunctionDeptAndAccountType(fundId, departmentId, functionId, accountType);
            return budgetGroups;
        }
        catch (ValidationException v) {
            return budgetGroups;
        }
    }

    @RequestMapping(value={"/getbudgetheadbyfunction"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<BudgetGroup> getBudgetHeadByFunction(@RequestParam(value="functionId") Long functionId) {
        List<Object> budgetGroups = new ArrayList<BudgetGroup>();
        CFunction function = this.functionService.findOne(functionId);
        try {
            budgetGroups = this.budgetGroupDAO.getBudgetHeadByFunction(function.getCode());
            return budgetGroups;
        }
        catch (ValidationException v) {
            return budgetGroups;
        }
    }

    @RequestMapping(value={"/getfunctionsbyfundidanddepartmentid"}, method={RequestMethod.GET})
    @ResponseBody
    public List<CFunction> getAllFunctionsByFundIdAndDepartmentId(Model model, @RequestParam(value="fundId") Integer fundId, @RequestParam(value="departmentId") Long departmentId) throws JsonGenerationException, JsonMappingException, IOException, NumberFormatException, ApplicationException {
        List functions = this.budgetDetailsHibernateDAO.getFunctionsByFundAndDepartment(fundId, departmentId);
        return functions;
    }

    @RequestMapping(value={"/getestimatenumbers-uploadphotographs"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findEstimateNumbersForEstimatePhotograph(@RequestParam String estimateNumber) {
        return this.lineEstimateService.getEstimateNumbersForEstimatePhotograph(estimateNumber);
    }

    @RequestMapping(value={"/getwin-uploadphotographs"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findWinForEstimatePhotograph(@RequestParam String workIdentificationNumber) {
        return this.lineEstimateService.getWinForEstimatePhotograph(workIdentificationNumber);
    }

    @RequestMapping(value={"/searchlineestimateforestimatephotograph"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxSearchLEForEstimatePhotograph(Model model, @ModelAttribute EstimatePhotographSearchRequest estimatePhotographSearchRequest) {
        List searchResultList = this.lineEstimateService.searchLineEstimatesForEstimatePhotograph(estimatePhotographSearchRequest);
        String result = "{ \"data\":" + this.toSearchLineEstimateForEstimatePhotograph((Object)searchResultList) + "}";
        return result;
    }

    public Object toSearchLineEstimateForEstimatePhotograph(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(LineEstimateDetails.class, (Object)this.lineEstimateForEstimatePhotographJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }
}

