/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.Date;
import org.egov.infra.utils.DateUtils;
import org.egov.works.contractorbill.entity.enums.BillTypes;
import org.egov.works.reports.entity.WorkProgressRegister;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class WorkProgressRegisterJsonAdaptor
implements JsonSerializer<WorkProgressRegister> {
    @Autowired
    private WorksUtils worksUtils;

    public JsonElement serialize(WorkProgressRegister workProgressRegister, Type type, JsonSerializationContext jsc) {
        JsonObject jsonObject = new JsonObject();
        if (workProgressRegister != null) {
            if (workProgressRegister.getWard() != null) {
                if (workProgressRegister.getWard().getBoundaryType().getName().equalsIgnoreCase("City")) {
                    jsonObject.addProperty("ward", workProgressRegister.getWard().getName());
                } else {
                    jsonObject.addProperty("ward", (Number)workProgressRegister.getWard().getBoundaryNum());
                }
            } else {
                jsonObject.addProperty("ward", "");
            }
            if (workProgressRegister.getLocation() != null) {
                jsonObject.addProperty("location", workProgressRegister.getLocation().getName());
            } else {
                jsonObject.addProperty("location", "");
            }
            if (workProgressRegister.getWorkCategory().toString() != null) {
                jsonObject.addProperty("workCategory", workProgressRegister.getWorkCategory().toString().replace("_", " "));
            } else {
                jsonObject.addProperty("workCategory", "NA");
            }
            if (workProgressRegister.getBeneficiary() != null) {
                jsonObject.addProperty("beneficiaries", workProgressRegister.getBeneficiary().toString().replaceAll("_C", " /C").replace("_", " "));
            } else {
                jsonObject.addProperty("beneficiaries", "NA");
            }
            if (workProgressRegister.getNameOfWork() != null) {
                jsonObject.addProperty("nameOfWork", workProgressRegister.getNameOfWork());
            } else {
                jsonObject.addProperty("nameOfWork", "");
            }
            if (workProgressRegister.getWinCode() != null) {
                jsonObject.addProperty("winCode", workProgressRegister.getWinCode());
            } else {
                jsonObject.addProperty("winCode", "");
            }
            if (workProgressRegister.getFund() != null) {
                jsonObject.addProperty("fund", workProgressRegister.getFund().getCode() + " - " + workProgressRegister.getFund().getName());
            } else {
                jsonObject.addProperty("fund", "");
            }
            if (workProgressRegister.getFunction() != null) {
                jsonObject.addProperty("function", workProgressRegister.getFunction().getCode() + " - " + workProgressRegister.getFunction().getName());
            } else {
                jsonObject.addProperty("function", "");
            }
            if (workProgressRegister.getBudgetHead() != null) {
                jsonObject.addProperty("budgetHead", workProgressRegister.getBudgetHead().getName());
            } else {
                jsonObject.addProperty("budgetHead", "");
            }
            if (workProgressRegister.getTypeOfWork() != null) {
                jsonObject.addProperty("typeOfWork", workProgressRegister.getTypeOfWork().getDescription());
            } else {
                jsonObject.addProperty("typeOfWork", "");
            }
            if (workProgressRegister.getSubTypeOfWork() != null) {
                jsonObject.addProperty("subTypeOfWork", workProgressRegister.getSubTypeOfWork().getDescription());
            } else {
                jsonObject.addProperty("subTypeOfWork", "");
            }
            if (workProgressRegister.getAdminSanctionBy() != null) {
                jsonObject.addProperty("adminSanctionAuthorityDate", workProgressRegister.getAdminSanctionBy() + " , " + DateUtils.getFormattedDate((Date)workProgressRegister.getAdminSanctionDate(), (String)"dd/MM/yyyy"));
            } else {
                jsonObject.addProperty("adminSanctionAuthorityDate", "");
            }
            if (workProgressRegister.getAdminSanctionAmount() != null) {
                jsonObject.addProperty("adminSanctionAmount", (Number)workProgressRegister.getAdminSanctionAmount());
            } else {
                jsonObject.addProperty("adminSanctionAmount", "");
            }
            if (workProgressRegister.getTechnicalSanctionBy() != null) {
                jsonObject.addProperty("technicalSanctionAuthorityDate", this.worksUtils.getUserDesignation(workProgressRegister.getTechnicalSanctionBy()) + " - " + workProgressRegister.getTechnicalSanctionBy().getName() + ", " + DateUtils.getFormattedDate((Date)workProgressRegister.getTechnicalSanctionDate(), (String)"dd/MM/yyyy"));
            } else {
                jsonObject.addProperty("technicalSanctionAuthorityDate", "NA");
            }
            if (workProgressRegister.getEstimateAmount() != null) {
                jsonObject.addProperty("estimateAmount", (Number)workProgressRegister.getEstimateAmount());
            } else {
                jsonObject.addProperty("estimateAmount", "");
            }
            if (workProgressRegister.getModeOfAllotment() != null) {
                jsonObject.addProperty("modeOfAllotment", workProgressRegister.getModeOfAllotment());
            } else {
                jsonObject.addProperty("modeOfAllotment", "");
            }
            if (workProgressRegister.getAgreementNumber() != null) {
                jsonObject.addProperty("agreementNumberDate", workProgressRegister.getAgreementNumber() + " - " + DateUtils.getFormattedDate((Date)workProgressRegister.getAgreementDate(), (String)"dd/MM/yyyy"));
            } else {
                jsonObject.addProperty("agreementNumberDate", "");
            }
            if (workProgressRegister.getContractor() != null) {
                jsonObject.addProperty("contractorCodeName", workProgressRegister.getContractor().getCode() + " - " + workProgressRegister.getContractor().getName());
            } else {
                jsonObject.addProperty("contractorCodeName", "");
            }
            if (workProgressRegister.getAgreementAmount() != null) {
                jsonObject.addProperty("agreementAmount", (Number)workProgressRegister.getAgreementAmount());
            } else {
                jsonObject.addProperty("agreementAmount", "");
            }
            if (workProgressRegister.getLatestBillNumber() != null && workProgressRegister.getLatestBillDate() != null) {
                jsonObject.addProperty("latestMbNumberDate", workProgressRegister.getLatestMbNumber() + ", " + DateUtils.getFormattedDate((Date)workProgressRegister.getLatestMbDate(), (String)"dd/MM/yyyy"));
            } else {
                jsonObject.addProperty("latestMbNumberDate", "NA");
            }
            if (workProgressRegister.getLatestBillNumber() != null) {
                jsonObject.addProperty("latestBillNumberDate", workProgressRegister.getLatestBillNumber() + " - " + DateUtils.getFormattedDate((Date)workProgressRegister.getLatestBillDate(), (String)"dd/MM/yyyy"));
            } else {
                jsonObject.addProperty("latestBillNumberDate", "NA");
            }
            if (workProgressRegister.getBilltype() != null) {
                jsonObject.addProperty("billType", workProgressRegister.getBilltype());
            } else {
                jsonObject.addProperty("billType", "NA");
            }
            if (workProgressRegister.getBillamount() != null) {
                jsonObject.addProperty("billAmount", (Number)workProgressRegister.getBillamount());
            } else {
                jsonObject.addProperty("billAmount", "");
            }
            if (workProgressRegister.getTotalBillAmount() != null) {
                jsonObject.addProperty("totalBillAmount", (Number)workProgressRegister.getTotalBillAmount());
            } else {
                jsonObject.addProperty("totalBillAmount", "");
            }
            if (workProgressRegister.getTotalBillPaidSoFar() != null) {
                jsonObject.addProperty("totalBillPaidSoFar", (Number)workProgressRegister.getTotalBillPaidSoFar());
            } else {
                jsonObject.addProperty("totalBillPaidSoFar", "");
            }
            if (workProgressRegister.getBalanceValueOfWorkToBill() != null) {
                if (workProgressRegister.getBilltype() != null && workProgressRegister.getBilltype().equalsIgnoreCase(BillTypes.Final_Bill.toString())) {
                    jsonObject.addProperty("balanceValueOfWorkToBill", "NA");
                } else {
                    jsonObject.addProperty("balanceValueOfWorkToBill", (Number)workProgressRegister.getBalanceValueOfWorkToBill());
                }
            } else {
                jsonObject.addProperty("balanceValueOfWorkToBill", "");
            }
            if (workProgressRegister.getMilestonePercentageCompleted() != null) {
                jsonObject.addProperty("milestonePercentageCompleted", (Number)workProgressRegister.getMilestonePercentageCompleted());
            } else {
                jsonObject.addProperty("milestonePercentageCompleted", "NA");
            }
            jsonObject.addProperty("createdDate", DateUtils.getFormattedDate((Date)workProgressRegister.getCreatedDate(), (String)"dd/MM/yyyy hh:mm a"));
        }
        return jsonObject;
    }
}

