/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.workorder;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import javax.script.ScriptContext;
import org.apache.commons.lang.StringUtils;
import org.egov.commons.CFinancialYear;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.script.service.ScriptService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Designation;
import org.egov.pims.commons.Position;
import org.egov.pims.model.PersonalInformation;
import org.egov.pims.service.EmployeeServiceOld;
import org.egov.pims.service.PersonalInformationService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.AbstractEstimateAppropriation;
import org.egov.works.models.contractoradvance.ContractorAdvanceRequisition;
import org.egov.works.models.measurementbook.MBHeader;
import org.egov.works.models.tender.TenderResponseActivity;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.models.workorder.WorkOrderEstimate;
import org.egov.works.services.MeasurementBookService;
import org.egov.works.services.contractoradvance.ContractorAdvanceService;
import org.springframework.beans.factory.annotation.Autowired;

public class AjaxWorkOrderAction
extends BaseFormAction {
    private static final long serialVersionUID = 6775725729956509634L;
    private String departmentName;
    private Long desgId;
    private static final String WORKORDER_DESIG_LIST = "workOrderDesignations";
    private static final String WORKORDER_USER_LIST = "workOrderUsers";
    private static final String WORKORDER_ASSIGNED_LIST = "workOrderAssignedUsers";
    private List<Designation> workOrderDesigList = new ArrayList();
    private String traIds;
    private List<TenderResponseActivity> tenderResponseActivitylist = new ArrayList();
    private PersistenceService<TenderResponseActivity, Long> tenderResponseActivityService;
    private Long executingDepartment;
    private PersonalInformationService personalInformationService;
    private List userList;
    private MeasurementBookService measurementBookService;
    List<MBHeader> approvedMBList = new ArrayList();
    private Long workOrderId;
    private String query = "";
    private List<AbstractEstimate> estimateList = new LinkedList();
    private List<WorkOrder> workOrderList = new LinkedList();
    private String trackMlsCheck;
    private String yearEndApprCheck;
    @Autowired
    private FinancialYearHibernateDAO finHibernateDao;
    private String estimateNo;
    private static final String VALID = "valid";
    private static final String INVALID = "invalid";
    private String advanceRequisitionNo;
    private String owner = "";
    private String arfInWorkFlowCheck;
    private ContractorAdvanceService contractorAdvanceService;
    @Autowired
    private EmployeeServiceOld employeeService;
    private static final String ARF_IN_WORKFLOW_CHECK = "arfInWorkflowCheck";
    @Autowired
    private ScriptService scriptService;

    public Object getModel() {
        return null;
    }

    public String getDesignationByDeptId() {
        if (StringUtils.isNotBlank((String)this.departmentName)) {
            ScriptContext scriptContext = ScriptService.createContext((Object[])new Object[]{"department", this.departmentName});
            List desglist = (List)this.scriptService.executeScript("workOrder.Designation.ByDepartment", scriptContext);
            this.workOrderDesigList.addAll(this.getPersistenceService().findAllByNamedQuery("getDesignationForListOfDesgNames", new Object[]{desglist}));
        }
        return WORKORDER_DESIG_LIST;
    }

    public String getUsersForDesg() {
        try {
            HashMap<String, Number> criteriaParams = new HashMap<String, Number>();
            criteriaParams.put("designationId", this.desgId.intValue());
            criteriaParams.put("departmentId", this.executingDepartment);
            this.userList = this.executingDepartment == null || this.executingDepartment == -1L ? Collections.EMPTY_LIST : this.personalInformationService.getListOfEmployeeViewBasedOnCriteria(criteriaParams, Integer.valueOf(-1), Integer.valueOf(-1));
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("user.find.error", (Throwable)e);
        }
        return WORKORDER_USER_LIST;
    }

    public String getWOAssignedTo1ForDepartment() {
        try {
            this.userList = this.executingDepartment == null || this.executingDepartment == -1L ? Collections.EMPTY_LIST : this.persistenceService.findAllBy("select distinct woe.workOrder.engineerIncharge from  WorkOrderEstimate woe where woe.estimate.executingDepartment.id=?", new Object[]{this.executingDepartment});
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("user.find.error", (Throwable)e);
        }
        return WORKORDER_ASSIGNED_LIST;
    }

    public String getWOAssignedTo2ForDepartment() {
        try {
            this.userList = this.executingDepartment == null || this.executingDepartment == -1L ? Collections.EMPTY_LIST : this.persistenceService.findAllBy("select distinct woe.workOrder.engineerIncharge2 from  WorkOrderEstimate woe where woe.estimate.executingDepartment.id=?", new Object[]{this.executingDepartment});
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("user.find.error", (Throwable)e);
        }
        return WORKORDER_ASSIGNED_LIST;
    }

    public String getTenderResponseActivityList() {
        if (StringUtils.isNotBlank((String)this.traIds)) {
            HashSet<Long> traIdentifierSet = new HashSet<Long>();
            HashMap<Long, Double> traMap = new HashMap<Long, Double>();
            String[] values = this.traIds.split("\\^");
            Long[] traIdLong = new Long[values.length];
            int j = 0;
            for (String value : values) {
                if (!StringUtils.isNotBlank((String)value)) continue;
                traIdLong[j] = Long.valueOf(value.split("~")[0].trim());
                traMap.put(traIdLong[j], Double.valueOf(value.split("~")[1]));
                ++j;
            }
            traIdentifierSet.addAll(Arrays.asList(traIdLong));
            List tempList = new ArrayList();
            tempList = this.tenderResponseActivityService.findAllByNamedQuery("getTenderResponseActivityByIds", new Object[]{traIdentifierSet});
            for (TenderResponseActivity tenderResponseActivity : tempList) {
                Double unAssignedQuantity = (Double)traMap.get(tenderResponseActivity.getId());
                tenderResponseActivity.setNegotiatedQuantity(unAssignedQuantity.doubleValue());
                this.getPersistenceService().getSession().evict((Object)tenderResponseActivity);
                this.tenderResponseActivitylist.add(tenderResponseActivity);
            }
        }
        return "tenderResponseActivities";
    }

    public String getApprovedMBsForWorkOrder() {
        this.approvedMBList = this.measurementBookService.findAllBy(" from MBHeader where workOrder.id=? and egwStatus.code<>'CANCELLED'", new Object[]{this.workOrderId});
        return "approvedMBs";
    }

    public String advanceRequisitionInWorkflowCheck() {
        ContractorAdvanceRequisition arf;
        this.arfInWorkFlowCheck = VALID;
        List woeList = this.persistenceService.findAllBy(" from WorkOrderEstimate woe where woe.workOrder.id = ? ", new Object[]{this.workOrderId});
        if (woeList.size() == 1 && (arf = this.contractorAdvanceService.getContractorARFInWorkflowByWOEId(((WorkOrderEstimate)woeList.get(0)).getId())) != null) {
            this.arfInWorkFlowCheck = INVALID;
            this.advanceRequisitionNo = arf.getAdvanceRequisitionNumber();
            this.estimateNo = arf.getWorkOrderEstimate().getEstimate().getEstimateNumber();
            PersonalInformation emp = this.employeeService.getEmployeeforPosition((Position)arf.getCurrentState().getOwnerPosition());
            if (emp != null) {
                this.owner = emp.getUserMaster().getName();
            }
        }
        return ARF_IN_WORKFLOW_CHECK;
    }

    public String trackMilestoneForBillCreationCheck() {
        List tm = this.persistenceService.findAllBy(" select trmls from WorkOrderEstimate as woe left join woe.milestone mls left join mls.trackMilestone trmls where trmls.egwStatus.code='APPROVED' and woe.workOrder.id = ? and trmls.total>0 ", new Object[]{this.workOrderId});
        this.trackMlsCheck = INVALID;
        if (tm != null && !tm.isEmpty() && tm.get(0) != null) {
            this.trackMlsCheck = VALID;
        }
        return "trackMlsForBillCreationCheck";
    }

    public String yearEndApprForBillCreationCheck() {
        List woeList = this.persistenceService.findAllBy(" from WorkOrderEstimate woe where woe.workOrder.id = ? ", new Object[]{this.workOrderId});
        this.yearEndApprCheck = VALID;
        Long currentFinYearId = 0L;
        if (woeList.size() == 1) {
            CFinancialYear currFinancialYear;
            this.estimateNo = ((WorkOrderEstimate)woeList.get(0)).getEstimate().getEstimateNumber();
            try {
                currFinancialYear = this.finHibernateDao.getFinancialYearByDate(new Date());
            }
            catch (Exception e) {
                throw new ValidationException(Arrays.asList(new ValidationError("yrEnd.appr.verification.for.bill.financialyear.invalid", "yrEnd.appr.verification.for.bill.financialyear.invalid")));
            }
            if (currFinancialYear != null) {
                currentFinYearId = currFinancialYear.getId();
            }
            if (((WorkOrderEstimate)woeList.get(0)).getEstimate().getDepositCode() == null) {
                AbstractEstimateAppropriation aeaObj = (AbstractEstimateAppropriation)this.persistenceService.findByNamedQuery("getLatestBudgetUsageForEstimate", new Object[]{((WorkOrderEstimate)woeList.get(0)).getEstimate().getId()});
                if (aeaObj != null && aeaObj.getBudgetUsage().getConsumedAmount() > 0.0) {
                    if (aeaObj.getBudgetUsage().getFinancialYearId().intValue() != currentFinYearId.intValue()) {
                        this.yearEndApprCheck = INVALID;
                    }
                } else {
                    this.yearEndApprCheck = INVALID;
                }
            }
        }
        return "yearEndApprForBillCreationCheck";
    }

    public String searchEstimateNumber() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select woe.estimate from WorkOrderEstimate woe where woe.workOrder.parent is null and UPPER(woe.estimate.estimateNumber) like '%'||?||'%'  and woe.workOrder.egwStatus.code = ? )";
            params.add(this.query.toUpperCase());
            params.add("APPROVED");
            this.estimateList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return "estimateNoSearchResults";
    }

    public String searchWorkOrderNumber() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = " from WorkOrder wo where wo.parent is null and UPPER(wo.workOrderNumber) like '%'||?||'%' and wo.egwStatus.code = ? ";
            params.add(this.query.toUpperCase());
            params.add("APPROVED");
            this.workOrderList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return "workOrderNoSearchResults";
    }

    public String getDepartmentName() {
        return this.departmentName;
    }

    public void setDepartmentName(String departmentName) {
        this.departmentName = departmentName;
    }

    public List<Designation> getWorkOrderDesigList() {
        return this.workOrderDesigList;
    }

    public void setWorkOrderDesigList(List<Designation> workOrderDesigList) {
        this.workOrderDesigList = workOrderDesigList;
    }

    public void setDesgId(Long desgId) {
        this.desgId = desgId;
    }

    public String getTraIds() {
        return this.traIds;
    }

    public void setTraIds(String traIds) {
        this.traIds = traIds;
    }

    public List<TenderResponseActivity> getTenderResponseActivitylist() {
        return this.tenderResponseActivitylist;
    }

    public void setTenderResponseActivitylist(List<TenderResponseActivity> tenderResponseActivitylist) {
        this.tenderResponseActivitylist = tenderResponseActivitylist;
    }

    public void setTenderResponseActivityService(PersistenceService<TenderResponseActivity, Long> tenderResponseActivityService) {
        this.tenderResponseActivityService = tenderResponseActivityService;
    }

    public Long getExecutingDepartment() {
        return this.executingDepartment;
    }

    public void setExecutingDepartment(Long executingDepartment) {
        this.executingDepartment = executingDepartment;
    }

    public void setPersonalInformationService(PersonalInformationService personalInformationService) {
        this.personalInformationService = personalInformationService;
    }

    public List getUserList() {
        return this.userList;
    }

    public void setUserList(List userList) {
        this.userList = userList;
    }

    public void setMeasurementBookService(MeasurementBookService measurementBookService) {
        this.measurementBookService = measurementBookService;
    }

    public List<MBHeader> getApprovedMBList() {
        return this.approvedMBList;
    }

    public void setApprovedMBList(List<MBHeader> approvedMBList) {
        this.approvedMBList = approvedMBList;
    }

    public Long getWorkOrderId() {
        return this.workOrderId;
    }

    public void setWorkOrderId(Long workOrderId) {
        this.workOrderId = workOrderId;
    }

    public List<AbstractEstimate> getEstimateList() {
        return this.estimateList;
    }

    public void setEstimateList(List<AbstractEstimate> estimateList) {
        this.estimateList = estimateList;
    }

    public List<WorkOrder> getWorkOrderList() {
        return this.workOrderList;
    }

    public void setWorkOrderList(List<WorkOrder> workOrderList) {
        this.workOrderList = workOrderList;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public String getTrackMlsCheck() {
        return this.trackMlsCheck;
    }

    public String getYearEndApprCheck() {
        return this.yearEndApprCheck;
    }

    public void setYearEndApprCheck(String yearEndApprCheck) {
        this.yearEndApprCheck = yearEndApprCheck;
    }

    public String getEstimateNo() {
        return this.estimateNo;
    }

    public void setEstimateNo(String estimateNo) {
        this.estimateNo = estimateNo;
    }

    public String getAdvanceRequisitionNo() {
        return this.advanceRequisitionNo;
    }

    public void setAdvanceRequisitionNo(String advanceRequisitionNo) {
        this.advanceRequisitionNo = advanceRequisitionNo;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getArfInWorkFlowCheck() {
        return this.arfInWorkFlowCheck;
    }

    public void setArfInWorkFlowCheck(String arfInWorkFlowCheck) {
        this.arfInWorkFlowCheck = arfInWorkFlowCheck;
    }

    public void setContractorAdvanceService(ContractorAdvanceService contractorAdvanceService) {
        this.contractorAdvanceService = contractorAdvanceService;
    }

    public void setEmployeeService(EmployeeServiceOld employeeService) {
        this.employeeService = employeeService;
    }
}

