/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.tender;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.io.OutputStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.EgwStatus;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.commons.Position;
import org.egov.pims.model.PersonalInformation;
import org.egov.pims.service.EmployeeServiceOld;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.models.masters.Contractor;
import org.egov.works.models.masters.MarketRate;
import org.egov.works.models.tender.EstimateLineItemsForWP;
import org.egov.works.models.tender.TenderResponse;
import org.egov.works.models.tender.TenderResponseActivity;
import org.egov.works.models.tender.TenderResponseContractors;
import org.egov.works.models.tender.TenderResponseQuotes;
import org.egov.works.models.tender.WorksPackage;
import org.egov.works.services.WorksService;
import org.egov.works.utils.AbstractPDFGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class TenderNegotiationPDFGenerator
extends AbstractPDFGenerator {
    public static final String TENDER_PDF_ERROR = "tenderresponse.pdf.error";
    public static final String TENDERNEGOTIATION_AMOUNT = "tenderNegotiationpdf.amount";
    public static final String TENDERNEGOTIATION_RATE = "tenderNegotiationpdf.rate";
    public static final String POSITIVE_SIGN = "(+)";
    public static final String NEGATIVE_SIGN = "(-)";
    private static final Logger LOGGER = Logger.getLogger(TenderNegotiationPDFGenerator.class);
    private static final String YES = "yes";
    private final TenderResponse tenderResponse;
    private final String cityName;
    private final NumberFormat formatter = new DecimalFormat("#0.00");
    private final SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy", Locale.US);
    private final Map<String, String> pdfLabel;
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private EmployeeServiceOld employeeService;
    private double totalAmt = 0.0;
    private double totalBefNegAmt = 0.0;
    private double totalAftNegAmt = 0.0;
    private double totalMarketRateAmt = 0.0;
    private String worksPackgeReq = "no";
    private WorksPackage worksPackage;
    private String percTenderType = "";
    private NumberFormat nf = null;
    private WorksService worksService;

    public TenderNegotiationPDFGenerator(TenderResponse tenderResponse, String cityName, OutputStream out, Map<String, String> pdfLabel) {
        super(out, "landscape");
        this.pdfLabel = pdfLabel;
        this.tenderResponse = tenderResponse;
        this.cityName = cityName;
    }

    public void generatePDF() {
        this.nf = NumberFormat.getInstance();
        this.nf.setMaximumFractionDigits(10);
        List tenderTypeList = this.worksService.getTendertypeList();
        if (tenderTypeList != null && !tenderTypeList.isEmpty()) {
            this.percTenderType = (String)tenderTypeList.get(0);
        }
        String headerText = (String)this.pdfLabel.get("tenderNegotiationpdf.header");
        try {
            Paragraph headerTextPara = new Paragraph(new Chunk(headerText, new Font(-1, 14.0f, 1)));
            headerTextPara.setAlignment(1);
            this.document.add((Element)headerTextPara);
            this.document.add((Element)this.makePara((Object)this.cityName, 2));
            if (this.tenderResponse != null && this.tenderResponse.getTenderEstimate() != null && this.tenderResponse.getTenderEstimate().getWorksPackage() != null) {
                this.worksPackgeReq = YES;
                this.worksPackage = this.tenderResponse.getTenderEstimate().getWorksPackage();
            }
            String deptName = "";
            if (YES.equalsIgnoreCase(this.worksPackgeReq)) {
                deptName = this.tenderResponse.getTenderEstimate().getWorksPackage().getDepartment().getName();
                this.document.add((Element)this.makePara((Object)deptName, 2));
                if (this.getWardList(this.worksPackage) != null) {
                    this.document.add((Element)this.makePara((Object)((String)this.pdfLabel.get("tenderNegotiationpdf.ward") + "/" + (String)this.pdfLabel.get("tenderNegotiationpdf.zone") + this.getWardList(this.worksPackage)), 0));
                }
            } else {
                if (this.tenderResponse != null && this.tenderResponse.getTenderEstimate() != null && this.tenderResponse.getTenderEstimate().getAbstractEstimate().getExecutingDepartment() != null && this.tenderResponse.getTenderEstimate().getAbstractEstimate().getExecutingDepartment().getName() != null) {
                    deptName = this.tenderResponse.getTenderEstimate().getAbstractEstimate().getExecutingDepartment().getName();
                }
                this.document.add((Element)this.makePara((Object)deptName, 2));
                if (this.tenderResponse != null && this.tenderResponse.getTenderEstimate() != null && this.tenderResponse.getTenderEstimate().getAbstractEstimate().getWard().getParent() != null && this.tenderResponse.getTenderEstimate().getAbstractEstimate().getWard() != null) {
                    this.document.add((Element)this.makePara((Object)((String)this.pdfLabel.get("tenderNegotiationpdf.ward") + "/" + (String)this.pdfLabel.get("tenderNegotiationpdf.zone") + this.tenderResponse.getTenderEstimate().getAbstractEstimate().getWard().getName() + "/" + this.tenderResponse.getTenderEstimate().getAbstractEstimate().getWard().getParent().getName()), 0));
                }
            }
            if (YES.equalsIgnoreCase(this.worksPackgeReq)) {
                this.document.add((Element)this.makePara((Object)((String)this.pdfLabel.get("tenderNegotiationpdf.nameofwork") + this.tenderResponse.getTenderEstimate().getWorksPackage().getName()), 0));
            } else if (this.tenderResponse != null && this.tenderResponse.getTenderEstimate() != null) {
                this.document.add((Element)this.makePara((Object)((String)this.pdfLabel.get("tenderNegotiationpdf.nameofwork") + this.tenderResponse.getTenderEstimate().getAbstractEstimate().getName()), 0));
            }
            if (this.tenderResponse != null && this.tenderResponse.getTenderEstimate() != null && this.tenderResponse.getTenderEstimate().getTenderHeader() != null && this.tenderResponse.getTenderEstimate().getTenderHeader().getTenderNo() != null) {
                this.document.add((Element)this.makePara((Object)((String)this.pdfLabel.get("tenderNumber") + this.tenderResponse.getTenderEstimate().getTenderHeader().getTenderNo()), 0));
            }
            if (this.tenderResponse != null && this.tenderResponse.getTenderEstimate() != null && this.tenderResponse.getTenderEstimate().getWorksPackage() != null) {
                this.document.add((Element)this.makePara((Object)((String)this.pdfLabel.get("tenderFileNo") + this.tenderResponse.getTenderEstimate().getWorksPackage().getTenderFileNumber()), 0));
            }
            this.document.add((Element)this.spacer());
            String tenderDate = "";
            if (this.tenderResponse != null && this.tenderResponse.getTenderEstimate() != null && this.tenderResponse.getTenderEstimate().getTenderHeader() != null && this.tenderResponse.getTenderEstimate().getTenderHeader().getTenderDate() != null) {
                tenderDate = this.sdf.format(this.tenderResponse.getTenderEstimate().getTenderHeader().getTenderDate());
            }
            this.document.add((Element)this.makePara((Object)((String)this.pdfLabel.get("tenderNegotiationpdf.tenderdate") + tenderDate), 2));
            this.document.add((Element)this.spacer());
            PdfPTable contractorTable = null;
            if (this.tenderResponse != null) {
                contractorTable = this.createContractorTable(this.tenderResponse);
                this.document.add((Element)contractorTable);
            }
            this.document.add((Element)this.spacer());
            if (this.tenderResponse != null && this.tenderResponse.getTenderEstimate().getTenderType().equalsIgnoreCase(this.percTenderType)) {
                PdfPTable negotiationTable = null;
                negotiationTable = this.createNegotiationTable(this.tenderResponse, ((TenderResponseContractors)this.tenderResponse.getTenderResponseContractors().get(0)).getContractor());
                this.document.add((Element)negotiationTable);
                this.document.add((Element)this.spacer());
                if (negotiationTable != null && negotiationTable.getRows().size() > 8) {
                    this.document.newPage();
                }
            } else if (this.tenderResponse != null && !this.tenderResponse.getTenderEstimate().getTenderType().equalsIgnoreCase(this.percTenderType)) {
                this.createNegotiationTableForContractors(this.tenderResponse);
            }
            if (this.tenderResponse != null && this.tenderResponse.getNegotiationPreparedBy() != null && this.tenderResponse.getNegotiationPreparedBy().getEmployeeName() != null) {
                this.document.add((Element)this.makePara((Object)((String)this.pdfLabel.get("tenderNegotiationpdf.preparedby") + " " + this.tenderResponse.getNegotiationPreparedBy().getEmployeeName())));
            }
            this.document.add((Element)this.spacer());
            this.document.add((Element)this.spacer());
            this.document.add((Element)this.makePara(this.pdfLabel.get("tenderNegotiationpdf.checkedby")));
            this.document.newPage();
            PdfPTable approvaldetailsTable = null;
            if (this.tenderResponse != null) {
                approvaldetailsTable = this.createApprovalDetailsTable(this.tenderResponse);
            }
            if (approvaldetailsTable != null && approvaldetailsTable.getRows().size() != 1) {
                this.document.add((Element)this.makePara(this.pdfLabel.get("tenderNegotiationpdf.approvaldetails")));
                this.document.add((Element)this.spacer());
                this.document.add((Element)approvaldetailsTable);
            }
            this.document.close();
        }
        catch (DocumentException e) {
            throw new ApplicationRuntimeException(TENDER_PDF_ERROR, (Throwable)e);
        }
    }

    private PdfPTable createApprovalDetailsTable(TenderResponse tenderResponse) throws DocumentException {
        try {
            PdfPTable approvaldetailsTable = new PdfPTable(5);
            approvaldetailsTable.setWidthPercentage(100.0f);
            approvaldetailsTable.setWidths(new float[]{1.0f, 1.0f, 2.0f, 1.5f, 2.0f});
            this.addRow(approvaldetailsTable, true, new Paragraph[]{this.makePara(this.pdfLabel.get("tenderNegotiationpdf.aprvalstep")), this.centerPara(this.pdfLabel.get("tenderNegotiationpdf.name")), this.centerPara(this.pdfLabel.get("tenderNegotiationpdf.designation")), this.centerPara(this.pdfLabel.get("tenderNegotiationpdf.aprvdon")), this.centerPara(this.pdfLabel.get("tenderNegotiationpdf.remarks"))});
            List history = null;
            if (tenderResponse.getCurrentState() != null && tenderResponse.getCurrentState().getHistory() != null) {
                history = tenderResponse.getStateHistory();
            }
            if (history != null) {
                Collections.reverse(history);
                StateHistory previous = null;
                for (StateHistory ad : history) {
                    if (!(ad.getValue().equals("NEW") || ad.getValue().equals("APPROVAL_PENDING") || ad.getValue().equals("END") || previous == null)) {
                        EgwStatus status = (EgwStatus)this.getPersistenceService().find("from EgwStatus where code=?", new Object[]{ad.getValue()});
                        PersonalInformation emp = this.employeeService.getEmpForPositionAndDate(ad.getCreatedDate(), Integer.valueOf(Integer.parseInt(((Position)previous.getOwnerPosition()).getId().toString())));
                        this.addRow(approvaldetailsTable, true, new Paragraph[]{this.makePara((Object)status.getDescription()), this.makePara((Object)emp.getEmployeeName()), this.makePara((Object)((Position)previous.getOwnerPosition()).getDeptDesig().getDesignation().getName()), this.makePara((Object)this.getDateInFormat(ad.getCreatedDate().toString())), this.rightPara((Object)ad.getComments())});
                    }
                    previous = ad;
                }
            }
            return approvaldetailsTable;
        }
        catch (Exception e) {
            throw new DocumentException("Exception occured while getting approval details " + e);
        }
    }

    private PdfPTable createNegotiationTable(TenderResponse tenderResponse, Contractor contractor) throws DocumentException {
        PdfPTable negotiationTable = new PdfPTable(13);
        negotiationTable.setWidthPercentage(100.0f);
        negotiationTable.setWidths(new float[]{0.5f, 1.0f, 3.6f, 1.5f, 1.1f, 0.9f, 1.5f, 1.7f, 1.7f, 1.7f, 1.7f, 1.7f, 1.7f});
        try {
            negotiationTable.getDefaultCell().setPadding(5.0f);
            negotiationTable.getDefaultCell().setBorderWidth(1.0f);
            negotiationTable.getDefaultCell().setHorizontalAlignment(1);
            negotiationTable.addCell((String)this.pdfLabel.get("tenderNegotiationpdf.slno"));
            negotiationTable.addCell((String)this.pdfLabel.get("tenderNegotiationpdf.scheduleno"));
            negotiationTable.addCell((String)this.pdfLabel.get("tenderNegotiationpdf.descofwork"));
            negotiationTable.addCell((String)this.pdfLabel.get("tenderNegotiationpdf.quantity"));
            PdfPTable estimateTable = this.createAsPerEstimateTable(tenderResponse);
            estimateTable.setWidths(new float[]{0.45f, 0.37f, 0.62f});
            PdfPCell estimateCell = new PdfPCell(estimateTable);
            estimateCell.setColspan(3);
            negotiationTable.addCell(estimateCell);
            PdfPTable beforeNegotiationTable = this.createBeforeNegotiationTable(tenderResponse);
            PdfPCell beforeNegotiationCell = new PdfPCell(beforeNegotiationTable);
            beforeNegotiationCell.setColspan(2);
            negotiationTable.addCell(beforeNegotiationCell);
            PdfPTable afterNegotiationTable = this.createAfterNegotiationTable(tenderResponse);
            PdfPCell afterNegotiationCell = new PdfPCell(afterNegotiationTable);
            afterNegotiationCell.setColspan(2);
            negotiationTable.addCell(afterNegotiationCell);
            PdfPTable marketRateTable = this.createMarketRateTable(tenderResponse);
            PdfPCell marketRateCell = new PdfPCell(marketRateTable);
            marketRateCell.setColspan(2);
            negotiationTable.addCell(marketRateCell);
            if (YES.equalsIgnoreCase(this.worksPackgeReq)) {
                this.createNegotiationTableDataForWp(tenderResponse, negotiationTable, contractor);
            } else {
                this.createNegotiationTableData(tenderResponse, negotiationTable, contractor);
            }
            this.createNegotiationTableFooter(negotiationTable);
            this.addRowFooter(negotiationTable);
            this.addTotalQuotedFooter(negotiationTable);
            this.addFinalRow(negotiationTable, tenderResponse);
        }
        catch (DocumentException e) {
            throw new ApplicationRuntimeException(TENDER_PDF_ERROR, (Throwable)e);
        }
        return negotiationTable;
    }

    public void createNegotiationTableDataForWp(TenderResponse tenderResponse, PdfPTable negotiationTable, Contractor contractor) {
        Date asOnDate = null;
        if (tenderResponse.getNegotiationDate() != null) {
            asOnDate = tenderResponse.getNegotiationDate();
        }
        int i = 0;
        Map exceptionaSorMap = this.worksService.getExceptionSOR();
        this.totalBefNegAmt = 0.0;
        this.totalAmt = 0.0;
        this.totalAftNegAmt = 0.0;
        this.totalMarketRateAmt = 0.0;
        for (TenderResponseActivity tenderResponseActivity : tenderResponse.getTenderResponseActivities()) {
            Map rateQtyMap;
            Double quantity = 0.0;
            double befNegRate = 0.0;
            double aftNegRate = 0.0;
            double marketRate = 0.0;
            double marketRateAmount = 0.0;
            double uomFactor = 1.0;
            if (tenderResponseActivity == null) continue;
            if (tenderResponseActivity.getActivity() != null && tenderResponseActivity.getActivity().getSchedule() != null && tenderResponseActivity.getActivity().getSchedule().getCode() != null && exceptionaSorMap.containsKey(tenderResponseActivity.getActivity().getUom().getUom())) {
                uomFactor = ((Integer)exceptionaSorMap.get(tenderResponseActivity.getActivity().getUom().getUom())).intValue();
            }
            if ((rateQtyMap = this.processLatestRateAndQtyForLineItem(this.worksPackage.getActivitiesForEstimate(), tenderResponseActivity.getActivity())) != null && !rateQtyMap.isEmpty()) {
                negotiationTable.addCell((Phrase)this.makePara((Object)(++i)));
                String schNo = (String)rateQtyMap.get("sorcode");
                negotiationTable.addCell((Phrase)this.centerPara((Object)schNo));
                negotiationTable.getDefaultCell().setHorizontalAlignment(0);
                String description = (String)rateQtyMap.get("desc");
                negotiationTable.addCell((Phrase)this.makePara((Object)description, 0));
                negotiationTable.getDefaultCell().setHorizontalAlignment(1);
                quantity = (Double)rateQtyMap.get("qty");
                negotiationTable.addCell((Phrase)this.centerPara((Object)this.formatter.format(quantity)));
                negotiationTable.getDefaultCell().setHorizontalAlignment(2);
                double rate = (Double)rateQtyMap.get("rate");
                negotiationTable.addCell((Phrase)this.rightPara((Object)this.formatter.format(rate)));
                negotiationTable.getDefaultCell().setHorizontalAlignment(1);
                String per = (String)rateQtyMap.get("per");
                negotiationTable.addCell((Phrase)this.centerPara((Object)per));
                negotiationTable.getDefaultCell().setHorizontalAlignment(2);
                double amount = (Double)rateQtyMap.get("amt");
                negotiationTable.addCell((Phrase)this.rightPara((Object)this.formatter.format(amount)));
                this.totalAmt += amount;
            }
            if (rateQtyMap == null || rateQtyMap.get("slno") == null) continue;
            negotiationTable.getDefaultCell().setHorizontalAlignment(2);
            for (TenderResponseQuotes tenderResponseQuotes : tenderResponseActivity.getTenderResponseQuotes()) {
                if (tenderResponseQuotes.getContractor().getId() != contractor.getId()) continue;
                if (tenderResponseQuotes.getQuotedRate() != 0.0) {
                    befNegRate = tenderResponseQuotes.getQuotedRate();
                }
                negotiationTable.addCell((Phrase)this.rightPara((Object)this.formatter.format(befNegRate)));
                double befNegAmount = quantity * befNegRate / uomFactor;
                this.totalBefNegAmt += befNegAmount;
                negotiationTable.addCell((Phrase)this.rightPara((Object)this.formatter.format(befNegAmount)));
            }
            if (tenderResponseActivity.getNegotiatedRate() != 0.0) {
                aftNegRate = tenderResponseActivity.getNegotiatedRate();
            }
            negotiationTable.addCell((Phrase)this.rightPara((Object)this.formatter.format(aftNegRate)));
            double aftNegAmount = quantity * aftNegRate / uomFactor;
            this.totalAftNegAmt += aftNegAmount;
            negotiationTable.addCell((Phrase)this.rightPara((Object)this.formatter.format(aftNegAmount)));
            if (tenderResponseActivity.getActivity() != null && tenderResponseActivity.getActivity().getSchedule() != null && asOnDate != null && tenderResponseActivity.getActivity().getSchedule().hasValidMarketRateFor(asOnDate)) {
                MarketRate marketRateObj = tenderResponseActivity.getActivity().getSchedule().getMarketRateOn(asOnDate);
                marketRate = marketRateObj.getMarketRate().getValue();
                marketRateAmount = quantity * marketRate / uomFactor;
            }
            if (tenderResponseActivity.getActivity() != null && tenderResponseActivity.getActivity().getSchedule() != null && asOnDate != null && !tenderResponseActivity.getActivity().getSchedule().hasValidMarketRateFor(asOnDate)) {
                marketRate = tenderResponseActivity.getActivity().getRate();
                marketRateAmount = quantity * marketRate;
            }
            if (tenderResponseActivity.getActivity() != null && tenderResponseActivity.getActivity().getNonSor() != null) {
                marketRate = tenderResponseActivity.getActivity().getRate();
                double marketQty = tenderResponseActivity.getActivity().getQuantity();
                marketRateAmount = marketQty * marketRate;
            }
            negotiationTable.addCell((Phrase)this.rightPara((Object)this.formatter.format(marketRate)));
            this.totalMarketRateAmt += marketRateAmount;
            negotiationTable.addCell((Phrase)this.rightPara((Object)this.formatter.format(marketRateAmount)));
        }
    }

    public void createNegotiationTableData(TenderResponse tenderResponse, PdfPTable negotiationTable, Contractor contractor) {
        Date asOnDate = null;
        if (tenderResponse.getNegotiationDate() != null) {
            asOnDate = tenderResponse.getNegotiationDate();
        }
        int i = 0;
        Map exceptionaSorMap = this.worksService.getExceptionSOR();
        for (TenderResponseActivity tenderResponseActivity : tenderResponse.getTenderResponseActivities()) {
            double marketQty;
            String schNo = "";
            String description = "";
            Double quantity = 0.0;
            double rate = 0.0;
            String per = "";
            double befNegRate = 0.0;
            double aftNegRate = 0.0;
            double marketRate = 0.0;
            double marketRateAmount = 0.0;
            negotiationTable.addCell((Phrase)this.makePara((Object)(++i)));
            double uomFactor = 1.0;
            if (tenderResponseActivity == null) continue;
            if (tenderResponseActivity.getActivity() != null && tenderResponseActivity.getActivity().getSchedule() != null && tenderResponseActivity.getActivity().getSchedule().getCode() != null && exceptionaSorMap.containsKey(tenderResponseActivity.getActivity().getUom().getUom())) {
                uomFactor = ((Integer)exceptionaSorMap.get(tenderResponseActivity.getActivity().getUom().getUom())).intValue();
            }
            if (tenderResponseActivity.getActivity() != null && tenderResponseActivity.getActivity().getSchedule() != null && tenderResponseActivity.getActivity().getSchedule().getCode() != null) {
                schNo = tenderResponseActivity.getActivity().getSchedule().getCode();
            }
            negotiationTable.addCell((Phrase)this.centerPara((Object)schNo));
            negotiationTable.getDefaultCell().setHorizontalAlignment(0);
            if (tenderResponseActivity.getActivity() != null && tenderResponseActivity.getActivity().getSchedule() != null && tenderResponseActivity.getActivity().getSchedule().getDescription() != null) {
                description = tenderResponseActivity.getActivity().getSchedule().getDescription();
            }
            if (tenderResponseActivity.getActivity() != null && tenderResponseActivity.getActivity().getNonSor() != null && tenderResponseActivity.getActivity().getNonSor().getDescription() != null) {
                description = tenderResponseActivity.getActivity().getNonSor().getDescription();
            }
            negotiationTable.addCell((Phrase)this.makePara((Object)description, 0));
            negotiationTable.getDefaultCell().setHorizontalAlignment(1);
            if (tenderResponseActivity.getActivity() != null && tenderResponseActivity.getActivity().getQuantity() != 0.0) {
                quantity = tenderResponseActivity.getActivity().getQuantity();
            }
            negotiationTable.addCell((Phrase)this.centerPara((Object)quantity));
            negotiationTable.getDefaultCell().setHorizontalAlignment(2);
            if (tenderResponseActivity.getActivity() != null && tenderResponseActivity.getActivity().getSchedule() != null && tenderResponseActivity.getActivity().getRate() != 0.0 && tenderResponseActivity.getActivity().getSORCurrentRate() != null) {
                rate = tenderResponseActivity.getActivity().getSORCurrentRate().getValue();
            }
            if (tenderResponseActivity.getActivity() != null && tenderResponseActivity.getActivity().getNonSor() != null && tenderResponseActivity.getActivity().getRate() != 0.0) {
                rate = tenderResponseActivity.getActivity().getRate();
            }
            negotiationTable.addCell((Phrase)this.rightPara((Object)this.formatter.format(rate)));
            negotiationTable.getDefaultCell().setHorizontalAlignment(1);
            if (tenderResponseActivity.getActivity().getSchedule() != null && tenderResponseActivity.getActivity().getSchedule().getUom() != null && tenderResponseActivity.getActivity().getSchedule().getUom().getUom() != null) {
                per = tenderResponseActivity.getActivity().getSchedule().getUom().getUom();
            }
            if (tenderResponseActivity.getActivity().getNonSor() != null && tenderResponseActivity.getActivity().getNonSor().getUom() != null && tenderResponseActivity.getActivity().getNonSor().getUom().getUom() != null) {
                per = tenderResponseActivity.getActivity().getNonSor().getUom().getUom();
            }
            negotiationTable.addCell((Phrase)this.centerPara((Object)per));
            double amount = quantity * rate / uomFactor;
            this.totalAmt += amount;
            negotiationTable.addCell((Phrase)this.rightPara((Object)this.formatter.format(amount)));
            negotiationTable.getDefaultCell().setHorizontalAlignment(2);
            for (TenderResponseQuotes tenderResponseQuotes : tenderResponseActivity.getTenderResponseQuotes()) {
                if (tenderResponseQuotes.getContractor().getId() != contractor.getId()) continue;
                if (tenderResponseQuotes.getQuotedRate() != 0.0) {
                    befNegRate = tenderResponseQuotes.getQuotedRate();
                }
                double quotedQty = tenderResponseQuotes.getQuotedQuantity();
                negotiationTable.addCell((Phrase)this.rightPara((Object)this.formatter.format(befNegRate)));
                double befNegAmount = quotedQty * befNegRate / uomFactor;
                this.totalBefNegAmt += befNegAmount;
                negotiationTable.addCell((Phrase)this.rightPara((Object)this.formatter.format(befNegAmount)));
            }
            if (tenderResponseActivity.getNegotiatedRate() != 0.0) {
                aftNegRate = tenderResponseActivity.getNegotiatedRate();
            }
            double negotiatedQty = tenderResponseActivity.getNegotiatedQuantity();
            negotiationTable.addCell((Phrase)this.rightPara((Object)this.formatter.format(aftNegRate)));
            double aftNegAmount = negotiatedQty * aftNegRate / uomFactor;
            this.totalAftNegAmt += aftNegAmount;
            negotiationTable.addCell((Phrase)this.rightPara((Object)this.formatter.format(aftNegAmount)));
            if (tenderResponseActivity.getActivity() != null && tenderResponseActivity.getActivity().getSchedule() != null && asOnDate != null && tenderResponseActivity.getActivity().getSchedule().hasValidMarketRateFor(asOnDate)) {
                MarketRate marketRateObj = tenderResponseActivity.getActivity().getSchedule().getMarketRateOn(asOnDate);
                marketRate = marketRateObj.getMarketRate().getValue();
                marketRateAmount = quantity * marketRate / uomFactor;
            } else if (tenderResponseActivity.getActivity() != null && tenderResponseActivity.getActivity().getSchedule() != null) {
                marketRate = tenderResponseActivity.getActivity().getSORCurrentRate().getValue();
                marketQty = tenderResponseActivity.getActivity().getQuantity();
                marketRateAmount = marketQty * marketRate / uomFactor;
            } else if (tenderResponseActivity.getActivity() != null && tenderResponseActivity.getActivity().getNonSor() != null) {
                marketRate = tenderResponseActivity.getActivity().getRate();
                marketQty = tenderResponseActivity.getActivity().getQuantity();
                marketRateAmount = marketQty * marketRate;
            }
            negotiationTable.addCell((Phrase)this.rightPara((Object)this.formatter.format(marketRate)));
            this.totalMarketRateAmt += marketRateAmount;
            negotiationTable.addCell((Phrase)this.rightPara((Object)this.formatter.format(marketRateAmount)));
        }
    }

    public void createNegotiationTableFooter(PdfPTable negotiationTable) {
        negotiationTable.addCell(" ");
        negotiationTable.addCell(" ");
        PdfPTable tenderTotalTable = this.createTenderTotalTable();
        PdfPCell tenderTotalTableCell = new PdfPCell(tenderTotalTable);
        tenderTotalTableCell.setColspan(3);
        negotiationTable.addCell(tenderTotalTableCell);
        negotiationTable.getDefaultCell().setHorizontalAlignment(2);
        negotiationTable.addCell(" ");
        negotiationTable.addCell((Phrase)this.rightPara((Object)this.formatter.format(this.totalAmt)));
        negotiationTable.addCell(" ");
        negotiationTable.addCell((Phrase)this.rightPara((Object)this.formatter.format(this.totalBefNegAmt)));
        negotiationTable.addCell(" ");
        negotiationTable.addCell((Phrase)this.rightPara((Object)this.formatter.format(this.totalAftNegAmt)));
        negotiationTable.addCell(" ");
        negotiationTable.addCell((Phrase)this.rightPara((Object)this.formatter.format(this.totalMarketRateAmt)));
    }

    public void addRowFooter(PdfPTable negotiationTable) {
        negotiationTable.addCell(" ");
        negotiationTable.addCell(" ");
        PdfPTable tenderPercentageTable = this.createTenderPercentageTable();
        PdfPCell tenderPercentageTableCell = new PdfPCell(tenderPercentageTable);
        tenderPercentageTableCell.setColspan(5);
        negotiationTable.addCell(tenderPercentageTableCell);
        negotiationTable.getDefaultCell().setHorizontalAlignment(2);
        PdfPTable befTenderNegFormulaTable = this.createBefTenderNegFormulaTable();
        PdfPCell befTenderNegFormulaTableCell = new PdfPCell(befTenderNegFormulaTable);
        befTenderNegFormulaTableCell.setColspan(2);
        negotiationTable.addCell(befTenderNegFormulaTableCell);
        PdfPTable aftTenderNegFormulaTable = this.createAftTenderNegFormulaTable();
        PdfPCell aftTenderNegFormulaTableCell = new PdfPCell(aftTenderNegFormulaTable);
        aftTenderNegFormulaTableCell.setColspan(2);
        negotiationTable.addCell(aftTenderNegFormulaTableCell);
        PdfPTable marketTenderNegFormulaTable = this.createMarketTenderNegFormulaTable();
        PdfPCell marketTenderNegFormulaTableCell = new PdfPCell(marketTenderNegFormulaTable);
        marketTenderNegFormulaTableCell.setColspan(2);
        negotiationTable.addCell(marketTenderNegFormulaTableCell);
    }

    public void addTotalQuotedFooter(PdfPTable negotiationTable) {
        negotiationTable.addCell(" ");
        negotiationTable.addCell(" ");
        PdfPTable tenderQuotedTable = this.createTotalQuotedValueTable();
        PdfPCell tenderQuotedTableCell = new PdfPCell(tenderQuotedTable);
        tenderQuotedTableCell.setColspan(5);
        negotiationTable.addCell(tenderQuotedTableCell);
        negotiationTable.getDefaultCell().setHorizontalAlignment(2);
        PdfPTable befTenderNegQuotedTable = this.createBefTenderNegQuotedTable();
        PdfPCell befTenderNegQuotedTableCell = new PdfPCell(befTenderNegQuotedTable);
        befTenderNegQuotedTableCell.setColspan(2);
        negotiationTable.addCell(befTenderNegQuotedTableCell);
        PdfPTable aftTenderNegQuotedTable = this.createAftTenderNegQuotedTable();
        PdfPCell aftTenderNegQuotedTableCell = new PdfPCell(aftTenderNegQuotedTable);
        aftTenderNegQuotedTableCell.setColspan(2);
        negotiationTable.addCell(aftTenderNegQuotedTableCell);
        PdfPTable marketTenderNegTable = this.createMarketTenderNegTable();
        PdfPCell marketTenderNegTableCell = new PdfPCell(marketTenderNegTable);
        marketTenderNegTableCell.setColspan(2);
        negotiationTable.addCell(marketTenderNegTableCell);
    }

    public PdfPTable createTenderPercentageTable() {
        PdfPTable tenderPercentageTable = new PdfPTable(5);
        tenderPercentageTable.getDefaultCell().setBorderWidth(1.0f);
        tenderPercentageTable.getDefaultCell().setHorizontalAlignment(0);
        tenderPercentageTable.getDefaultCell().setColspan(5);
        tenderPercentageTable.addCell((String)this.pdfLabel.get("tenderNegotiationpdf.percentage"));
        return tenderPercentageTable;
    }

    public PdfPTable createTotalQuotedValueTable() {
        PdfPTable tenderQuotedTable = new PdfPTable(5);
        tenderQuotedTable.getDefaultCell().setBorderWidth(1.0f);
        tenderQuotedTable.getDefaultCell().setHorizontalAlignment(0);
        tenderQuotedTable.getDefaultCell().setColspan(5);
        tenderQuotedTable.addCell((String)this.pdfLabel.get("tenderNegotiationpdf.quoted.total"));
        return tenderQuotedTable;
    }

    public PdfPTable createBefTenderNegFormulaTable() {
        double totTenderBefNegPer = this.tenderResponse.getPercQuotedRate();
        PdfPTable befTenderNegFormulaTable = new PdfPTable(2);
        befTenderNegFormulaTable.getDefaultCell().setBorderWidth(1.0f);
        befTenderNegFormulaTable.getDefaultCell().setHorizontalAlignment(2);
        befTenderNegFormulaTable.getDefaultCell().setColspan(2);
        String formated_perc = null;
        formated_perc = this.tenderResponse.getTenderEstimate().getTenderType().equalsIgnoreCase(this.percTenderType) ? this.nf.format(totTenderBefNegPer) : this.formatter.format(Math.abs(totTenderBefNegPer));
        befTenderNegFormulaTable.addCell((Phrase)this.makePara((Object)((totTenderBefNegPer > 0.0 ? POSITIVE_SIGN : NEGATIVE_SIGN) + formated_perc + "%")));
        return befTenderNegFormulaTable;
    }

    public PdfPTable createBefTenderNegQuotedTable() {
        double totTenderBefNegPer = this.tenderResponse.getPercQuotedRate();
        PdfPTable befTenderNegQuotedTable = new PdfPTable(2);
        befTenderNegQuotedTable.getDefaultCell().setBorderWidth(1.0f);
        befTenderNegQuotedTable.getDefaultCell().setHorizontalAlignment(2);
        befTenderNegQuotedTable.getDefaultCell().setColspan(2);
        String perc_amt = null;
        perc_amt = this.tenderResponse.getTenderEstimate().getTenderType().equalsIgnoreCase(this.percTenderType) ? (totTenderBefNegPer > 0.0 ? this.formatter.format(this.totalBefNegAmt + this.totalBefNegAmt * (Math.abs(totTenderBefNegPer) / 100.0)) : this.formatter.format(this.totalBefNegAmt - this.totalBefNegAmt * (Math.abs(totTenderBefNegPer) / 100.0))) : this.formatter.format(Math.abs(this.totalBefNegAmt));
        befTenderNegQuotedTable.addCell((Phrase)this.makePara((Object)perc_amt));
        return befTenderNegQuotedTable;
    }

    public PdfPTable createAftTenderNegFormulaTable() {
        double totTenderAftNegPer = this.tenderResponse.getPercNegotiatedAmountRate();
        PdfPTable aftTenderNegFormulaTable = new PdfPTable(2);
        aftTenderNegFormulaTable.getDefaultCell().setBorderWidth(1.0f);
        aftTenderNegFormulaTable.getDefaultCell().setHorizontalAlignment(2);
        aftTenderNegFormulaTable.getDefaultCell().setColspan(2);
        String formated_perc = null;
        formated_perc = this.tenderResponse.getTenderEstimate().getTenderType().equalsIgnoreCase(this.percTenderType) ? this.nf.format(totTenderAftNegPer) : this.formatter.format(Math.abs(totTenderAftNegPer));
        aftTenderNegFormulaTable.addCell((Phrase)this.makePara((Object)((totTenderAftNegPer > 0.0 ? POSITIVE_SIGN : NEGATIVE_SIGN) + formated_perc + "%")));
        return aftTenderNegFormulaTable;
    }

    public PdfPTable createAftTenderNegQuotedTable() {
        double totTenderAftNegPer = this.tenderResponse.getPercNegotiatedAmountRate();
        PdfPTable aftTenderNegQuotedTable = new PdfPTable(2);
        aftTenderNegQuotedTable.getDefaultCell().setBorderWidth(1.0f);
        aftTenderNegQuotedTable.getDefaultCell().setHorizontalAlignment(2);
        aftTenderNegQuotedTable.getDefaultCell().setColspan(2);
        String perc_amt = null;
        perc_amt = this.tenderResponse.getTenderEstimate().getTenderType().equalsIgnoreCase(this.percTenderType) ? (totTenderAftNegPer > 0.0 ? this.formatter.format(this.totalAftNegAmt + this.totalAftNegAmt * (Math.abs(totTenderAftNegPer) / 100.0)) : this.formatter.format(this.totalAftNegAmt - this.totalAftNegAmt * (Math.abs(totTenderAftNegPer) / 100.0))) : this.formatter.format(Math.abs(this.totalAftNegAmt));
        aftTenderNegQuotedTable.addCell((Phrase)this.makePara((Object)perc_amt));
        return aftTenderNegQuotedTable;
    }

    public PdfPTable createMarketTenderNegFormulaTable() {
        double totTenderNegMarketPer = this.calculateMarketRate();
        PdfPTable marketTenderNegFormulaTable = new PdfPTable(2);
        marketTenderNegFormulaTable.getDefaultCell().setBorderWidth(1.0f);
        marketTenderNegFormulaTable.getDefaultCell().setHorizontalAlignment(2);
        marketTenderNegFormulaTable.getDefaultCell().setColspan(2);
        String formated_perc = null;
        formated_perc = this.nf.format(totTenderNegMarketPer);
        marketTenderNegFormulaTable.addCell((Phrase)this.makePara((Object)((totTenderNegMarketPer > 0.0 ? POSITIVE_SIGN : NEGATIVE_SIGN) + formated_perc + "%")));
        return marketTenderNegFormulaTable;
    }

    public PdfPTable createMarketTenderNegTable() {
        double totTenderNegMarketPer = this.calculateMarketRate();
        PdfPTable marketTenderNegQuotedTable = new PdfPTable(2);
        marketTenderNegQuotedTable.getDefaultCell().setBorderWidth(1.0f);
        marketTenderNegQuotedTable.getDefaultCell().setHorizontalAlignment(2);
        marketTenderNegQuotedTable.getDefaultCell().setColspan(2);
        String perc_amt = null;
        perc_amt = totTenderNegMarketPer >= 0.0 ? this.formatter.format(this.totalMarketRateAmt + this.totalMarketRateAmt * (Math.abs(totTenderNegMarketPer) / 100.0)) : this.formatter.format(this.totalMarketRateAmt - this.totalMarketRateAmt * (Math.abs(totTenderNegMarketPer) / 100.0));
        marketTenderNegQuotedTable.addCell((Phrase)this.makePara((Object)perc_amt));
        return marketTenderNegQuotedTable;
    }

    private double calculateMarketRate() {
        double percentage = 0.0;
        double totTenderAftNegPer = this.tenderResponse.getPercNegotiatedAmountRate();
        try {
            percentage = (this.totalAmt * (1.0 + totTenderAftNegPer / 100.0) - this.totalMarketRateAmt) / this.totalMarketRateAmt * 100.0;
        }
        catch (Exception e) {
            percentage = 0.0;
            LOGGER.info((Object)("Exception while calculating totTenderNegMarketPer" + e));
        }
        return percentage;
    }

    public double calculatPercentage(double amt1, double am2, int type) {
        double percentage = 0.0;
        try {
            if (type == 1) {
                percentage = (amt1 - am2) / amt1 * 100.0;
            } else if (type == 2) {
                percentage = (amt1 - am2) / am2 * 100.0;
            }
            if (Double.isInfinite(percentage)) {
                percentage = 0.0;
            }
        }
        catch (Exception e) {
            percentage = 0.0;
            LOGGER.info((Object)("Exception while calculating totTenderNegMarketPer" + e));
        }
        return Math.abs(percentage);
    }

    public void addFinalRow(PdfPTable negotiationTable, TenderResponse tenderResponse) {
        PdfPTable tenderNarrationTable = this.createTenderNarrationTable(tenderResponse);
        PdfPCell tenderNarrationTableCell = new PdfPCell(tenderNarrationTable);
        tenderNarrationTableCell.setColspan(13);
        negotiationTable.addCell(tenderNarrationTableCell);
    }

    public PdfPTable createTenderNarrationTable(TenderResponse tenderResponse) {
        PdfPTable tenderNarrationTable = new PdfPTable(13);
        tenderNarrationTable.getDefaultCell().setBorderWidth(1.0f);
        tenderNarrationTable.getDefaultCell().setHorizontalAlignment(0);
        tenderNarrationTable.getDefaultCell().setColspan(13);
        tenderNarrationTable.addCell("\t" + (tenderResponse.getNarration() == null ? "" : tenderResponse.getNarration()));
        return tenderNarrationTable;
    }

    public PdfPTable createTenderTotalTable() {
        PdfPTable tenderTotalTable = new PdfPTable(3);
        tenderTotalTable.getDefaultCell().setBorderWidth(1.0f);
        tenderTotalTable.getDefaultCell().setHorizontalAlignment(1);
        tenderTotalTable.getDefaultCell().setColspan(3);
        tenderTotalTable.addCell((String)this.pdfLabel.get("tenderNegotiationpdf.tendertotal"));
        return tenderTotalTable;
    }

    public PdfPTable createAsPerEstimateTable(TenderResponse tenderResponse) {
        PdfPTable estimateTable = new PdfPTable(3);
        estimateTable.getDefaultCell().setBorderWidth(1.0f);
        estimateTable.getDefaultCell().setHorizontalAlignment(1);
        estimateTable.getDefaultCell().setColspan(3);
        estimateTable.addCell((String)this.pdfLabel.get("tenderNegotiationpdf.asPerEstimate"));
        estimateTable.getDefaultCell().setColspan(1);
        estimateTable.addCell((String)this.pdfLabel.get(TENDERNEGOTIATION_RATE));
        estimateTable.addCell((String)this.pdfLabel.get("tenderNegotiationpdf.Per"));
        estimateTable.addCell((String)this.pdfLabel.get(TENDERNEGOTIATION_AMOUNT));
        return estimateTable;
    }

    public PdfPTable createBeforeNegotiationTable(TenderResponse tenderResponse) {
        PdfPTable beforeNegotiationTable = new PdfPTable(2);
        beforeNegotiationTable.getDefaultCell().setBorderWidth(1.0f);
        beforeNegotiationTable.getDefaultCell().setHorizontalAlignment(1);
        beforeNegotiationTable.getDefaultCell().setColspan(2);
        beforeNegotiationTable.addCell((String)this.pdfLabel.get("tenderNegotiationpdf.asPerTender"));
        beforeNegotiationTable.getDefaultCell().setColspan(1);
        beforeNegotiationTable.addCell((String)this.pdfLabel.get(TENDERNEGOTIATION_RATE));
        beforeNegotiationTable.addCell((String)this.pdfLabel.get(TENDERNEGOTIATION_AMOUNT));
        return beforeNegotiationTable;
    }

    public PdfPTable createAfterNegotiationTable(TenderResponse tenderResponse) {
        PdfPTable afterNegotiationTable = new PdfPTable(2);
        afterNegotiationTable.getDefaultCell().setBorderWidth(1.0f);
        afterNegotiationTable.getDefaultCell().setHorizontalAlignment(1);
        afterNegotiationTable.getDefaultCell().setColspan(2);
        String negDate = "";
        if (tenderResponse != null && tenderResponse.getNegotiationDate() != null) {
            negDate = this.sdf.format(tenderResponse.getNegotiationDate());
        }
        afterNegotiationTable.addCell((String)this.pdfLabel.get("tenderNegotiationpdf.aftneg") + negDate);
        afterNegotiationTable.getDefaultCell().setColspan(1);
        afterNegotiationTable.addCell((String)this.pdfLabel.get(TENDERNEGOTIATION_RATE));
        afterNegotiationTable.addCell((String)this.pdfLabel.get(TENDERNEGOTIATION_AMOUNT));
        return afterNegotiationTable;
    }

    public PdfPTable createMarketRateTable(TenderResponse tenderResponse) {
        String asOnDate = "";
        if (tenderResponse != null && tenderResponse.getNegotiationDate() != null) {
            asOnDate = this.sdf.format(tenderResponse.getNegotiationDate());
        }
        PdfPTable marketRateTable = new PdfPTable(2);
        marketRateTable.getDefaultCell().setBorderWidth(1.0f);
        marketRateTable.getDefaultCell().setHorizontalAlignment(1);
        marketRateTable.getDefaultCell().setColspan(2);
        marketRateTable.addCell((String)this.pdfLabel.get("tenderNegotiationpdf.marketratedate") + asOnDate);
        marketRateTable.getDefaultCell().setColspan(1);
        marketRateTable.addCell((String)this.pdfLabel.get(TENDERNEGOTIATION_RATE));
        marketRateTable.addCell((String)this.pdfLabel.get(TENDERNEGOTIATION_AMOUNT));
        return marketRateTable;
    }

    private String getDateInFormat(String date) throws DocumentException {
        String dateInFormat = null;
        try {
            dateInFormat = new SimpleDateFormat("dd-MMM-yyyy", Locale.US).format(new SimpleDateFormat("yyyy-MM-dd", Locale.US).parse(date));
        }
        catch (Exception e) {
            throw new DocumentException("Exception occured while parsing date := " + e);
        }
        return dateInFormat;
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public EmployeeServiceOld getemployeeService() {
        return this.employeeService;
    }

    public void setEmployeeService(EmployeeServiceOld employeeService) {
        this.employeeService = employeeService;
    }

    public Map<String, Object> processLatestRateAndQtyForLineItem(Collection<EstimateLineItemsForWP> estimateLinItems, Activity act) {
        HashMap<String, Object> rateQtyMap = new HashMap<String, Object>();
        for (EstimateLineItemsForWP lineItem : estimateLinItems) {
            if (lineItem.getActivity() == null || lineItem.getActivity().getId() == null || lineItem.getActivity().getId().longValue() != act.getId().longValue()) continue;
            rateQtyMap.put("slno", lineItem.getSrlNo());
            rateQtyMap.put("desc", lineItem.getDescription());
            rateQtyMap.put("sorcode", lineItem.getCode());
            rateQtyMap.put("qty", lineItem.getQuantity());
            rateQtyMap.put("rate", lineItem.getRate());
            rateQtyMap.put("per", lineItem.getUom());
            rateQtyMap.put("amt", lineItem.getAmt());
        }
        return rateQtyMap;
    }

    public String getWardList(WorksPackage wp) {
        HashMap<String, String> resultMap = new HashMap<String, String>();
        ArrayList<String> wardnameList = new ArrayList<String>();
        for (AbstractEstimate ae : wp.getAllEstimates()) {
            if (ae.getWard() == null || ae.getWard().getParent() == null || ae.getWard().getParent().getName() == null || resultMap.containsKey(ae.getWard().getName())) continue;
            wardnameList.add(ae.getWard().getName() + "/" + ae.getWard().getParent().getName());
            resultMap.put(ae.getWard().getName(), ae.getWard().getParent().getName());
        }
        return StringUtils.join((Object[])wardnameList.toArray(), (String)",");
    }

    public String getWorksPackgeReq() {
        return this.worksPackgeReq;
    }

    public void setWorksPackgeReq(String worksPackgeReq) {
        this.worksPackgeReq = worksPackgeReq;
    }

    public WorksService getWorksService() {
        return this.worksService;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    private PdfPTable createContractorTable(TenderResponse tenderResponse) throws DocumentException {
        PdfPTable contractorTable = new PdfPTable(3);
        contractorTable.setWidthPercentage(100.0f);
        contractorTable.setWidths(new float[]{1.6f, 3.6f, 6.6f});
        try {
            contractorTable.getDefaultCell().setPadding(5.0f);
            contractorTable.getDefaultCell().setBorderWidth(1.0f);
            contractorTable.getDefaultCell().setHorizontalAlignment(1);
            contractorTable.addCell((String)this.pdfLabel.get("tenderNegotiationpdf.contractorcode"));
            contractorTable.addCell((String)this.pdfLabel.get("tenderNegotiationpdf.contractorname"));
            contractorTable.addCell((String)this.pdfLabel.get("tenderNegotiationpdf.contractoraddress"));
            for (TenderResponseContractors tenderResponseContractors : tenderResponse.getTenderResponseContractors()) {
                contractorTable.addCell((Phrase)this.centerPara((Object)tenderResponseContractors.getContractor().getCode()));
                contractorTable.addCell((Phrase)this.centerPara((Object)tenderResponseContractors.getContractor().getName()));
                contractorTable.addCell((Phrase)this.centerPara((Object)tenderResponseContractors.getContractor().getCorrespondenceAddress()));
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)("Exception while creating contractor table" + e));
        }
        return contractorTable;
    }

    private void createNegotiationTableForContractors(TenderResponse tenderResponse) throws DocumentException {
        PdfPTable negotiationTable = null;
        int count = 0;
        for (TenderResponseContractors tenderResponseContractors : tenderResponse.getTenderResponseContractors()) {
            this.document.add((Element)this.makePara((Object)((String)this.pdfLabel.get("tenderNegotiationpdf.contractorname") + " - " + tenderResponseContractors.getContractor().getName() + "(" + tenderResponseContractors.getContractor().getCode() + " ) "), 0));
            this.document.add((Element)this.spacer());
            negotiationTable = this.createNegotiationTable(tenderResponse, tenderResponseContractors.getContractor());
            this.document.add((Element)negotiationTable);
            if (tenderResponse.getTenderResponseContractors().size() != ++count) {
                this.document.newPage();
                continue;
            }
            this.document.add((Element)this.spacer());
        }
    }

    public String getPercTenderType() {
        return this.percTenderType;
    }

    public void setPercTenderType(String percTenderType) {
        this.percTenderType = percTenderType;
    }
}

