/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.measurementbook;

import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.entity.EmployeeView;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.persistence.utils.Page;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.infra.web.utils.EgovPaginatedList;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.WorkflowAction;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.pims.commons.Position;
import org.egov.pims.model.PersonalInformation;
import org.egov.pims.service.EisUtilService;
import org.egov.pims.service.EmployeeServiceOld;
import org.egov.pims.service.PersonalInformationService;
import org.egov.works.models.masters.Contractor;
import org.egov.works.models.measurementbook.MBDetails;
import org.egov.works.models.measurementbook.MBHeader;
import org.egov.works.models.tender.TenderEstimate;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.models.workorder.WorkOrderActivity;
import org.egov.works.models.workorder.WorkOrderEstimate;
import org.egov.works.revisionestimate.entity.enums.RevisionType;
import org.egov.works.services.MeasurementBookService;
import org.egov.works.services.MeasurementBookWFService;
import org.egov.works.services.WorkOrderService;
import org.egov.works.services.WorksService;
import org.egov.works.utils.DateConversionUtil;
import org.egov.works.web.actions.measurementbook.AjaxMeasurementBookAction;
import org.hibernate.Query;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Result(name={"new"}, location="measurementBook-new.jsp")
public class MeasurementBookAction
extends BaseFormAction {
    private static final long serialVersionUID = 1536135285051426488L;
    private static final Logger logger = Logger.getLogger(MeasurementBookAction.class);
    private static final String VERIFY = "verify";
    private static final String SUBMITTED = "submitted";
    private static final String ACTIVITY_SEARCH = "activitySearch";
    private static final String MB_SEARCH = "mbSearch";
    private static final String DATEFORMAT = "dd-MMM-yyyy";
    private MBHeader mbHeader = new MBHeader();
    private List<MBDetails> mbDetails = new LinkedList();
    private String messageKey;
    private Long id;
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private EmployeeServiceOld employeeServiceOld;
    @Autowired
    private UserService userService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    private EmployeeView mbPreparedByView;
    private MeasurementBookService measurementBookService;
    private WorksService worksService;
    private WorkOrderService workOrderService;
    private List<MBDetails> actionMbDetailValues = new LinkedList();
    private double quantityFactor;
    private List<WorkOrderActivity> activityList;
    private List<MBHeader> mbList;
    private List<WorkOrderEstimate> workOrderEstimateList = new ArrayList();
    private String workorderNo;
    private Long workOrderId;
    private String mode;
    private String mborderNumberRequired;
    private String workName;
    private String projectCode;
    private String activityCode;
    private String activityDesc;
    private Long contractorId;
    private Date fromDate;
    private Date toDate;
    private String mbRefNo;
    private String mbPages;
    private String mbStatus;
    private Long departmentId;
    private Integer designationId;
    private String approverComments;
    private Integer approverUserId;
    private MeasurementBookWFService measurementBookWFService;
    private WorkflowService<MBHeader> workflowService;
    private static final String SAVE_ACTION = "save";
    private static final String SOURCE_INBOX = "inbox";
    private String sourcepage = "";
    private String dispEmployeeName;
    private String dispDesignation;
    private Long estimateId;
    private PersonalInformationService personalInformationService;
    private static final String ACTION_NAME = "actionName";
    private String activitySearchMode;
    private boolean isLegacyMB;
    private static final String NON_TENDERED = "nonTendered";
    private static final String LUMP_SUM = "lumpSum";
    private String cancellationReason;
    private String cancelRemarks;
    private Long mbId;
    private String estimateNo;
    private Integer execDeptid;
    private Integer page = 1;
    private Integer pageSize = 30;
    private EgovPaginatedList pagedResults;
    private Integer defaultPreparedById;
    private String defaultDesgination;
    private String isRCEstimate;
    private static final String YES = "yes";
    private Date workCommencedDate;
    private Date latestMBDate;
    private Long woId;

    public MeasurementBookAction() {
        this.addRelatedEntity("workOrder", WorkOrder.class);
    }

    public void prepare() {
        AjaxMeasurementBookAction ajaxMBAction = new AjaxMeasurementBookAction();
        ajaxMBAction.setPersistenceService(this.getPersistenceService());
        ajaxMBAction.setAssignmentService(this.assignmentService);
        ajaxMBAction.setPersonalInformationService(this.personalInformationService);
        if (this.id != null) {
            this.mbHeader = (MBHeader)this.measurementBookService.findById((Serializable)this.id, false);
            if (this.mbHeader != null) {
                this.workOrderEstimateList.add(this.mbHeader.getWorkOrderEstimate());
            }
        } else if (this.workOrderId != null) {
            this.workOrderEstimateList.addAll(this.getPersistenceService().findAllByNamedQuery("getWorkOrderEstimateByWorkOrderId", new Object[]{this.workOrderId}));
            this.mbHeader.setWorkOrder((WorkOrder)this.workOrderService.findById((Serializable)this.workOrderId, false));
        }
        if (this.workOrderEstimateList.isEmpty()) {
            this.addDropdownData("workOrderEstimateList", Collections.EMPTY_LIST);
        } else {
            this.addDropdownData("workOrderEstimateList", this.measurementBookService.getWorkOrderEstimatesForMB(this.workOrderEstimateList));
        }
        super.prepare();
        this.setupDropdownDataExcluding(new String[]{"workOrder"});
        this.addDropdownData("executingDepartmentList", this.getPersistenceService().findAllBy("from DepartmentImpl", new Object[0]));
        if (this.getLatestAssignmentForCurrentLoginUser() != null) {
            this.departmentId = this.getLatestAssignmentForCurrentLoginUser().getDepartment().getId();
        }
        this.populateQuantityFactor();
        if ("cancelMB".equals(this.sourcepage)) {
            this.setMbStatus(MBHeader.MeasurementBookStatus.APPROVED.toString());
        }
        this.getWrkCommndAndLatestMBDates();
    }

    private void getWrkCommndAndLatestMBDates() {
        if (this.id == null || this.mbHeader.getEgwStatus() != null && (this.mbHeader.getEgwStatus().getCode().equalsIgnoreCase("NEW") || this.mbHeader.getEgwStatus().getCode().equalsIgnoreCase("REJECTED"))) {
            Long estId;
            this.woId = this.id == null ? this.workOrderId : this.mbHeader.getWorkOrder().getId();
            if (this.woId != null) {
                this.workCommencedDate = this.measurementBookService.getWorkCommencedDate(this.woId);
            }
            if (this.workOrderEstimateList.size() == 1 && (estId = this.id == null ? ((WorkOrderEstimate)this.workOrderEstimateList.get(0)).getEstimate().getId() : this.mbHeader.getWorkOrderEstimate().getEstimate().getId()) != null) {
                this.latestMBDate = this.measurementBookService.getLastMBCreatedDate(this.woId, estId);
            }
        }
    }

    public Assignment getLatestAssignmentForCurrentLoginUser() {
        PersonalInformation personalInformation = null;
        Long loggedInUserId = this.worksService.getCurrentLoggedInUserId();
        if (loggedInUserId != null) {
            personalInformation = this.employeeServiceOld.getEmpForUserId(loggedInUserId);
        }
        Assignment assignment = null;
        if (personalInformation != null) {
            assignment = this.employeeServiceOld.getLatestAssignmentForEmployee(personalInformation.getIdPersonalInformation());
        }
        return assignment;
    }

    protected void populateQuantityFactor() {
        String configVal = this.worksService.getWorksConfigValue("MAXEXTRALINEITEMPERCENTAGE");
        try {
            this.quantityFactor = Double.valueOf(configVal);
        }
        catch (Exception e) {
            logger.error((Object)("Exception in populateQuantityFactor()>>>" + e.getMessage()));
            this.quantityFactor = 0.0;
        }
    }

    protected MBHeader calculateMBdetails(MBHeader mbHeader, boolean isPersistedObject) {
        return this.measurementBookService.calculateMBDetails(mbHeader, isPersistedObject);
    }

    public String loadSerachForActivity() {
        logger.info((Object)"Loading search page for Activity............");
        return ACTIVITY_SEARCH;
    }

    public String searchActivitiesForMB() {
        HashMap<String, Object> criteriaMap = new HashMap<String, Object>();
        if (this.workorderNo != null && !"".equalsIgnoreCase(this.workorderNo)) {
            criteriaMap.put("WORKORDER_NO", this.workorderNo);
        }
        if (this.estimateId != null) {
            criteriaMap.put("WORKORDER_ESTIMATE_ID", this.estimateId);
        }
        if (this.activityCode != null && !"".equalsIgnoreCase(this.activityCode)) {
            criteriaMap.put("ACTIVITY_CODE", this.activityCode);
        }
        if (this.activityDesc != null && !"".equalsIgnoreCase(this.activityDesc)) {
            criteriaMap.put("ACTIVITY_DESC", this.activityDesc);
        }
        if (this.workOrderId != null) {
            criteriaMap.put("WORKORDER_ID", this.workOrderId);
        }
        if (StringUtils.isNotBlank((String)this.activitySearchMode) && this.activitySearchMode.equalsIgnoreCase(NON_TENDERED)) {
            criteriaMap.put("REVISION_TYPE", RevisionType.NON_TENDERED_ITEM.toString());
            this.activityList = this.workOrderService.searchWOActivitiesFromRevEstimates(criteriaMap);
        } else if (StringUtils.isNotBlank((String)this.activitySearchMode) && this.activitySearchMode.equalsIgnoreCase(LUMP_SUM)) {
            criteriaMap.put("REVISION_TYPE", RevisionType.LUMP_SUM_ITEM.toString());
            this.activityList = this.workOrderService.searchWOActivitiesFromRevEstimates(criteriaMap);
        } else {
            this.activityList = this.workOrderService.searchWOActivities(criteriaMap);
        }
        return ACTIVITY_SEARCH;
    }

    public String loadSerachForMB() {
        logger.debug((Object)"Loading search page for MB............");
        return MB_SEARCH;
    }

    public String loadSearchForMB() {
        logger.debug((Object)"Loading search page for MB............");
        return MB_SEARCH;
    }

    public String searchMB() {
        Page resPage;
        Long count;
        HashMap<String, Object> criteriaMap = new HashMap<String, Object>();
        ArrayList paramList = new ArrayList();
        List qryObj = new ArrayList();
        if (this.workorderNo != null && !"".equalsIgnoreCase(this.workorderNo)) {
            criteriaMap.put("WORKORDER_NO", this.workorderNo);
        }
        if (this.contractorId != null && this.contractorId != -1L) {
            criteriaMap.put("CONTRACTOR_ID", this.contractorId);
        }
        if (this.fromDate != null && this.toDate != null && !DateUtils.compareDates((Date)this.getToDate(), (Date)this.getFromDate())) {
            this.addFieldError("enddate", this.getText("greaterthan.endDate.fromDate"));
        }
        if (this.toDate != null && !DateUtils.compareDates((Date)new Date(), (Date)this.getToDate())) {
            this.addFieldError("enddate", this.getText("greaterthan.endDate.currentdate"));
        }
        if (this.fromDate != null && this.toDate == null) {
            criteriaMap.put("FROM_DATE", new Date(DateUtils.getFormattedDate((Date)this.getFromDate(), (String)DATEFORMAT)));
        } else if (this.toDate != null && this.fromDate == null) {
            criteriaMap.put("TO_DATE", new Date(DateUtils.getFormattedDate((Date)this.getToDate(), (String)DATEFORMAT)));
        } else if (this.fromDate != null && this.toDate != null && this.getFieldErrors().isEmpty()) {
            criteriaMap.put("FROM_DATE", new Date(DateUtils.getFormattedDate((Date)this.getFromDate(), (String)DATEFORMAT)));
            criteriaMap.put("TO_DATE", new Date(DateUtils.getFormattedDate((Date)this.getToDate(), (String)DATEFORMAT)));
        }
        if (this.mbRefNo != null && !"".equalsIgnoreCase(this.mbRefNo)) {
            criteriaMap.put("MB_REF_NO", this.mbRefNo);
        }
        if (this.mbPages != null && !"".equalsIgnoreCase(this.mbPages)) {
            criteriaMap.put("MB_PAGE_NO", this.mbPages);
        }
        if (this.mbStatus != null && !"".equalsIgnoreCase(this.mbStatus) && !"-1".equals(this.mbStatus)) {
            criteriaMap.put("STATUS", this.mbStatus);
        }
        if (this.execDeptid != null && this.execDeptid != -1) {
            criteriaMap.put("DEPT_ID", this.execDeptid);
        }
        if (this.estimateNo != null && !"".equalsIgnoreCase(this.estimateNo)) {
            criteriaMap.put("EST_NO", this.estimateNo);
        }
        qryObj = this.measurementBookService.searchMB(criteriaMap, paramList);
        String qry = (String)qryObj.get(0);
        if (paramList.isEmpty()) {
            Object params = null;
            Query qry1 = this.persistenceService.getSession().createQuery(qry);
            count = (Long)this.persistenceService.find((String)qryObj.get(1));
            resPage = new Page(qry1, this.page.intValue(), this.pageSize.intValue());
        } else {
            Object[] params = new Object[paramList.size()];
            params = paramList.toArray(params);
            count = (Long)this.persistenceService.find((String)qryObj.get(1), params);
            resPage = this.persistenceService.findPageBy(qry, this.page, this.pageSize, params);
        }
        this.pagedResults = new EgovPaginatedList(resPage, count.intValue());
        List list = this.mbList = this.pagedResults != null ? this.pagedResults.getList() : null;
        if (!this.mbList.isEmpty()) {
            this.mbList = this.getPositionAndUser(this.mbList);
        }
        this.pagedResults.setList(this.mbList);
        return MB_SEARCH;
    }

    protected List<MBHeader> getPositionAndUser(List<MBHeader> results) {
        ArrayList<MBHeader> mbHeaderList = new ArrayList<MBHeader>();
        for (MBHeader mbh : results) {
            PersonalInformation emp;
            if (!mbh.getEgwStatus().getCode().equalsIgnoreCase("APPROVED") && !mbh.getEgwStatus().getCode().equalsIgnoreCase("CANCELLED") && (emp = this.employeeServiceOld.getEmployeeforPosition((Position)mbh.getCurrentState().getOwnerPosition())) != null && StringUtils.isNotBlank((String)emp.getEmployeeName())) {
                mbh.setOwner(emp.getEmployeeName());
            }
            mbHeaderList.add(mbh);
            String actions = this.worksService.getWorksConfigValue("MB_SHOW_ACTIONS");
            if (!StringUtils.isNotBlank((String)actions)) continue;
            mbh.getMbActions().addAll(Arrays.asList(actions.split(",")));
        }
        return mbHeaderList;
    }

    public Map<String, Object> getContractorForApprovedWorkOrder() {
        HashMap<String, Object> contractorsWithWOList = new HashMap<String, Object>();
        if (this.workOrderService.getContractorsWithWO() != null) {
            for (Contractor contractor : this.workOrderService.getContractorsWithWO()) {
                contractorsWithWOList.put(contractor.getId() + "", contractor.getCode() + " - " + contractor.getName());
            }
        }
        return contractorsWithWOList;
    }

    public List<EgwStatus> getMbStatusList() {
        return this.persistenceService.findAllBy("from EgwStatus s where moduletype=? and code<>'NEW' order by orderId", new Object[]{MBHeader.class.getSimpleName()});
    }

    public List<Contractor> getContractorList() {
        return this.workOrderService.getAllContractorForWorkOrder();
    }

    @Action(value="/measurementbook/measurementBook-newform")
    public String newform() {
        return "new";
    }

    public String edit() {
        if (SOURCE_INBOX.equalsIgnoreCase(this.sourcepage)) {
            User user = this.userService.getUserById(this.worksService.getCurrentLoggedInUserId());
            boolean isValidUser = this.worksService.validateWorkflowForUser((StateAware)this.mbHeader, user);
            if (isValidUser) {
                throw new ApplicationRuntimeException("Error: Invalid Owner - No permission to view this page.");
            }
        } else if (StringUtils.isEmpty((String)this.sourcepage)) {
            this.sourcepage = "search";
        }
        this.mbHeader = this.calculateMBdetails(this.mbHeader, true);
        return "new";
    }

    public String execute() {
        return "success";
    }

    private boolean canUserModify() {
        boolean result = false;
        String designWhoCanModify = null;
        designWhoCanModify = this.getMBWorkflowModifyDesignation();
        String currentDesgination = null;
        if (this.mbHeader.getCurrentState() != null && this.mbHeader.getCurrentState().getOwnerPosition() != null && ((Position)this.mbHeader.getCurrentState().getOwnerPosition()).getDeptDesig() != null && ((Position)this.mbHeader.getCurrentState().getOwnerPosition()).getDeptDesig().getDesignation() != null && ((Position)this.mbHeader.getCurrentState().getOwnerPosition()).getDeptDesig().getDesignation().getName() != null) {
            currentDesgination = ((Position)this.mbHeader.getCurrentState().getOwnerPosition()).getDeptDesig().getDesignation().getName();
        }
        if (designWhoCanModify != null && currentDesgination != null && designWhoCanModify.equalsIgnoreCase(currentDesgination)) {
            result = true;
        }
        return result;
    }

    private void setApprovedQtyAndPrevCumlVal() {
        AjaxMeasurementBookAction ajaxMBAction = new AjaxMeasurementBookAction();
        ajaxMBAction.setPersistenceService(this.getPersistenceService());
        ajaxMBAction.setAssignmentService(this.assignmentService);
        ajaxMBAction.setPersonalInformationService(this.personalInformationService);
        ajaxMBAction.setMeasurementBookService(this.measurementBookService);
        Long woActId = null;
        Long mbHeaderId = this.mbHeader.getId() == null ? null : this.mbHeader.getId();
        ajaxMBAction.setMbHeaderId(mbHeaderId);
        for (MBDetails mbDetails : this.mbHeader.getMbDetails()) {
            if (mbDetails == null) continue;
            woActId = mbDetails.getWorkOrderActivity().getId();
            ajaxMBAction.setWoActivityId(woActId);
            ajaxMBAction.activityDetails();
            mbDetails.setTotalEstQuantity(ajaxMBAction.getTotalEstQuantity().doubleValue());
            mbDetails.setPrevCumlvQuantity(ajaxMBAction.getPrevCulmEntry().doubleValue());
        }
    }

    public String save() {
        if (this.mbHeader.getEgwStatus() == null || "REJECTED".equalsIgnoreCase(this.mbHeader.getEgwStatus().getCode()) || "new".equalsIgnoreCase(this.mbHeader.getEgwStatus().getCode()) || this.canUserModify()) {
            this.mbHeader.getMbDetails().clear();
        }
        this.mbHeader.setIsLegacyMB(this.isLegacyMB);
        String actionName = "";
        if (this.parameters.get(ACTION_NAME) != null && ((String[])this.parameters.get(ACTION_NAME))[0] != null) {
            actionName = ((String[])this.parameters.get(ACTION_NAME))[0];
        }
        if (this.mbHeader.getEgwStatus() == null || "REJECTED".equalsIgnoreCase(this.mbHeader.getEgwStatus().getCode()) || "new".equalsIgnoreCase(this.mbHeader.getEgwStatus().getCode()) || this.canUserModify()) {
            this.populateActivities();
        }
        WorkOrderEstimate woe = (WorkOrderEstimate)this.persistenceService.findByNamedQuery("getWorkOrderEstimateByEstAndWO", new Object[]{this.estimateId, this.workOrderId});
        this.mbHeader.setWorkOrderEstimate(woe);
        if (this.id == null || this.mbHeader.getEgwStatus() != null && (this.mbHeader.getEgwStatus().getCode().equalsIgnoreCase("NEW") || this.mbHeader.getEgwStatus().getCode().equalsIgnoreCase("REJECTED"))) {
            if (this.workCommencedDate != null && this.workCommencedDate.after(this.mbHeader.getMbDate())) {
                throw new ValidationException(Arrays.asList(new ValidationError("mb.lessThan.wrk.cmmncd.date", this.getText("mb.lessThan.wrk.cmmncd.date") + " " + new SimpleDateFormat("dd/MM/yyyy").format(this.workCommencedDate) + ". " + this.getText("pls.enter.valid.date"))));
            }
            if (this.latestMBDate != null && this.latestMBDate.after(this.mbHeader.getMbDate())) {
                throw new ValidationException(Arrays.asList(new ValidationError("mb.lessThan.latest.mbdate.date", this.getText("mb.lessThan.latest.mbdate.date") + " " + new SimpleDateFormat("dd/MM/yyyy").format(this.latestMBDate) + ". " + this.getText("pls.enter.valid.date"))));
            }
        }
        try {
            if (this.mbHeader.getEgwStatus() == null || "REJECTED".equalsIgnoreCase(this.mbHeader.getEgwStatus().getCode()) || "new".equalsIgnoreCase(this.mbHeader.getEgwStatus().getCode()) || this.canUserModify()) {
                this.validateMBAmount(woe);
            }
        }
        catch (ValidationException e) {
            throw e;
        }
        catch (Exception e) {
            logger.debug((Object)("Error while validation of mb and wo amount" + e));
        }
        if (actionName.equalsIgnoreCase(MBHeader.Actions.SUBMIT_FOR_APPROVAL.toString()) && this.mbHeader.getMbDetails().isEmpty()) {
            this.setApprovedQtyAndPrevCumlVal();
            throw new ValidationException(Arrays.asList(new ValidationError("measurementbook.item.mandatory", "measurementbook.item.mandatory")));
        }
        if (this.mbHeader.getEgwStatus() == null || "REJECTED".equalsIgnoreCase(this.mbHeader.getEgwStatus().getCode()) || "new".equalsIgnoreCase(this.mbHeader.getEgwStatus().getCode()) || this.canUserModify()) {
            for (MBDetails details : this.mbHeader.getMbDetails()) {
                Boolean limitStatus = this.measurementBookService.approvalLimitCrossed(details);
                if (limitStatus == null) {
                    Double percentage = this.worksService.getConfigval() + 100.0;
                    this.setApprovedQtyAndPrevCumlVal();
                    if (this.isRCEstimate.equalsIgnoreCase(YES)) {
                        throw new ValidationException(Arrays.asList(new ValidationError("measurementbook.currMBEntry.quantityFactor.rcEstimate.complete.error", this.getText("measurementbook.currMBEntry.quantityFactor.rcEstimate.complete.error", new String[]{percentage.toString()}))));
                    }
                    throw new ValidationException(Arrays.asList(new ValidationError("measurementbook.currMBEntry.quantityFactor.complete.error", this.getText("measurementbook.currMBEntry.quantityFactor.complete.error", new String[]{percentage.toString()}))));
                }
                if (!limitStatus.booleanValue()) continue;
                if (!StringUtils.isNotBlank((String)details.getOrderNumber())) {
                    this.setApprovedQtyAndPrevCumlVal();
                    throw new ValidationException(Arrays.asList(new ValidationError("measurementbook.currMBEntry.enter.order.no", this.getText("measurementbook.currMBEntry.enter.order.no"))));
                }
                if (details.getMbdetailsDate() == null) {
                    this.setApprovedQtyAndPrevCumlVal();
                    throw new ValidationException(Arrays.asList(new ValidationError("measurementbook.currMBEntry.enter.order.dt", this.getText("measurementbook.currMBEntry.enter.order.dt"))));
                }
                if (details.getMbdetailsDate() == null || !DateConversionUtil.isBeforeByDate((Date)new Date(), (Date)details.getMbdetailsDate())) continue;
                this.setApprovedQtyAndPrevCumlVal();
                throw new ValidationException(Arrays.asList(new ValidationError("measurementbook.currMBEntry.order.date.error", this.getText("measurementbook.currMBEntry.order.date.error"))));
            }
        }
        if (SAVE_ACTION.equals(actionName) && this.mbHeader.getEgwStatus() == null) {
            this.mbHeader.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("MBHeader", "NEW"));
        }
        this.mbHeader = (MBHeader)this.measurementBookService.persist((Object)this.mbHeader);
        if (!actionName.isEmpty()) {
            this.mbHeader = (MBHeader)this.workflowService.transition(actionName, (StateAware)this.mbHeader, this.approverComments);
        }
        if (this.mbHeader.getEgwStatus() == null || "REJECTED".equalsIgnoreCase(this.mbHeader.getEgwStatus().getCode()) || "new".equalsIgnoreCase(this.mbHeader.getEgwStatus().getCode()) || this.canUserModify()) {
            this.mbHeader = this.calculateMBdetails(this.mbHeader, true);
        }
        this.messageKey = this.mbHeader.getEgwStatus() != null && this.mbHeader.getEgwStatus().getCode() != null && MBHeader.MeasurementBookStatus.APPROVED.toString().equalsIgnoreCase(this.mbHeader.getEgwStatus().getCode()) ? "measurementbook.approved" : "measurementbook.save.success";
        this.addActionMessage(this.getText(this.messageKey, this.messageKey));
        this.getDesignation(this.mbHeader);
        if (SAVE_ACTION.equals(actionName)) {
            this.sourcepage = SOURCE_INBOX;
        }
        return SAVE_ACTION.equals(actionName) ? "edit" : "success";
    }

    private void validateMBAmount(WorkOrderEstimate workOrderEstimate) {
        double negoPerc = 0.0;
        String tenderType = "";
        BigDecimal totalMBAmount = BigDecimal.ZERO;
        BigDecimal currMBTotal = BigDecimal.ZERO;
        BigDecimal allMBsTotal = BigDecimal.ZERO;
        Double woEstimateAmount = 0.0;
        Double totalWOAmount = 0.0;
        Object[] obj = (Object[])this.persistenceService.find("select tr.percNegotiatedAmountRate,tr.tenderEstimate,tr.tenderNegotiatedValue from TenderResponse tr where tr.egwStatus.code = 'APPROVED' and tr.negotiationNumber = ? ", new Object[]{workOrderEstimate.getWorkOrder().getNegotiationNumber()});
        TenderEstimate tenderEstimate = (TenderEstimate)obj[1];
        tenderType = tenderEstimate.getTenderType();
        if (StringUtils.isNotBlank((String)tenderType) && tenderType.equalsIgnoreCase("Percentage-Tender")) {
            negoPerc = (Double)obj[0];
        } else {
            double negotiationValue = (Double)obj[2];
            negoPerc = negotiationValue / tenderEstimate.getWorksPackage().getTotalAmount();
        }
        totalMBAmount = this.measurementBookService.getTotalMBAmountForPrevMBs(workOrderEstimate, negoPerc, tenderType);
        currMBTotal = this.getAmountsForCurrentMB(this.mbHeader.getMbDetails(), negoPerc, tenderType);
        allMBsTotal = totalMBAmount.add(currMBTotal);
        Double approvedRevisionWOAmount = (Double)this.persistenceService.find(" select sum(woe.workOrder.workOrderAmount) from WorkOrderEstimate woe where woe.workOrder.parent is not null and woe.workOrder.egwStatus.code='APPROVED' and woe.estimate.parent.id=? ", new Object[]{this.estimateId});
        if (StringUtils.isNotBlank((String)tenderType) && tenderType.equalsIgnoreCase("Percentage-Tender")) {
            Double estimateAmt = (Double)this.persistenceService.find("select woe.estimate.workValue.value from WorkOrderEstimate woe where woe.workOrder.parent is null and woe.workOrder.egwStatus.code='APPROVED' and woe.estimate.id=? ", new Object[]{this.estimateId});
            woEstimateAmount = estimateAmt + estimateAmt * negoPerc / 100.0;
        } else {
            for (WorkOrderActivity woa : workOrderEstimate.getWorkOrderActivities()) {
                woEstimateAmount = woEstimateAmount + woa.getApprovedAmount();
            }
        }
        totalWOAmount = approvedRevisionWOAmount == null ? woEstimateAmount : approvedRevisionWOAmount + woEstimateAmount;
        if (allMBsTotal.doubleValue() > totalWOAmount) {
            this.setApprovedQtyAndPrevCumlVal();
            throw new ValidationException(Arrays.asList(new ValidationError("measurementbook.workOrder.amount.exceeded", "measurementbook.workOrder.amount.exceeded")));
        }
    }

    private BigDecimal getAmountsForCurrentMB(List<MBDetails> mbDetailsList, double negoPerc, String tenderType) {
        BigDecimal currentMBTenderedAmt = BigDecimal.ZERO;
        BigDecimal currMBAmount = BigDecimal.ZERO;
        BigDecimal tenderedMBAmount = BigDecimal.ZERO;
        BigDecimal currMBTotal = BigDecimal.ZERO;
        if (tenderType.equalsIgnoreCase("Percentage-Tender")) {
            for (MBDetails mbd : mbDetailsList) {
                if (mbd.getWorkOrderActivity().getActivity().getRevisionType() != null) continue;
                currentMBTenderedAmt = currentMBTenderedAmt.add(BigDecimal.valueOf(mbd.getAmount()));
            }
            currMBAmount = this.mbHeader.getTotalMBAmount();
            if (currentMBTenderedAmt != null) {
                tenderedMBAmount = currentMBTenderedAmt.add(currentMBTenderedAmt.multiply(BigDecimal.valueOf(negoPerc / 100.0)));
            }
            currMBTotal = tenderedMBAmount.add(currMBAmount.subtract(currentMBTenderedAmt));
        } else {
            currMBTotal = this.mbHeader.getTotalMBAmount();
        }
        return currMBTotal.setScale(2, RoundingMode.HALF_UP);
    }

    protected void populateActivities() {
        for (MBDetails mbDetails : this.actionMbDetailValues) {
            if (mbDetails == null) continue;
            mbDetails.setMbHeader(this.mbHeader);
            if (mbDetails.getWorkOrderActivity().getActivity().getId() == null) {
                mbDetails.setWorkOrderActivity((WorkOrderActivity)this.getPersistenceService().find("from WorkOrderActivity where id=?", new Object[]{mbDetails.getWorkOrderActivity().getId()}));
            }
            this.mbHeader.addMbDetails(mbDetails);
        }
    }

    public String reject() {
        String actionName = "";
        if (this.parameters.get(ACTION_NAME) != null && ((String[])this.parameters.get(ACTION_NAME))[0] != null) {
            actionName = ((String[])this.parameters.get(ACTION_NAME))[0];
        }
        if (this.mbHeader != null && this.mbHeader.getId() != null && !actionName.isEmpty()) {
            this.workflowService.transition(actionName, (StateAware)this.mbHeader, this.approverComments);
            this.mbHeader = (MBHeader)this.measurementBookService.persist((Object)this.mbHeader);
            this.getDesignation(this.mbHeader);
        }
        this.messageKey = "measurementbook.reject";
        return "success";
    }

    public String cancel() {
        if (this.mbHeader != null && this.mbHeader.getEgBillregister() != null && this.mbHeader.getEgBillregister().getStatus() != null && !this.mbHeader.getEgBillregister().getStatus().getCode().equalsIgnoreCase("CANCELLED")) {
            this.messageKey = "measurementbook.cancel.failure";
            this.addActionError(this.getText(this.messageKey));
            return "edit";
        }
        String actionName = "";
        if (this.parameters.get(ACTION_NAME) != null && ((String[])this.parameters.get(ACTION_NAME))[0] != null) {
            actionName = ((String[])this.parameters.get(ACTION_NAME))[0];
        }
        if (this.mbHeader != null && this.mbHeader.getId() != null && !actionName.isEmpty()) {
            this.workflowService.transition(actionName, (StateAware)this.mbHeader, this.approverComments);
            this.mbHeader = (MBHeader)this.measurementBookService.persist((Object)this.mbHeader);
            this.getDesignation(this.mbHeader);
        }
        this.messageKey = "measurementbook.cancel";
        return "success";
    }

    protected void getDesignation(MBHeader mbHeader) {
        String result;
        if (mbHeader.getEgwStatus() != null && !"NEW".equalsIgnoreCase(mbHeader.getEgwStatus().getCode()) && (result = this.worksService.getEmpNameDesignation((Position)mbHeader.getState().getOwnerPosition(), mbHeader.getState().getCreatedDate())) != null && !"@".equalsIgnoreCase(result)) {
            String empName = result.substring(0, result.lastIndexOf(64));
            String designation = result.substring(result.lastIndexOf(64) + 1, result.length());
            this.setDispEmployeeName(empName);
            this.setDispDesignation(designation);
        }
    }

    public String verify() {
        return VERIFY;
    }

    public String submit() {
        return SUBMITTED;
    }

    public Object getModel() {
        return this.mbHeader;
    }

    public String cancelApprovedMB() {
        MBHeader mbHeader = (MBHeader)this.measurementBookService.findById((Serializable)this.mbId, false);
        mbHeader.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("MBHeader", MBHeader.MeasurementBookStatus.CANCELLED.toString()));
        PersonalInformation prsnlInfo = this.employeeServiceOld.getEmpForUserId(this.worksService.getCurrentLoggedInUserId());
        String empName = "";
        if (prsnlInfo.getEmployeeFirstName() != null) {
            empName = prsnlInfo.getEmployeeFirstName();
        }
        if (prsnlInfo.getEmployeeLastName() != null) {
            empName = empName.concat(" ").concat(prsnlInfo.getEmployeeLastName());
        }
        if (this.cancelRemarks == null || StringUtils.isNotBlank((String)this.cancelRemarks)) {
            // empty if block
        }
        this.mbRefNo = mbHeader.getMbRefNo();
        this.messageKey = this.mbRefNo + " : " + this.getText("mb.cancel.success.message");
        return "success";
    }

    public void setModel(MBHeader mbHeader) {
        this.mbHeader = mbHeader;
    }

    public List<MBDetails> getMbDetails() {
        return this.mbDetails;
    }

    public void setMbDetails(List<MBDetails> mbDetails) {
        this.mbDetails = mbDetails;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public void setMessageKey(String messageKey) {
        this.messageKey = messageKey;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EmployeeView getMbPreparedByView() {
        return this.mbPreparedByView;
    }

    public void setMbPreparedByView(EmployeeView mbPreparedByView) {
        this.mbPreparedByView = mbPreparedByView;
    }

    public void setMeasurementBookService(MeasurementBookService measurementBookService) {
        this.measurementBookService = measurementBookService;
    }

    public void setActionMbDetailValues(List<MBDetails> actionMbDetailValues) {
        this.actionMbDetailValues = actionMbDetailValues;
    }

    public List<WorkOrderActivity> getActivityList() {
        return this.activityList;
    }

    public List<MBDetails> getActionMbDetailValues() {
        return this.actionMbDetailValues;
    }

    public String getActivityCode() {
        return this.activityCode;
    }

    public void setActivityCode(String activityCode) {
        this.activityCode = activityCode;
    }

    public String getActivityDesc() {
        return this.activityDesc;
    }

    public void setActivityDesc(String activityDesc) {
        this.activityDesc = activityDesc;
    }

    public String getWorkorderNo() {
        return this.workorderNo;
    }

    public void setWorkorderNo(String workorderNo) {
        this.workorderNo = workorderNo;
    }

    public void setWorkOrderService(WorkOrderService workOrderService) {
        this.workOrderService = workOrderService;
    }

    public double getQuantityFactor() {
        return this.quantityFactor;
    }

    public void setQuantityFactor(double quantityFactor) {
        this.quantityFactor = quantityFactor;
    }

    public List<MBHeader> getMbList() {
        return this.mbList;
    }

    public void setActivityList(List<WorkOrderActivity> activityList) {
        this.activityList = activityList;
    }

    public Long getContractorId() {
        return this.contractorId;
    }

    public void setContractorId(Long contractorId) {
        this.contractorId = contractorId;
    }

    public String getMbRefNo() {
        return this.mbRefNo;
    }

    public void setMbRefNo(String mbRefNo) {
        this.mbRefNo = mbRefNo;
    }

    public String getMbPages() {
        return this.mbPages;
    }

    public void setMbPages(String mbPages) {
        this.mbPages = mbPages;
    }

    public String getMbStatus() {
        return this.mbStatus;
    }

    public void setMbStatus(String mbStatus) {
        this.mbStatus = mbStatus;
    }

    public List<WorkflowAction> getValidActions() {
        return this.workflowService.getValidActions((StateAware)this.mbHeader);
    }

    public void setMeasurementBookWorkflowService(WorkflowService<MBHeader> workflow) {
        this.workflowService = workflow;
    }

    public MeasurementBookWFService getMeasurementBookWFService() {
        return this.measurementBookWFService;
    }

    public void setMeasurementBookWFService(MeasurementBookWFService measurementBookWFService) {
        this.measurementBookWFService = measurementBookWFService;
    }

    public String getSourcepage() {
        return this.sourcepage;
    }

    public void setSourcepage(String sourcepage) {
        this.sourcepage = sourcepage;
    }

    public String getDispEmployeeName() {
        return this.dispEmployeeName;
    }

    public void setDispEmployeeName(String dispEmployeeName) {
        this.dispEmployeeName = dispEmployeeName;
    }

    public String getDispDesignation() {
        return this.dispDesignation;
    }

    public void setDispDesignation(String dispDesignation) {
        this.dispDesignation = dispDesignation;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public Long getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public Integer getDesignationId() {
        return this.designationId;
    }

    public void setDesignationId(Integer designationId) {
        this.designationId = designationId;
    }

    public String getApproverComments() {
        return this.approverComments;
    }

    public void setApproverComments(String approverComments) {
        this.approverComments = approverComments;
    }

    public Integer getApproverUserId() {
        return this.approverUserId;
    }

    public void setApproverUserId(Integer approverUserId) {
        this.approverUserId = approverUserId;
    }

    public String getMborderNumberRequired() {
        this.mborderNumberRequired = this.worksService.getWorksConfigValue("ORDER_NUMBER_REQUIRED");
        return this.mborderNumberRequired;
    }

    public String getWorkOrderEstimateRequired() {
        return this.worksService.getWorksConfigValue("WORKORDER_ESTIMATE_REQUIRED");
    }

    public String getMBWorkflowModifyDesignation() {
        return this.worksService.getWorksConfigValue("MB_WORKFLOW_MODIFY_DESIG");
    }

    public void setMborderNumberRequired(String mborderNumberRequired) {
        this.mborderNumberRequired = mborderNumberRequired;
    }

    public Long getWorkOrderId() {
        return this.workOrderId;
    }

    public void setWorkOrderId(Long workOrderId) {
        this.workOrderId = workOrderId;
    }

    public Long getEstimateId() {
        return this.estimateId;
    }

    public void setEstimateId(Long estimateId) {
        this.estimateId = estimateId;
    }

    public String getWorkName() {
        return this.workName;
    }

    public void setWorkName(String workName) {
        this.workName = workName;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public List<WorkOrderEstimate> getWorkOrderEstimateList() {
        return this.workOrderEstimateList;
    }

    public void setWorkOrderEstimateList(List<WorkOrderEstimate> workOrderEstimateList) {
        this.workOrderEstimateList = workOrderEstimateList;
    }

    public void setPersonalInformationService(PersonalInformationService personalInformationService) {
        this.personalInformationService = personalInformationService;
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public String getActivitySearchMode() {
        return this.activitySearchMode;
    }

    public void setActivitySearchMode(String activitySearchMode) {
        this.activitySearchMode = activitySearchMode;
    }

    public boolean getIsLegacyMB() {
        return this.isLegacyMB;
    }

    public void setIsLegacyMB(boolean isLegacyMB) {
        this.isLegacyMB = isLegacyMB;
    }

    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public Long getMbId() {
        return this.mbId;
    }

    public void setMbId(Long mbId) {
        this.mbId = mbId;
    }

    public String getEstimateNo() {
        return this.estimateNo;
    }

    public void setEstimateNo(String estimateNo) {
        this.estimateNo = estimateNo;
    }

    public Integer getExecDeptid() {
        return this.execDeptid;
    }

    public void setExecDeptid(Integer execDeptid) {
        this.execDeptid = execDeptid;
    }

    public String getCancelRemarks() {
        return this.cancelRemarks;
    }

    public void setCancelRemarks(String cancelRemarks) {
        this.cancelRemarks = cancelRemarks;
    }

    public Integer getPage() {
        return this.page;
    }

    public Integer getPageSize() {
        return this.pageSize;
    }

    public EgovPaginatedList getPagedResults() {
        return this.pagedResults;
    }

    public void setPage(Integer page) {
        this.page = page;
    }

    public void setPageSize(Integer pageSize) {
        this.pageSize = pageSize;
    }

    public void setPagedResults(EgovPaginatedList pagedResults) {
        this.pagedResults = pagedResults;
    }

    public void setEisService(EisUtilService eisService) {
    }

    public Integer getDefaultPreparedById() {
        return this.defaultPreparedById;
    }

    public void setDefaultPreparedById(Integer defaultPreparedById) {
        this.defaultPreparedById = defaultPreparedById;
    }

    public String getDefaultDesgination() {
        return this.defaultDesgination;
    }

    public String getIsRCEstimate() {
        return this.isRCEstimate;
    }

    public void setIsRCEstimate(String isRCEstimate) {
        this.isRCEstimate = isRCEstimate;
    }

    public Date getWorkCommencedDate() {
        return this.workCommencedDate;
    }

    public void setWorkCommencedDate(Date workCommencedDate) {
        this.workCommencedDate = workCommencedDate;
    }

    public Date getLatestMBDate() {
        return this.latestMBDate;
    }

    public void setLatestMBDate(Date latestMBDate) {
        this.latestMBDate = latestMBDate;
    }

    public Long getWoId() {
        return this.woId;
    }

    public void setWoId(Long woId) {
        this.woId = woId;
    }
}

