/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.masters;

import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.convention.annotation.Results;
import org.egov.commons.Bank;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.egf.commons.bank.service.CreateBankService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.services.PersistenceService;
import org.egov.works.master.service.ContractorGradeService;
import org.egov.works.master.service.ContractorService;
import org.egov.works.models.masters.Contractor;
import org.egov.works.models.masters.ContractorDetail;
import org.egov.works.services.WorksService;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Results(value={@Result(name={"new"}, location="contractor-new.jsp"), @Result(name={"searchContractor"}, location="contractor-searchContractor.jsp"), @Result(name={"search"}, location="contractor-search.jsp"), @Result(name={"success"}, location="contractor-success.jsp"), @Result(name={"edit"}, location="contractor-edit.jsp"), @Result(name={"view"}, location="contractor-view.jsp")})
public class ContractorAction
extends SearchFormAction {
    private static final long serialVersionUID = 3167651186547987956L;
    private static final Logger logger = Logger.getLogger(ContractorAction.class);
    public static final String SEARCH_CONTRACTOR = "searchContractor";
    public static final String SEARCH = "search";
    public static final String SUCCESS = "success";
    @Autowired
    private ContractorService contractorService;
    private Contractor contractor = new Contractor();
    private Map<String, String> exmptionMap = ContractorService.exemptionForm;
    private List<Contractor> contractorList = null;
    private List<ContractorDetail> actionContractorDetails = new LinkedList();
    private Long id;
    private String mode;
    @Autowired
    private UserService userService;
    private WorksService worksService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibDAO;
    @Autowired
    private ContractorGradeService contractorGradeService;
    @Autowired
    private WorksUtils worksUtils;
    private String contractorName;
    private String contractorCode;
    private Long departmentId;
    private Long gradeId;
    private Date searchDate;
    private boolean sDisabled;
    private Integer statusId;
    private List<ContractorDetail> contractorDetailList = null;
    private PersistenceService<ContractorDetail, Long> contractorDetailService;
    private Integer rowId;
    private Long defaultDepartmentId;
    private boolean contractorCodeAutoGeneration;
    private Map<String, Object> criteriaMap = null;
    @Autowired
    private CreateBankService createBankService;
    @PersistenceContext
    private EntityManager entityManager;

    public String execute() {
        return this.list();
    }

    @Action(value="/masters/contractor-newform")
    public String newform() {
        return "new";
    }

    public String list() {
        this.contractorList = this.contractorService.getAllContractors();
        return SUCCESS;
    }

    @Action(value="/masters/contractor-edit")
    public String edit() {
        this.contractor = (Contractor)this.contractorService.findById((Serializable)this.contractor.getId(), false);
        if (this.mode.equals("edit")) {
            return "edit";
        }
        return "view";
    }

    @Action(value="/masters/contractor-search")
    public String search() {
        return SEARCH_CONTRACTOR;
    }

    @Action(value="/masters/contractor-searchContractor")
    public String searchContractor() {
        return SEARCH_CONTRACTOR;
    }

    @Action(value="/masters/contractor-viewResult")
    public String viewResult() {
        this.setPageSize(30);
        this.contractorList = this.contractorService.getContractorListForCriterias(this.createCriteriaMap());
        super.search();
        return SEARCH_CONTRACTOR;
    }

    @Action(value="/masters/contractor-save")
    public String save() {
        if (this.actionContractorDetails.isEmpty()) {
            this.addActionMessage(this.getText("contractor.details.altleastone_details_needed"));
            return "new";
        }
        if (this.contractor.getBank().getId() != -1 && this.contractor.getBank().getId() != 0 && this.contractor.getBank() != null && this.contractor.getBank().getId() != null) {
            Integer bankId = this.contractor.getBank().getId();
            this.entityManager.detach((Object)this.contractor.getBank());
            Bank bank = (Bank)this.entityManager.find(Bank.class, (Object)bankId);
            this.contractor.setBank(bank);
        } else {
            this.contractor.setBank(null);
        }
        this.populateContractorDetails(this.mode);
        if (this.isContractorCodeAutoGeneration() && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.mode)) {
            this.contractor.setCode(this.contractorService.generateContractorCode(this.contractor));
        }
        this.contractor = (Contractor)this.contractorService.persist((Object)this.contractor);
        if (this.mode == null || StringUtils.isEmpty((String)this.mode)) {
            this.contractorService.createAccountDetailKey(this.contractor);
        }
        this.contractorService.persist((Object)this.contractor);
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)this.mode)) {
            this.addActionMessage(this.getText("contractor.save.success", new String[]{this.contractor.getCode()}));
        } else {
            this.addActionMessage(this.getText("contractor.modified.success"));
        }
        return SUCCESS;
    }

    @Action(value="/masters/contractor-searchPage")
    public String searchPage() {
        String negDate = (String)this.request.get("negDate");
        if (negDate != null) {
            SimpleDateFormat dftDateFormatter = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
            try {
                this.searchDate = dftDateFormatter.parse(negDate);
            }
            catch (ParseException e) {
                logger.error((Object)"Negotiation date is not valid, should be in dd/MM/yyyy format");
            }
        }
        return SEARCH;
    }

    @Action(value="/masters/contractor-searchResult")
    public String searchResult() {
        this.contractorService.searchContractor(this.createCriteriaMap());
        return SEARCH;
    }

    protected void populateContractorDetails(String mode) {
        this.contractor.getContractorDetails().clear();
        for (ContractorDetail contractorDetail : this.actionContractorDetails) {
            if (this.validContractorDetail(contractorDetail)) {
                contractorDetail.setDepartment(this.departmentService.getDepartmentById(contractorDetail.getDepartment().getId()));
                contractorDetail.setStatus(this.egwStatusHibDAO.findById(contractorDetail.getStatus().getId(), false));
                if (contractorDetail.getGrade().getId() == null) {
                    contractorDetail.setGrade(null);
                } else {
                    contractorDetail.setGrade(this.contractorGradeService.getContractorGradeById(contractorDetail.getGrade().getId()));
                }
                if (contractorDetail.getCategory() == null || "0".equals(contractorDetail.getCategory())) {
                    contractorDetail.setCategory(null);
                }
                contractorDetail.setContractor(this.contractor);
                if (mode.equals("edit")) {
                    this.setPrimaryDetails(contractorDetail);
                }
                this.contractor.addContractorDetail(contractorDetail);
                continue;
            }
            if (contractorDetail == null) continue;
            if (contractorDetail.getDepartment() == null || contractorDetail.getDepartment().getId() == null) {
                contractorDetail.setDepartment(null);
            } else {
                contractorDetail.setDepartment(this.departmentService.getDepartmentById(contractorDetail.getDepartment().getId()));
            }
            if (contractorDetail.getStatus() == null || contractorDetail.getStatus().getId() == null) {
                contractorDetail.setStatus(null);
            } else {
                contractorDetail.setStatus(this.egwStatusHibDAO.findById(contractorDetail.getStatus().getId(), false));
            }
            if (contractorDetail.getGrade() == null || contractorDetail.getGrade().getId() == null) {
                contractorDetail.setGrade(null);
            } else {
                contractorDetail.setGrade(this.contractorGradeService.getContractorGradeById(contractorDetail.getGrade().getId()));
            }
            if (contractorDetail.getCategory() == null || "0".equals(contractorDetail.getCategory())) {
                contractorDetail.setCategory(null);
            }
            contractorDetail.setContractor(this.contractor);
            if (mode.equals("edit")) {
                this.setPrimaryDetails(contractorDetail);
            }
            this.contractor.addContractorDetail(contractorDetail);
        }
    }

    protected boolean validContractorDetail(ContractorDetail contractorDetail) {
        if (contractorDetail != null && contractorDetail.getDepartment() != null && contractorDetail.getStatus() != null && contractorDetail.getDepartment().getId() != null && contractorDetail.getStatus().getId() != null) {
            this.validateContractorMasterMandatoryFields(contractorDetail);
            return true;
        }
        return false;
    }

    public Object getModel() {
        return this.contractor;
    }

    public List<Contractor> getContractorList() {
        return this.contractorList;
    }

    public void prepare() {
        if (this.id != null) {
            this.contractor = (Contractor)this.contractorService.findById((Serializable)this.id, false);
        }
        super.prepare();
        this.setupDropdownDataExcluding(new String[]{"bank"});
        this.addDropdownData("departmentList", this.departmentService.getAllDepartments());
        this.addDropdownData("gradeList", this.contractorGradeService.getAllContractorGrades());
        this.addDropdownData("bankList", this.createBankService.getByIsActiveTrueOrderByName());
        this.addDropdownData("statusList", this.egwStatusHibDAO.getStatusByModule("Contractor"));
        this.defaultDepartmentId = this.worksUtils.getDefaultDepartmentId();
        this.addDropdownData("contractorDetailsCategoryValues", Arrays.asList(this.contractorService.getContractorMasterCategoryValues()));
        this.addDropdownData("contractorMasterMandatoryFields", Arrays.asList(this.contractorService.getcontractorMasterSetMandatoryFields()));
        this.addDropdownData("contractorMasterHiddenFields", Arrays.asList(this.contractorService.getcontractorMasterSetHiddenFields()));
        this.setContractorMasterCodeAutoGenerationConfigValue();
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public Contractor getContractor() {
        return this.contractor;
    }

    public void setContractor(Contractor contractor) {
        this.contractor = contractor;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public List<ContractorDetail> getActionContractorDetails() {
        return this.actionContractorDetails;
    }

    public void setActionContractorDetails(List<ContractorDetail> actionContractorDetails) {
        this.actionContractorDetails = actionContractorDetails;
    }

    public String getContractorName() {
        return this.contractorName;
    }

    public void setContractorName(String contractorName) {
        this.contractorName = contractorName;
    }

    public String getContractorCode() {
        return this.contractorCode;
    }

    public void setContractorCode(String contractorCode) {
        this.contractorCode = contractorCode;
    }

    public Long getDepartmentId() {
        return this.departmentId;
    }

    public void setDepartmentId(Long departmentId) {
        this.departmentId = departmentId;
    }

    public Long getGradeId() {
        return this.gradeId;
    }

    public void setGradeId(Long gradeId) {
        this.gradeId = gradeId;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public Date getSearchDate() {
        return this.searchDate;
    }

    public void setSearchDate(Date searchDate) {
        this.searchDate = searchDate;
    }

    public Map<String, String> getExmptionMap() {
        return this.exmptionMap;
    }

    public void setExmptionMap(Map<String, String> exmptionMap) {
        this.exmptionMap = exmptionMap;
    }

    public Integer getStatusId() {
        return this.statusId;
    }

    public void setStatusId(Integer statusId) {
        this.statusId = statusId;
    }

    public List<ContractorDetail> getContractorDetailList() {
        return this.contractorDetailList;
    }

    public void setContractorDetailList(List<ContractorDetail> contractorDetailList) {
        this.contractorDetailList = contractorDetailList;
    }

    public PersistenceService<ContractorDetail, Long> getContractorDetailService() {
        return this.contractorDetailService;
    }

    public void setContractorDetailService(PersistenceService<ContractorDetail, Long> contractorDetailService) {
        this.contractorDetailService = contractorDetailService;
    }

    public boolean isSDisabled() {
        return this.sDisabled;
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        return this.contractorService.prepareQuery(this.createCriteriaMap());
    }

    public Integer getRowId() {
        return this.rowId;
    }

    public void setRowId(Integer rowId) {
        this.rowId = rowId;
    }

    private ContractorDetail setPrimaryDetails(ContractorDetail contractorDetail) {
        User user = this.userService.getUserById(this.worksService.getCurrentLoggedInUserId());
        contractorDetail.setCreatedBy(user);
        contractorDetail.setCreatedDate(new Date());
        return contractorDetail;
    }

    private Map<String, Object> createCriteriaMap() {
        this.criteriaMap = new HashMap();
        this.criteriaMap.put("contractorName", this.contractorName);
        this.criteriaMap.put("contractorCode", this.contractorCode);
        this.criteriaMap.put("departmentId", this.departmentId);
        this.criteriaMap.put("statusId", this.statusId);
        this.criteriaMap.put("gradeId", this.gradeId);
        this.criteriaMap.put("searchDate", this.searchDate);
        return this.criteriaMap;
    }

    public List<ValidationError> getContractorMasterMandatoryFieldsErrors(Contractor contractor, String[] mandatoryFields) {
        String[] contractorMasterMandatoryFields;
        ArrayList<ValidationError> validationErrors = new ArrayList<ValidationError>();
        for (String val : contractorMasterMandatoryFields = mandatoryFields) {
            if ("mobileNumber".equals(val) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contractor.getMobileNumber())) {
                this.addValidationError(validationErrors, "contractor.mobileNumber", "depositworks.roadcut.enter.mobileno");
            }
            if ("bankAccount".equals(val) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contractor.getBankAccount())) {
                this.addValidationError(validationErrors, "contractor.bankAccount", "contractor.bankaccount.null");
            }
            if ("bank".equals(val) && (contractor.getBank() == null || contractor.getBank().getId() == -1)) {
                this.addValidationError(validationErrors, "contractor.bank.name", "bank.name.null");
            }
            if ("ifscCode".equals(val) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contractor.getIfscCode())) {
                this.addValidationError(validationErrors, "contractor.ifscCode", "contractor.ifsccode.null");
            }
            if ("tinNumber".equals(val) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contractor.getTinNumber())) {
                this.addValidationError(validationErrors, "contractor.tinNumber", "contractor.tinnumber.null");
            }
            if ("panNumber".equals(val) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contractor.getPanNumber())) {
                this.addValidationError(validationErrors, "contractor.panNumber", "contractor.pannumber.null");
            }
            if ("email".equals(val) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contractor.getEmail())) {
                this.addValidationError(validationErrors, "contractor.email", "depositworks.roadcut.enter.email");
            }
            if ("contactPerson".equals(val) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contractor.getContactPerson())) {
                this.addValidationError(validationErrors, "contractor.contactPerson", "contractor.contactperson.null");
            }
            if ("narration".equals(val) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contractor.getNarration())) {
                this.addValidationError(validationErrors, "contractor.narration", "contractor.narration.null");
            }
            if ("correspondenceAddress".equals(val) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contractor.getCorrespondenceAddress())) {
                this.addValidationError(validationErrors, "contractor.correspondenceAddress", "contractor.correspondenceAddress.null");
            }
            if ("paymentAddress".equals(val) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contractor.getPaymentAddress())) {
                this.addValidationError(validationErrors, "contractor.paymentAddress", "contractor.paymentAddress.null");
            }
            if ("pwdApprovalCode".equals(val) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contractor.getPwdApprovalCode())) {
                this.addValidationError(validationErrors, "contractor.pwdApprovalCode", "contractor.pwdApprovalCode.null");
            }
            if (!"exemptionForm".equals(val) || !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contractor.getExemptionForm().toString())) continue;
            this.addValidationError(validationErrors, "contractor.exemptionForm", "contractor.exemptionForm.null");
        }
        if (!this.isContractorCodeAutoGeneration() && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contractor.getCode())) {
            this.addValidationError(validationErrors, "contractor.code", "contractor.code.null");
        }
        if (this.isContractorCodeAutoGeneration() && contractor.getName().length() < 4) {
            this.addValidationError(validationErrors, "contractor.name", "contractor.name.length");
        }
        return validationErrors;
    }

    private void validateContractorMasterMandatoryFields(ContractorDetail contractorDetail) {
        ArrayList validationErrors = new ArrayList();
        String[] contractorMasterMandatoryFields = this.contractorService.getContractorMasterMandatoryFields();
        validationErrors.addAll(this.getContractorMasterMandatoryFieldsErrors(this.contractor, contractorMasterMandatoryFields));
        for (String val : contractorMasterMandatoryFields) {
            if ("registrationNumber".equals(val) && org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contractorDetail.getRegistrationNumber())) {
                this.addValidationError(validationErrors, "contractorDetail.registrationNumber", "contractordetail.registrationnumber.required");
            }
            if ("grade".equals(val) && (contractorDetail.getGrade() == null || contractorDetail.getGrade().getId() == null)) {
                this.addValidationError(validationErrors, "contractorDetail.grade", "contractordetail.grade.required");
            }
            if (!"category".equals(val) || !org.apache.commons.lang3.StringUtils.isBlank((CharSequence)contractorDetail.getCategory())) continue;
            this.addValidationError(validationErrors, "contractorDetail.category", "contractordetail.category.required");
        }
        contractorDetail.setErrorList(validationErrors);
    }

    public void addValidationError(List<ValidationError> errorList, String errorCode, String errorValue) {
        errorList.add(new ValidationError(errorCode, errorValue));
    }

    public Long getDefaultDepartmentId() {
        return this.defaultDepartmentId;
    }

    public void setDefaultDepartmentId(Long defaultDepartmentId) {
        this.defaultDepartmentId = defaultDepartmentId;
    }

    public boolean isContractorCodeAutoGeneration() {
        return this.contractorCodeAutoGeneration;
    }

    public void setContractorCodeAutoGeneration(boolean contractorCodeAutoGeneration) {
        this.contractorCodeAutoGeneration = contractorCodeAutoGeneration;
    }

    public void setContractorMasterCodeAutoGenerationConfigValue() {
        String autoGenerateContractorCode = this.contractorService.getContractorMasterAutoCodeGenerateValue();
        if (autoGenerateContractorCode != null && "Yes".equals(autoGenerateContractorCode)) {
            this.setContractorCodeAutoGeneration(true);
        } else {
            this.setContractorCodeAutoGeneration(false);
        }
    }
}

