/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.estimate;

import com.lowagie.text.Chunk;
import com.lowagie.text.DocumentException;
import com.lowagie.text.Element;
import com.lowagie.text.Font;
import com.lowagie.text.HeaderFooter;
import com.lowagie.text.Paragraph;
import com.lowagie.text.Phrase;
import com.lowagie.text.pdf.PdfPCell;
import com.lowagie.text.pdf.PdfPTable;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CFinancialYear;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.eis.entity.Employee;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.DateUtils;
import org.egov.infra.workflow.entity.StateHistory;
import org.egov.infstr.services.PersistenceService;
import org.egov.model.budget.BudgetUsage;
import org.egov.pims.commons.DeptDesig;
import org.egov.pims.commons.Position;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.AbstractEstimateAppropriation;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.abstractestimate.entity.FinancialDetail;
import org.egov.works.abstractestimate.entity.MultiYearEstimate;
import org.egov.works.abstractestimate.entity.OverheadValue;
import org.egov.works.models.masters.OverheadRate;
import org.egov.works.services.AbstractEstimateService;
import org.egov.works.services.DepositWorksUsageService;
import org.egov.works.services.WorksService;
import org.egov.works.utils.AbstractPDFGenerator;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class EstimatePDFGenerator
extends AbstractPDFGenerator {
    private static final Logger logger = Logger.getLogger(EstimatePDFGenerator.class);
    private static final String space1 = "\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t";
    private static final String MODULE_NAME = "Works";
    private static final String KEY_NAME = "SKIP_BUDGET_CHECK";
    private final AbstractEstimate estimate;
    private List<AbstractEstimateAppropriation> abstractEstimateAppropriationList = new LinkedList();
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    private PersistenceService<AbstractEstimateAppropriation, Long> estimateAppropriationService;
    private String headerText;
    @Autowired
    private AssignmentService assignmentService;
    private BudgetDetailsDAO budgetDetailsDAO;
    private AbstractEstimateService abstractEstimateService;
    private WorksService worksService;
    private String appValue = "";
    private DepositWorksUsageService depositWorksUsageService;
    private boolean skipBudget = false;
    private List<StateHistory> history = null;
    private boolean shouldShowApprovalNumber;

    public EstimatePDFGenerator(AbstractEstimate estimate, String headerText, OutputStream out) {
        super(out, "portrait");
        this.estimate = estimate;
        this.headerText = headerText;
    }

    public void generatePDF() {
        try {
            HeaderFooter hf;
            Paragraph headerTextPara = new Paragraph(new Chunk(this.headerText, new Font(-1, 14.0f, 1)));
            String oldEstNo = "";
            headerTextPara.setAlignment(1);
            this.document.add((Element)headerTextPara);
            this.document.add((Element)this.makePara((Object)("Executing Department:" + this.estimate.getExecutingDepartment().getName()), 0));
            if (this.estimate.getUserDepartment() != null) {
                this.document.add((Element)this.makePara((Object)("User Department:" + this.estimate.getUserDepartment().getName()), 0));
            }
            CFinancialYear estimateFinancialYear = ((MultiYearEstimate)this.estimate.getMultiYearEstimates().get(0)).getFinancialYear();
            this.addZoneYearHeader(this.estimate, estimateFinancialYear);
            this.document.add((Element)this.makePara((Object)("Name of Work: " + this.estimate.getName()), 0));
            this.document.add((Element)this.makePara((Object)("Description: " + this.estimate.getDescription()), 0));
            if (this.estimate.getProjectCode() != null) {
                String projectCode = "Project Code : " + this.estimate.getProjectCode().getCode();
                this.document.add((Element)this.makePara((Object)projectCode, 0));
                hf = new HeaderFooter(new Phrase("\t  \t  \t  \t \t \t  \t  \t  \t \t \t  \t  \t  \t \t\t  \t  \t  \t \t\t  \t  \t  \t \t\t  \t  \t  \t \t\t  \t  \t  \t  \t  \t  \t \t\t  \t  \t  \t \t" + this.headerText.concat("\n").concat("\t  \t  \t  \t \t \t  \t  \t  \t \t\t  \t  \t  \t \t\t  \t  \t  \t \t\t  \t  \t  \t \t\t  \t  \t  \t  \t  \t  \t \t\t  \t  \t  \t \t ABSTRACT ESTIMATE").concat("\n\n").concat("Name of Work: " + this.estimate.getName()).concat("\n").concat("Description: " + this.estimate.getDescription()).concat("\n").concat("Estimate Number: " + this.estimate.getEstimateNumber()).concat("").concat("\n").concat(projectCode)), false);
            } else {
                hf = new HeaderFooter(new Phrase("\t  \t  \t  \t \t \t  \t  \t  \t \t \t  \t  \t  \t \t\t  \t  \t  \t \t\t  \t  \t  \t \t\t  \t  \t  \t \t\t  \t  \t  \t  \t  \t  \t \t\t  \t  \t  \t \t" + this.headerText.concat("\n").concat("\t  \t  \t  \t \t \t  \t  \t  \t \t\t  \t  \t  \t \t\t  \t  \t  \t \t\t  \t  \t  \t \t\t  \t  \t  \t  \t  \t  \t \t\t  \t  \t  \t \t ABSTRACT ESTIMATE").concat("\n\n").concat("Name of Work: " + this.estimate.getName()).concat("\n").concat("Description: " + this.estimate.getDescription()).concat("\n").concat("Estimate Number: " + this.estimate.getEstimateNumber()).concat("")), false);
            }
            hf.disableBorderSide(1);
            hf.disableBorderSide(2);
            hf.setLeft(0.0f);
            this.document.setHeader(hf);
            PdfPTable overheadsTable = this.createOverheadsTable(this.estimate);
            this.document.add((Element)this.spacer());
            this.document.add((Element)overheadsTable);
            this.document.add((Element)this.spacer());
            PdfPTable multiyearTable = this.createMultiYearTable(this.estimate);
            this.document.add((Element)this.makePara((Object)"Year-wise Estimate"));
            this.document.add((Element)this.spacer());
            this.document.add((Element)multiyearTable);
            this.document.add((Element)this.spacer());
            this.document.add((Element)this.makePara((Object)("Estimate Created By: " + this.estimate.getCreatedBy().getName())));
            this.document.add((Element)this.spacer());
            this.document.add((Element)this.spacer());
            this.document.add((Element)this.makePara((Object)"Checked By: "));
            this.document.newPage();
            this.addZoneYearHeaderWithOutEstimateNo(this.estimate, estimateFinancialYear);
            this.document.add((Element)this.createActivitiesTable(this.estimate));
            this.document.add((Element)this.spacer());
            PdfPTable approvaldetailsTable = this.createApprovalDetailsTable(this.estimate);
            String appropriationNumber = this.abstractEstimateService.getLatestEstimateAppropriationNumber(this.estimate);
            if (this.isSkipBudgetCheck().booleanValue()) {
                PdfPTable depositWorksAppropriationTable = this.createDepositAppropriationTable(this.estimate, appropriationNumber);
                if (depositWorksAppropriationTable.getRows().size() != 1 && appropriationNumber != null) {
                    this.document.newPage();
                    this.document.add((Element)this.spacer());
                    this.document.add((Element)this.makePara((Object)"Deposit Code Appropriation Details"));
                    this.document.add((Element)this.spacer());
                    this.document.add((Element)depositWorksAppropriationTable);
                }
            } else {
                PdfPTable BudgetaryAppropriationTable = this.createBudgetaryAppropriationTable(this.estimate, appropriationNumber);
                String estimateNumber = this.estimate.getEstimateNumber();
                if (BudgetaryAppropriationTable.getRows().size() != 1 && !this.getBudgetDetailUsage(estimateNumber).isEmpty() && appropriationNumber != null) {
                    this.document.newPage();
                    this.document.add((Element)this.spacer());
                    this.document.add((Element)this.makePara((Object)"Budgetary Appropriation"));
                    this.document.add((Element)this.spacer());
                    this.document.add((Element)BudgetaryAppropriationTable);
                }
            }
            this.document.newPage();
            this.document.add((Element)this.spacer());
            this.document.add((Element)this.makePara((Object)"EXECUTIVE ENGINEER'S OFFICE,  ZONE.......................................................................", 0));
            this.document.add((Element)this.spacer());
            this.document.add((Element)this.makePara((Object)"Est No.                                                Unit:                                                 Dept.", 0));
            this.document.add((Element)this.spacer());
            Paragraph budgetheadTextPara = new Paragraph(new Chunk("BUDGET HEAD", new Font(-1, 14.0f, 1)));
            budgetheadTextPara.setAlignment(1);
            this.document.add((Element)budgetheadTextPara);
            this.document.add((Element)this.spacer());
            this.document.add((Element)this.makePara((Object)"____________________________________________________________________________", 0));
            this.document.add((Element)this.makePara((Object)"Rs.                                            ", 0));
            this.document.add((Element)this.makePara((Object)"____________________________________________________________________________", 0));
            this.document.add((Element)this.makePara((Object)"Works:                                          ", 0));
            this.document.add((Element)this.spacer());
            this.document.add((Element)this.spacer());
            Paragraph memoTextPara = new Paragraph(new Chunk("MEMO", new Font(-1, 14.0f, 1)));
            memoTextPara.setAlignment(1);
            this.document.add((Element)memoTextPara);
            this.document.add((Element)this.makePara((Object)"Budget Grant                               ", 0));
            this.document.add((Element)this.makePara((Object)"Amount Appropriated:__________________________________________________________", 0));
            this.document.add((Element)this.makePara((Object)"Balance on Hand:                                ", 0));
            this.document.add((Element)this.makePara((Object)"Amount of this estimate_________________________________________________________", 0));
            this.document.add((Element)this.makePara((Object)"Balance forward_______________________________________________________________", 0));
            this.document.add((Element)this.makePara((Object)"Submitted for favour of sanction                           ", 0));
            this.document.add((Element)this.spacer());
            this.document.add((Element)this.spacer());
            this.document.add((Element)this.makePara((Object)"A.E.E.Unit \t  \t  \t  \t \t \t  \t  \t  \t \t \t \t\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t \t \t \t \t \t \tExe.Eng.Zone.....................", 0));
            this.document.add((Element)this.spacer());
            this.document.add((Element)this.makePara((Object)"Sanctioned", 1));
            this.document.add((Element)this.spacer());
            this.document.add((Element)this.spacer());
            this.document.add((Element)this.makePara((Object)"DATE:\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t\t  \t  \t  \t \t \t  \t  \t  \t \t \t \tAsst.Commissioner Zone...............", 0));
            this.document.add((Element)this.spacer());
            this.document.add((Element)this.makePara((Object)"\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t\t  \t  \t  \t \t \t  \t  \t  \t \t \t \tAPPROPRIATION No.", 0));
            this.document.add((Element)this.makePara((Object)"\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t \t \t \tDate:", 0));
            if (approvaldetailsTable.getRows().size() != 1 && this.shouldShowApprovalNumber) {
                this.document.resetHeader();
                this.document.newPage();
                this.document.add((Element)this.makePara((Object)("\t  \t  \t  \t \t \t  \t  \t  \t \t \t  \t  \t  \t \t\t  \t  \t  \t \t\t  \t  \t  \t \t\t  \t  \t  \t \t\t  \t  \t  \t  \t  \t  \t \t\t  \t  \t  \t \t" + this.headerText.concat("\n").concat("\t  \t  \t  \t \t \t  \t  \t  \t \t\t  \t  \t  \t \t\t  \t  \t  \t \t\t  \t  \t  \t \t\t  \t  \t  \t  \t  \t  \t \t\t  \t  \t  \t \t ABSTRACT ESTIMATE").concat("\n\n"))));
                this.document.add((Element)this.makePara((Object)"File Current Number :\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t \t   Date: \t \t", 0));
                this.document.add((Element)this.makePara((Object)"\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t\t  \t  \t  \t \t \t \t \t  \t  \t  \t Department : ", 0));
                this.document.add((Element)this.spacer());
                Paragraph headingPara1 = new Paragraph(new Chunk("NOTE FOR ADMINISTRATIVE SANCTION AS PER RULE 78 OF ", new Font(-1, 14.0f, 1)));
                headingPara1.setAlignment(1);
                this.document.add((Element)headingPara1);
                Paragraph headingPara2 = new Paragraph(new Chunk("MCMC ACT 1919 ", new Font(-1, 14.0f, 1)));
                headingPara2.setAlignment(1);
                this.document.add((Element)headingPara2);
                this.document.add((Element)this.spacer());
                PdfPTable estimateDetailsTable1 = this.createEstimateDetailsTable1(this.estimate);
                this.document.add((Element)estimateDetailsTable1);
                PdfPTable budgetDetailsTableFourCols = this.createBudgetDetailsForEstimateTable(this.estimate);
                this.document.add((Element)budgetDetailsTableFourCols);
                PdfPTable estimateDetailsTable2 = this.createBalanceAmtCalculationTable(this.estimate);
                this.document.add((Element)estimateDetailsTable2);
                this.document.add((Element)this.spacer());
                Paragraph endTextPara = new Paragraph(new Chunk("** END **", new Font(-1, 14.0f, 1)));
                endTextPara.setAlignment(1);
                this.document.add((Element)endTextPara);
            }
            this.document.close();
        }
        catch (DocumentException e) {
            throw new ApplicationRuntimeException("estimate.pdf.error", (Throwable)e);
        }
    }

    private PdfPTable createMultiYearTable(AbstractEstimate estimate) throws DocumentException {
        PdfPTable multiyearTable = new PdfPTable(3);
        multiyearTable.setWidthPercentage(100.0f);
        multiyearTable.setWidths(new float[]{1.0f, 2.0f, 2.0f});
        this.addRow(multiyearTable, true, new Paragraph[]{this.makePara((Object)"Sl No"), this.centerPara((Object)"Year"), this.centerPara((Object)"Percentage")});
        int i = 0;
        for (MultiYearEstimate year : estimate.getMultiYearEstimates()) {
            this.addRow(multiyearTable, true, new Paragraph[]{this.makePara((Object)(++i)), this.makePara((Object)year.getFinancialYear().getFinYearRange(), 1), this.rightPara((Object)year.getPercentage())});
        }
        return multiyearTable;
    }

    private PdfPTable createOverheadsTable(AbstractEstimate estimate) throws DocumentException {
        PdfPTable overheadsTable = new PdfPTable(3);
        overheadsTable.setWidthPercentage(100.0f);
        overheadsTable.setWidths(new float[]{1.0f, 4.0f, 2.0f});
        this.addRow(overheadsTable, true, new Paragraph[]{this.makePara((Object)"Sl No"), this.centerPara((Object)"Description"), this.centerPara((Object)"Amount")});
        this.addRow(overheadsTable, true, new Paragraph[]{this.makePara((Object)"1"), this.makePara((Object)"Work Value"), this.rightPara((Object)this.toCurrency(estimate.getWorkValue()))});
        int i = 1;
        for (OverheadValue oh : estimate.getOverheadValues()) {
            this.addRow(overheadsTable, true, new Paragraph[]{this.makePara((Object)(++i)), this.makePara((Object)this.getOverheadDescription(oh)), this.rightPara((Object)this.toCurrency(oh.getAmount()))});
        }
        this.addRow(overheadsTable, true, new Paragraph[]{this.centerPara((Object)""), this.makePara((Object)"TOTAL"), this.rightPara((Object)this.toCurrency(estimate.getTotalAmount()))});
        return overheadsTable;
    }

    private PdfPTable createDepositAppropriationTable(AbstractEstimate estimate, String appropriationNumber) throws DocumentException {
        int isReject = -1;
        this.depositWorksUsageService = this.abstractEstimateService.getDepositWorksUsageService();
        Accountdetailtype accountdetailtype = this.worksService.getAccountdetailtypeByName("DEPOSITCODE");
        this.estimateAppropriationService = this.abstractEstimateService.getEstimateAppropriationService();
        this.abstractEstimateAppropriationList = this.estimateAppropriationService.findAllBy("from AbstractEstimateAppropriation aea where aea.abstractEstimate.id=? and aea.depositWorksUsage.id is not null order by id, aea.depositWorksUsage.financialYearId asc", new Object[]{estimate.getId()});
        PdfPTable depositWorksAppropriationTable = new PdfPTable(2);
        depositWorksAppropriationTable.setWidthPercentage(100.0f);
        depositWorksAppropriationTable.setWidths(new float[]{2.0f, 8.0f});
        if (appropriationNumber != null && appropriationNumber.toUpperCase().contains("BC")) {
            isReject = 1;
        }
        if (appropriationNumber != null && estimate.getTotalAmount() != null && isReject == -1) {
            this.addRow(depositWorksAppropriationTable, true, new Paragraph[]{this.centerPara((Object)"Deposit Code"), this.centerPara((Object)estimate.getDepositCode().getCode())});
            this.addRow(depositWorksAppropriationTable, true, new Paragraph[]{this.centerPara((Object)"Account Code"), this.centerPara((Object)(((FinancialDetail)estimate.getFinancialDetails().get(0)).getCoa().getGlcode() + "-" + ((FinancialDetail)estimate.getFinancialDetails().get(0)).getCoa().getName()))});
            this.addRow(depositWorksAppropriationTable, true, new Paragraph[]{this.makePara((Object)"Function Center"), this.centerPara((Object)((FinancialDetail)estimate.getFinancialDetails().get(0)).getFunction().getName())});
            this.addRow(depositWorksAppropriationTable, true, new Paragraph[]{this.makePara((Object)"Department"), this.centerPara((Object)estimate.getUserDepartment().getName())});
            this.addRow(depositWorksAppropriationTable, true, new Paragraph[]{this.makePara((Object)"Amount of the Estimate "), this.rightPara((Object)this.toCurrency(estimate.getTotalAmount()))});
            PdfPTable appropriationDetailTable = new PdfPTable(6);
            this.addRow(appropriationDetailTable, true, new Paragraph[]{this.makePara(7.0f, (Object)"Appropriation Number"), this.makePara(7.0f, (Object)"Total Deposit Amount"), this.makePara(7.0f, (Object)"Amount Appropriated so far"), this.makePara(7.0f, (Object)"Amount Appropriated"), this.makePara(7.0f, (Object)"Balance on Hand"), this.makePara(7.0f, (Object)"Balance After Appropriation")});
            for (AbstractEstimateAppropriation abstractEstimateAppropriation : this.abstractEstimateAppropriationList) {
                if (abstractEstimateAppropriation.getDepositWorksUsage().getConsumedAmount().doubleValue() == 0.0) continue;
                BigDecimal totalDepositAmt = this.depositWorksUsageService.getTotalDepositWorksAmount(estimate.getDepositCode().getFund(), ((FinancialDetail)abstractEstimateAppropriation.getAbstractEstimate().getFinancialDetails().get(0)).getCoa(), accountdetailtype, estimate.getDepositCode().getId(), abstractEstimateAppropriation.getDepositWorksUsage().getAppropriationDate());
                BigDecimal totalUtilizedAmt = this.depositWorksUsageService.getTotalUtilizedAmountForDepositWorks((FinancialDetail)abstractEstimateAppropriation.getAbstractEstimate().getFinancialDetails().get(0), abstractEstimateAppropriation.getDepositWorksUsage().getCreatedDate());
                if (totalUtilizedAmt == null) {
                    totalUtilizedAmt = BigDecimal.ZERO;
                }
                BigDecimal amtAppropriatedsofar = totalUtilizedAmt.subtract(abstractEstimateAppropriation.getDepositWorksUsage().getConsumedAmount());
                BigDecimal balOnHand = totalDepositAmt.subtract(amtAppropriatedsofar);
                BigDecimal amtAppropriated = abstractEstimateAppropriation.getDepositWorksUsage().getConsumedAmount();
                BigDecimal balanceAvailable = BigDecimal.valueOf(totalDepositAmt.doubleValue() - totalUtilizedAmt.doubleValue());
                this.addRow(appropriationDetailTable, true, new Paragraph[]{this.makePara(7.0f, (Object)abstractEstimateAppropriation.getDepositWorksUsage().getAppropriationNumber()), this.rightPara(7.0f, (Object)this.toCurrency(totalDepositAmt.doubleValue())), this.rightPara(7.0f, (Object)this.toCurrency(amtAppropriatedsofar.doubleValue())), this.rightPara(7.0f, (Object)this.toCurrency(amtAppropriated.doubleValue())), this.rightPara(7.0f, (Object)this.toCurrency(balOnHand.doubleValue())), this.rightPara(7.0f, (Object)this.toCurrency(balanceAvailable.doubleValue()))});
            }
            PdfPCell appDetailpdfCell = new PdfPCell(appropriationDetailTable);
            appDetailpdfCell.setBorderWidth(0.0f);
            PdfPCell appDetailRightHeader = new PdfPCell((Phrase)this.makePara((Object)"Financail Year Wise Appropriation Details"));
            appDetailRightHeader.setVerticalAlignment(5);
            depositWorksAppropriationTable.addCell(appDetailRightHeader);
            appropriationDetailTable.setWidthPercentage(100.0f);
            depositWorksAppropriationTable.addCell(appDetailpdfCell);
        }
        return depositWorksAppropriationTable;
    }

    private PdfPTable createBudgetaryAppropriationTable(AbstractEstimate estimate, String appropriationNumber) throws DocumentException {
        int isReject = -1;
        List financialdetails = estimate.getFinancialDetails();
        BigDecimal totGrantafterMultiFactor = BigDecimal.ZERO;
        this.estimateAppropriationService = this.abstractEstimateService.getEstimateAppropriationService();
        this.abstractEstimateAppropriationList = this.estimateAppropriationService.findAllBy("from AbstractEstimateAppropriation aea where aea.abstractEstimate.id=? and aea.budgetUsage.id is not null order by aea.budgetUsage.id,aea.budgetUsage.financialYearId asc", new Object[]{estimate.getId()});
        PdfPTable budgetaryAppropriationTable = new PdfPTable(1);
        budgetaryAppropriationTable.setWidthPercentage(100.0f);
        budgetaryAppropriationTable.setWidths(new float[]{8.0f});
        if (appropriationNumber != null && appropriationNumber.toUpperCase().contains("BC")) {
            isReject = 1;
        }
        if (appropriationNumber != null && estimate.getTotalAmount() != null && isReject == -1) {
            for (FinancialDetail financialDetail : financialdetails) {
                if (financialDetail.getBudgetGroup() == null) continue;
                this.addRow(budgetaryAppropriationTable, true, new Paragraph[]{this.centerPara((Object)"Budget Head"), this.centerPara((Object)financialDetail.getBudgetGroup().getName())});
                this.addRow(budgetaryAppropriationTable, true, new Paragraph[]{this.makePara((Object)"Function Center"), this.centerPara((Object)financialDetail.getFunction().getName())});
                this.addRow(budgetaryAppropriationTable, true, new Paragraph[]{this.makePara((Object)"Amount of the Estimate "), this.rightPara((Object)this.toCurrency(estimate.getTotalAmount()))});
            }
        }
        PdfPTable appropriationDetailTable = new PdfPTable(8);
        int count = 0;
        for (AbstractEstimateAppropriation abstractEstimateAppropriation : this.abstractEstimateAppropriationList) {
            if (abstractEstimateAppropriation.getBudgetUsage().getConsumedAmount() == 0.0) continue;
            Department dept = this.getDeptFromBudgtAppropriationNo(abstractEstimateAppropriation.getBudgetUsage().getAppropriationnumber());
            BigDecimal totalGrant = this.abstractEstimateService.getTotalGrantForYearAsOnDate((FinancialDetail)financialdetails.get(0), Long.valueOf(abstractEstimateAppropriation.getBudgetUsage().getFinancialYearId().longValue()), Integer.valueOf(Integer.parseInt(dept.getId().toString())), (Date)abstractEstimateAppropriation.getBudgetUsage().getUpdatedTime());
            BigDecimal planningBudgetPerc = this.abstractEstimateService.getPlanningBudgetPercentage((FinancialDetail)financialdetails.get(0), Long.valueOf(abstractEstimateAppropriation.getBudgetUsage().getFinancialYearId().longValue()), Integer.valueOf(Integer.parseInt(dept.getId().toString())));
            if (planningBudgetPerc != null && planningBudgetPerc.compareTo(BigDecimal.ZERO) != 0) {
                totGrantafterMultiFactor = totalGrant.multiply(planningBudgetPerc.divide(new BigDecimal(100)));
                this.appValue = planningBudgetPerc.divide(new BigDecimal(100)).toString();
            }
            BigDecimal budgetAvailable = abstractEstimateAppropriation.getBalanceAvailable();
            BigDecimal balOnHand = budgetAvailable.add(new BigDecimal(abstractEstimateAppropriation.getBudgetUsage().getConsumedAmount()));
            BigDecimal amtAppropriated = totGrantafterMultiFactor.subtract(balOnHand);
            if (count == 0) {
                this.addRow(budgetaryAppropriationTable, false, new Paragraph[]{this.makePara((Object)""), this.centerPara((Object)"Financial Year Wise Appropriation Details ")});
                this.addRow(appropriationDetailTable, true, new Paragraph[]{this.makePara(8.0f, (Object)"Department"), this.makePara(8.0f, (Object)"Appropriation Number"), this.makePara(8.0f, (Object)"Total Grant"), this.makePara(8.0f, (Object)(this.appValue + " Times Total Grant")), this.makePara(8.0f, (Object)"Amount Appropriated so far"), this.makePara(8.0f, (Object)"Amount Appropriated"), this.makePara(8.0f, (Object)"Balance on Hand"), this.makePara(8.0f, (Object)"Balance After Appropriation")});
            }
            this.addRow(appropriationDetailTable, true, new Paragraph[]{this.rightPara(8.0f, (Object)dept.getName()), this.makePara(8.0f, (Object)abstractEstimateAppropriation.getBudgetUsage().getAppropriationnumber()), this.rightPara(8.0f, (Object)this.toCurrency(totalGrant.doubleValue())), this.rightPara(8.0f, (Object)this.toCurrency(totGrantafterMultiFactor.doubleValue())), this.rightPara(8.0f, (Object)this.toCurrency(amtAppropriated.doubleValue())), this.rightPara(8.0f, (Object)this.toCurrency(abstractEstimateAppropriation.getBudgetUsage().getConsumedAmount().doubleValue())), this.rightPara(8.0f, (Object)this.toCurrency(balOnHand.doubleValue())), this.rightPara(8.0f, (Object)this.toCurrency(budgetAvailable.doubleValue()))});
            ++count;
        }
        PdfPCell appDetailpdfCell = new PdfPCell(appropriationDetailTable);
        appropriationDetailTable.setWidthPercentage(100.0f);
        budgetaryAppropriationTable.addCell(appDetailpdfCell);
        return budgetaryAppropriationTable;
    }

    private Department getDeptFromBudgtAppropriationNo(String number) {
        if (StringUtils.isBlank((String)number)) {
            logger.error((Object)"Empty Ban Number");
            throw new ApplicationRuntimeException("Exception in getDeptFromBudgtAppropriationNo ");
        }
        String[] strArr = number.split("/");
        if (strArr == null || strArr.length == 0) {
            logger.error((Object)("Department prefix not present in ban no--" + number));
            throw new ApplicationRuntimeException("Exception in getDeptFromBudgtAppropriationNo ");
        }
        String deptCode = strArr[0];
        Department dept = (Department)this.persistenceService.find(" from Department where code=?", new Object[]{deptCode});
        if (dept == null) {
            logger.error((Object)("No department found with prefix--" + deptCode));
            throw new ApplicationRuntimeException("Exception in getDeptFromBudgtAppropriationNo ");
        }
        return dept;
    }

    private PdfPTable createApprovalDetailsTable(AbstractEstimate estimate) throws DocumentException {
        try {
            PdfPTable approvaldetailsTable = null;
            if (this.shouldShowApprovalNumber) {
                approvaldetailsTable = new PdfPTable(6);
                approvaldetailsTable.setWidths(new float[]{2.0f, 1.0f, 1.0f, 1.0f, 1.5f, 2.0f});
            } else {
                approvaldetailsTable = new PdfPTable(5);
                approvaldetailsTable.setWidths(new float[]{2.0f, 1.5f, 1.5f, 1.5f, 2.0f});
            }
            approvaldetailsTable.setWidthPercentage(100.0f);
            this.addRow(approvaldetailsTable, true, new Paragraph[]{this.makePara((Object)"Approval Step"), this.centerPara((Object)"Name"), this.centerPara((Object)"Designation"), this.centerPara((Object)"Approved on"), this.centerPara((Object)"Remarks")});
            if (estimate != null && estimate.getCurrentState() != null) {
                this.history = new LinkedList();
                if (estimate.getCurrentState().getHistory() != null) {
                    this.history.addAll(estimate.getCurrentState().getHistory());
                }
                this.history.add(new StateHistory(estimate.getCurrentState()));
            }
            if (this.history != null) {
                for (StateHistory stateHistory : this.history) {
                    this.displayHistory(stateHistory, approvaldetailsTable);
                }
            }
            return approvaldetailsTable;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Exception occured while getting approval details " + e);
        }
    }

    private PdfPTable createEstimateDetailsTable1(AbstractEstimate estimate) throws DocumentException {
        try {
            PdfPTable estimateDetailsTable1 = new PdfPTable(2);
            estimateDetailsTable1.setWidthPercentage(75.0f);
            estimateDetailsTable1.setWidths(new float[]{0.6f, 1.0f});
            this.addRow(estimateDetailsTable1, true, new Paragraph[]{this.centerPara((Object)"Department"), this.centerPara((Object)estimate.getExecutingDepartment().getName())});
            this.addRow(estimateDetailsTable1, true, new Paragraph[]{this.centerPara((Object)"Name of the Work"), this.centerPara((Object)estimate.getName())});
            this.addRow(estimateDetailsTable1, true, new Paragraph[]{this.centerPara((Object)"Estimate Number"), this.centerPara((Object)estimate.getEstimateNumber())});
            return estimateDetailsTable1;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Exception occured while estimate details method1 " + e);
        }
    }

    private PdfPTable createBudgetDetailsForEstimateTable(AbstractEstimate estimate) throws DocumentException {
        try {
            AbstractEstimateAppropriation latestAbstractEstimateAppropriation;
            PdfPTable estBudgetDetailsTable = new PdfPTable(4);
            estBudgetDetailsTable.setWidthPercentage(75.0f);
            estBudgetDetailsTable.setWidths(new float[]{0.6f, 1.0f, 0.5f, 1.0f});
            BigDecimal amtAppropriated = BigDecimal.ZERO;
            BigDecimal totGrantafterMultiFactor = BigDecimal.ZERO;
            BigDecimal amtAppropriatedsofar = BigDecimal.ZERO;
            this.worksService.getAccountdetailtypeByName("DEPOSITCODE");
            if (this.abstractEstimateAppropriationList != null && !this.abstractEstimateAppropriationList.isEmpty() && (latestAbstractEstimateAppropriation = (AbstractEstimateAppropriation)this.abstractEstimateAppropriationList.get(this.abstractEstimateAppropriationList.size() - 1)) != null) {
                if (estimate.getDepositCode() == null) {
                    if (latestAbstractEstimateAppropriation.getBudgetUsage().getConsumedAmount() != 0.0) {
                        Department dept = this.getDeptFromBudgtAppropriationNo(latestAbstractEstimateAppropriation.getBudgetUsage().getAppropriationnumber());
                        BigDecimal totalGrant = this.abstractEstimateService.getTotalGrantForYearAsOnDate((FinancialDetail)estimate.getFinancialDetails().get(0), Long.valueOf(latestAbstractEstimateAppropriation.getBudgetUsage().getFinancialYearId().longValue()), Integer.valueOf(Integer.parseInt(dept.getId().toString())), (Date)latestAbstractEstimateAppropriation.getBudgetUsage().getUpdatedTime());
                        BigDecimal planningBudgetPerc = this.abstractEstimateService.getPlanningBudgetPercentage((FinancialDetail)estimate.getFinancialDetails().get(0), Long.valueOf(latestAbstractEstimateAppropriation.getBudgetUsage().getFinancialYearId().longValue()), Integer.valueOf(Integer.parseInt(dept.getId().toString())));
                        if (planningBudgetPerc != null && planningBudgetPerc.compareTo(BigDecimal.ZERO) != 0) {
                            totGrantafterMultiFactor = totalGrant.multiply(planningBudgetPerc.divide(new BigDecimal(100)));
                            this.appValue = planningBudgetPerc.divide(new BigDecimal(100)).toString();
                        }
                        BigDecimal budgetAvailable = latestAbstractEstimateAppropriation.getBalanceAvailable();
                        BigDecimal balOnHand = budgetAvailable.add(new BigDecimal(latestAbstractEstimateAppropriation.getBudgetUsage().getConsumedAmount()));
                        amtAppropriated = totGrantafterMultiFactor.subtract(balOnHand);
                    }
                } else if (latestAbstractEstimateAppropriation.getDepositWorksUsage().getConsumedAmount().doubleValue() != 0.0) {
                    BigDecimal totalUtilizedAmt = this.depositWorksUsageService.getTotalUtilizedAmountForDepositWorks((FinancialDetail)latestAbstractEstimateAppropriation.getAbstractEstimate().getFinancialDetails().get(0), latestAbstractEstimateAppropriation.getDepositWorksUsage().getCreatedDate());
                    if (totalUtilizedAmt == null) {
                        totalUtilizedAmt = BigDecimal.ZERO;
                    }
                    amtAppropriatedsofar = totalUtilizedAmt.subtract(latestAbstractEstimateAppropriation.getDepositWorksUsage().getConsumedAmount());
                }
            }
            this.addRow(estBudgetDetailsTable, true, new Paragraph[]{this.centerPara((Object)"Estimate Date"), this.centerPara((Object)DateUtils.getFormattedDate((Date)estimate.getEstimateDate(), (String)"dd/MM/yyyy")), this.centerPara((Object)"Fund"), this.centerPara((Object)(estimate.getFinancialDetails().isEmpty() ? "" : ((FinancialDetail)estimate.getFinancialDetails().get(0)).getFund().getName()))});
            if (estimate.getDepositCode() == null) {
                this.addRow(estBudgetDetailsTable, true, new Paragraph[]{this.centerPara((Object)"Function "), this.centerPara((Object)(estimate.getFinancialDetails().isEmpty() ? "" : ((FinancialDetail)estimate.getFinancialDetails().get(0)).getFunction().getName())), this.centerPara((Object)"Budget Head"), this.centerPara((Object)(estimate.getFinancialDetails().isEmpty() ? "" : ((FinancialDetail)estimate.getFinancialDetails().get(0)).getBudgetGroup().getName()))});
                this.addRow(estBudgetDetailsTable, true, new Paragraph[]{this.centerPara((Object)"Amount Appropriated so far"), this.centerPara((Object)(amtAppropriated == null ? "" : this.toCurrency(amtAppropriated.doubleValue()))), this.centerPara((Object)"Estimate Amount"), this.centerPara((Object)this.toCurrency(estimate.getTotalAmount().getValue()))});
            } else {
                this.addRow(estBudgetDetailsTable, true, new Paragraph[]{this.centerPara((Object)"Function "), this.centerPara((Object)(estimate.getFinancialDetails().isEmpty() ? "" : ((FinancialDetail)estimate.getFinancialDetails().get(0)).getFunction().getName())), this.centerPara((Object)"Deposit COA/Deposit Code"), this.centerPara((Object)(estimate.getFinancialDetails().isEmpty() ? "" : ((FinancialDetail)estimate.getFinancialDetails().get(0)).getCoa().getGlcode().concat("-").concat(((FinancialDetail)estimate.getFinancialDetails().get(0)).getCoa().getName()).concat(" / ").concat(estimate.getDepositCode().getCode())))});
                this.addRow(estBudgetDetailsTable, true, new Paragraph[]{this.centerPara((Object)"Amount Appropriated so far"), this.centerPara((Object)(amtAppropriatedsofar == null ? "" : this.toCurrency(amtAppropriatedsofar.doubleValue()))), this.centerPara((Object)"Estimate Amount"), this.makePara((Object)this.toCurrency(estimate.getTotalAmount().getValue()), 2)});
            }
            return estBudgetDetailsTable;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Exception occured while estimate details method 2 " + e);
        }
    }

    private PdfPTable createBalanceAmtCalculationTable(AbstractEstimate estimate) throws DocumentException {
        try {
            AbstractEstimateAppropriation latestAbstractEstimateAppropriation;
            PdfPTable estimateDetailsTable2 = new PdfPTable(2);
            estimateDetailsTable2.setWidthPercentage(75.0f);
            estimateDetailsTable2.setWidths(new float[]{0.6f, 1.0f});
            BigDecimal budgetAvailable = BigDecimal.ZERO;
            BigDecimal balanceAvailable = BigDecimal.ZERO;
            Accountdetailtype accountdetailtype = this.worksService.getAccountdetailtypeByName("DEPOSITCODE");
            if (this.abstractEstimateAppropriationList != null && !this.abstractEstimateAppropriationList.isEmpty() && (latestAbstractEstimateAppropriation = (AbstractEstimateAppropriation)this.abstractEstimateAppropriationList.get(this.abstractEstimateAppropriationList.size() - 1)) != null) {
                if (estimate.getDepositCode() == null) {
                    if (latestAbstractEstimateAppropriation.getBudgetUsage().getConsumedAmount() != 0.0) {
                        budgetAvailable = latestAbstractEstimateAppropriation.getBalanceAvailable();
                    }
                } else if (latestAbstractEstimateAppropriation.getDepositWorksUsage().getConsumedAmount().doubleValue() != 0.0) {
                    BigDecimal totalDepositAmt = this.depositWorksUsageService.getTotalDepositWorksAmount(estimate.getDepositCode().getFund(), ((FinancialDetail)latestAbstractEstimateAppropriation.getAbstractEstimate().getFinancialDetails().get(0)).getCoa(), accountdetailtype, estimate.getDepositCode().getId(), latestAbstractEstimateAppropriation.getDepositWorksUsage().getAppropriationDate());
                    BigDecimal totalUtilizedAmt = this.depositWorksUsageService.getTotalUtilizedAmountForDepositWorks((FinancialDetail)latestAbstractEstimateAppropriation.getAbstractEstimate().getFinancialDetails().get(0), latestAbstractEstimateAppropriation.getDepositWorksUsage().getCreatedDate());
                    if (totalUtilizedAmt == null) {
                        totalUtilizedAmt = BigDecimal.ZERO;
                    }
                    balanceAvailable = BigDecimal.valueOf(totalDepositAmt.doubleValue() - totalUtilizedAmt.doubleValue());
                }
            }
            if (estimate.getDepositCode() == null) {
                this.addRow(estimateDetailsTable2, true, new Paragraph[]{this.centerPara((Object)"Balance Amount Available"), this.centerPara((Object)(budgetAvailable == null ? "" : this.toCurrency(budgetAvailable.doubleValue())))});
            } else {
                this.addRow(estimateDetailsTable2, true, new Paragraph[]{this.centerPara((Object)"Balance Amount Available"), this.centerPara((Object)(balanceAvailable == null ? "" : this.toCurrency(balanceAvailable.doubleValue())))});
            }
            this.addRow(estimateDetailsTable2, true, new Paragraph[]{this.centerPara((Object)"Reference"), this.centerPara((Object)space1)});
            this.addRow(estimateDetailsTable2, true, new Paragraph[]{this.centerPara((Object)"Any Other Remarks"), this.centerPara((Object)"\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t\t  \t  \t  \t \t \t  \t  \t  \t \t \t \t\n\n")});
            return estimateDetailsTable2;
        }
        catch (Exception e) {
            throw new ApplicationRuntimeException("Exception occured while estimate and budget details method 3" + e);
        }
    }

    public void displayHistory(StateHistory<Position> stateHistory, PdfPTable approvaldetailsTable) {
        if (!stateHistory.getValue().equals("NEW") && !stateHistory.getValue().equals("END")) {
            String nextAction = "";
            if (stateHistory.getNextAction() != null && !stateHistory.getNextAction().equals("END")) {
                nextAction = stateHistory.getNextAction();
            }
            String state = stateHistory.getValue();
            if (!nextAction.equalsIgnoreCase("")) {
                state = stateHistory.getValue() + " - " + nextAction;
            }
            Long positionId = ((Position)stateHistory.getOwnerPosition()).getId();
            DeptDesig deptdesig = ((Position)stateHistory.getOwnerPosition()).getDeptDesig();
            String desgName = deptdesig.getDesignation().getName();
            Employee employee = this.assignmentService.getPrimaryAssignmentForPositionAndDate(positionId, stateHistory.getCreatedDate()).getEmployee();
            this.addRow(approvaldetailsTable, true, new Paragraph[]{this.makePara((Object)state), this.makePara((Object)employee.getName()), this.makePara((Object)desgName), this.makePara((Object)DateUtils.getFormattedDate((Date)stateHistory.getCreatedDate(), (String)"dd/MM/yyyy")), this.rightPara((Object)stateHistory.getComments())});
        }
    }

    private PdfPTable createActivitiesTable(AbstractEstimate estimate) throws DocumentException {
        PdfPTable activitiesTable = new PdfPTable(7);
        activitiesTable.setWidthPercentage(100.0f);
        activitiesTable.setWidths(new float[]{0.5f, 1.0f, 3.1f, 1.2f, 0.8f, 1.1f, 1.5f});
        this.addRow(activitiesTable, true, new Paragraph[]{this.makePara((Object)"Sl No"), this.centerPara((Object)"Quantity"), this.centerPara((Object)"Description"), this.centerPara((Object)"Sch. No"), this.centerPara((Object)"Unit"), this.centerPara((Object)"Rate"), this.centerPara((Object)"Amount")});
        Collection activities = estimate.getSORActivities();
        int index = 1;
        for (Activity activity : activities) {
            String estimateUom = "";
            estimateUom = activity.getUom() == null ? activity.getSchedule().getUom().getUom() : activity.getUom().getUom();
            this.addRow(activitiesTable, true, new Paragraph[]{this.makePara((Object)index++), this.rightPara((Object)activity.getQuantity()), this.makePara((Object)activity.getSchedule().getDescription()), this.centerPara((Object)activity.getSchedule().getCode()), this.centerPara((Object)estimateUom), this.rightPara((Object)this.toCurrency(activity.getSORCurrentRate())), this.rightPara((Object)this.toCurrency(activity.getAmount()))});
        }
        activities = estimate.getNonSORActivities();
        for (Activity activity : activities) {
            this.addRow(activitiesTable, true, new Paragraph[]{this.makePara((Object)index++), this.rightPara((Object)activity.getQuantity()), this.makePara((Object)activity.getNonSor().getDescription()), this.centerPara((Object)""), this.centerPara((Object)activity.getNonSor().getUom().getUom()), this.rightPara((Object)this.toCurrency(activity.getRate())), this.rightPara((Object)this.toCurrency(activity.getAmount()))});
        }
        this.addRow(activitiesTable, true, new Paragraph[]{this.centerPara((Object)""), this.centerPara((Object)""), this.makePara((Object)""), this.rightPara((Object)""), this.centerPara((Object)""), this.centerPara((Object)"TOTAL"), this.rightPara((Object)this.toCurrency(estimate.getWorkValue()))});
        this.addRow(activitiesTable, true, new Paragraph[]{this.centerPara((Object)""), this.centerPara((Object)""), this.makePara((Object)""), this.rightPara((Object)""), this.centerPara((Object)""), this.centerPara((Object)"WORK VALUE"), this.rightPara((Object)this.toCurrency(estimate.getWorkValueIncludingTaxes()))});
        return activitiesTable;
    }

    private String getOverheadDescription(OverheadValue oh) {
        if (((OverheadRate)oh.getOverhead().getOverheadRates().get(0)).getPercentage() > 0.0) {
            return oh.getOverhead().getDescription() + '-' + ((OverheadRate)oh.getOverhead().getOverheadRates().get(0)).getPercentage() + '%';
        }
        return oh.getOverhead().getDescription();
    }

    private void addZoneYearHeader(AbstractEstimate estimate, CFinancialYear financialYear) throws DocumentException {
        this.document.add((Element)this.spacer());
        PdfPTable headerTable = new PdfPTable(2);
        headerTable.setWidthPercentage(100.0f);
        headerTable.setWidths(new float[]{1.0f, 1.0f});
        Paragraph financialYearPara = new Paragraph();
        if (financialYear != null) {
            financialYearPara = this.makePara((Object)("Budget Year: " + financialYear.getFinYearRange()), 2);
        }
        this.addRow(headerTable, false, new Paragraph[]{this.makePara((Object)("Estimate Number: " + estimate.getEstimateNumber()), 0), financialYearPara});
        this.document.add((Element)headerTable);
        if (estimate.getWard() != null && "Ward".equalsIgnoreCase(estimate.getWard().getBoundaryType().getName()) && estimate.getWard().getParent() != null && estimate.getWard().getParent().getName() != null) {
            this.document.add((Element)this.makePara((Object)("Ward: " + estimate.getWard().getName() + " / Zone: " + estimate.getWard().getParent().getName()), 2));
        } else if (estimate.getWard() != null && "Zone".equalsIgnoreCase(estimate.getWard().getBoundaryType().getName()) && estimate.getWard().getParent() != null && estimate.getWard().getParent().getName() != null) {
            this.document.add((Element)this.makePara((Object)("Zone: " + estimate.getWard().getName() + " / Region: " + estimate.getWard().getParent().getName()), 2));
        } else if (estimate.getWard() != null) {
            this.document.add((Element)this.makePara((Object)("Jurisdiction: " + estimate.getWard().getName() + "(" + estimate.getWard().getBoundaryType().getName() + ")"), 2));
        }
        this.document.add((Element)this.spacer());
    }

    private void addZoneYearHeaderWithOutEstimateNo(AbstractEstimate estimate, CFinancialYear financialYear) throws DocumentException {
        PdfPTable headerTable = new PdfPTable(2);
        headerTable.setWidthPercentage(100.0f);
        headerTable.setWidths(new float[]{1.0f, 1.0f});
        Paragraph financialYearPara = new Paragraph();
        if (financialYear != null) {
            financialYearPara = this.makePara((Object)("Budget Year: " + financialYear.getFinYearRange()), 2);
        }
        this.addRow(headerTable, false, new Paragraph[]{new Paragraph(), financialYearPara});
        this.document.add((Element)headerTable);
        if (estimate.getWard() != null && "Ward".equalsIgnoreCase(estimate.getWard().getBoundaryType().getName()) && estimate.getWard().getParent() != null && estimate.getWard().getParent().getName() != null) {
            this.document.add((Element)this.makePara((Object)("Ward: " + estimate.getWard().getName() + " / Zone: " + estimate.getWard().getParent().getName()), 2));
        } else if (estimate.getWard() != null && "Zone".equalsIgnoreCase(estimate.getWard().getBoundaryType().getName()) && estimate.getWard().getParent() != null && estimate.getWard().getParent().getName() != null) {
            this.document.add((Element)this.makePara((Object)("Zone: " + estimate.getWard().getName() + " / Region: " + estimate.getWard().getParent().getName()), 2));
        } else if (estimate.getWard() != null) {
            this.document.add((Element)this.makePara((Object)("Jurisdiction: " + estimate.getWard().getName() + "(" + estimate.getWard().getBoundaryType().getName() + ")"), 2));
        }
        this.document.add((Element)this.spacer());
    }

    public PersistenceService getPersistenceService() {
        return this.persistenceService;
    }

    public void setPersistenceService(PersistenceService persistenceService) {
        this.persistenceService = persistenceService;
    }

    public String getHeaderText() {
        return this.headerText;
    }

    public void setHeaderText(String headerText) {
        this.headerText = headerText;
    }

    public BudgetDetailsDAO getBudgetDetailsDAO() {
        return this.budgetDetailsDAO;
    }

    public void setBudgetDetailsDAO(BudgetDetailsDAO budgetDetailsDAO) {
        this.budgetDetailsDAO = budgetDetailsDAO;
    }

    public void setAbstractEstimateService(AbstractEstimateService abstractEstimateService) {
        this.abstractEstimateService = abstractEstimateService;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public List<String> getAppConfigValuesToSkipBudget() {
        return this.worksService.getNatureOfWorkAppConfigValues(MODULE_NAME, KEY_NAME);
    }

    public Boolean isSkipBudgetCheck() {
        List depositTypeList = this.getAppConfigValuesToSkipBudget();
        if (this.estimate != null && this.estimate.getId() != null) {
            for (String type : depositTypeList) {
                if (!type.equals(this.estimate.getNatureOfWork().getName())) continue;
                this.skipBudget = true;
            }
        }
        return this.skipBudget;
    }

    public List<BudgetUsage> getBudgetDetailUsage(String estimateNumber) {
        return this.persistenceService.findAllBy("from BudgetUsage bu where bu.referenceNumber=?", new Object[]{estimateNumber});
    }

    public List<AbstractEstimateAppropriation> getAbstractEstimateAppropriationList() {
        return this.abstractEstimateAppropriationList;
    }

    public void setAbstractEstimateAppropriationList(List<AbstractEstimateAppropriation> abstractEstimateAppropriationList) {
        this.abstractEstimateAppropriationList = abstractEstimateAppropriationList;
    }

    public void setAssignmentService(AssignmentService assignmentService) {
        this.assignmentService = assignmentService;
    }
}

