/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.contractorBill;

import java.io.IOException;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.ServletActionContext;
import org.egov.commons.Accountdetailtype;
import org.egov.commons.CChartOfAccounts;
import org.egov.commons.CFinancialYear;
import org.egov.commons.EgPartytype;
import org.egov.commons.EgwTypeOfWork;
import org.egov.commons.dao.ChartOfAccountsHibernateDAO;
import org.egov.commons.dao.EgPartytypeHibernateDAO;
import org.egov.commons.dao.EgwTypeOfWorkHibernateDAO;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.egf.commons.EgovCommon;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.infra.exception.ApplicationException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.BaseFormAction;
import org.egov.model.bills.EgBillregister;
import org.egov.model.budget.BudgetGroup;
import org.egov.pims.commons.Position;
import org.egov.pims.model.PersonalInformation;
import org.egov.pims.service.EmployeeServiceOld;
import org.egov.services.budget.BudgetService;
import org.egov.services.recoveries.RecoveryService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.AbstractEstimateAppropriation;
import org.egov.works.abstractestimate.entity.FinancialDetail;
import org.egov.works.contractorbill.entity.ContractorBillRegister;
import org.egov.works.models.contractorBill.WorkCompletionDetailInfo;
import org.egov.works.models.contractorBill.WorkCompletionInfo;
import org.egov.works.models.contractoradvance.ContractorAdvanceRequisition;
import org.egov.works.models.measurementbook.MBHeader;
import org.egov.works.models.workorder.AssetsForWorkOrder;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.models.workorder.WorkOrderEstimate;
import org.egov.works.services.ContractorBillService;
import org.egov.works.services.WorksService;
import org.egov.works.services.contractoradvance.ContractorAdvanceService;
import org.egov.works.services.impl.MeasurementBookServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;

public class AjaxContractorBillAction
extends BaseFormAction {
    private static final long serialVersionUID = -3316045051992569984L;
    private static final Logger logger = Logger.getLogger(AjaxContractorBillAction.class);
    private static final String ADVANCE_AJUSTMENT = "advanceAdjustment";
    private static final String CHECK_LIST = "checklist";
    private static final String STANDARD_DEDUCTION_ACCOUNTS = "standardDeductionAccounts";
    private static final String TOTAL_WORK_VALUE = "totalWorkValue";
    private static final String CUMULATIVE_BILL_VALUE = "cumulativeBillValue";
    private static final String LATEST_APPROVED_BILL_DATE = "latestBillDate";
    private static final String COMPLETION_DETAILS = "completionDetails";
    private static final String APPCONFIG_KEY_NAME = "SKIP_BUDGET_CHECK";
    private WorkCompletionInfo workcompletionInfo;
    private List<WorkCompletionDetailInfo> workCompletionDetailInfo = new LinkedList();
    private ContractorBillService contractorBillService;
    private EgBillregister egBillregister;
    private WorkOrder workOrder;
    private Long id;
    private Long workOrderId;
    private Date billDate;
    private String workOrderNumber;
    private String billType;
    private String deductionType;
    private String rowId;
    private Long workOrderEstimateId;
    private List<CChartOfAccounts> standardDeductionAccountList = new LinkedList();
    private boolean noMBsPresent;
    private String latestBillDateStr;
    private Long billId;
    @Autowired
    private FinancialYearHibernateDAO finHibernateDao;
    private Date latestMBDate;
    private Long estId;
    private Long woId;
    private String refNo;
    private List<AppConfigValues> finalBillChecklist = new LinkedList();
    private List<String> checklistValues = new LinkedList();
    private String[] selectedchecklistvalues;
    private List<MBHeader> approvedMBHeaderList = new LinkedList();
    private BigDecimal totalWorkValueRecorded = BigDecimal.ZERO;
    private BigDecimal totalTenderedItemsAmt = BigDecimal.ZERO;
    private BigDecimal totalUtilizedAmount = BigDecimal.ZERO;
    private BigDecimal budgetSanctionAmount = BigDecimal.ZERO;
    private WorksService worksService;
    private MeasurementBookServiceImpl measurementBookService;
    @Autowired
    private EgPartytypeHibernateDAO egPartytypeHibernateDAO;
    @Autowired
    private EgwTypeOfWorkHibernateDAO egwTypeOfWorkHibernateDAO;
    private BigDecimal totalPendingBalance = new BigDecimal("0.00");
    private BigDecimal totalAdvancePaid = new BigDecimal("0.00");
    private String source;
    @Autowired
    private ChartOfAccountsHibernateDAO chartOfAccountsHibernateDAO;
    private List<CChartOfAccounts> coaList = new LinkedList();
    private List<AssetsForWorkOrder> assetList = new LinkedList();
    private static final String SKIP_BUDGCHECK_APPCONF_KEYNAME = "SKIP_BUDGET_CHECK";
    private Long glCode;
    private BigDecimal budgBalance;
    private BigDecimal budgAmount;
    private FinancialDetail financialDetail = new FinancialDetail();
    private BigDecimal totalGrantAmount = BigDecimal.ZERO;
    private BudgetDetailsDAO budgetDetailsDAO;
    private static final String BUDGET_DETAILS = "budgetDetails";
    private BigDecimal actualAmount = BigDecimal.ZERO;
    private boolean checkBudget;
    private Long estimateId;
    private Long glCodeId;
    private String errorMsg;
    private EgovCommon egovCommon;
    private static final String WORKS = "Works";
    private static final String TRACK_MLS_CHECK = "trackMlsCheckForBillCreation";
    private static final String STATUTORY_DEDUCTION_AMOUNT = "statutoryDeductionAmount";
    private static final String PARTY_TYPE_CONTRACTOR = "Contractor";
    @Autowired
    @Qualifier(value="recoveryPersistenceService")
    private RecoveryService recoveryService;
    private String subPartyType;
    private String typeOfWork;
    private BigDecimal grossAmount;
    private BigDecimal statutoryAmount = BigDecimal.ZERO;
    private String recoveryType;
    private BigDecimal cumulativeBillValue;
    private BudgetService budgetService;
    private Long contractorBillId;
    private String estimateNumber;
    private String query = "";
    private List<WorkOrder> workOrderList = new LinkedList();
    private List<ContractorBillRegister> contractorBillList = new LinkedList();
    private String trackMlsCheck;
    private List<AbstractEstimate> estimateList = new LinkedList();
    private String yearEndApprCheck;
    private String estimateNo;
    private static final String VALID = "valid";
    private static final String INVALID = "invalid";
    private ContractorAdvanceService contractorAdvanceService;
    private String advanceRequisitionNo;
    private String owner = "";
    private String arfInWorkFlowCheck;
    @Autowired
    private EmployeeServiceOld employeeService;
    private static final String ARF_IN_WORKFLOW_CHECK = "arfInWorkflowCheck";
    private String showValidationMsg = "";

    public void setStandardDeductionAccountList(List<CChartOfAccounts> standardDeductionAccountList) {
        this.standardDeductionAccountList = standardDeductionAccountList;
    }

    public void setBudgetService(BudgetService budgetService) {
        this.budgetService = budgetService;
    }

    public Object getModel() {
        return null;
    }

    public String totalWorkValue() {
        this.totalWorkValueRecorded = this.contractorBillService.getApprovedMBAmount(this.workOrderId, this.workOrderEstimateId, this.billDate);
        this.approvedMBHeaderList.addAll(this.measurementBookService.getApprovedMBList(this.workOrderId, this.workOrderEstimateId, this.billDate));
        this.totalTenderedItemsAmt = this.contractorBillService.getApprovedMBAmountOfTenderedItems(this.workOrderId, this.workOrderEstimateId, this.billDate);
        this.isSkipBudgetCheck(this.workOrderEstimateId);
        if (this.approvedMBHeaderList.isEmpty()) {
            this.noMBsPresent = true;
        }
        return TOTAL_WORK_VALUE;
    }

    public String getLastBillDate() {
        List billList;
        this.latestBillDateStr = "";
        WorkOrderEstimate workOrderEstimate = (WorkOrderEstimate)this.persistenceService.find("from WorkOrderEstimate where id=?", new Object[]{this.workOrderEstimateId});
        if (workOrderEstimate != null && (billList = this.contractorBillService.getListOfNonCancelledBillsforEstimate(workOrderEstimate.getEstimate(), new Date())) != null && !billList.isEmpty()) {
            Date latestBillDt = ((EgBillregister)billList.get(0)).getBilldate();
            for (EgBillregister bill : billList) {
                if (latestBillDt.compareTo(bill.getBilldate()) >= 0) continue;
                latestBillDt = bill.getBilldate();
            }
            this.latestBillDateStr = new SimpleDateFormat("dd/MM/yyyy").format(latestBillDt);
        }
        return LATEST_APPROVED_BILL_DATE;
    }

    public String totalCumulativeBillValue() {
        WorkOrderEstimate workOrderEstimate = (WorkOrderEstimate)this.persistenceService.find("from WorkOrderEstimate where id=?", new Object[]{this.workOrderEstimateId});
        this.cumulativeBillValue = this.contractorBillService.getTotalValueWoForUptoBillDate(this.billDate, workOrderEstimate.getWorkOrder().getId(), workOrderEstimate.getId());
        return CUMULATIVE_BILL_VALUE;
    }

    public String yearEndApprCheckForBillCreation() {
        CFinancialYear billDateFinYear;
        AbstractEstimate estimate = (AbstractEstimate)this.persistenceService.find("select woe.estimate from WorkOrderEstimate woe where woe.id = ? ", new Object[]{this.workOrderEstimateId});
        this.yearEndApprCheck = VALID;
        this.estimateNo = estimate.getEstimateNumber();
        Long billDateFinYearId = 0L;
        try {
            billDateFinYear = this.finHibernateDao.getFinancialYearByDate(this.billDate);
        }
        catch (Exception e) {
            throw new ValidationException(Arrays.asList(new ValidationError("yrEnd.appr.verification.for.bill.financialyear.invalid", "yrEnd.appr.verification.for.bill.financialyear.invalid")));
        }
        if (billDateFinYear != null) {
            billDateFinYearId = billDateFinYear.getId();
        }
        if (estimate.getDepositCode() == null) {
            AbstractEstimateAppropriation aeaObj = (AbstractEstimateAppropriation)this.persistenceService.findByNamedQuery("getLatestBudgetUsageForEstimate", new Object[]{estimate.getId()});
            if (aeaObj != null && aeaObj.getBudgetUsage().getConsumedAmount() > 0.0) {
                if (aeaObj.getBudgetUsage().getFinancialYearId().intValue() != billDateFinYearId.intValue()) {
                    this.yearEndApprCheck = INVALID;
                }
            } else {
                this.yearEndApprCheck = INVALID;
            }
        }
        return "yearEndApprForBillCreationCheck";
    }

    public String advanceRequisitionInWorkflowCheck() {
        ContractorAdvanceRequisition arf;
        this.arfInWorkFlowCheck = VALID;
        if (this.workOrderEstimateId != null && (arf = this.contractorAdvanceService.getContractorARFInWorkflowByWOEId(this.workOrderEstimateId)) != null) {
            this.arfInWorkFlowCheck = INVALID;
            this.advanceRequisitionNo = arf.getAdvanceRequisitionNumber();
            this.estimateNo = arf.getWorkOrderEstimate().getEstimate().getEstimateNumber();
            PersonalInformation emp = this.employeeService.getEmployeeforPosition((Position)arf.getCurrentState().getOwnerPosition());
            if (emp != null) {
                this.owner = emp.getUserMaster().getName();
            }
        }
        return ARF_IN_WORKFLOW_CHECK;
    }

    private void isSkipBudgetCheck(Long workOrderEstimateId) {
        List appConfigValuesList = this.worksService.getAppConfigValue(WORKS, "SKIP_BUDGET_CHECK");
        WorkOrderEstimate workOrderEstimate = (WorkOrderEstimate)this.persistenceService.find("from WorkOrderEstimate where id=?", new Object[]{workOrderEstimateId});
        logger.info((Object)("length of appconfig values>>>>>> " + appConfigValuesList.size()));
        for (AppConfigValues appValues : appConfigValuesList) {
            if (!appValues.getValue().equals(workOrderEstimate.getEstimate().getNatureOfWork().getName())) continue;
            this.checkBudget = false;
            return;
        }
        this.checkBudget = true;
    }

    public String completionInfo() {
        WorkOrderEstimate workOrderEstimate = (WorkOrderEstimate)this.persistenceService.find("from WorkOrderEstimate where id=?", new Object[]{this.workOrderEstimateId});
        this.workcompletionInfo = this.contractorBillService.setWorkCompletionInfoFromBill(null, workOrderEstimate);
        this.workCompletionDetailInfo.addAll(this.contractorBillService.setWorkCompletionDetailInfoList(workOrderEstimate));
        return COMPLETION_DETAILS;
    }

    public String calculateAdvanceAdjustment() {
        WorkOrderEstimate workOrderEstimate = (WorkOrderEstimate)this.persistenceService.find("from WorkOrderEstimate where id=?", new Object[]{this.workOrderEstimateId});
        this.totalAdvancePaid = this.contractorAdvanceService.getTotalAdvancePaymentMadeByWOEstimateId(workOrderEstimate.getId(), this.billDate);
        this.totalPendingBalance = this.contractorBillService.calculateTotalPendingAdvance(this.totalAdvancePaid, this.billDate, workOrderEstimate, this.billId);
        return ADVANCE_AJUSTMENT;
    }

    public String billCheckListDetails() throws NumberFormatException, ApplicationException {
        WorkOrderEstimate workOrderEstimate = (WorkOrderEstimate)this.persistenceService.find("from WorkOrderEstimate where id=?", new Object[]{this.workOrderEstimateId});
        this.checklistValues.add("N/A");
        this.checklistValues.add("Yes");
        this.checklistValues.add("No");
        try {
            if ((workOrderEstimate.getEstimate().getNatureOfWork().getCode().equals("Improvement Works") || workOrderEstimate.getEstimate().getNatureOfWork().getCode().equals("Capital Works")) && this.billType.contains("Final")) {
                this.finalBillChecklist = this.worksService.getAppConfigValue(WORKS, "CONTRACTOR_Bill_FinalChecklist");
            } else if ((workOrderEstimate.getEstimate().getNatureOfWork().getCode().equals("Improvement Works") || workOrderEstimate.getEstimate().getNatureOfWork().getCode().equals("Capital Works")) && this.billType.contains("Part")) {
                this.finalBillChecklist = this.worksService.getAppConfigValue(WORKS, "CONTRACTOR_Bill_RunChecklist");
            } else if (workOrderEstimate.getEstimate().getNatureOfWork().getCode().equals("Repairs and maintenance") && (this.billType.contains("Final") || this.billType.contains("Part"))) {
                this.finalBillChecklist = this.worksService.getAppConfigValue(WORKS, "CONTRACTOR_Bill_MaintananceChecklist");
            }
        }
        catch (Exception e) {
            logger.error((Object)"--------------Error in check bill List-------------");
        }
        return CHECK_LIST;
    }

    public String trackMilestoneCheckForFinalBill() {
        List tm = this.persistenceService.findAllBy(" select trmls from WorkOrderEstimate as woe left join woe.milestone mls left join mls.trackMilestone trmls where trmls.egwStatus.code='APPROVED' and woe.id = ? and trmls.total=100 ", new Object[]{this.workOrderEstimateId});
        this.trackMlsCheck = INVALID;
        if (tm != null && !tm.isEmpty() && tm.get(0) != null) {
            this.trackMlsCheck = VALID;
        }
        return TRACK_MLS_CHECK;
    }

    public String trackMilestoneCheckForPartBill() {
        List tm = this.persistenceService.findAllBy(" select trmls from WorkOrderEstimate as woe left join woe.milestone mls left join mls.trackMilestone trmls where trmls.egwStatus.code='APPROVED' and woe.id = ? and trmls.total>0 ", new Object[]{this.workOrderEstimateId});
        this.trackMlsCheck = INVALID;
        if (tm != null && !tm.isEmpty() && tm.get(0) != null) {
            this.trackMlsCheck = VALID;
        }
        return TRACK_MLS_CHECK;
    }

    public String populateAccountHeadsForDeductionType() {
        this.getStandardDeductionTypes();
        return STANDARD_DEDUCTION_ACCOUNTS;
    }

    public void setDespositWorksAccBal() throws Exception {
        CChartOfAccounts coaObj = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts where id=?", new Object[]{this.getGlCodeId()});
        AbstractEstimate estimate = (AbstractEstimate)this.persistenceService.find("from AbstractEstimate where id=?", new Object[]{this.getEstimateId()});
        Accountdetailtype adt = this.chartOfAccountsHibernateDAO.getAccountDetailTypeIdByName(coaObj.getGlcode(), "DEPOSITCODE");
        String fundCode = null;
        if (estimate != null && estimate.getFinancialDetails().get(0) != null) {
            this.financialDetail = (FinancialDetail)estimate.getFinancialDetails().get(0);
            fundCode = this.financialDetail.getFund().getCode();
        }
        if (adt == null) {
            throw new ValidationException("", "The AccountDetailType is not  defined for Desposit Works ", new String[0]);
        }
        if (estimate.getDepositCode() == null) {
            throw new ValidationException("", "The Deposit code is not  defined for Estimate ", new String[0]);
        }
        BigDecimal accBalAmount = this.egovCommon.getAccountBalanceTillDate(this.getBillDate(), coaObj.getGlcode(), fundCode, adt.getId(), Integer.valueOf(estimate.getDepositCode().getId().intValue()), null);
        BigDecimal billAccBalAmount = this.egovCommon.getBillAccountBalanceforDate(this.getBillDate(), coaObj.getGlcode(), fundCode, adt.getId(), Integer.valueOf(estimate.getDepositCode().getId().intValue()));
        this.budgBalance = accBalAmount.add(billAccBalAmount);
        this.budgAmount = this.egovCommon.getDepositAmountForDepositCode(this.getBillDate(), coaObj.getGlcode(), fundCode, adt.getId(), Integer.valueOf(estimate.getDepositCode().getId().intValue()));
    }

    public String populateStandardDeductionType() {
        List coaStandardDedList = this.getStandardDeductionTypes();
        this.getServletResponse().setContentType("text/xml");
        this.getServletResponse().setHeader("Cache-Control", "no-cache");
        String coaString = null;
        for (CChartOfAccounts coa : coaStandardDedList) {
            if (coaString == null) {
                coaString = coa.getId() + "/" + coa.getGlcode() + "-" + coa.getName();
                continue;
            }
            coaString = coaString + "$" + coa.getId() + "/" + coa.getGlcode() + "-" + coa.getName();
        }
        try {
            this.getServletResponse().getWriter().write(coaString);
        }
        catch (IOException ioex) {
            logger.error((Object)"Error while writing to response --from getByResponseAware()");
        }
        return null;
    }

    public HttpServletResponse getServletResponse() {
        return ServletActionContext.getResponse();
    }

    public List<CChartOfAccounts> getStandardDeductionTypes() {
        List pList = null;
        try {
            Map typeAndCodesMap = this.contractorBillService.getStandardDeductionsFromConfig();
            String[] codes = (String[])typeAndCodesMap.get(this.deductionType);
            if (codes != null && codes.length != 0) {
                for (String code : codes) {
                    pList = this.chartOfAccountsHibernateDAO.getListOfDetailCode(code);
                    if (pList == null) continue;
                    this.standardDeductionAccountList.addAll(pList);
                }
            }
        }
        catch (Exception e) {
            logger.error((Object)"--------------Error in fetching other deduction - AccountHeadsForStandardDeductionType-------------");
        }
        return this.standardDeductionAccountList;
    }

    public String getDebitAccountCodes() {
        WorkOrderEstimate workOrderEstimate = (WorkOrderEstimate)this.persistenceService.find("from WorkOrderEstimate where id=?", new Object[]{this.workOrderEstimateId});
        if (workOrderEstimate != null && workOrderEstimate.getId() != null) {
            this.isSkipBudgetCheck(workOrderEstimate.getId());
            this.addDropdownData("assestList", workOrderEstimate.getAssetValues());
            this.assetList = workOrderEstimate.getAssetValues();
            String accountCodeFromBudgetHead = this.worksService.getWorksConfigValue("BILL_DEFAULT_BUDGETHEAD_ACCOUNTCODE");
            this.showValidationMsg = "no";
            if (workOrderEstimate.getEstimate().getNatureOfWork().getCode().equals("Capital Works") || workOrderEstimate.getEstimate().getNatureOfWork().getCode().equals("Improvement Works")) {
                if (StringUtils.isNotBlank((String)accountCodeFromBudgetHead) && "no".equals(accountCodeFromBudgetHead) && StringUtils.isNotBlank((String)this.worksService.getWorksConfigValue("WORKS_CWIP_CODE"))) {
                    this.coaList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(this.worksService.getWorksConfigValue("WORKS_CWIP_CODE")));
                    this.addDropdownData("coaList", this.coaList);
                } else if (StringUtils.isNotBlank((String)accountCodeFromBudgetHead) && "yes".equals(accountCodeFromBudgetHead)) {
                    ArrayList<BudgetGroup> budgetGroupList = new ArrayList<BudgetGroup>();
                    if (((FinancialDetail)workOrderEstimate.getEstimate().getFinancialDetails().get(0)).getBudgetGroup() != null) {
                        budgetGroupList.add(((FinancialDetail)workOrderEstimate.getEstimate().getFinancialDetails().get(0)).getBudgetGroup());
                    }
                    this.coaList = this.budgetService.getAccountCodeForBudgetHead(budgetGroupList);
                    this.addDropdownData("coaList", this.coaList);
                } else {
                    this.coaList = Collections.EMPTY_LIST;
                }
            } else if (workOrderEstimate.getEstimate().getNatureOfWork().getCode().equals("Repairs and maintenance")) {
                if (StringUtils.isNotBlank((String)accountCodeFromBudgetHead) && "no".equals(accountCodeFromBudgetHead) && StringUtils.isNotBlank((String)this.worksService.getWorksConfigValue("WORKS_REPAIRS_AND_MAINTENANCE"))) {
                    this.coaList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(this.worksService.getWorksConfigValue("WORKS_REPAIRS_AND_MAINTENANCE")));
                    this.addDropdownData("coaList", this.coaList);
                } else if (StringUtils.isNotBlank((String)accountCodeFromBudgetHead) && "yes".equals(accountCodeFromBudgetHead)) {
                    ArrayList<BudgetGroup> budgetGroupList = new ArrayList<BudgetGroup>();
                    if (((FinancialDetail)workOrderEstimate.getEstimate().getFinancialDetails().get(0)).getBudgetGroup() != null) {
                        budgetGroupList.add(((FinancialDetail)workOrderEstimate.getEstimate().getFinancialDetails().get(0)).getBudgetGroup());
                    }
                    this.coaList = this.budgetService.getAccountCodeForBudgetHead(budgetGroupList);
                    this.addDropdownData("coaList", this.coaList);
                } else {
                    this.coaList = Collections.EMPTY_LIST;
                }
            } else if (this.getAppConfigValuesToSkipBudget().contains(workOrderEstimate.getEstimate().getNatureOfWork().getName())) {
                if (StringUtils.isNotBlank((String)this.worksService.getWorksConfigValue("WORKS_DEPOSIT_OTHER_WORKS")) && this.checkBudget) {
                    this.coaList = this.chartOfAccountsHibernateDAO.getAccountCodeByPurpose(Integer.valueOf(this.worksService.getWorksConfigValue("WORKS_CWIP_CODE")));
                    this.addDropdownData("coaList", this.coaList);
                } else if (StringUtils.isNotBlank((String)this.worksService.getWorksConfigValue("WORKS_DEPOSIT_OTHER_WORKS")) && !this.checkBudget && ((FinancialDetail)workOrderEstimate.getEstimate().getFinancialDetails().get(0)).getCoa() != null) {
                    this.coaList = this.contractorBillService.getBudgetHeadForDepositCOA(workOrderEstimate.getEstimate());
                    if (!this.coaList.isEmpty()) {
                        this.addDropdownData("coaList", this.coaList);
                    } else {
                        this.coaList = Collections.EMPTY_LIST;
                    }
                    if (this.coaList.isEmpty()) {
                        this.showValidationMsg = "yes";
                        return "coaList";
                    }
                } else {
                    this.coaList = Collections.EMPTY_LIST;
                }
            }
        }
        return "coaList";
    }

    public String getBudgetDetails() throws Exception {
        WorkOrderEstimate workOrderEstimate = (WorkOrderEstimate)this.persistenceService.find("from WorkOrderEstimate woe where woe.estimate.id=?", new Object[]{this.getEstimateId()});
        this.isSkipBudgetCheck(workOrderEstimate.getId());
        this.setBudgetAmtAndBalForCapitalWorks(workOrderEstimate);
        return BUDGET_DETAILS;
    }

    private void setBudgetAmtAndBalForCapitalWorks(WorkOrderEstimate workOrderEstimate) {
        block22: {
            HashMap<String, Object> queryParamMap = new HashMap<String, Object>();
            try {
                if (workOrderEstimate.getEstimate() != null && workOrderEstimate.getEstimate().getFinancialDetails().get(0) != null) {
                    this.financialDetail = (FinancialDetail)workOrderEstimate.getEstimate().getFinancialDetails().get(0);
                }
                if (this.financialDetail != null && this.financialDetail.getFund() != null && this.financialDetail.getFund().getId() != null && this.financialDetail.getFund().getId() != -1) {
                    queryParamMap.put("fundid", this.financialDetail.getFund().getId());
                }
                if (this.financialDetail != null && this.financialDetail.getScheme() != null && this.financialDetail.getScheme().getId() != null && this.financialDetail.getScheme().getId() != -1) {
                    queryParamMap.put("schemeid", this.financialDetail.getScheme().getId());
                }
                if (this.financialDetail != null && this.financialDetail.getSubScheme() != null && this.financialDetail.getSubScheme().getId() != null && this.financialDetail.getSubScheme().getId() != -1) {
                    queryParamMap.put("subschemeid", this.financialDetail.getSubScheme().getId());
                }
                if (this.financialDetail != null && this.financialDetail.getFunctionary() != null && this.financialDetail.getFunctionary().getId() != null && this.financialDetail.getFunctionary().getId() != -1) {
                    queryParamMap.put("functionaryid", this.financialDetail.getFunctionary().getId());
                }
                if (this.financialDetail != null && this.financialDetail.getAbstractEstimate().getWard() != null) {
                    queryParamMap.put("boundaryid", this.financialDetail.getAbstractEstimate().getWard().getId());
                }
                if (this.financialDetail != null && this.financialDetail.getFunction() != null && this.financialDetail.getFunction().getId() != null && this.financialDetail.getFunction().getId() != -1L) {
                    queryParamMap.put("functionid", this.financialDetail.getFunction().getId());
                }
                if (this.financialDetail != null && this.financialDetail.getAbstractEstimate().getUserDepartment() != null) {
                    queryParamMap.put("deptid", this.financialDetail.getAbstractEstimate().getUserDepartment().getId());
                }
                if (this.getBillDate() != null) {
                    CFinancialYear finyear = this.getCurrentFinancialYear(this.getBillDate());
                    if (finyear != null && finyear.getId() != null) {
                        queryParamMap.put("financialyearid", finyear.getId());
                    }
                    queryParamMap.put("toDate", this.getBillDate());
                    queryParamMap.put("asondate", this.getBillDate());
                }
                if (this.getGlCodeId() != null) {
                    CChartOfAccounts coaObj = (CChartOfAccounts)this.persistenceService.find("from CChartOfAccounts where id=?", new Object[]{this.getGlCodeId()});
                    queryParamMap.put("glcode", coaObj.getGlcode());
                    queryParamMap.put("glcodeid", this.getGlCodeId());
                    try {
                        List bgList = this.budgetDetailsDAO.getBudgetHeadByGlcode(coaObj);
                        if (bgList == null || bgList.isEmpty()) {
                            throw new ValidationException("", "The Budget balance is not specified for the account code: " + coaObj.getGlcode(), new String[0]);
                        }
                        queryParamMap.put("budgetheadid", bgList);
                    }
                    catch (ValidationException valEx) {
                        this.errorMsg = "The Budget balance is not specified for the account code: " + coaObj.getGlcode();
                        logger.error((Object)this.errorMsg);
                    }
                }
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("queryParamMap size >>>>>>>>>> " + queryParamMap.size()));
                }
                if (queryParamMap.isEmpty() || !this.getFieldErrors().isEmpty()) break block22;
                this.totalGrantAmount = this.budgetDetailsDAO.getBudgetedAmtForYear(queryParamMap);
                this.totalUtilizedAmount = this.budgetDetailsDAO.getActualBudgetUtilizedForBudgetaryCheck(queryParamMap);
                this.actualAmount = this.budgetDetailsDAO.getBillAmountForBudgetCheck(queryParamMap);
                BigDecimal budgetBalance = this.totalGrantAmount.subtract(this.totalUtilizedAmount.add(this.actualAmount));
                this.budgAmount = this.totalGrantAmount;
                this.budgBalance = budgetBalance;
            }
            catch (Exception e) {
                logger.error((Object)("--------------Error in fetching -------------" + e.getMessage()));
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("totalGrantAmount>>>>>>>>> " + this.totalGrantAmount));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("totalUtilizedAmount>>>>>>>>> " + this.totalUtilizedAmount));
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("actual amount>>>>>> " + this.actualAmount));
        }
    }

    public CFinancialYear getCurrentFinancialYear(Date billDate) {
        return this.finHibernateDao.getFinYearByDate(billDate);
    }

    public String getStatutoryDeductionAmount() throws Exception {
        this.getDeductionAmount();
        return STATUTORY_DEDUCTION_AMOUNT;
    }

    public void getDeductionAmount() throws Exception {
        String subPartyTypeCode = null;
        String typeOfWorkCode = null;
        try {
            try {
                if (!"0".equals(this.subPartyType)) {
                    EgPartytype egPartyType = new EgPartytype();
                    egPartyType = this.egPartytypeHibernateDAO.findById(Integer.valueOf(this.subPartyType));
                    subPartyTypeCode = egPartyType.getCode();
                }
                if (!"0".equals(this.typeOfWork)) {
                    EgwTypeOfWork egwTOW = new EgwTypeOfWork();
                    egwTOW = this.egwTypeOfWorkHibernateDAO.getTypeOfWorkById(Long.valueOf(this.typeOfWork));
                    typeOfWorkCode = egwTOW.getCode();
                }
                this.statutoryAmount = this.recoveryService.getDeductionAmount(this.recoveryType, PARTY_TYPE_CONTRACTOR, subPartyTypeCode, typeOfWorkCode, this.grossAmount, this.billDate);
                if (logger.isDebugEnabled()) {
                    logger.debug((Object)("statutoryAmount>>>>>>>>> " + this.statutoryAmount));
                }
            }
            catch (ValidationException e) {
                this.errorMsg = ((ValidationError)e.getErrors().get(0)).getMessage();
                logger.error((Object)this.errorMsg);
            }
        }
        catch (Exception e) {
            logger.error((Object)("--------------Error in fetching -------------" + e.getMessage()));
            throw e;
        }
    }

    public String getProjectClosureEstimateForBill() {
        WorkOrderEstimate woe = (WorkOrderEstimate)this.getPersistenceService().find("select distinct mb.workOrderEstimate from MBHeader mb where mb.egBillregister.id=? and  mb.egBillregister.billstatus='APPROVED' and mb.workOrderEstimate.estimate.projectCode.egwStatus.code='CLOSED'", new Object[]{this.contractorBillId});
        this.estimateNumber = woe != null ? woe.getEstimate().getEstimateNumber() : "";
        return "projectClosureEstimate";
    }

    public String searchWorkOrderNumber() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select distinct mbh.workOrder from MBHeader mbh where mbh.workOrder.parent is null and mbh.egBillregister is not null and mbh.egBillregister.billstatus <> ? and mbh.workOrder.workOrderNumber like '%'||?||'%' ";
            params.add("NEW");
            params.add(this.query.toUpperCase());
            this.workOrderList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return "workOrderNoSearchResults";
    }

    public String searchContractorBillNo() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = " from ContractorBillRegister cbr where cbr.billnumber like '%'||?||'%' and cbr.billstatus <> ? ";
            params.add(this.query.toUpperCase());
            params.add("NEW");
            this.contractorBillList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return "billNumberSearchResults";
    }

    public String searchEstimateNumber() {
        String strquery = "";
        ArrayList<String> params = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)this.query)) {
            strquery = "select woe.estimate from WorkOrderEstimate woe where woe.workOrder.parent is null and woe.estimate.estimateNumber like '%'||?||'%'  and woe.id in (select distinct mbh.workOrderEstimate.id from MBHeader mbh where mbh.egBillregister.id in (select egbr.id from EgBillregister egbr where egbr.billstatus <> ?) )";
            params.add(this.query.toUpperCase());
            params.add("NEW");
            this.estimateList = this.getPersistenceService().findAllBy(strquery, params.toArray());
        }
        return "estimateNoSearchResults";
    }

    public String getLatestMBDateCreatedAndRefNum() {
        Object[] mbDateRefNo = this.contractorBillService.getLatestMBCreatedDateAndRefNo(this.woId, this.estId);
        this.refNo = (String)mbDateRefNo[0];
        this.latestMBDate = (Date)mbDateRefNo[1];
        return "mblatestDateResult";
    }

    public Date getBillDate() {
        return this.billDate;
    }

    public void setBillDate(Date billDate) {
        this.billDate = billDate;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public EgBillregister getEgBillregister() {
        return this.egBillregister;
    }

    public void setEgBillregister(EgBillregister egBillregister) {
        this.egBillregister = egBillregister;
    }

    public Long getWorkOrderId() {
        return this.workOrderId;
    }

    public void setWorkOrderId(Long workOrderId) {
        this.workOrderId = workOrderId;
    }

    public WorkOrder getWorkOrder() {
        return this.workOrder;
    }

    public void setWorkOrder(WorkOrder workOrder) {
        this.workOrder = workOrder;
    }

    public void setContractorBillService(ContractorBillService contractorBillService) {
        this.contractorBillService = contractorBillService;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public BigDecimal getTotalPendingBalance() {
        return this.totalPendingBalance;
    }

    public void setDeductionType(String deductionType) {
        this.deductionType = deductionType;
    }

    public List<CChartOfAccounts> getStandardDeductionAccountList() {
        return this.standardDeductionAccountList;
    }

    public String getRowId() {
        return this.rowId;
    }

    public void setRowId(String rowId) {
        this.rowId = rowId;
    }

    public String getWorkOrderNumber() {
        return this.workOrderNumber;
    }

    public void setWorkOrderNumber(String workOrderNumber) {
        this.workOrderNumber = workOrderNumber;
    }

    public String getBillType() {
        return this.billType;
    }

    public void setBillType(String billType) {
        this.billType = billType;
    }

    public void setMeasurementBookService(MeasurementBookServiceImpl measurementBookService) {
        this.measurementBookService = measurementBookService;
    }

    public BigDecimal getTotalUtilizedAmount() {
        return this.totalUtilizedAmount;
    }

    public void setTotalUtilizedAmount(BigDecimal totalUtilizedAmount) {
        this.totalUtilizedAmount = totalUtilizedAmount;
    }

    public List<AppConfigValues> getFinalBillChecklist() {
        return this.finalBillChecklist;
    }

    public void setFinalBillChecklist(List<AppConfigValues> finalBillChecklist) {
        this.finalBillChecklist = finalBillChecklist;
    }

    public BigDecimal getTotalWorkValueRecorded() {
        return this.totalWorkValueRecorded;
    }

    public void setTotalWorkValueRecorded(BigDecimal totalWorkValueRecorded) {
        this.totalWorkValueRecorded = totalWorkValueRecorded;
    }

    public List<MBHeader> getApprovedMBHeaderList() {
        return this.approvedMBHeaderList;
    }

    public void setApprovedMBHeaderList(List<MBHeader> approvedMBHeaderList) {
        this.approvedMBHeaderList = approvedMBHeaderList;
    }

    public BigDecimal getBudgetSanctionAmount() {
        return this.budgetSanctionAmount;
    }

    public void setBudgetSanctionAmount(BigDecimal budgetSanctionAmount) {
        this.budgetSanctionAmount = budgetSanctionAmount;
    }

    public List<String> getChecklistValues() {
        return this.checklistValues;
    }

    public void setChecklistValues(List<String> checklistValues) {
        this.checklistValues = checklistValues;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public String[] getSelectedchecklistvalues() {
        return this.selectedchecklistvalues;
    }

    public void setSelectedchecklistvalues(String[] selectedchecklistvalues) {
        this.selectedchecklistvalues = selectedchecklistvalues;
    }

    public Long getEstimateId() {
        return this.estimateId;
    }

    public void setEstimateId(Long estimateId) {
        this.estimateId = estimateId;
    }

    public List<AssetsForWorkOrder> getAssetList() {
        return this.assetList;
    }

    public void setAssetList(List<AssetsForWorkOrder> assetList) {
        this.assetList = assetList;
    }

    public List<CChartOfAccounts> getCoaList() {
        return this.coaList;
    }

    public void setCoaList(List<CChartOfAccounts> coaList) {
        this.coaList = coaList;
    }

    public WorkCompletionInfo getWorkcompletionInfo() {
        return this.workcompletionInfo;
    }

    public void setWorkcompletionInfo(WorkCompletionInfo workcompletionInfo) {
        this.workcompletionInfo = workcompletionInfo;
    }

    public List<WorkCompletionDetailInfo> getWorkCompletionDetailInfo() {
        return this.workCompletionDetailInfo;
    }

    public void setWorkCompletionDetailInfo(List<WorkCompletionDetailInfo> workCompletionDetailInfo) {
        this.workCompletionDetailInfo = workCompletionDetailInfo;
    }

    public Long getGlCode() {
        return this.glCode;
    }

    public void setGlCode(Long glCode) {
        this.glCode = glCode;
    }

    public BigDecimal getBudgBalance() {
        return this.budgBalance;
    }

    public void setBudgBalance(BigDecimal budgBalance) {
        this.budgBalance = budgBalance;
    }

    public BigDecimal getBudgAmount() {
        return this.budgAmount;
    }

    public void setBudgAmount(BigDecimal budgAmount) {
        this.budgAmount = budgAmount;
    }

    public boolean getCheckBudget() {
        return this.checkBudget;
    }

    public void setCheckBudget(boolean checkBudget) {
        this.checkBudget = checkBudget;
    }

    public void setBudgetDetailsDAO(BudgetDetailsDAO budgetDetailsDAO) {
        this.budgetDetailsDAO = budgetDetailsDAO;
    }

    public Long getWorkOrderEstimateId() {
        return this.workOrderEstimateId;
    }

    public void setWorkOrderEstimateId(Long workOrderEstimateId) {
        this.workOrderEstimateId = workOrderEstimateId;
    }

    public Long getGlCodeId() {
        return this.glCodeId;
    }

    public void setGlCodeId(Long glCodeId) {
        this.glCodeId = glCodeId;
    }

    public String getErrorMsg() {
        return this.errorMsg;
    }

    public void setErrorMsg(String errorMsg) {
        this.errorMsg = errorMsg;
    }

    public void setEgovCommon(EgovCommon egovCommon) {
        this.egovCommon = egovCommon;
    }

    public String getSubPartyType() {
        return this.subPartyType;
    }

    public void setSubPartyType(String subPartyType) {
        this.subPartyType = subPartyType;
    }

    public String getTypeOfWork() {
        return this.typeOfWork;
    }

    public void setTypeOfWork(String typeOfWork) {
        this.typeOfWork = typeOfWork;
    }

    public BigDecimal getGrossAmount() {
        return this.grossAmount;
    }

    public void setGrossAmount(BigDecimal grossAmount) {
        this.grossAmount = grossAmount;
    }

    public void setStatutoryAmount(BigDecimal statutoryAmount) {
        this.statutoryAmount = statutoryAmount;
    }

    public BigDecimal getStatutoryAmount() {
        return this.statutoryAmount;
    }

    public String getRecoveryType() {
        return this.recoveryType;
    }

    public void setRecoveryType(String recoveryType) {
        this.recoveryType = recoveryType;
    }

    public BigDecimal getCumulativeBillValue() {
        return this.cumulativeBillValue;
    }

    public void setCumulativeBillValue(BigDecimal cumulativeBillValue) {
        this.cumulativeBillValue = cumulativeBillValue;
    }

    public List<String> getAppConfigValuesToSkipBudget() {
        return this.worksService.getNatureOfWorkAppConfigValues(WORKS, "SKIP_BUDGET_CHECK");
    }

    public BigDecimal getTotalTenderedItemsAmt() {
        return this.totalTenderedItemsAmt;
    }

    public void setTotalTenderedItemsAmt(BigDecimal totalTenderedItemsAmt) {
        this.totalTenderedItemsAmt = totalTenderedItemsAmt;
    }

    public Long getContractorBillId() {
        return this.contractorBillId;
    }

    public void setContractorBillId(Long contractorBillId) {
        this.contractorBillId = contractorBillId;
    }

    public String getEstimateNumber() {
        return this.estimateNumber;
    }

    public void setEstimateNumber(String estimateNumber) {
        this.estimateNumber = estimateNumber;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public List<WorkOrder> getWorkOrderList() {
        return this.workOrderList;
    }

    public void setWorkOrderList(List<WorkOrder> workOrderList) {
        this.workOrderList = workOrderList;
    }

    public List<ContractorBillRegister> getContractorBillList() {
        return this.contractorBillList;
    }

    public void setContractorBillList(List<ContractorBillRegister> contractorBillList) {
        this.contractorBillList = contractorBillList;
    }

    public boolean getNoMBsPresent() {
        return this.noMBsPresent;
    }

    public void setNoMBsPresent(boolean noMBsPresent) {
        this.noMBsPresent = noMBsPresent;
    }

    public String getLatestBillDateStr() {
        return this.latestBillDateStr;
    }

    public String getTrackMlsCheck() {
        return this.trackMlsCheck;
    }

    public List<AbstractEstimate> getEstimateList() {
        return this.estimateList;
    }

    public void setEstimateList(List<AbstractEstimate> estimateList) {
        this.estimateList = estimateList;
    }

    public String getYearEndApprCheck() {
        return this.yearEndApprCheck;
    }

    public void setYearEndApprCheck(String yearEndApprCheck) {
        this.yearEndApprCheck = yearEndApprCheck;
    }

    public String getEstimateNo() {
        return this.estimateNo;
    }

    public void setEstimateNo(String estimateNo) {
        this.estimateNo = estimateNo;
    }

    public void setContractorAdvanceService(ContractorAdvanceService contractorAdvanceService) {
        this.contractorAdvanceService = contractorAdvanceService;
    }

    public BigDecimal getTotalAdvancePaid() {
        return this.totalAdvancePaid;
    }

    public void setTotalAdvancePaid(BigDecimal totalAdvancePaid) {
        this.totalAdvancePaid = totalAdvancePaid;
    }

    public Long getBillId() {
        return this.billId;
    }

    public void setBillId(Long billId) {
        this.billId = billId;
    }

    public String getAdvanceRequisitionNo() {
        return this.advanceRequisitionNo;
    }

    public void setAdvanceRequisitionNo(String advanceRequisitionNo) {
        this.advanceRequisitionNo = advanceRequisitionNo;
    }

    public String getOwner() {
        return this.owner;
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public String getArfInWorkFlowCheck() {
        return this.arfInWorkFlowCheck;
    }

    public void setArfInWorkFlowCheck(String arfInWorkFlowCheck) {
        this.arfInWorkFlowCheck = arfInWorkFlowCheck;
    }

    public void setEmployeeService(EmployeeServiceOld employeeService) {
        this.employeeService = employeeService;
    }

    public String getShowValidationMsg() {
        return this.showValidationMsg;
    }

    public void setShowValidationMsg(String showValidationMsg) {
        this.showValidationMsg = showValidationMsg;
    }

    public Date getLatestMBDate() {
        return this.latestMBDate;
    }

    public void setLatestMBDate(Date latestMBDate) {
        this.latestMBDate = latestMBDate;
    }

    public Long getEstId() {
        return this.estId;
    }

    public void setEstId(Long estId) {
        this.estId = estId;
    }

    public String getRefNo() {
        return this.refNo;
    }

    public void setRefNo(String refNo) {
        this.refNo = refNo;
    }

    public Long getWoId() {
        return this.woId;
    }

    public void setWoId(Long woId) {
        this.woId = woId;
    }
}

