/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.letterofacceptance;

import java.io.IOException;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.web.utils.WebUtils;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/letterofacceptance"})
public class LetterOfAcceptancePDFController {
    @Autowired
    private ReportService reportService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    public static final String LETTEROFACCEPTANCEPDF = "letterOfAcceptancePDF";
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;

    @RequestMapping(value={"/letterOfAcceptancePDF/{letterOfAcceptanceId}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateLineEstimatePDF(HttpServletRequest request, @PathVariable(value="letterOfAcceptanceId") Long id, HttpSession session) throws IOException {
        WorkOrder workOrder = this.letterOfAcceptanceService.getWorkOrderById(id);
        return this.generateReport(workOrder, request, session);
    }

    private ResponseEntity<byte[]> generateReport(WorkOrder workOrder, HttpServletRequest request, HttpSession session) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        ReportRequest reportInput = null;
        ReportOutput reportOutput = null;
        if (workOrder != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            DecimalFormat df = new DecimalFormat("0.00");
            LineEstimateDetails lineEstimateDetails = this.lineEstimateService.findByEstimateNumber(workOrder.getEstimateNumber());
            String url = WebUtils.extractRequestDomainURL((HttpServletRequest)request, (boolean)false);
            reportParams.put("cityLogo", url.concat("/egi").concat((String)request.getSession().getAttribute("citylogo")));
            String cityName = (String)request.getSession().getAttribute("citymunicipalityname");
            reportParams.put("cityName", cityName);
            reportParams.put("workOrderNumber", workOrder.getWorkOrderNumber() != null ? workOrder.getWorkOrderNumber() : "");
            reportParams.put("workOrderDate", workOrder.getWorkOrderDate() != null ? formatter.format(workOrder.getWorkOrderDate()) : "");
            reportParams.put("contractorName", workOrder.getContractor().getName() != null ? workOrder.getContractor().getName() : "");
            reportParams.put("contractorAddress", workOrder.getContractor().getBankaccount() != null ? workOrder.getContractor().getCorrespondenceAddress() : "");
            reportParams.put("panNo", workOrder.getContractor().getPanNumber() != null ? workOrder.getContractor().getPanNumber() : "");
            reportParams.put("bank", workOrder.getContractor().getBank() != null ? workOrder.getContractor().getBank().getName() : "");
            reportParams.put("accountNo", workOrder.getContractor().getBankaccount() != null ? workOrder.getContractor().getBankaccount() : "");
            reportParams.put("subject", lineEstimateDetails.getNameOfWork());
            reportParams.put("modeOfAllotment", lineEstimateDetails.getLineEstimate().getModeOfAllotment());
            reportParams.put("agreementAmount", df.format(workOrder.getWorkOrderAmount()));
            reportParams.put("emd", df.format(workOrder.getEmdAmountDeposited()));
            reportParams.put("asd", df.format(workOrder.getSecurityDeposit()));
            reportParams.put("WINCode", lineEstimateDetails.getProjectCode().getCode());
            reportParams.put("amountOfEstimate", lineEstimateDetails.getActualEstimateAmount().setScale(2, 6));
            reportParams.put("headOfAccount", lineEstimateDetails.getLineEstimate().getBudgetHead().getName());
            reportParams.put("ward", lineEstimateDetails.getLineEstimate().getWard().getName());
            String technicalSanctionByDesignation = lineEstimateDetails.getLineEstimate().getTechnicalSanctionBy() != null ? this.worksUtils.getUserDesignation(lineEstimateDetails.getLineEstimate().getTechnicalSanctionBy()) : this.worksUtils.getUserDesignation(lineEstimateDetails.getLineEstimate().getCreatedBy());
            reportParams.put("technicalSanctionByDesignation", technicalSanctionByDesignation);
            reportInput = new ReportRequest(LETTEROFACCEPTANCEPDF, (Object)workOrder.getContractor(), reportParams);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=LetterOfAcceptance.pdf");
        reportOutput = this.reportService.createReport(reportInput);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

