/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.reports;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.infra.utils.DateUtils;
import org.egov.works.contractorbill.entity.enums.BillTypes;
import org.egov.works.reports.entity.WorkProgressRegister;
import org.egov.works.reports.entity.WorkProgressRegisterPdf;
import org.egov.works.reports.entity.WorkProgressRegisterSearchRequest;
import org.egov.works.reports.service.WorkProgressRegisterService;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports/workprogressregister"})
public class WorkProgressRegisterPDFController {
    @Autowired
    private ReportService reportService;
    @Autowired
    private WorksUtils worksUtils;
    @Autowired
    private WorkProgressRegisterService workProgressRegisterService;
    @Autowired
    private DepartmentService departmentService;
    public static final String WORKPROGRESSREGISTERPDF = "workProgressRegisterPdf";
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;

    @RequestMapping(value={"/pdf"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateWorkProgressRegisterPDF(HttpServletRequest request, @RequestParam(value="adminSanctionFromDate") Date adminSanctionFromDate, @RequestParam(value="adminSanctionToDate") Date adminSanctionToDate, @RequestParam(value="workIdentificationNumber") String workIdentificationNumber, @RequestParam(value="contractor") String contractor, @RequestParam(value="department") Long department, @RequestParam(value="spillOverFlag") boolean spillOverFlag, @RequestParam(value="contentType") String contentType, HttpSession session) throws IOException {
        HashMap<String, String> reportParams = new HashMap<String, String>();
        WorkProgressRegisterSearchRequest searchRequest = new WorkProgressRegisterSearchRequest();
        searchRequest.setAdminSanctionFromDate(adminSanctionFromDate);
        searchRequest.setAdminSanctionToDate(adminSanctionToDate);
        searchRequest.setContractor(contractor);
        searchRequest.setWorkIdentificationNumber(workIdentificationNumber);
        searchRequest.setDepartment(department);
        searchRequest.setSpillOverFlag(spillOverFlag);
        List workProgressRegisters = this.workProgressRegisterService.searchWorkProgressRegister(searchRequest);
        String queryParameters = "Work Progress Register Report ";
        if (spillOverFlag) {
            queryParameters = "Work Progress Register for Spill Over Line Estimates ";
        }
        if (adminSanctionFromDate != null || adminSanctionToDate != null || workIdentificationNumber != null || contractor != null || department != null) {
            queryParameters = queryParameters + "for ";
        }
        if (adminSanctionFromDate != null && adminSanctionToDate != null) {
            queryParameters = queryParameters + "Date Range : " + DateUtils.getFormattedDate((Date)adminSanctionFromDate, (String)"dd/MM/yyyy") + " - " + DateUtils.getFormattedDate((Date)adminSanctionToDate, (String)"dd/MM/yyyy") + ", ";
        }
        if (adminSanctionFromDate != null && adminSanctionToDate == null) {
            queryParameters = queryParameters + "Admin Sanction From Date : " + adminSanctionFromDate + ", ";
        }
        if (adminSanctionToDate != null && adminSanctionFromDate == null) {
            queryParameters = queryParameters + "Admin Sanction To Date : " + adminSanctionToDate + ", ";
        }
        if (workIdentificationNumber != null) {
            queryParameters = queryParameters + "Work Identification Number : " + workIdentificationNumber + ", ";
        }
        if (contractor != null) {
            queryParameters = queryParameters + "Contractor : " + contractor + ", ";
        }
        if (department != null) {
            queryParameters = queryParameters + "Department : " + this.departmentService.getDepartmentById(department).getName() + ", ";
        }
        if (queryParameters.endsWith(", ")) {
            queryParameters = queryParameters.substring(0, queryParameters.length() - 2);
        }
        reportParams.put("queryParameters", queryParameters);
        return this.generateReport(workProgressRegisters, request, session, contentType, reportParams);
    }

    private ResponseEntity<byte[]> generateReport(List<WorkProgressRegister> workProgressRegisters, HttpServletRequest request, HttpSession session, String contentType, Map<String, Object> reportParams) {
        ArrayList<WorkProgressRegisterPdf> workProgressRegisterPdfList = new ArrayList<WorkProgressRegisterPdf>();
        String dataRunDate = "";
        ReportRequest reportInput = null;
        ReportOutput reportOutput = null;
        if (workProgressRegisters != null && !workProgressRegisters.isEmpty()) {
            for (WorkProgressRegister wpr : workProgressRegisters) {
                WorkProgressRegisterPdf pdf = new WorkProgressRegisterPdf();
                if (wpr.getWard() != null) {
                    if (wpr.getWard().getBoundaryType().getName().equalsIgnoreCase("City")) {
                        pdf.setWard(wpr.getWard().getName());
                    } else {
                        pdf.setWard(wpr.getWard().getBoundaryNum().toString());
                    }
                } else {
                    pdf.setWard("");
                }
                if (wpr.getLocation() != null) {
                    pdf.setLocation(wpr.getLocation().getName());
                } else {
                    pdf.setLocation("");
                }
                if (wpr.getWorkCategory() != null) {
                    pdf.setWorkCategory(wpr.getWorkCategory().toString().replace("_", " "));
                } else {
                    pdf.setWorkCategory("NA");
                }
                if (wpr.getBeneficiary() != null) {
                    pdf.setBeneficiary(wpr.getBeneficiary().toString().replaceAll("_C", "/C").replace("_", " "));
                } else {
                    pdf.setBeneficiary("NA");
                }
                if (wpr.getWinCode() != null) {
                    pdf.setWinCode(wpr.getWinCode());
                } else {
                    pdf.setWinCode("");
                }
                if (wpr.getFund() != null) {
                    pdf.setFund(wpr.getFund().getCode() + " - " + wpr.getFund().getName());
                } else {
                    pdf.setFund("");
                }
                if (wpr.getFunction() != null) {
                    pdf.setFunction(wpr.getFunction().getCode() + " - " + wpr.getFunction().getName());
                } else {
                    pdf.setFunction("");
                }
                if (wpr.getBudgetHead() != null) {
                    pdf.setBudgetHead(wpr.getBudgetHead().getName());
                } else {
                    pdf.setBudgetHead("");
                }
                if (wpr.getTypeOfWork() != null) {
                    pdf.setTypeOfWork(wpr.getTypeOfWork().getDescription());
                } else {
                    pdf.setTypeOfWork("");
                }
                if (wpr.getSubTypeOfWork() != null) {
                    pdf.setSubTypeOfWork(wpr.getSubTypeOfWork().getDescription());
                } else {
                    pdf.setSubTypeOfWork("");
                }
                if (wpr.getAdminSanctionBy() != null) {
                    pdf.setAdminSanctionAuthorityDate(wpr.getAdminSanctionBy() + " , " + DateUtils.getFormattedDate((Date)wpr.getAdminSanctionDate(), (String)"dd/MM/yyyy"));
                } else {
                    pdf.setAdminSanctionAuthorityDate("");
                }
                if (wpr.getAdminSanctionAmount() != null) {
                    pdf.setAdminSanctionAmount(wpr.getAdminSanctionAmount().setScale(2, 6).toString());
                } else {
                    pdf.setAdminSanctionAmount("NA");
                }
                if (wpr.getTechnicalSanctionBy() != null) {
                    pdf.setTechnicalSanctionAuthorityDate(this.worksUtils.getUserDesignation(wpr.getTechnicalSanctionBy()) + " - " + wpr.getTechnicalSanctionBy().getName() + ", " + DateUtils.getFormattedDate((Date)wpr.getTechnicalSanctionDate(), (String)"dd/MM/yyyy"));
                } else {
                    pdf.setTechnicalSanctionAuthorityDate("NA");
                }
                if (wpr.getEstimateAmount() != null) {
                    pdf.setEstimateAmount(wpr.getEstimateAmount().setScale(2, 6).toString());
                } else {
                    pdf.setEstimateAmount("NA");
                }
                if (wpr.getModeOfAllotment() != null) {
                    pdf.setModeOfAllotment(wpr.getModeOfAllotment());
                } else {
                    pdf.setModeOfAllotment("");
                }
                if (wpr.getAgreementNumber() != null) {
                    pdf.setAgreementNumberDate(wpr.getAgreementNumber() + " - " + DateUtils.getFormattedDate((Date)wpr.getAgreementDate(), (String)"dd/MM/yyyy"));
                } else {
                    pdf.setAgreementNumberDate("");
                }
                if (wpr.getContractor() != null) {
                    pdf.setContractorCodeName(wpr.getContractor().getCode() + " - " + wpr.getContractor().getName());
                } else {
                    pdf.setContractorCodeName("");
                }
                if (wpr.getAgreementAmount() != null) {
                    pdf.setAgreementAmount(wpr.getAgreementAmount().setScale(2, 6).toString());
                } else {
                    pdf.setAgreementAmount("NA");
                }
                if (wpr.getLatestMbNumber() != null && wpr.getLatestMbDate() != null) {
                    pdf.setLatestMbNumberDate(wpr.getLatestMbNumber() + " - " + DateUtils.getFormattedDate((Date)wpr.getLatestMbDate(), (String)"dd/MM/yyyy"));
                } else {
                    pdf.setLatestMbNumberDate("");
                }
                if (wpr.getLatestBillNumber() != null) {
                    pdf.setLatestBillNumberDate(wpr.getLatestBillNumber() + " - " + DateUtils.getFormattedDate((Date)wpr.getLatestBillDate(), (String)"dd/MM/yyyy"));
                } else {
                    pdf.setLatestBillNumberDate("");
                }
                if (wpr.getBilltype() != null) {
                    pdf.setBilltype(wpr.getBilltype());
                } else {
                    pdf.setBilltype("NA");
                }
                if (wpr.getBillamount() != null) {
                    pdf.setBillamount(wpr.getBillamount().setScale(2, 6).toString());
                } else {
                    pdf.setBillamount("NA");
                }
                if (wpr.getTotalBillAmount() != null) {
                    pdf.setTotalBillAmount(wpr.getTotalBillAmount().setScale(2, 6).toString());
                } else {
                    pdf.setTotalBillAmount("NA");
                }
                if (wpr.getMilestonePercentageCompleted() != null) {
                    pdf.setMilestonePercentageCompleted(wpr.getMilestonePercentageCompleted().toString());
                } else {
                    pdf.setMilestonePercentageCompleted("NA");
                }
                if (wpr.getTotalBillPaidSoFar() != null) {
                    pdf.setTotalBillPaidSoFar(wpr.getTotalBillPaidSoFar().setScale(2, 6).toString());
                } else {
                    pdf.setTotalBillPaidSoFar("NA");
                }
                if (wpr.getBalanceValueOfWorkToBill() != null) {
                    if (wpr.getBilltype() != null && wpr.getBilltype().equalsIgnoreCase(BillTypes.Final_Bill.toString())) {
                        pdf.setBalanceValueOfWorkToBill("NA");
                    } else {
                        pdf.setBalanceValueOfWorkToBill(wpr.getBalanceValueOfWorkToBill().setScale(2, 6).toString());
                    }
                } else {
                    pdf.setBalanceValueOfWorkToBill("NA");
                }
                dataRunDate = DateUtils.getFormattedDate((Date)wpr.getCreatedDate(), (String)"dd/MM/yyyy hh:mm a");
                workProgressRegisterPdfList.add(pdf);
            }
        }
        reportParams.put("heading", "Work Progress Register Report");
        reportParams.put("reportRunDate", DateUtils.getFormattedDate((Date)new Date(), (String)"dd/MM/yyyy hh:mm a"));
        reportParams.put("dataRunDate", dataRunDate);
        reportInput = new ReportRequest(WORKPROGRESSREGISTERPDF, workProgressRegisterPdfList, reportParams);
        HttpHeaders headers = new HttpHeaders();
        if (contentType.equalsIgnoreCase("pdf")) {
            reportInput.setReportFormat(ReportConstants.FileFormat.PDF);
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
            headers.add("content-disposition", "inline;filename=WorkProgressRegister.pdf");
        } else {
            reportInput.setReportFormat(ReportConstants.FileFormat.XLS);
            headers.setContentType(MediaType.parseMediaType((String)"application/vnd.ms-excel"));
            headers.add("content-disposition", "inline;filename=WorkProgressRegister.xls");
        }
        reportOutput = this.reportService.createReport(reportInput);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

