/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.reports;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.egov.commons.dao.FinancialYearHibernateDAO;
import org.egov.commons.dao.FunctionHibernateDAO;
import org.egov.commons.dao.FundHibernateDAO;
import org.egov.dao.budget.BudgetDetailsDAO;
import org.egov.dao.budget.BudgetGroupDAO;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.model.budget.BudgetGroup;
import org.egov.services.budget.BudgetGroupService;
import org.egov.works.models.estimate.BudgetFolioDetail;
import org.egov.works.reports.entity.EstimateAppropriationRegisterSearchRequest;
import org.egov.works.reports.service.EstimateAppropriationRegisterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports/estimateappropriationregister"})
public class EstimateAppropriationRegisterPDFController {
    @Autowired
    private ReportService reportService;
    @Autowired
    private EstimateAppropriationRegisterService estimateAppropriationRegisterService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private FundHibernateDAO fundHibernateDAO;
    @Autowired
    private FunctionHibernateDAO functionHibernateDAO;
    @Autowired
    private BudgetDetailsDAO budgetDetailsDAO;
    @Autowired
    private BudgetGroupDAO budgetGroupDAO;
    @Autowired
    private FinancialYearHibernateDAO financialYearHibernateDAO;
    @Autowired
    private BudgetGroupService budgetGroupService;
    public static final String BUDGETFOLIOPDF = "BudgetFolio";
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;

    @RequestMapping(value={"/pdf"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateAppropriationRegisterPDF(HttpServletRequest request, @RequestParam(value="departments") Long department, @RequestParam(value="financialYear") Long financialYear, @RequestParam(value="asOnDate") Date asOnDate, @RequestParam(value="fund") Long fund, @RequestParam(value="functionName") Long function, @RequestParam(value="budgetHead") Long budgetHead, @RequestParam(value="contentType") String contentType, HttpSession session) throws IOException {
        EstimateAppropriationRegisterSearchRequest searchRequest = new EstimateAppropriationRegisterSearchRequest();
        searchRequest.setAsOnDate(asOnDate);
        searchRequest.setBudgetHead(budgetHead);
        searchRequest.setDepartment(department);
        searchRequest.setFinancialYear(financialYear);
        searchRequest.setFunction(function);
        searchRequest.setFund(fund);
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        HashMap<String, Serializable> queryParamMap = new HashMap<String, Serializable>();
        BigDecimal totalGrant = BigDecimal.ZERO;
        BigDecimal totalGrantPerc = BigDecimal.ZERO;
        BigDecimal planningBudgetPerc = new BigDecimal(0);
        if (searchRequest != null && searchRequest.getFund() != null) {
            queryParamMap.put("fundid", Integer.valueOf(searchRequest.getFund().intValue()));
        }
        if (searchRequest != null && searchRequest.getFunction() != null) {
            queryParamMap.put("functionid", searchRequest.getFunction());
        }
        if (searchRequest != null && searchRequest.getBudgetHead() != null) {
            ArrayList<BudgetGroup> budgetheadid = new ArrayList<BudgetGroup>();
            BudgetGroup budgetGroup = (BudgetGroup)this.budgetGroupService.findById((Serializable)searchRequest.getBudgetHead(), true);
            budgetheadid.add(budgetGroup);
            queryParamMap.put("budgetheadid", budgetheadid);
        }
        if (searchRequest != null && searchRequest.getDepartment() != null) {
            queryParamMap.put("deptid", searchRequest.getDepartment());
        }
        if (searchRequest != null && searchRequest.getFinancialYear() != null) {
            queryParamMap.put("financialyearid", searchRequest.getFinancialYear());
        }
        if (searchRequest != null && searchRequest.getAsOnDate() != null) {
            queryParamMap.put("fromDate", this.financialYearHibernateDAO.getFinancialYearById(searchRequest.getFinancialYear()).getStartingDate());
        }
        totalGrant = this.budgetDetailsDAO.getBudgetedAmtForYear(queryParamMap);
        queryParamMap.put("deptid", Integer.valueOf(searchRequest.getDepartment().intValue()));
        planningBudgetPerc = this.budgetDetailsDAO.getPlanningPercentForYear(queryParamMap);
        if (planningBudgetPerc != null && !planningBudgetPerc.equals(0)) {
            totalGrantPerc = totalGrant.multiply(planningBudgetPerc.divide(new BigDecimal(100)));
            queryParamMap.put("totalGrantPerc", totalGrantPerc);
        }
        reportParams.put("totalGrant", totalGrant);
        reportParams.put("planningBudgetPerc", planningBudgetPerc);
        reportParams.put("totalGrantPerc", totalGrantPerc);
        reportParams.put("department", this.departmentService.getDepartmentById(department).getName());
        reportParams.put("function", this.functionHibernateDAO.getFunctionById(function).getName());
        reportParams.put("functionCode", this.functionHibernateDAO.getFunctionById(function).getCode());
        reportParams.put("budgetHead", this.budgetGroupDAO.getBudgetHeadById(budgetHead).getName());
        reportParams.put("fund", this.fundHibernateDAO.fundById(Integer.valueOf(fund.intValue()), true).getName());
        Map approvedBudgetFolioDetailsMap = this.estimateAppropriationRegisterService.searchEstimateAppropriationRegister(searchRequest);
        List approvedBudgetFolioDetails = (List)approvedBudgetFolioDetailsMap.get("budgetFolioList");
        List calculatedValuesList = (List)approvedBudgetFolioDetailsMap.get("calculatedValues");
        Double latestCumulative = (Double)calculatedValuesList.get(0);
        BigDecimal latestBalance = (BigDecimal)calculatedValuesList.get(1);
        for (BudgetFolioDetail bfd : approvedBudgetFolioDetails) {
            bfd.setCumulativeExpensesIncurred(latestCumulative);
            bfd.setActualBalanceAvailable(Double.valueOf(latestBalance.doubleValue()));
        }
        return this.generateReport(approvedBudgetFolioDetails, request, session, contentType, reportParams);
    }

    private ResponseEntity<byte[]> generateReport(List<BudgetFolioDetail> budgetFolioDetails, HttpServletRequest request, HttpSession session, String contentType, Map<String, Object> reportParams) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy hh:mm a");
        ReportRequest reportInput = null;
        ReportOutput reportOutput = null;
        reportParams.put("heading", "Estimate Appropriation Register Report");
        reportParams.put("reportRunDate", formatter.format(new Date()));
        reportInput = new ReportRequest(BUDGETFOLIOPDF, budgetFolioDetails, reportParams);
        reportParams.put("latestBalanceAvailable", budgetFolioDetails.get(0).getActualBalanceAvailable());
        reportParams.put("cumulativeExpensesIncurred", budgetFolioDetails.get(0).getCumulativeExpensesIncurred());
        HttpHeaders headers = new HttpHeaders();
        if (contentType.equalsIgnoreCase("pdf")) {
            reportInput.setReportFormat(ReportConstants.FileFormat.PDF);
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
            headers.add("content-disposition", "inline;filename=EstimateAppropriationRegister.pdf");
        } else {
            reportInput.setReportFormat(ReportConstants.FileFormat.XLS);
            headers.setContentType(MediaType.parseMediaType((String)"application/vnd.ms-excel"));
            headers.add("content-disposition", "inline;filename=EstimateAppropriationRegister.xls");
        }
        reportOutput = this.reportService.createReport(reportInput);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

