/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.reports;

import java.io.IOException;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.egov.commons.Scheme;
import org.egov.commons.SubScheme;
import org.egov.commons.dao.EgwTypeOfWorkHibernateDAO;
import org.egov.infra.admin.master.entity.Department;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.reporting.engine.ReportConstants;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.services.masters.SchemeService;
import org.egov.services.masters.SubSchemeService;
import org.egov.works.master.service.NatureOfWorkService;
import org.egov.works.reports.entity.EstimateAbstractReport;
import org.egov.works.reports.service.WorkProgressRegisterService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports/estimateabstractreport"})
public class EstimateAbstractReportPDFController {
    @Autowired
    private ReportService reportService;
    @Autowired
    private WorkProgressRegisterService workProgressRegisterService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    @Qualifier(value="schemeService")
    private SchemeService schemeService;
    @Autowired
    @Qualifier(value="subSchemeService")
    private SubSchemeService subSchemeService;
    @Autowired
    private NatureOfWorkService natureOfWorkService;
    @Autowired
    private EgwTypeOfWorkHibernateDAO egwTypeOfWorkHibernateDAO;
    @Autowired
    private MessageSource messageSource;

    @RequestMapping(value={"/departmentwise/pdf"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generatePDFDepartmentWise(HttpServletRequest request, @RequestParam(value="adminSanctionFromDate") Date adminSanctionFromDate, @RequestParam(value="adminSanctionToDate") Date adminSanctionToDate, @RequestParam(value="department") Long department, @RequestParam(value="scheme") Integer scheme, @RequestParam(value="subScheme") Integer subScheme, @RequestParam(value="workCategory") String workCategory, @RequestParam(value="beneficiary") String beneficiary, @RequestParam(value="natureOfWork") Long natureOfWork, @RequestParam(value="spillOverFlag") boolean spillOverFlag, @RequestParam(value="contentType") String contentType, HttpSession session) throws IOException {
        EstimateAbstractReport searchRequest = new EstimateAbstractReport();
        HashMap<String, String> reportParams = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        searchRequest.setAdminSanctionFromDate(adminSanctionFromDate);
        searchRequest.setAdminSanctionToDate(adminSanctionToDate);
        searchRequest.setDepartment(department);
        searchRequest.setScheme(scheme);
        searchRequest.setSubScheme(subScheme);
        searchRequest.setWorkCategory(workCategory);
        searchRequest.setBeneficiary(beneficiary);
        searchRequest.setNatureOfWork(natureOfWork);
        searchRequest.setSpillOverFlag(spillOverFlag);
        List estimateAbstractReports = this.workProgressRegisterService.searchEstimateAbstractReportByDepartmentWise(searchRequest);
        String queryParameters = this.messageSource.getMessage("msg.estimateabstractreport.by.departmentwise", null, null);
        if (spillOverFlag) {
            queryParameters = this.messageSource.getMessage("msg.estimateabstractreport.by.departmentwise.for.spillover", null, null);
        }
        if (adminSanctionFromDate != null || adminSanctionToDate != null || department != null) {
            queryParameters = queryParameters + "for ";
        }
        if (adminSanctionFromDate != null && adminSanctionToDate != null) {
            queryParameters = queryParameters + this.messageSource.getMessage("msg.daterange", null, null) + sdf.format(adminSanctionFromDate) + " - " + sdf.format(adminSanctionToDate) + ", ";
        }
        if (adminSanctionFromDate != null && adminSanctionToDate == null) {
            queryParameters = queryParameters + this.messageSource.getMessage("msg.adminsanctionfromdate", null, null) + adminSanctionFromDate + ", ";
        }
        if (adminSanctionToDate != null && adminSanctionFromDate == null) {
            queryParameters = queryParameters + this.messageSource.getMessage("msg.adminsanctiontodate", null, null) + adminSanctionToDate + ", ";
        }
        if (department != null) {
            queryParameters = queryParameters + this.messageSource.getMessage("msg.department", null, null) + this.departmentService.getDepartmentById(department).getName() + ", ";
        }
        if (scheme != null) {
            queryParameters = queryParameters + this.messageSource.getMessage("msg.scheme", null, null) + ((Scheme)this.schemeService.findById((Serializable)scheme, false)).getName() + ", ";
        }
        if (subScheme != null) {
            queryParameters = queryParameters + this.messageSource.getMessage("msg.subscheme", null, null) + ((SubScheme)this.subSchemeService.findById((Serializable)subScheme, false)).getName() + ", ";
        }
        if (workCategory != null) {
            queryParameters = queryParameters + "Work Category : " + workCategory.replace('_', ' ') + ", ";
        }
        if (beneficiary != null) {
            queryParameters = queryParameters + this.messageSource.getMessage("msg.beneficiary", null, null) + beneficiary.replaceAll("_C", "/C").replace("_", " ") + ", ";
        }
        if (natureOfWork != null) {
            queryParameters = queryParameters + this.messageSource.getMessage("msg.natureofwork", null, null) + this.natureOfWorkService.findById(natureOfWork).getName() + ", ";
        }
        if (queryParameters.endsWith(", ")) {
            queryParameters = queryParameters.substring(0, queryParameters.length() - 2);
        }
        reportParams.put("queryParameters", queryParameters);
        return this.generateReportDepartmentWise(estimateAbstractReports, request, session, contentType, reportParams);
    }

    private ResponseEntity<byte[]> generateReportDepartmentWise(List<EstimateAbstractReport> estimateAbstractReports, HttpServletRequest request, HttpSession session, String contentType, Map<String, Object> reportParams) {
        ArrayList<EstimateAbstractReport> estimateAbstractReportPdfList = new ArrayList<EstimateAbstractReport>();
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy hh:mm a");
        ReportRequest reportInput = null;
        ReportOutput reportOutput = null;
        String dataRunDate = "";
        if (estimateAbstractReports != null && !estimateAbstractReports.isEmpty()) {
            for (EstimateAbstractReport eadwr : estimateAbstractReports) {
                EstimateAbstractReport pdf = new EstimateAbstractReport();
                if (eadwr.getDepartmentName() != null) {
                    pdf.setDepartmentName(eadwr.getDepartmentName());
                } else {
                    pdf.setDepartmentName("");
                }
                if (eadwr.getLineEstimates() != null) {
                    pdf.setLineEstimates(eadwr.getLineEstimates());
                } else {
                    pdf.setLineEstimates(null);
                }
                if (eadwr.getAdminSanctionedEstimates() != null) {
                    pdf.setAdminSanctionedEstimates(eadwr.getAdminSanctionedEstimates());
                } else {
                    pdf.setAdminSanctionedEstimates(null);
                }
                if (eadwr.getAdminSanctionedAmountInCrores() != null) {
                    pdf.setAdminSanctionedAmountInCrores(new BigDecimal(eadwr.getAdminSanctionedAmountInCrores()).setScale(2, 6).toString());
                } else {
                    pdf.setAdminSanctionedAmountInCrores("NA");
                }
                if (eadwr.getTechnicalSanctionedEstimates() != null) {
                    pdf.setTechnicalSanctionedEstimates(eadwr.getTechnicalSanctionedEstimates());
                } else {
                    pdf.setTechnicalSanctionedEstimates(null);
                }
                if (eadwr.getLoaCreated() != null) {
                    pdf.setLoaCreated(eadwr.getLoaCreated());
                } else {
                    pdf.setLoaCreated(null);
                }
                if (eadwr.getAgreementValueInCrores() != null) {
                    pdf.setAgreementValueInCrores(new BigDecimal(eadwr.getAgreementValueInCrores()).setScale(2, 6).toString());
                } else {
                    pdf.setAgreementValueInCrores("NA");
                }
                if (eadwr.getWorkInProgress() != null) {
                    pdf.setWorkInProgress(eadwr.getWorkInProgress());
                } else {
                    pdf.setWorkInProgress(null);
                }
                if (eadwr.getWorkCompleted() != null) {
                    pdf.setWorkCompleted(eadwr.getWorkCompleted());
                } else {
                    pdf.setWorkCompleted(null);
                }
                if (eadwr.getBillsCreated() != null) {
                    pdf.setBillsCreated(eadwr.getBillsCreated());
                } else {
                    pdf.setBillsCreated(null);
                }
                if (eadwr.getBillValueInCrores() != null) {
                    pdf.setBillValueInCrores(new BigDecimal(eadwr.getBillValueInCrores()).setScale(2, 6).toString());
                } else {
                    pdf.setBillValueInCrores("NA");
                }
                dataRunDate = formatter.format(this.workProgressRegisterService.getReportSchedulerRunDate());
                estimateAbstractReportPdfList.add(pdf);
            }
        }
        reportParams.put("heading", this.messageSource.getMessage("msg.estimateabstractreport.by.departmentwise", null, null));
        reportParams.put("reportRunDate", formatter.format(new Date()));
        reportParams.put("dataRunDate", dataRunDate);
        reportInput = new ReportRequest(this.messageSource.getMessage("msg.estimateabstractreportbydepartmentwisepdf", null, null), estimateAbstractReportPdfList, reportParams);
        HttpHeaders headers = new HttpHeaders();
        if (contentType.equalsIgnoreCase("pdf")) {
            reportInput.setReportFormat(ReportConstants.FileFormat.PDF);
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
            headers.add("content-disposition", "inline;filename=EstimateAbstractReportByDepartmentWise.pdf");
        } else {
            reportInput.setReportFormat(ReportConstants.FileFormat.XLS);
            headers.setContentType(MediaType.parseMediaType((String)"application/vnd.ms-excel"));
            headers.add("content-disposition", "inline;filename=EstimateAbstractReportByDepartmentWise.xls");
        }
        reportOutput = this.reportService.createReport(reportInput);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/typeofworkwise/pdf"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generatePDFTypeOfWorkWise(HttpServletRequest request, @RequestParam(value="adminSanctionFromDate") Date adminSanctionFromDate, @RequestParam(value="adminSanctionToDate") Date adminSanctionToDate, @RequestParam(value="typeOfWork") Long typeOfWork, @RequestParam(value="subTypeOfWork") Long subTypeOfWork, @RequestParam(value="departments") Set<Department> departments, @RequestParam(value="scheme") Integer scheme, @RequestParam(value="subScheme") Integer subScheme, @RequestParam(value="workCategory") String workCategory, @RequestParam(value="beneficiary") String beneficiary, @RequestParam(value="natureOfWork") Long natureOfWork, @RequestParam(value="spillOverFlag") boolean spillOverFlag, @RequestParam(value="contentType") String contentType, HttpSession session) throws IOException {
        EstimateAbstractReport searchRequest = new EstimateAbstractReport();
        SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
        searchRequest.setAdminSanctionFromDate(adminSanctionFromDate);
        searchRequest.setAdminSanctionToDate(adminSanctionToDate);
        searchRequest.setTypeOfWork(typeOfWork);
        searchRequest.setSubTypeOfWork(subTypeOfWork);
        searchRequest.setDepartments(departments);
        searchRequest.setScheme(scheme);
        searchRequest.setSubScheme(subScheme);
        searchRequest.setWorkCategory(workCategory);
        searchRequest.setBeneficiary(beneficiary);
        searchRequest.setNatureOfWork(natureOfWork);
        searchRequest.setSpillOverFlag(spillOverFlag);
        List estimateAbstractReports = this.workProgressRegisterService.searchEstimateAbstractReportByTypeOfWorkWise(searchRequest);
        HashMap<String, String> reportParams = new HashMap<String, String>();
        String queryParameters = this.messageSource.getMessage("msg.estimateabstractreport.by.typeofworkwise", null, null);
        if (spillOverFlag) {
            queryParameters = this.messageSource.getMessage("msg.estimateabstractreport.by.typeofworkwise.for.spillover", null, null);
        }
        if (adminSanctionFromDate != null || adminSanctionToDate != null) {
            queryParameters = queryParameters + "for ";
        }
        if (adminSanctionFromDate != null && adminSanctionToDate != null) {
            queryParameters = queryParameters + this.messageSource.getMessage("msg.daterange", null, null) + sdf.format(adminSanctionFromDate) + " - " + sdf.format(adminSanctionToDate) + ", ";
        }
        if (adminSanctionFromDate != null && adminSanctionToDate == null) {
            queryParameters = queryParameters + this.messageSource.getMessage("msg.adminsanctionfromdate", null, null) + adminSanctionFromDate + ", ";
        }
        if (adminSanctionToDate != null && adminSanctionFromDate == null) {
            queryParameters = queryParameters + this.messageSource.getMessage("msg.adminsanctiontodate", null, null) + adminSanctionToDate + ", ";
        }
        if (typeOfWork != null) {
            queryParameters = queryParameters + this.messageSource.getMessage("msg.typeofwork", null, null) + this.egwTypeOfWorkHibernateDAO.getTypeOfWorkById(typeOfWork).getDescription() + ", ";
        }
        if (subTypeOfWork != null) {
            queryParameters = queryParameters + this.messageSource.getMessage("msg.subtypeofwork", null, null) + this.egwTypeOfWorkHibernateDAO.getTypeOfWorkById(subTypeOfWork).getDescription() + ", ";
        }
        if (departments != null && !departments.toString().equalsIgnoreCase("[null]")) {
            String departmentNames = "";
            for (Department dept : departments) {
                departmentNames = departmentNames + dept.getName() + ",";
            }
            departmentNames = departmentNames.substring(0, departmentNames.length() - 1);
            queryParameters = queryParameters + this.messageSource.getMessage("msg.departments", null, null) + departmentNames + ", ";
        }
        if (scheme != null) {
            queryParameters = queryParameters + this.messageSource.getMessage("msg.scheme", null, null) + ((Scheme)this.schemeService.findById((Serializable)scheme, false)).getName() + ", ";
        }
        if (subScheme != null) {
            queryParameters = queryParameters + this.messageSource.getMessage("msg.subscheme", null, null) + ((SubScheme)this.subSchemeService.findById((Serializable)subScheme, false)).getName() + ", ";
        }
        if (workCategory != null) {
            queryParameters = queryParameters + this.messageSource.getMessage("msg.workcategory", null, null) + workCategory.replace('_', ' ') + ", ";
        }
        if (beneficiary != null) {
            queryParameters = queryParameters + this.messageSource.getMessage("msg.beneficiary", null, null) + beneficiary.replaceAll("_C", "/C").replace("_", " ") + ", ";
        }
        if (natureOfWork != null) {
            queryParameters = queryParameters + this.messageSource.getMessage("msg.natureofwork", null, null) + this.natureOfWorkService.findById(natureOfWork).getName() + ", ";
        }
        if (queryParameters.endsWith(", ")) {
            queryParameters = queryParameters.substring(0, queryParameters.length() - 2);
        }
        reportParams.put("queryParameters", queryParameters);
        return this.generateReportTypeOfWorkWise(estimateAbstractReports, request, session, contentType, departments, reportParams);
    }

    private ResponseEntity<byte[]> generateReportTypeOfWorkWise(List<EstimateAbstractReport> estimateAbstractReports, HttpServletRequest request, HttpSession session, String contentType, Set<Department> departments, Map<String, Object> reportParams) {
        ArrayList<EstimateAbstractReport> estimateAbstractReportPdfList = new ArrayList<EstimateAbstractReport>();
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy hh:mm a");
        String dataRunDate = "";
        ReportRequest reportInput = null;
        ReportOutput reportOutput = null;
        if (estimateAbstractReports != null && !estimateAbstractReports.isEmpty()) {
            for (EstimateAbstractReport eadwr : estimateAbstractReports) {
                EstimateAbstractReport pdf = new EstimateAbstractReport();
                if (eadwr.getDepartmentName() != null) {
                    pdf.setDepartmentName(eadwr.getDepartmentName());
                } else {
                    pdf.setDepartmentName("");
                }
                if (eadwr.getTypeOfWorkName() != null) {
                    pdf.setTypeOfWorkName(eadwr.getTypeOfWorkName());
                } else {
                    pdf.setTypeOfWorkName("");
                }
                if (eadwr.getSubTypeOfWorkName() != null) {
                    pdf.setSubTypeOfWorkName(eadwr.getSubTypeOfWorkName());
                } else {
                    pdf.setSubTypeOfWorkName("");
                }
                if (eadwr.getLineEstimates() != null) {
                    pdf.setLineEstimates(eadwr.getLineEstimates());
                } else {
                    pdf.setLineEstimates(null);
                }
                if (eadwr.getAdminSanctionedEstimates() != null) {
                    pdf.setAdminSanctionedEstimates(eadwr.getAdminSanctionedEstimates());
                } else {
                    pdf.setAdminSanctionedEstimates(null);
                }
                if (eadwr.getAdminSanctionedAmountInCrores() != null) {
                    pdf.setAdminSanctionedAmountInCrores(new BigDecimal(eadwr.getAdminSanctionedAmountInCrores()).setScale(2, 6).toString());
                } else {
                    pdf.setAdminSanctionedAmountInCrores("NA");
                }
                if (eadwr.getTechnicalSanctionedEstimates() != null) {
                    pdf.setTechnicalSanctionedEstimates(eadwr.getTechnicalSanctionedEstimates());
                } else {
                    pdf.setTechnicalSanctionedEstimates(null);
                }
                if (eadwr.getLoaCreated() != null) {
                    pdf.setLoaCreated(eadwr.getLoaCreated());
                } else {
                    pdf.setLoaCreated(null);
                }
                if (eadwr.getAgreementValueInCrores() != null) {
                    pdf.setAgreementValueInCrores(new BigDecimal(eadwr.getAgreementValueInCrores()).setScale(2, 6).toString());
                } else {
                    pdf.setAgreementValueInCrores("NA");
                }
                if (eadwr.getWorkInProgress() != null) {
                    pdf.setWorkInProgress(eadwr.getWorkInProgress());
                } else {
                    pdf.setWorkInProgress(null);
                }
                if (eadwr.getWorkCompleted() != null) {
                    pdf.setWorkCompleted(eadwr.getWorkCompleted());
                } else {
                    pdf.setWorkCompleted(null);
                }
                if (eadwr.getBillsCreated() != null) {
                    pdf.setBillsCreated(eadwr.getBillsCreated());
                } else {
                    pdf.setBillsCreated(null);
                }
                if (eadwr.getBillValueInCrores() != null) {
                    pdf.setBillValueInCrores(new BigDecimal(eadwr.getBillValueInCrores()).setScale(2, 6).toString());
                } else {
                    pdf.setBillValueInCrores("NA");
                }
                dataRunDate = formatter.format(this.workProgressRegisterService.getReportSchedulerRunDate());
                estimateAbstractReportPdfList.add(pdf);
            }
        }
        reportParams.put("heading", this.messageSource.getMessage("msg.estimateabstractreport.by.typeofworkwise", null, null));
        reportParams.put("reportRunDate", formatter.format(new Date()));
        reportParams.put("dataRunDate", dataRunDate);
        reportInput = departments != null && !departments.toString().equalsIgnoreCase("[null]") ? new ReportRequest(this.messageSource.getMessage("msg.estimateabstractreportbytypeofworkwisewithdeptpdf", null, null), estimateAbstractReportPdfList, reportParams) : new ReportRequest(this.messageSource.getMessage("msg.estimateabstractreportbytypeofworkwisepdf", null, null), estimateAbstractReportPdfList, reportParams);
        HttpHeaders headers = new HttpHeaders();
        if (contentType.equalsIgnoreCase("pdf")) {
            reportInput.setReportFormat(ReportConstants.FileFormat.PDF);
            headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
            headers.add("content-disposition", "inline;filename=EstimateAbstractReportByTypeOfWorkWise.pdf");
        } else {
            reportInput.setReportFormat(ReportConstants.FileFormat.XLS);
            headers.setContentType(MediaType.parseMediaType((String)"application/vnd.ms-excel"));
            headers.add("content-disposition", "inline;filename=EstimateAbstractReportByTypeOfWorkWise.xls");
        }
        reportOutput = this.reportService.createReport(reportInput);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

