/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.letterofacceptance;

import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateService;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.utils.WorksUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/letterofacceptance"})
public class ViewLetterOfAcceptanceController {
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private LineEstimateService lineEstimateService;
    @Autowired
    private WorksUtils worksUtils;

    @RequestMapping(value={"/view/{id}"}, method={RequestMethod.GET})
    public String viewLOA(@PathVariable String id, Model model, HttpServletRequest request) throws ApplicationException {
        WorkOrder workOrder = this.letterOfAcceptanceService.getWorkOrderById(Long.valueOf(Long.parseLong(id)));
        LineEstimateDetails lineEstimateDetails = this.lineEstimateService.findByEstimateNumber(workOrder.getEstimateNumber());
        WorkOrder newWorkOrder = this.getWorkOrderDocuments(workOrder);
        model.addAttribute("workOrder", (Object)newWorkOrder);
        model.addAttribute("lineEstimateDetails", (Object)lineEstimateDetails);
        model.addAttribute("mode", (Object)"view");
        return "letterOfAcceptance-view";
    }

    private WorkOrder getWorkOrderDocuments(WorkOrder workOrder) {
        List documentDetailsList = new ArrayList();
        documentDetailsList = this.worksUtils.findByObjectIdAndObjectType(workOrder.getId(), "WorkOrder");
        workOrder.setDocumentDetails(documentDetailsList);
        return workOrder;
    }
}

