/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.letterofacceptance;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import org.egov.works.letterofacceptance.entity.SearchRequestContractor;
import org.egov.works.letterofacceptance.entity.SearchRequestLetterOfAcceptance;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.master.service.ContractorService;
import org.egov.works.milestone.entity.TrackMilestone;
import org.egov.works.milestone.service.TrackMilestoneService;
import org.egov.works.models.masters.Contractor;
import org.egov.works.models.masters.ContractorDetail;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.models.workorder.WorkOrderEstimate;
import org.egov.works.web.adaptor.LetterOfAcceptanceForMilestoneJSONAdaptor;
import org.egov.works.web.adaptor.SearchContractorJsonAdaptor;
import org.egov.works.web.adaptor.SearchLetterOfAcceptanceJsonAdaptor;
import org.egov.works.web.adaptor.SearchLetterOfAcceptanceToCreateContractorBillJson;
import org.egov.works.workorderestimate.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/letterofacceptance"})
public class AjaxLetterOfAcceptanceController {
    @Autowired
    private ContractorService contractorService;
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;
    @Autowired
    private SearchLetterOfAcceptanceJsonAdaptor searchLetterOfAcceptanceJsonAdaptor;
    @Autowired
    private SearchContractorJsonAdaptor searchContractorJsonAdaptor;
    @Autowired
    private SearchLetterOfAcceptanceToCreateContractorBillJson searchLetterOfAcceptanceToCreateContractorBillJson;
    @Autowired
    private LetterOfAcceptanceForMilestoneJSONAdaptor letterOfAcceptanceForMilestoneJSONAdaptor;
    @Autowired
    private TrackMilestoneService trackMilestoneService;
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    @Qualifier(value="messageSource")
    private MessageSource messageSource;

    @RequestMapping(value={"/ajaxcontractors-loa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Contractor> findContractorsByCodeOrName(@RequestParam String name) {
        return this.contractorService.getContractorsByCodeOrName(name);
    }

    @RequestMapping(value={"/ajaxsearch-loa"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxSearch(Model model, @ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        List searchLoaList = this.letterOfAcceptanceService.searchLetterOfAcceptance(searchRequestLetterOfAcceptance);
        String result = "{ \"data\":" + this.toSearchLetterOfAcceptanceJson((Object)searchLoaList) + "}";
        return result;
    }

    public Object toSearchLetterOfAcceptanceJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorkOrder.class, (Object)this.searchLetterOfAcceptanceJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxestimatenumbers"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findEstimateNumbersForLOA(@RequestParam String name) {
        return this.letterOfAcceptanceService.getApprovedEstimateNumbersToModifyLOA(name);
    }

    @RequestMapping(value={"/ajaxloanumber"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findLoaNumbers(@RequestParam String name) {
        return this.letterOfAcceptanceService.getApprovedWorkOrderByNumberToModifyLOA(name);
    }

    @RequestMapping(value={"/ajaxsearchcontractors-loaforcontractorbill"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findLoaContractorforContractorBill(@RequestParam String name) {
        return this.letterOfAcceptanceService.findDistinctContractorsInWorkOrderByCodeOrName(name);
    }

    @RequestMapping(value={"/ajaxsearch-loaforcontractorbill"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxSearchForContractorBill(Model model, @ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        List searchLoaList = this.letterOfAcceptanceService.searchLetterOfAcceptanceForContractorBill(searchRequestLetterOfAcceptance);
        String result = "{ \"data\":" + this.toSearchLetterOfAcceptanceToCreateContractorBillJson((Object)searchLoaList) + "}";
        return result;
    }

    public Object toSearchLetterOfAcceptanceToCreateContractorBillJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorkOrder.class, (Object)this.searchLetterOfAcceptanceToCreateContractorBillJson).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxestimatenumbers-contractorbill"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findEstimateNumbersForContractorBill(@RequestParam String estimateNumber) {
        return this.letterOfAcceptanceService.getApprovedEstimateNumbersForCreateContractorBill(estimateNumber);
    }

    @RequestMapping(value={"/ajaxloanumber-contractorbill"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findLoaNumbersForContractorBill(@RequestParam String workOrderNumber) {
        return this.letterOfAcceptanceService.getApprovedWorkOrdersForCreateContractorBill(workOrderNumber);
    }

    @RequestMapping(value={"/ajaxsearchcontractors-loa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findLoaContractor(@RequestParam String contractorname) {
        return this.letterOfAcceptanceService.getApprovedContractorsForCreateContractorBill(contractorname);
    }

    @RequestMapping(value={"/ajaxvalidate-createcontractorbill"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String validateWorkOrderNumberForCreateContractorBill(@RequestParam(value="workOrderId") Long workOrderId) {
        String message = "";
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateByWorkOrderId(workOrderId);
        TrackMilestone trackMileStone = this.trackMilestoneService.getMinimumPercentageToCreateContractorBill(workOrderEstimate.getId());
        if (trackMileStone == null) {
            message = this.messageSource.getMessage("error.contractorbil.milestone.percentage", null, null);
        } else {
            Boolean nonApprovedBills = this.letterOfAcceptanceService.validateContractorBillInWorkflowForWorkorder(workOrderId);
            if (!nonApprovedBills.booleanValue()) {
                message = this.messageSource.getMessage("error.contractorbill.nonapprovedbills", (Object[])new String[]{workOrderEstimate.getWorkOrder().getWorkOrderNumber()}, null);
            }
        }
        return message;
    }

    @RequestMapping(value={"/ajaxcontractorsbycode-loa"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<Contractor> findContractorsByCode(@RequestParam String name) {
        return this.contractorService.getContractorsByCode(name);
    }

    @RequestMapping(value={"/ajax-contractorsforloa"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxContractorSearch(Model model, @ModelAttribute SearchRequestContractor searchRequestContractor) {
        List contractorDetails = this.letterOfAcceptanceService.searchContractorDetails(searchRequestContractor);
        ArrayList<Contractor> contractors = new ArrayList<Contractor>();
        for (ContractorDetail cd : contractorDetails) {
            if (contractors.contains(cd.getContractor())) continue;
            contractors.add(cd.getContractor());
        }
        String result = "{ \"data\":" + this.toSearchContractorJson(contractors) + "}";
        return result;
    }

    public Object toSearchContractorJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(Contractor.class, (Object)this.searchContractorJsonAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxloanumber-milestone"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findLoaNumbersForMilestone(@RequestParam String workOrderNumber) {
        return this.letterOfAcceptanceService.findLoaWorkOrderNumberForMilestone(workOrderNumber);
    }

    @RequestMapping(value={"/ajaxworkidentificationnumber-milestone"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findworkIdNumbersForLoa(@RequestParam String code) {
        return this.letterOfAcceptanceService.findWorkIdentificationNumbersToCreateMilestone(code);
    }

    @RequestMapping(value={"/ajaxsearch-loaformilestone"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String showSearchLoaToCreateMilestone(@ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        List workOrder = this.letterOfAcceptanceService.getLoaForCreateMilestone(searchRequestLetterOfAcceptance);
        String result = "{ \"data\":" + this.toSearchContractorBillJson((Object)workOrder) + "}";
        return result;
    }

    public Object toSearchContractorBillJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorkOrder.class, (Object)this.letterOfAcceptanceForMilestoneJSONAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxsearch-loatomodify"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String ajaxSearchLoaToModify(Model model, @ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        List searchLoaList = this.letterOfAcceptanceService.searchLetterOfAcceptanceToModify(searchRequestLetterOfAcceptance);
        String result = "{ \"data\":" + this.toSearchLetterOfAcceptanceJson((Object)searchLoaList) + "}";
        return result;
    }

    @RequestMapping(value={"/cancel/ajax-search"}, method={RequestMethod.POST}, produces={"text/plain"})
    @ResponseBody
    public String searchLOAsToCancel(Model model, @ModelAttribute SearchRequestLetterOfAcceptance searchRequestLetterOfAcceptance) {
        List workOrders = this.letterOfAcceptanceService.searchLOAsToCancel(searchRequestLetterOfAcceptance);
        String result = "{ \"data\":" + this.toSearchLOAsToCancelJson((Object)workOrders) + "}";
        return result;
    }

    public Object toSearchLOAsToCancelJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorkOrder.class, (Object)this.searchLetterOfAcceptanceToCreateContractorBillJson).create();
        String json = gson.toJson(object);
        return json;
    }

    @RequestMapping(value={"/ajaxworkidentificationnumbers-loatocancel"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findWorkIdNumbersToCancelLOA(@RequestParam String code) {
        return this.letterOfAcceptanceService.findWorkIdentificationNumbersToSearchLOAToCancel(code);
    }

    @RequestMapping(value={"/ajaxcontractors-loatocancel"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findContractorsToCancelLOA(@RequestParam String code) {
        return this.letterOfAcceptanceService.findContractorsToSearchLOAToCancel(code);
    }

    @RequestMapping(value={"/ajax-checkifbillscreated"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String checkIfBillsCreated(@RequestParam Long id) {
        String billNumbers = this.letterOfAcceptanceService.checkIfBillsCreated(id);
        String message = this.messageSource.getMessage("error.loa.bills.created", (Object[])new String[]{billNumbers}, null);
        if (billNumbers.equals("")) {
            return "";
        }
        return message;
    }

    @RequestMapping(value={"/getworkordernumber-viewestimatephotograph"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findWorkOrderNumbersForViewEstimatePhotograph(@RequestParam String workOrderNumber) {
        return this.letterOfAcceptanceService.getWorkOrderNumbersForViewEstimatePhotograph(workOrderNumber);
    }

    @RequestMapping(value={"/getcontractorname-viewestimatephotograph"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<String> findContractorsNamesForViewEstimatePhotograph(@RequestParam String contractorName) {
        return this.letterOfAcceptanceService.getContractorsNamesForViewEstimatePhotograph(contractorName);
    }
}

