/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.estimatephotograph;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.exception.ApplicationException;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.EstimatePhotographs;
import org.egov.works.abstractestimate.service.EstimatePhotographService;
import org.egov.works.abstractestimate.service.EstimateService;
import org.egov.works.letterofacceptance.service.LetterOfAcceptanceService;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.lineestimate.service.LineEstimateDetailService;
import org.egov.works.models.workorder.WorkOrder;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

@Controller
@RequestMapping(value={"/estimatephotograph"})
public class UploadEstimatePhotographController {
    @Autowired
    private LineEstimateDetailService lineEstimateDetailService;
    @Autowired
    private EstimatePhotographService estimatePhotographService;
    @Autowired
    private EstimateService estimateService;
    @Autowired
    private LetterOfAcceptanceService letterOfAcceptanceService;

    @RequestMapping(value={"/newform"}, method={RequestMethod.GET})
    public String showUploadEstimatePhotographForm(@ModelAttribute(value="estimatePhotographs") EstimatePhotographs estimatePhotographs, Model model, HttpServletRequest request) throws ApplicationException {
        Long lineEstimateDetailsId = Long.valueOf(request.getParameter("lineEstimateDetailsId"));
        List photographsBefore = this.estimatePhotographService.getEstimatePhotographsByEstimatePhotographStageAndLineEstimateDetails(EstimatePhotographs.WorkProgress.BEFORE, lineEstimateDetailsId);
        List photographsAfter = this.estimatePhotographService.getEstimatePhotographsByEstimatePhotographStageAndLineEstimateDetails(EstimatePhotographs.WorkProgress.AFTER, lineEstimateDetailsId);
        List photographsOnProcess = this.estimatePhotographService.getEstimatePhotographsByEstimatePhotographStageAndLineEstimateDetails(EstimatePhotographs.WorkProgress.DURING, lineEstimateDetailsId);
        JsonObject photographStages = new JsonObject();
        JsonArray array = new JsonArray();
        for (EstimatePhotographs ep : photographsBefore) {
            JsonObject before = new JsonObject();
            before.addProperty("name", ep.getFileStore().getFileName());
            before.addProperty("type", "image/jpg");
            before.addProperty("file", "/egi/downloadfile?fileStoreId=" + ep.getFileStore().getFileStoreId() + "&moduleName=WMS");
            before.addProperty("key", (Number)ep.getFileStore().getId());
            array.add((JsonElement)before);
        }
        photographStages.add("before", (JsonElement)array);
        array = new JsonArray();
        for (EstimatePhotographs ep : photographsAfter) {
            JsonObject after = new JsonObject();
            after.addProperty("name", ep.getFileStore().getFileName());
            after.addProperty("type", "image/jpg");
            after.addProperty("file", "/egi/downloadfile?fileStoreId=" + ep.getFileStore().getFileStoreId() + "&moduleName=WMS");
            after.addProperty("key", (Number)ep.getFileStore().getId());
            array.add((JsonElement)after);
        }
        photographStages.add("after", (JsonElement)array);
        array = new JsonArray();
        for (EstimatePhotographs ep : photographsOnProcess) {
            JsonObject during = new JsonObject();
            during.addProperty("name", ep.getFileStore().getFileName());
            during.addProperty("type", "image/jpg");
            during.addProperty("file", "/egi/downloadfile?fileStoreId=" + ep.getFileStore().getFileStoreId() + "&moduleName=WMS");
            during.addProperty("key", (Number)ep.getFileStore().getId());
            array.add((JsonElement)during);
        }
        photographStages.add("during", (JsonElement)array);
        LineEstimateDetails lineEstimateDetails = this.lineEstimateDetailService.getById(lineEstimateDetailsId);
        WorkOrder workOrder = this.letterOfAcceptanceService.getWorkOrderByEstimateNumber(lineEstimateDetails.getEstimateNumber());
        AbstractEstimate abstractEstimate = this.estimateService.getAbstractEstimateByEstimateNumber(lineEstimateDetails.getEstimateNumber());
        model.addAttribute("estimatePhotographs", (Object)estimatePhotographs);
        model.addAttribute("abstractEstimate", (Object)abstractEstimate);
        model.addAttribute("workOrder", (Object)workOrder);
        model.addAttribute("photographStages", (Object)photographStages);
        model.addAttribute("lineEstimateDetails", (Object)lineEstimateDetails);
        model.addAttribute("estimatePhotographTrackStage", (Object)EstimatePhotographs.WorkProgress.values());
        return "estimatePhotographs-form";
    }

    @RequestMapping(value={"/upload/{id}/{estimatephotographstage}"}, method={RequestMethod.POST})
    @ResponseBody
    public String uploadEstimatePhotographForm(@ModelAttribute(value="estimatePhotographs") EstimatePhotographs estimatePhotographs, @RequestParam(value="file[]") MultipartFile[] files, HttpServletRequest request, @PathVariable Long id, @PathVariable String estimatephotographstage) throws IOException {
        LineEstimateDetails lineEstimateDetails = this.lineEstimateDetailService.getById(id);
        List estimatePhotographsList = this.estimatePhotographService.getEstimatePhotographs(files, (Object)lineEstimateDetails);
        JsonArray array = new JsonArray();
        for (EstimatePhotographs ep : estimatePhotographsList) {
            JsonObject child = new JsonObject();
            ep.setDateOfCapture(new Date());
            ep.setLineEstimateDetails(lineEstimateDetails);
            ep.setLatitude(ep.getLatitude());
            ep.setLongitude(ep.getLongitude());
            if (EstimatePhotographs.WorkProgress.BEFORE.toString().equalsIgnoreCase(estimatephotographstage)) {
                ep.setWorkProgress(EstimatePhotographs.WorkProgress.BEFORE);
            } else if (EstimatePhotographs.WorkProgress.AFTER.toString().equalsIgnoreCase(estimatephotographstage)) {
                ep.setWorkProgress(EstimatePhotographs.WorkProgress.AFTER);
            } else {
                ep.setWorkProgress(EstimatePhotographs.WorkProgress.DURING);
            }
            this.estimatePhotographService.save(ep);
            child.addProperty("key", (Number)ep.getFileStore().getId());
            array.add((JsonElement)child);
        }
        return array.toString();
    }

    @RequestMapping(value={"/update/{id}/{estimatephotographstage}/{fileid}"}, method={RequestMethod.POST})
    @ResponseBody
    public String updateEstimatePhotographForm(@ModelAttribute(value="estimatePhotographs") EstimatePhotographs estimatePhotographs, HttpServletRequest request, @PathVariable Long id, @PathVariable String estimatephotographstage, @PathVariable Long fileid) throws IOException {
        EstimatePhotographs photographs = this.estimatePhotographService.getEstimatePhotographByFilestore(fileid);
        this.estimatePhotographService.delete(photographs);
        return "";
    }
}

