/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.controller.dashboard;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.egov.works.elasticsearch.model.WorksIndexsRequest;
import org.egov.works.elasticsearch.model.WorksMilestoneIndexResponse;
import org.egov.works.elasticsearch.service.WorksMilestoneIndexService;
import org.egov.works.elasticsearch.service.WorksTransactionIndexService;
import org.egov.works.web.adaptor.WorksMilestoneIndexJsonAdaptor;
import org.egov.works.web.adaptor.WorksSectorReportJsonAdaptor;
import org.egov.works.web.adaptor.WorksTransactionIndexJsonAdaptor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/public/worksdashboard"})
public class StateLevelDashboardController {
    private static final String DATA = "{ \"data\":";
    private static final Logger LOGGER = LoggerFactory.getLogger(StateLevelDashboardController.class);
    @Autowired
    private WorksMilestoneIndexService worksMilestoneIndexService;
    @Autowired
    private WorksTransactionIndexService worksTransactionIndexService;
    @Autowired
    private WorksMilestoneIndexJsonAdaptor worksMilestoneIndexJsonAdaptor;
    @Autowired
    private WorksTransactionIndexJsonAdaptor worksTransactionIndexJsonAdaptor;
    @Autowired
    private WorksSectorReportJsonAdaptor worksSectorReportJsonAdaptor;

    @RequestMapping(value={"/statewisetypeofwork"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getStateWiseTypeOfWorkDetails() throws IOException {
        WorksIndexsRequest worksIndexsRequest = new WorksIndexsRequest();
        Long startTime = System.currentTimeMillis();
        worksIndexsRequest.setReportType("SECTOR");
        List resultList = this.worksMilestoneIndexService.getAggregationResults(worksIndexsRequest, "lineestimatetypeofworkname");
        String result = DATA + this.toMilestoneJson((Object)resultList) + "}";
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve getStateWiseTypeOfWorkDetails is : " + timeTaken + " (millisecs)");
        }
        return result;
    }

    @RequestMapping(value={"/districtwise-bytypeofwork"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getDistrictWiseByTypeOfWork(@RequestParam(value="typeofwork") String typeofwork) throws IOException {
        WorksIndexsRequest worksIndexsRequest = new WorksIndexsRequest();
        worksIndexsRequest.setTypeofwork(typeofwork);
        worksIndexsRequest.setReportType("District Name");
        Long startTime = System.currentTimeMillis();
        List resultList = this.worksMilestoneIndexService.getAggregationResults(worksIndexsRequest, "distname");
        String result = DATA + this.toMilestoneJson((Object)resultList) + "}";
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve getDistrictWiseDistrictDetails is : " + timeTaken + " (millisecs)");
        }
        return result;
    }

    @RequestMapping(value={"/ulbwise-bytypeofwork"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getUlbWiseByTypeOfWork(@RequestParam(value="typeofwork") String typeofwork) throws IOException {
        WorksIndexsRequest worksIndexsRequest = new WorksIndexsRequest();
        worksIndexsRequest.setTypeofwork(typeofwork);
        worksIndexsRequest.setReportType("ULB Name");
        Long startTime = System.currentTimeMillis();
        List resultList = this.worksMilestoneIndexService.getAggregationResults(worksIndexsRequest, "ulbname");
        String result = DATA + this.toMilestoneJson((Object)resultList) + "}";
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve getUlbWiseDistrictDetails is : " + timeTaken + " (millisecs)");
        }
        return result;
    }

    @RequestMapping(value={"/ulbwise-bydistrictandtypeofwork"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getUlbWiseByDistrictAndTypeOfWork(@RequestParam(value="typeofwork") String typeofwork, @RequestParam(value="districtname") String districtname) throws IOException {
        WorksIndexsRequest worksIndexsRequest = new WorksIndexsRequest();
        worksIndexsRequest.setTypeofwork(typeofwork);
        worksIndexsRequest.setDistname(districtname);
        worksIndexsRequest.setReportType("ULB Name");
        Long startTime = System.currentTimeMillis();
        List resultList = this.worksMilestoneIndexService.getAggregationResults(worksIndexsRequest, "ulbname");
        String result = DATA + this.toMilestoneJson((Object)resultList) + "}";
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve getUlbWiseByDistrictAndTypeOfWork is : " + timeTaken + " (millisecs)");
        }
        return result;
    }

    @RequestMapping(value={"/ulbwise-bytypeofworkandulbs"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getUlbWiseByTypeOfWorkAndUlbs(@RequestParam(value="typeofwork") String typeofwork, @RequestParam(value="ulbcodes") String ulbcodes) throws IOException {
        WorksIndexsRequest worksIndexsRequest = new WorksIndexsRequest();
        worksIndexsRequest.setTypeofwork(typeofwork);
        worksIndexsRequest.setUlbcodes(Arrays.asList(ulbcodes.split(",")));
        worksIndexsRequest.setReportType("ULB Name");
        Long startTime = System.currentTimeMillis();
        List resultList = this.worksMilestoneIndexService.getAggregationResults(worksIndexsRequest, "ulbname");
        String result = DATA + this.toMilestoneJson((Object)resultList) + "}";
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve getUlbWiseByTypeOfWorkAndUlbs is : " + timeTaken + " (millisecs)");
        }
        return result;
    }

    @RequestMapping(value={"/statewiseulb"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getStateWiseULBDetails(@RequestParam(value="typeofwork") String typeofwork, @RequestParam(value="ulbname") String ulbname) throws IOException {
        WorksIndexsRequest worksIndexsRequest = new WorksIndexsRequest();
        Long startTime = System.currentTimeMillis();
        worksIndexsRequest.setTypeofwork(typeofwork);
        worksIndexsRequest.setUlbname(ulbname);
        List resultList = this.worksTransactionIndexService.getWorksTransactionDetails(worksIndexsRequest);
        ArrayList<Integer> lineestimatedetailids = new ArrayList<Integer>();
        for (WorksMilestoneIndexResponse response : resultList) {
            lineestimatedetailids.add(response.getLineestimatedetailid());
        }
        worksIndexsRequest.setUlbname(ulbname);
        worksIndexsRequest.setLineestimatedetailids(lineestimatedetailids);
        resultList = this.worksMilestoneIndexService.getAggregationResultsForUlb(worksIndexsRequest, resultList);
        String result = DATA + this.toTransactionJson((Object)resultList) + "}";
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve getStateWiseULBDetails is : " + timeTaken + " (millisecs)");
        }
        return result;
    }

    @RequestMapping(value={"/sectorwisereport"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getSectorWiseULBDetails() throws IOException {
        ArrayList finalResultList = new ArrayList();
        WorksIndexsRequest worksIndexsRequest = new WorksIndexsRequest();
        Long startTime = System.currentTimeMillis();
        List resultList = this.worksTransactionIndexService.getWorksTransactionDetails(worksIndexsRequest);
        HashMap ulbNameWiseMap = new HashMap();
        for (WorksMilestoneIndexResponse response : resultList) {
            if (ulbNameWiseMap.get(response.getUlbname()) != null) {
                ((List)ulbNameWiseMap.get(response.getUlbname())).add(response);
                continue;
            }
            ulbNameWiseMap.put(response.getUlbname(), new ArrayList());
            ((List)ulbNameWiseMap.get(response.getUlbname())).add(response);
        }
        for (String key : ulbNameWiseMap.keySet()) {
            ArrayList<Integer> lineestimatedetailids = new ArrayList<Integer>();
            for (WorksMilestoneIndexResponse response : (List)ulbNameWiseMap.get(key)) {
                lineestimatedetailids.add(response.getLineestimatedetailid());
            }
            worksIndexsRequest.setUlbname(key);
            worksIndexsRequest.setLineestimatedetailids(lineestimatedetailids);
            resultList = this.worksMilestoneIndexService.getAggregationResultsForUlb(worksIndexsRequest, (List)ulbNameWiseMap.get(key));
            finalResultList.addAll(resultList);
        }
        String result = DATA + this.toSectorReportJson(finalResultList) + "}";
        Long timeTaken = System.currentTimeMillis() - startTime;
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Time taken to serve getSectorWiseULBDetails is : " + timeTaken + " (millisecs)");
        }
        return result;
    }

    public Object toMilestoneJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorksMilestoneIndexResponse.class, (Object)this.worksMilestoneIndexJsonAdaptor).create();
        return gson.toJson(object);
    }

    public Object toTransactionJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorksMilestoneIndexResponse.class, (Object)this.worksTransactionIndexJsonAdaptor).create();
        return gson.toJson(object);
    }

    public Object toSectorReportJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(WorksMilestoneIndexResponse.class, (Object)this.worksSectorReportJsonAdaptor).create();
        return gson.toJson(object);
    }
}

