/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.adaptor;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import org.egov.works.lineestimate.entity.LineEstimateDetails;
import org.egov.works.milestone.entity.TrackMilestone;
import org.egov.works.milestone.service.TrackMilestoneService;
import org.egov.works.models.workorder.WorkOrderEstimate;
import org.egov.works.workorderestimate.service.WorkOrderEstimateService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class ViewEstimatePhotographJsonAdaptor
implements JsonSerializer<LineEstimateDetails> {
    @Autowired
    private WorkOrderEstimateService workOrderEstimateService;
    @Autowired
    private TrackMilestoneService trackMilestoneService;

    public JsonElement serialize(LineEstimateDetails lineEstimateDetails, Type type, JsonSerializationContext jsc) {
        WorkOrderEstimate workOrderEstimate = this.workOrderEstimateService.getWorkOrderEstimateByEstimateNumber(lineEstimateDetails.getEstimateNumber());
        JsonObject jsonObject = new JsonObject();
        if (lineEstimateDetails != null) {
            if (lineEstimateDetails.getProjectCode() != null) {
                jsonObject.addProperty("winCode", lineEstimateDetails.getProjectCode().getCode());
            } else {
                jsonObject.addProperty("winCode", "NA");
            }
            if (lineEstimateDetails.getNameOfWork() != null) {
                jsonObject.addProperty("nameOfWork", lineEstimateDetails.getNameOfWork());
            } else {
                jsonObject.addProperty("nameOfWork", "");
            }
            if (lineEstimateDetails.getEstimateAmount() != null) {
                jsonObject.addProperty("estimateAmount", (Number)lineEstimateDetails.getEstimateAmount());
            } else {
                jsonObject.addProperty("estimateAmount", "");
            }
            if (workOrderEstimate != null) {
                jsonObject.addProperty("workOrderNumber", workOrderEstimate.getWorkOrder().getWorkOrderNumber());
                jsonObject.addProperty("contractorName", workOrderEstimate.getWorkOrder().getContractor().getName());
            } else {
                jsonObject.addProperty("workOrderNumber", "NA");
                jsonObject.addProperty("contractorName", "NA");
                jsonObject.addProperty("workCompletion", "NA");
            }
            if (workOrderEstimate != null) {
                TrackMilestone trackMilestone = this.trackMilestoneService.getTrackMilestoneTotalPercentage(workOrderEstimate.getId());
                if (trackMilestone != null) {
                    jsonObject.addProperty("workCompletion", (Number)trackMilestone.getTotalPercentage());
                } else {
                    jsonObject.addProperty("workCompletion", "NA");
                }
            }
            jsonObject.addProperty("lineEstimateDetailsId", (Number)lineEstimateDetails.getId());
        }
        return jsonObject;
    }
}

