/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.tender;

import java.io.Serializable;
import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.apache.struts2.convention.annotation.Action;
import org.apache.struts2.convention.annotation.ParentPackage;
import org.apache.struts2.convention.annotation.Result;
import org.apache.struts2.interceptor.validation.SkipValidation;
import org.egov.commons.CFinancialYear;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.eis.entity.Assignment;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.validation.exception.ValidationError;
import org.egov.infra.validation.exception.ValidationException;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infra.web.struts.annotation.ValidationErrorPage;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.infra.workflow.entity.WorkflowAction;
import org.egov.infra.workflow.service.WorkflowService;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.egov.infstr.services.PersistenceService;
import org.egov.pims.model.PersonalInformation;
import org.egov.pims.service.EisUtilService;
import org.egov.pims.service.EmployeeServiceOld;
import org.egov.pims.service.PersonalInformationService;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.abstractestimate.entity.Activity;
import org.egov.works.models.masters.Contractor;
import org.egov.works.models.tender.NegotiationNumberGenerator;
import org.egov.works.models.tender.OfflineStatus;
import org.egov.works.models.tender.TenderEstimate;
import org.egov.works.models.tender.TenderHeader;
import org.egov.works.models.tender.TenderResponse;
import org.egov.works.models.tender.TenderResponseActivity;
import org.egov.works.models.tender.TenderResponseContractors;
import org.egov.works.models.tender.TenderResponseQuotes;
import org.egov.works.models.tender.WorksPackage;
import org.egov.works.models.workorder.WorkOrder;
import org.egov.works.services.AbstractEstimateService;
import org.egov.works.services.TenderResponseService;
import org.egov.works.services.WorksPackageService;
import org.egov.works.services.WorksService;
import org.egov.works.utils.DateConversionUtil;
import org.egov.works.web.actions.estimate.AjaxEstimateAction;
import org.egov.works.web.actions.tender.AjaxTenderNegotiationAction;
import org.springframework.beans.factory.annotation.Autowired;

@ParentPackage(value="egov")
@Result(name={"new"}, location="tenderNegotiation-new.jsp")
public class TenderNegotiationAction
extends SearchFormAction {
    private static final long serialVersionUID = 1705982410378688424L;
    private static final Logger logger = Logger.getLogger(TenderNegotiationAction.class);
    private TenderResponseService tenderResponseService;
    private PersistenceService<TenderHeader, Long> tenderHeaderService;
    private AbstractEstimateService abstractEstimateService;
    private NegotiationNumberGenerator negotiationNumberGenerator;
    private TenderResponse tenderResponse = new TenderResponse();
    private AbstractEstimate abstractEstimate;
    private WorksPackage worksPackage;
    private TenderHeader tenderHeader = new TenderHeader();
    private TenderEstimate tenderEstimate = new TenderEstimate();
    private WorkflowService<TenderResponse> workflowService;
    private WorksPackageService workspackageService;
    private String messageKey;
    private String designation;
    private Long estimateId;
    private Long worksPackageId;
    private String tenderType;
    @Autowired
    private EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    private UserService userService;
    private static final String PREPARED_BY_LIST = "preparedByList";
    private static final String DEPARTMENT_LIST = "departmentList";
    private List<TenderResponseActivity> actionTenderResponseActivities = new LinkedList();
    private List<TenderResponseContractors> actionTenderResponseContractors = new LinkedList();
    @Autowired
    private DepartmentService departmentService;
    private static final String OBJECT_TYPE = "TenderResponseContractors";
    private PersonalInformationService personalInformationService;
    private Long contractorId;
    private String negotiationNumber;
    private String negoNumber;
    private Date negotiationDate;
    private String wpYear;
    private Long deptId;
    private Integer departmentId;
    private String estimateNumber;
    private String projectCode;
    private String tenderSource;
    private String mode;
    private String status;
    private WorksService worksService;
    private String employeeName;
    private String designationNegotiation;
    private static final String SAVE_ACTION = "save";
    private static final String SOURCE_INBOX = "inbox";
    private static final String VALIDATION_PREPAREDBY = "tenderResponse.negotiationPreparedBy";
    private static final String VALIDATION_PREPAREDBY_ERROR = "tenderResponse.negotiationPreparedBy.null";
    private static final String ACTION_NAME = "actionName";
    private String sourcepage = "";
    @Autowired
    private AssignmentService assignmentService;
    @Autowired
    private EmployeeServiceOld employeeServiceOld;
    private String nsActionName;
    private String option;
    private Integer negotiationStatusId;
    private Integer negotiationStatusApprovedById;
    private Long tenderRespId;
    private Date approvedDateHidden;
    public static final String APPROVED = "APPROVED";
    public static final String REJECTED = "REJECTED";
    public static final String NEWNs = "NEW";
    private String errorType = "";
    private WorkOrder workOrder = new WorkOrder();
    public static final String TENDERRESPONSE_CONTRACTOR = "tenderResponse.contractor";
    public static final String TENDERRESPONSE_CONTRACTOR_NULL = "tenderResponse.contractor.null";
    private Integer statusIdValue;
    private String currentApproverName;
    private String currentStatus;
    private Date currentApprovedDate;
    private String currentApprovedDateStr = "";
    private static final String SOURCE_SEARCH = "search";
    private final DecimalFormat formatter = new DecimalFormat("0.00");
    private String createdBySelection = "no";
    private String editableDate = "yes";
    private Double emdAmountDeposited;
    private Double securityDeposit;
    private Double labourWelfareFund;
    private Integer workOrderInchargeId;
    private String setStatus;
    private String wpNumber;
    private Date fromDate;
    private Date toDate;
    private String tenderCretedBy;
    private String tenderFileNumber;
    private Double sorPerDiff;
    private OfflineStatus setStatusObj = new OfflineStatus();
    private static final String TENDER_ACCEPTANCE_NOTE = "acceptanceNote";
    private PersistenceService<Contractor, Long> contractorService;
    private static final String CONTRACTOR_LIST = "contractorList";
    private List<String> tenderTypeList;
    private PersistenceService<OfflineStatus, Long> worksStatusService;
    private static final String STATUS_OBJECTID = "getStatusDateByObjectId_Type_Desc";
    private static final String SEARCH_NEGOTIATION_FOR_WO = "searchNegotiationForWO";
    private String cancellationReason;
    private String cancelRemarks;
    private String loggedInUserEmployeeCode;
    private EisUtilService eisService;
    private Map<String, String> tenderInvitationTypeMap = new LinkedHashMap();
    private Long id;

    public TenderResponse getTenderResponse() {
        return this.tenderResponse;
    }

    public Double getEmdAmountDeposited() {
        if (this.emdAmountDeposited == null) {
            this.emdAmountDeposited = new Double("0.0");
        }
        return this.emdAmountDeposited;
    }

    public void setEmdAmountDeposited(Double emdAmountDeposited) {
        this.emdAmountDeposited = emdAmountDeposited;
    }

    public Double getSecurityDeposit() {
        if (this.securityDeposit == null) {
            try {
                this.securityDeposit = new Double(this.worksService.getWorksConfigValue("SECURITY_DEPOSIT_MULTIPLIER")) / 100.0 * this.abstractEstimate.getWorkValueIncludingTaxes().getValue();
                this.securityDeposit = new Double(this.formatter.format(this.securityDeposit));
            }
            catch (Exception e) {
                this.securityDeposit = 0.0;
                logger.info((Object)("exception " + e));
            }
        }
        return this.securityDeposit;
    }

    public void setSecurityDeposit(Double securityDeposit) {
        this.securityDeposit = securityDeposit;
    }

    protected PersonalInformation getEmployee() {
        if (this.tenderResponse.getNegotiationPreparedBy() == null) {
            return this.employeeServiceOld.getEmpForUserId(this.worksService.getCurrentLoggedInUserId());
        }
        return this.tenderResponse.getNegotiationPreparedBy();
    }

    public Double getLabourWelfareFund() {
        if (this.labourWelfareFund == null) {
            try {
                this.labourWelfareFund = new Double(this.worksService.getWorksConfigValue("LWF_MULTIPLIER")) / 100.0 * this.abstractEstimate.getWorkValueIncludingTaxes().getValue();
                this.labourWelfareFund = new Double(this.formatter.format(this.labourWelfareFund));
            }
            catch (Exception e) {
                this.labourWelfareFund = 0.0;
                logger.info((Object)("exception " + e));
            }
        }
        return this.labourWelfareFund;
    }

    public void setLabourWelfareFund(Double labourWelfareFund) {
        this.labourWelfareFund = labourWelfareFund;
    }

    public TenderNegotiationAction() {
        this.addRelatedEntity("contractor", Contractor.class);
        this.addRelatedEntity("negotiationPreparedBy", PersonalInformation.class);
    }

    @SkipValidation
    public String edit() {
        if (SOURCE_INBOX.equalsIgnoreCase(this.sourcepage)) {
            User user;
            boolean isValidUser;
            if (this.userService != null && (isValidUser = this.worksService.validateWorkflowForUser((StateAware)this.tenderResponse, user = this.userService.getUserById(this.worksService.getCurrentLoggedInUserId())))) {
                throw new ApplicationRuntimeException("Error: Invalid Owner - No permission to view this page.");
            }
        } else if (StringUtils.isEmpty((String)this.sourcepage)) {
            this.sourcepage = SOURCE_SEARCH;
        }
        if (SOURCE_INBOX.equals(this.getSourcepage())) {
            if (this.tenderResponse.getTenderEstimate().getAbstractEstimate() != null) {
                this.abstractEstimate = (AbstractEstimate)this.abstractEstimateService.findById((Serializable)this.tenderResponse.getTenderEstimate().getAbstractEstimate().getId(), false);
            }
            if (this.tenderResponse.getTenderEstimate().getWorksPackage() != null) {
                this.worksPackage = (WorksPackage)this.workspackageService.findById((Serializable)this.tenderResponse.getTenderEstimate().getWorksPackage().getId(), false);
            }
            this.tenderHeader = (TenderHeader)this.tenderHeaderService.findById((Serializable)this.tenderResponse.getTenderEstimate().getTenderHeader().getId(), false);
            this.tenderType = this.tenderResponse.getTenderEstimate().getTenderType();
        }
        if (this.getAssignment(this.tenderResponse.getNegotiationPreparedBy()) != null) {
            this.setDesignationNegotiation(this.getAssignment(this.tenderResponse.getNegotiationPreparedBy()).getDesignation().getName());
            this.setDeptId(this.getAssignment(this.tenderResponse.getNegotiationPreparedBy()).getDepartment().getId());
        }
        ArrayList<Contractor> contractorList = new ArrayList<Contractor>();
        for (TenderResponseContractors tenderResponseContractors : this.tenderResponse.getTenderResponseContractors()) {
            contractorList.add(tenderResponseContractors.getContractor());
        }
        this.addDropdownData(CONTRACTOR_LIST, contractorList);
        return "edit";
    }

    @ValidationErrorPage(value="searchNegotiationPage")
    public String searchNegotiation() {
        return "searchNegotiationPage";
    }

    public Object getModel() {
        return this.tenderResponse;
    }

    public void prepare() {
        Assignment latestAssignment;
        AjaxTenderNegotiationAction ajaxTenderNegotiationAction = new AjaxTenderNegotiationAction();
        ajaxTenderNegotiationAction.setPersistenceService(this.getPersistenceService());
        ajaxTenderNegotiationAction.setAssignmentService(this.assignmentService);
        ajaxTenderNegotiationAction.setPersonalInformationService(this.personalInformationService);
        AjaxEstimateAction ajaxEstimateAction = new AjaxEstimateAction();
        ajaxEstimateAction.setPersistenceService(this.getPersistenceService());
        ajaxEstimateAction.setAssignmentService(this.assignmentService);
        ajaxEstimateAction.setAbstractEstimateService(this.abstractEstimateService);
        ajaxEstimateAction.setEisService(this.eisService);
        this.tenderResponseService.setPersonalInformationService(this.personalInformationService);
        if (StringUtils.isNotBlank((String)this.getPastDate())) {
            this.setEditableDate(this.getPastDate());
        }
        if (this.negoNumber != null && StringUtils.isNotBlank((String)this.negoNumber)) {
            this.tenderResponse = (TenderResponse)this.tenderResponseService.find("from TenderResponse tr where tr.negotiationNumber =? and tr.egwStatus.code = 'APPROVED'", new Object[]{this.negoNumber});
            this.id = this.tenderResponse.getId();
            this.tenderHeader = this.tenderResponse.getTenderEstimate().getTenderHeader();
            this.worksPackageId = this.tenderResponse.getTenderEstimate().getWorksPackage().getId();
        }
        if (this.estimateId != null) {
            this.abstractEstimate = (AbstractEstimate)this.abstractEstimateService.findById((Serializable)this.estimateId, false);
        }
        if (this.worksPackageId != null) {
            this.worksPackage = (WorksPackage)this.workspackageService.findById((Serializable)this.worksPackageId, false);
            String status = this.worksService.getWorksConfigValue("WORKSPACKAGE_STATUS");
            String objType = this.getTenderSource();
            if (objType != null && objType.equals("package")) {
                objType = "WorksPackage";
            }
            Long objId = this.getWorksPackageId();
            if (StringUtils.isNotBlank((String)status)) {
                this.setStatusObj = (OfflineStatus)this.getPersistenceService().findByNamedQuery(STATUS_OBJECTID, new Object[]{objId, objType, status});
                if (this.setStatusObj != null) {
                    this.tenderHeader.setTenderDate(this.setStatusObj.getStatusDate());
                }
            }
        }
        if (this.id != null) {
            this.tenderResponse = (TenderResponse)this.tenderResponseService.findById((Serializable)this.id, false);
            this.tenderHeader = (TenderHeader)this.tenderHeaderService.findById((Serializable)this.tenderHeader.getId(), false);
            if (this.mode != null && (this.mode.equalsIgnoreCase("view") || this.mode.equalsIgnoreCase(SOURCE_SEARCH))) {
                this.tenderType = this.tenderResponse.getTenderEstimate().getTenderType();
            }
            if (this.tenderResponse.getTenderEstimate().getAbstractEstimate() != null) {
                this.setTenderSource("estimate");
            }
            if (this.tenderResponse.getTenderEstimate().getWorksPackage() != null) {
                this.setTenderSource("package");
            }
        }
        if ((latestAssignment = this.abstractEstimateService.getLatestAssignmentForCurrentLoginUser()) != null) {
            this.tenderResponse.setWorkflowDepartmentId(this.abstractEstimateService.getLatestAssignmentForCurrentLoginUser().getDepartment().getId());
            if (this.tenderResponse.getNegotiationPreparedBy() == null) {
                this.setDesignationNegotiation(latestAssignment.getDesignation().getName());
                this.loggedInUserEmployeeCode = latestAssignment.getEmployee().getCode();
            } else {
                this.loggedInUserEmployeeCode = this.tenderResponse.getNegotiationPreparedBy().getEmployeeCode();
            }
        }
        if (StringUtils.isNotBlank((String)this.getCreatedBy()) && "yes".equalsIgnoreCase(this.getCreatedBy())) {
            this.setCreatedBySelection(this.getCreatedBy());
            this.addDropdownData(DEPARTMENT_LIST, this.departmentService.getAllDepartments());
            this.populatePreparedByList(ajaxEstimateAction, this.deptId != null);
        } else {
            if (this.id != null) {
                this.worksPackage = this.tenderResponse.getTenderEstimate().getWorksPackage();
            }
            if (this.worksPackage != null) {
                this.addDropdownData(DEPARTMENT_LIST, Arrays.asList(this.worksPackage.getDepartment()));
                this.populatePreparedByList(ajaxEstimateAction, this.worksPackage.getDepartment().getId() != null);
                this.tenderResponse.setNegotiationPreparedBy(this.getEmployee());
            }
        }
        List departmentList = this.departmentService.getAllDepartments();
        if (this.sourcepage != null && this.sourcepage.equalsIgnoreCase(SEARCH_NEGOTIATION_FOR_WO)) {
            this.addDropdownData("searchDepartmentList", this.worksService.getAllDeptmentsForLoggedInUser());
        } else {
            this.addDropdownData("searchDepartmentList", departmentList);
        }
        super.prepare();
        this.setupDropdownDataExcluding(new String[]{"contractor", "negotiationPreparedBy", ""});
        this.addDropdownData("executingDepartmentList", departmentList);
        this.tenderTypeList = this.worksService.getTendertypeList();
        this.addDropdownData("tenderTypeList", this.tenderTypeList);
        if (StringUtils.isNotBlank((String)this.worksService.getWorksConfigValue("SOR_PERCENTAGE_DIFF"))) {
            this.sorPerDiff = Double.valueOf(this.worksService.getWorksConfigValue("SOR_PERCENTAGE_DIFF"));
        }
        this.setTenderCretedBy(this.worksService.getWorksConfigValue("ESTIMATE_OR_WP_SEARCH_REQ"));
        ArrayList<Contractor> contractorList = new ArrayList<Contractor>();
        for (TenderResponseContractors tenderResponseContractors : this.tenderResponseService.getActionTenderResponseContractorsList(this.actionTenderResponseContractors)) {
            contractorList.add(tenderResponseContractors.getContractor());
        }
        this.addDropdownData(CONTRACTOR_LIST, contractorList);
    }

    protected void populatePreparedByList(AjaxEstimateAction ajaxEstimateAction, boolean departID) {
        if (departID) {
            ajaxEstimateAction.setExecutingDepartment(this.worksPackage.getDepartment().getId());
            if (StringUtils.isNotBlank((String)this.loggedInUserEmployeeCode)) {
                ajaxEstimateAction.setEmployeeCode(this.loggedInUserEmployeeCode);
            }
            ajaxEstimateAction.usersInExecutingDepartment();
            this.addDropdownData(PREPARED_BY_LIST, ajaxEstimateAction.getUsersInExecutingDepartment());
        } else {
            this.addDropdownData(PREPARED_BY_LIST, Collections.EMPTY_LIST);
        }
    }

    public String execute() {
        return "success";
    }

    @SkipValidation
    @Action(value="/tender/tenderNegotiation-newform")
    public String newform() {
        this.setDeptId(this.worksPackage.getDepartment().getId());
        return "new";
    }

    protected Assignment getAssignment(PersonalInformation pi) {
        if (this.tenderResponse.getNegotiationPreparedBy() == null) {
            return this.employeeServiceOld.getAssignmentByEmpAndDate(new Date(), pi.getIdPersonalInformation());
        }
        return this.employeeServiceOld.getAssignmentByEmpAndDate(new Date(), this.tenderResponse.getNegotiationPreparedBy().getIdPersonalInformation());
    }

    public String getCreatedBy() {
        return this.worksService.getWorksConfigValue("TENDER_NEGOTIATION_CREATED_BY_SELECTION");
    }

    public String getPastDate() {
        return this.worksService.getWorksConfigValue("TENDER_NEGOTIATION_DATE_SELECTION");
    }

    private boolean validTenderDate() {
        if (this.abstractEstimate != null) {
            return this.abstractEstimate != null && this.tenderHeader != null && this.tenderHeader.getTenderDate() != null && this.abstractEstimate.getCurrentState().getCreatedDate() != null && this.abstractEstimate.getCurrentState().getValue().equalsIgnoreCase("END") && !DateConversionUtil.isBeforeByDate((Date)this.tenderHeader.getTenderDate(), (Date)this.abstractEstimate.getCurrentState().getCreatedDate()) && !DateConversionUtil.isBeforeByDate((Date)new Date(), (Date)this.tenderHeader.getTenderDate());
        }
        if (this.worksPackage != null) {
            return this.worksPackage != null && this.tenderHeader != null && this.tenderHeader.getTenderDate() != null && this.worksPackage.getCurrentState().getCreatedDate() != null && this.worksPackage.getEgwStatus().getCode().equalsIgnoreCase(WorksPackage.WorkPacakgeStatus.APPROVED.toString()) && !DateConversionUtil.isBeforeByDate((Date)this.tenderHeader.getTenderDate(), (Date)this.worksPackage.getWpDate()) && !DateConversionUtil.isBeforeByDate((Date)new Date(), (Date)this.tenderHeader.getTenderDate());
        }
        return Boolean.TRUE;
    }

    public String save() {
        if (this.tenderResponse != null && (this.tenderResponse.getEgwStatus() == null || "new".equalsIgnoreCase(this.tenderResponse.getEgwStatus().getCode()) || REJECTED.equalsIgnoreCase(this.tenderResponse.getEgwStatus().getCode()))) {
            this.tenderResponse.getTenderResponseContractors().clear();
        }
        this.actionTenderResponseContractors = (List)this.tenderResponseService.getActionTenderResponseContractorsList(this.actionTenderResponseContractors);
        if (!(this.tenderResponse == null || this.actionTenderResponseContractors.isEmpty() || this.actionTenderResponseContractors.get(0) == null || ((TenderResponseContractors)this.actionTenderResponseContractors.get(0)).getContractor() == null || ((TenderResponseContractors)this.actionTenderResponseContractors.get(0)).getContractor().getId() != null && ((TenderResponseContractors)this.actionTenderResponseContractors.get(0)).getContractor().getId() != 0L && ((TenderResponseContractors)this.actionTenderResponseContractors.get(0)).getContractor().getId() != -1L)) {
            throw new ValidationException(Arrays.asList(new ValidationError(TENDERRESPONSE_CONTRACTOR, TENDERRESPONSE_CONTRACTOR_NULL)));
        }
        if (this.tenderResponse != null && !this.actionTenderResponseContractors.isEmpty() && this.actionTenderResponseContractors.get(0) != null && ((TenderResponseContractors)this.actionTenderResponseContractors.get(0)).getContractor() == null) {
            throw new ValidationException(Arrays.asList(new ValidationError(TENDERRESPONSE_CONTRACTOR, TENDERRESPONSE_CONTRACTOR_NULL)));
        }
        if (!this.validTenderDate()) {
            if (this.abstractEstimate != null) {
                throw new ValidationException(Arrays.asList(new ValidationError("tenderHeader.tenderDate.invalid", "tenderHeader.tenderDate.invalid")));
            }
            if (this.worksPackage != null) {
                throw new ValidationException(Arrays.asList(new ValidationError("tenderHeader.tenderDate.workspackage.invalid", "tenderHeader.tenderDate.workspackage.invalid")));
            }
        }
        if (this.validTenderNo()) {
            throw new ValidationException(Arrays.asList(new ValidationError("tenderHeader.tenderNo.isunique", "tenderHeader.tenderNo.isunique")));
        }
        if (this.tenderResponse != null && this.tenderResponse.getNegotiationPreparedBy() != null && (this.tenderResponse.getNegotiationPreparedBy().getIdPersonalInformation() == null || this.tenderResponse.getNegotiationPreparedBy().getIdPersonalInformation() == 0 || this.tenderResponse.getNegotiationPreparedBy().getIdPersonalInformation() == -1)) {
            logger.info((Object)"2--- inside save and validation err");
            throw new ValidationException(Arrays.asList(new ValidationError(VALIDATION_PREPAREDBY, VALIDATION_PREPAREDBY_ERROR)));
        }
        if (this.tenderResponse != null && this.tenderResponse.getNegotiationPreparedBy() == null) {
            logger.info((Object)"3--- inside save and validation err");
            throw new ValidationException(Arrays.asList(new ValidationError(VALIDATION_PREPAREDBY, VALIDATION_PREPAREDBY_ERROR)));
        }
        CFinancialYear financialYear = null;
        if (this.tenderResponse != null) {
            financialYear = this.abstractEstimateService.getCurrentFinancialYear(this.tenderResponse.getNegotiationDate());
            if (this.tenderResponse.getEgwStatus() == null || REJECTED.equalsIgnoreCase(this.tenderResponse.getEgwStatus().getCode()) || "new".equalsIgnoreCase(this.tenderResponse.getEgwStatus().getCode())) {
                this.tenderResponse.getTenderResponseActivities().clear();
            }
        }
        if (this.tenderResponse.getEgwStatus() == null || REJECTED.equalsIgnoreCase(this.tenderResponse.getEgwStatus().getCode()) || "new".equalsIgnoreCase(this.tenderResponse.getEgwStatus().getCode())) {
            this.populateTenderResponseContractors();
            this.populateTenderResponseActivities();
        }
        ArrayList<Contractor> contractorList = new ArrayList<Contractor>();
        for (TenderResponseContractors tenderResponseContractors : this.tenderResponse.getTenderResponseContractors()) {
            contractorList.add(tenderResponseContractors.getContractor());
        }
        this.addDropdownData(CONTRACTOR_LIST, contractorList);
        this.saveTender();
        this.tenderResponse.setTenderEstimate((TenderEstimate)this.tenderHeader.getTenderEstimates().get(0));
        String actionName = "";
        if (this.parameters.get(ACTION_NAME) != null && ((String[])this.parameters.get(ACTION_NAME))[0] != null) {
            actionName = ((String[])this.parameters.get(ACTION_NAME))[0];
        }
        try {
            this.setNegotiationNumber(this.tenderResponse, financialYear);
            this.tenderHeaderService.persist((Object)this.tenderHeader);
            if (SAVE_ACTION.equals(((String[])this.parameters.get(ACTION_NAME))[0]) && this.tenderResponse.getEgwStatus() == null) {
                this.tenderResponse.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("TenderResponse", NEWNs));
            }
            this.tenderResponse = (TenderResponse)this.tenderResponseService.persist((Object)this.tenderResponse);
        }
        catch (ValidationException sequenceException) {
            List errorList = sequenceException.getErrors();
            for (ValidationError error : errorList) {
                if (!error.getMessage().contains("DatabaseSequenceFirstTimeException")) continue;
                this.prepare();
                if (this.tenderResponse != null) {
                    this.tenderResponse.getTenderResponseContractors().clear();
                }
                this.actionTenderResponseContractors = (List)this.tenderResponseService.getActionTenderResponseContractorsList(this.actionTenderResponseContractors);
                if (this.tenderResponse != null) {
                    this.tenderResponse.getTenderResponseActivities().clear();
                    financialYear = this.abstractEstimateService.getCurrentFinancialYear(this.tenderResponse.getNegotiationDate());
                }
                this.populateTenderResponseContractors();
                this.populateTenderResponseActivities();
                throw new ValidationException(Arrays.asList(new ValidationError("error", error.getMessage())));
            }
        }
        if (actionName != null) {
            this.tenderResponse = (TenderResponse)this.workflowService.transition(actionName, (StateAware)this.tenderResponse, this.tenderResponse.getWorkflowapproverComments());
        }
        this.tenderResponse = (TenderResponse)this.tenderResponseService.persist((Object)this.tenderResponse);
        this.messageKey = this.tenderResponse.getEgwStatus() != null && APPROVED.equalsIgnoreCase(this.tenderResponse.getEgwStatus().getCode()) ? "tenderResponse.approved" : "tenderNegotiation.save.success";
        this.addActionMessage(this.getText(this.messageKey, this.messageKey));
        this.getDesignation(this.tenderResponse);
        if (SAVE_ACTION.equals(actionName)) {
            this.sourcepage = SOURCE_INBOX;
        }
        return SAVE_ACTION.equals(actionName) ? "edit" : "success";
    }

    public String cancel() {
        this.actionTenderResponseContractors = (List)this.tenderResponseService.getActionTenderResponseContractorsList(this.actionTenderResponseContractors);
        if (!(this.tenderResponse == null || this.actionTenderResponseContractors.isEmpty() || this.actionTenderResponseContractors.get(0) == null || ((TenderResponseContractors)this.actionTenderResponseContractors.get(0)).getContractor() == null || ((TenderResponseContractors)this.actionTenderResponseContractors.get(0)).getContractor().getId() != null && ((TenderResponseContractors)this.actionTenderResponseContractors.get(0)).getContractor().getId() != 0L && ((TenderResponseContractors)this.actionTenderResponseContractors.get(0)).getContractor().getId() != -1L)) {
            throw new ValidationException(Arrays.asList(new ValidationError(TENDERRESPONSE_CONTRACTOR, TENDERRESPONSE_CONTRACTOR_NULL)));
        }
        if (this.tenderResponse != null && !this.actionTenderResponseContractors.isEmpty() && this.actionTenderResponseContractors.get(0) != null && ((TenderResponseContractors)this.actionTenderResponseContractors.get(0)).getContractor() == null) {
            throw new ValidationException(Arrays.asList(new ValidationError(TENDERRESPONSE_CONTRACTOR, TENDERRESPONSE_CONTRACTOR_NULL)));
        }
        if (this.tenderResponse != null && this.tenderResponse.getNegotiationPreparedBy() != null && (this.tenderResponse.getNegotiationPreparedBy().getIdPersonalInformation() == null || this.tenderResponse.getNegotiationPreparedBy().getIdPersonalInformation() == 0 || this.tenderResponse.getNegotiationPreparedBy().getIdPersonalInformation() == -1)) {
            throw new ValidationException(Arrays.asList(new ValidationError(VALIDATION_PREPAREDBY, VALIDATION_PREPAREDBY_ERROR)));
        }
        if (this.tenderResponse != null && this.tenderResponse.getNegotiationPreparedBy() == null) {
            throw new ValidationException(Arrays.asList(new ValidationError(VALIDATION_PREPAREDBY, VALIDATION_PREPAREDBY_ERROR)));
        }
        this.saveTender();
        this.tenderResponse.setTenderEstimate((TenderEstimate)this.tenderHeader.getTenderEstimates().get(0));
        if (this.tenderResponse.getId() != null) {
            this.workflowService.transition(TenderResponse.Actions.CANCEL.toString(), (StateAware)this.tenderResponse, "");
            this.tenderResponse = (TenderResponse)this.tenderResponseService.persist((Object)this.tenderResponse);
        }
        this.messageKey = "tenderResponse.cancel";
        this.getDesignation(this.tenderResponse);
        return "success";
    }

    private void getDesignation(TenderResponse tenderResponse) {
        String result;
        if (tenderResponse.getEgwStatus() != null && !NEWNs.equalsIgnoreCase(tenderResponse.getEgwStatus().getCode()) && (result = this.worksService.getEmpNameDesignation(tenderResponse.getState().getOwnerPosition(), tenderResponse.getState().getCreatedDate())) != null && !"@".equalsIgnoreCase(result)) {
            String empName = result.substring(0, result.lastIndexOf(64));
            String designation = result.substring(result.lastIndexOf(64) + 1, result.length());
            this.setEmployeeName(empName);
            this.setDesignation(designation);
        }
    }

    private void saveTender() {
        this.populateTenderEstimate();
    }

    private void populateTenderEstimate() {
        if (this.id != null) {
            this.tenderResponse.getTenderEstimate().getTenderHeader().getTenderEstimates().clear();
        }
        if (this.abstractEstimate != null) {
            this.tenderEstimate.setAbstractEstimate(this.abstractEstimate);
        }
        if (this.worksPackage != null) {
            this.tenderEstimate.setWorksPackage(this.worksPackage);
        }
        if (this.tenderType != null && !this.tenderType.equals("-1")) {
            this.tenderEstimate.setTenderType(this.tenderType);
        }
        if (this.id == null) {
            this.tenderEstimate.setTenderHeader(this.tenderHeader);
        }
        this.tenderHeader.addTenderEstimate(this.tenderEstimate);
    }

    private void populateTenderResponseContractors() {
        for (TenderResponseContractors tenderResponseContractors : this.actionTenderResponseContractors) {
            if (tenderResponseContractors == null) continue;
            this.tenderResponse.addTenderResponseContractors(tenderResponseContractors);
        }
    }

    private void populateTenderResponseActivities() {
        if (this.abstractEstimate != null) {
            this.addAllActivities(this.abstractEstimate.getActivities());
        }
        if (this.worksPackage != null) {
            this.addAllActivities(this.worksPackage.getAllActivities());
        }
    }

    private void addAllActivities(List<Activity> actList) {
        if (this.tenderTypeList != null && !this.tenderTypeList.isEmpty() && this.tenderType.equals(this.tenderTypeList.get(0))) {
            for (Activity activity : actList) {
                TenderResponseQuotes tenderResponseQuotes;
                TenderResponseActivity tenderResponseActivity = new TenderResponseActivity();
                ArrayList<TenderResponseQuotes> tenderResponseQuotesList = new ArrayList<TenderResponseQuotes>();
                tenderResponseActivity.setActivity(activity);
                tenderResponseActivity.setNegotiatedQuantity(activity.getQuantity());
                if ("BILL".equalsIgnoreCase(this.worksService.getWorksConfigValue("REBATE_PREMIUM_LEVEL"))) {
                    for (TenderResponseContractors tenderResponseContractors : this.actionTenderResponseContractors) {
                        if (tenderResponseContractors == null) continue;
                        tenderResponseQuotes = new TenderResponseQuotes();
                        if (activity.getNonSor() == null) {
                            tenderResponseQuotes.setQuotedRate(activity.getSORCurrentRate().getValue());
                            tenderResponseActivity.setNegotiatedRate(activity.getSORCurrentRate().getValue());
                        } else if (activity.getSchedule() == null) {
                            tenderResponseQuotes.setQuotedRate(activity.getRate());
                            tenderResponseActivity.setNegotiatedRate(activity.getRate());
                        }
                        tenderResponseQuotes.setContractor(tenderResponseContractors.getContractor());
                        tenderResponseQuotes.setQuotedQuantity(activity.getQuantity());
                        tenderResponseQuotes.setTenderResponseActivity(tenderResponseActivity);
                        tenderResponseQuotesList.add(tenderResponseQuotes);
                        tenderResponseActivity.setTenderResponseQuotes(tenderResponseQuotesList);
                    }
                } else {
                    for (TenderResponseContractors tenderResponseContractors : this.actionTenderResponseContractors) {
                        if (tenderResponseContractors == null) continue;
                        tenderResponseQuotes = new TenderResponseQuotes();
                        if (activity.getNonSor() == null) {
                            tenderResponseQuotes.setQuotedRate(activity.getSORCurrentRate().getValue() + activity.getSORCurrentRate().getValue() * this.tenderResponse.getPercQuotedRate() / 100.0);
                            tenderResponseActivity.setNegotiatedRate(activity.getSORCurrentRate().getValue() + activity.getSORCurrentRate().getValue() * this.tenderResponse.getPercNegotiatedAmountRate() / 100.0);
                        } else if (activity.getSchedule() == null) {
                            tenderResponseQuotes.setQuotedRate(activity.getRate() + activity.getRate() * this.tenderResponse.getPercQuotedRate() / 100.0);
                            tenderResponseActivity.setNegotiatedRate(activity.getRate() + activity.getRate() * this.tenderResponse.getPercNegotiatedAmountRate() / 100.0);
                        }
                        tenderResponseQuotes.setContractor(tenderResponseContractors.getContractor());
                        tenderResponseQuotes.setQuotedQuantity(activity.getQuantity());
                        tenderResponseQuotes.setTenderResponseActivity(tenderResponseActivity);
                        tenderResponseQuotesList.add(tenderResponseQuotes);
                        tenderResponseActivity.setTenderResponseQuotes(tenderResponseQuotesList);
                    }
                }
                tenderResponseActivity.setTenderResponse(this.tenderResponse);
                this.tenderResponse.addTenderResponseActivity(tenderResponseActivity);
            }
        } else {
            for (Activity activity : actList) {
                double negotiatedRate = 0.0;
                HashMap tenderResponseQuotesMap = new HashMap();
                for (TenderResponseActivity tenderResponseActivityTemp : this.actionTenderResponseActivities) {
                    if (tenderResponseActivityTemp == null) continue;
                    ArrayList<TenderResponseQuotes> tenderResponseQuotesList = new ArrayList<TenderResponseQuotes>();
                    for (TenderResponseQuotes tenderResponseQuotesTemp : tenderResponseActivityTemp.getTenderResponseQuotesList()) {
                        TenderResponseQuotes tenderResponseQuotes = new TenderResponseQuotes();
                        tenderResponseQuotes.setQuotedRate(tenderResponseQuotesTemp.getQuotedRate());
                        Contractor contractor = (Contractor)this.contractorService.findById((Serializable)tenderResponseQuotesTemp.getContractor().getId(), false);
                        tenderResponseQuotes.setContractor(contractor);
                        tenderResponseQuotes.setQuotedQuantity(activity.getQuantity());
                        tenderResponseQuotesList.add(tenderResponseQuotes);
                    }
                    tenderResponseQuotesMap.put(tenderResponseActivityTemp.getActivity().getId(), tenderResponseQuotesList);
                    if (StringUtils.isNotBlank((String)tenderResponseActivityTemp.getSchCode()) && activity.getSchedule() != null && activity.getSchedule().getCode().equals(tenderResponseActivityTemp.getSchCode())) {
                        negotiatedRate = tenderResponseActivityTemp.getNegotiatedRate();
                        tenderResponseQuotesMap.put(activity.getId(), tenderResponseQuotesList);
                        continue;
                    }
                    if (tenderResponseActivityTemp.getActivity().getId().intValue() != activity.getId().intValue()) continue;
                    negotiatedRate = tenderResponseActivityTemp.getNegotiatedRate();
                }
                TenderResponseActivity tenderResponseActivity = new TenderResponseActivity();
                tenderResponseActivity.setActivity(activity);
                tenderResponseActivity.setNegotiatedQuantity(activity.getQuantity());
                tenderResponseActivity.setNegotiatedRate(negotiatedRate);
                tenderResponseActivity.setTenderResponse(this.tenderResponse);
                List tenderResponseQuotesList = new ArrayList();
                tenderResponseQuotesList = (List)tenderResponseQuotesMap.get(activity.getId());
                for (TenderResponseQuotes tenderResponseQuotes : tenderResponseQuotesList) {
                    tenderResponseQuotes.setTenderResponseActivity(tenderResponseActivity);
                    tenderResponseActivity.addTenderResponseQuotes(tenderResponseQuotes);
                }
                this.tenderResponse.addTenderResponseActivity(tenderResponseActivity);
            }
        }
    }

    public String reject() {
        this.saveTender();
        this.tenderResponse.setTenderEstimate((TenderEstimate)this.tenderHeader.getTenderEstimates().get(0));
        this.workflowService.transition(TenderResponse.Actions.REJECT.toString(), (StateAware)this.tenderResponse, "");
        this.tenderResponse = (TenderResponse)this.tenderResponseService.persist((Object)this.tenderResponse);
        this.getDesignation(this.tenderResponse);
        this.messageKey = "tenderResponse.reject";
        return "success";
    }

    public void setNegotiationNumber(TenderResponse entity, CFinancialYear financialYear) {
        if (entity.getNegotiationNumber() == null || entity.getNegotiationNumber() != null && this.negotiationNumberChangeRequired(entity, financialYear)) {
            if (entity.getTenderEstimate().getAbstractEstimate() != null) {
                entity.setNegotiationNumber(this.negotiationNumberGenerator.getTenderNegotiationNumber(entity.getTenderEstimate().getAbstractEstimate(), financialYear));
            }
            if (entity.getTenderEstimate().getWorksPackage() != null) {
                entity.setNegotiationNumber(this.negotiationNumberGenerator.getTenderNegotiationNumber(entity.getTenderEstimate().getWorksPackage(), financialYear));
            }
        }
    }

    private boolean negotiationNumberChangeRequired(TenderResponse entity, CFinancialYear financialYear) {
        String[] estNum = entity.getNegotiationNumber().split("/");
        if (entity.getTenderEstimate().getAbstractEstimate() != null && estNum[0].equals(entity.getTenderEstimate().getAbstractEstimate().getExecutingDepartment().getCode()) && estNum[2].equals(financialYear.getFinYearRange())) {
            return false;
        }
        return entity.getTenderEstimate().getWorksPackage() == null || !estNum[0].equals(entity.getTenderEstimate().getWorksPackage().getDepartment().getCode()) || !estNum[2].equals(financialYear.getFinYearRange());
    }

    public void setAbstractEstimateService(AbstractEstimateService abstractEstimateService) {
        this.abstractEstimateService = abstractEstimateService;
    }

    public void setTenderResponse(TenderResponse tenderResponse) {
        this.tenderResponse = tenderResponse;
    }

    public Long getEstimateId() {
        return this.estimateId;
    }

    public void setEstimateId(Long estimateId) {
        this.estimateId = estimateId;
    }

    public AbstractEstimate getAbstractEstimate() {
        return this.abstractEstimate;
    }

    public void setAbstractEstimate(AbstractEstimate abstractEstimate) {
        this.abstractEstimate = abstractEstimate;
    }

    public TenderHeader getTenderHeader() {
        return this.tenderHeader;
    }

    public void setTenderHeader(TenderHeader tenderHeader) {
        this.tenderHeader = tenderHeader;
    }

    public String getTenderType() {
        return this.tenderType;
    }

    public void setTenderType(String tenderType) {
        this.tenderType = tenderType;
    }

    public void setTenderHeaderService(PersistenceService<TenderHeader, Long> tenderHeaderService) {
        this.tenderHeaderService = tenderHeaderService;
    }

    public void setTenderEstimate(TenderEstimate tenderEstimate) {
        this.tenderEstimate = tenderEstimate;
    }

    public void setNegotiationNumberGenerator(NegotiationNumberGenerator negotiationNumberGenerator) {
        this.negotiationNumberGenerator = negotiationNumberGenerator;
    }

    public String getNegotiationNumber() {
        return this.negotiationNumber;
    }

    public void setNegotiationNumber(String negotiationNumber) {
        this.negotiationNumber = negotiationNumber;
    }

    public Date getNegotiationDate() {
        return this.negotiationDate;
    }

    public void setNegotiationDate(Date negotiationDate) {
        this.negotiationDate = negotiationDate;
    }

    public Long getDeptId() {
        return this.deptId;
    }

    public void setDepartmentId(Integer departmentId) {
        this.departmentId = departmentId;
    }

    public String getEstimateNumber() {
        return this.estimateNumber;
    }

    public void setEstimateNumber(String estimateNumber) {
        this.estimateNumber = estimateNumber;
    }

    public String getProjectCode() {
        return this.projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getMode() {
        return this.mode;
    }

    public void setMode(String mode) {
        this.mode = mode;
    }

    public List<WorkflowAction> getValidActions() {
        return this.workflowService.getValidActions((StateAware)this.tenderResponse);
    }

    public void setTenderResponseWorkflowService(WorkflowService<TenderResponse> workflow) {
        this.workflowService = workflow;
    }

    public List<EgwStatus> getEstimateStatuses() {
        List tnStatusList = this.egwStatusHibernateDAO.getStatusByModule(TenderResponse.class.getSimpleName());
        tnStatusList.remove(this.egwStatusHibernateDAO.getStatusByModuleAndCode(TenderResponse.class.getSimpleName(), NEWNs));
        return tnStatusList;
    }

    public List<EgwStatus> getNegotiationStatusesForWO() {
        ArrayList<EgwStatus> tnStatusList = new ArrayList<EgwStatus>();
        String wpStatus = this.worksService.getWorksConfigValue("WP_STATUS_SEARCH");
        String status = this.worksService.getWorksConfigValue("TenderResponse.setstatus");
        String lastStatus = this.worksService.getWorksConfigValue("TenderResponse.laststatus");
        ArrayList<String> statList = new ArrayList<String>();
        if (StringUtils.isNotBlank((String)wpStatus)) {
            statList.add(wpStatus);
        }
        if (StringUtils.isNotBlank((String)status) && StringUtils.isNotBlank((String)lastStatus)) {
            List<String> statusList = Arrays.asList(status.split(","));
            for (String stat : statusList) {
                if (stat.equals(lastStatus)) {
                    statList.add(stat);
                    break;
                }
                statList.add(stat);
            }
        }
        if ("cancelTN".equals(this.sourcepage)) {
            tnStatusList.add(this.egwStatusHibernateDAO.getStatusByModuleAndCode(TenderResponse.class.getSimpleName(), APPROVED));
        }
        tnStatusList.addAll(this.egwStatusHibernateDAO.getStatusListByModuleAndCodeList(TenderResponse.class.getSimpleName(), statList));
        return tnStatusList;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public void validate() {
        TenderResponse tenderResp;
        if (this.actionTenderResponseContractors != null) {
            ArrayList<Contractor> contractorList = new ArrayList<Contractor>();
            for (TenderResponseContractors tenderResponseContractors : this.tenderResponseService.getActionTenderResponseContractorsList(this.actionTenderResponseContractors)) {
                contractorList.add(tenderResponseContractors.getContractor());
            }
            this.addDropdownData(CONTRACTOR_LIST, contractorList);
        }
        if (!(this.tenderResponse.getId() != null || this.tenderResponse.getEgwStatus() != null || !this.sourcepage.equalsIgnoreCase("createNegotiationForWP") || this.sourcepage.equalsIgnoreCase(SOURCE_INBOX) || this.sourcepage.equalsIgnoreCase("cancelTN") || this.sourcepage.equalsIgnoreCase(SEARCH_NEGOTIATION_FOR_WO) || this.sourcepage.equalsIgnoreCase(SOURCE_SEARCH) || (tenderResp = (TenderResponse)this.persistenceService.findByNamedQuery("getTenderForWorksPackageNum", new Object[]{this.getWpNumber()})) == null)) {
            this.addActionError(this.getText("tenderNegotiation.workspackage.uniquecheck.message", new String[]{this.getWpNumber(), tenderResp.getNegotiationNumber()}));
        }
        if (this.tenderResponse != null && this.tenderType != null && !this.tenderTypeList.isEmpty() && this.tenderType.equals(this.tenderTypeList.get(0))) {
            if (this.tenderResponse.getPercQuotedRate() <= -100.0) {
                this.addActionError(this.getText("tenderResponse.percQuotedRate.valid"));
            }
            if (this.tenderResponse.getPercNegotiatedAmountRate() <= -100.0) {
                this.addActionError(this.getText("tenderResponse.percNegotiatedRate.valid"));
            }
        }
        Collection tenderResponseActivityList = this.tenderResponseService.getTenderResponseActivityList(this.actionTenderResponseActivities);
        if (this.tenderResponse != null && this.tenderType != null && !this.tenderTypeList.isEmpty() && this.tenderType.equals(this.tenderTypeList.get(1)) && !tenderResponseActivityList.isEmpty()) {
            for (TenderResponseActivity tenderResponseActivity : tenderResponseActivityList) {
                for (TenderResponseQuotes tenderResponseQuotes : tenderResponseActivity.getTenderResponseQuotesList()) {
                    if (tenderResponseQuotes.getQuotedRate() != 0.0) continue;
                    this.addActionError(this.getText("tenderResponseActivity.quotedRate.non.negative"));
                }
                if (tenderResponseActivity.getNegotiatedRate() != 0.0) continue;
                this.addActionError(this.getText("tenderResponseActivity.negotiatedRate.non.negative"));
            }
        }
    }

    public WorksService getWorksService() {
        return this.worksService;
    }

    public void setWorksService(WorksService worksService) {
        this.worksService = worksService;
    }

    public String getEmployeeName() {
        return this.employeeName;
    }

    public void setEmployeeName(String employeeName) {
        this.employeeName = employeeName;
    }

    public String getSourcepage() {
        return this.sourcepage;
    }

    public void setSourcepage(String sourcepage) {
        this.sourcepage = sourcepage;
    }

    public WorkOrder getWorkOrder() {
        return this.workOrder;
    }

    public void setWorkOrder(WorkOrder workOrder) {
        this.workOrder = workOrder;
    }

    public String getErrorType() {
        return this.errorType;
    }

    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    public Date getApprovedDateHidden() {
        return this.approvedDateHidden;
    }

    public void setApprovedDateHidden(Date approvedDateHidden) {
        this.approvedDateHidden = approvedDateHidden;
    }

    public String getNsActionName() {
        return this.nsActionName;
    }

    public void setNsActionName(String nsActionName) {
        this.nsActionName = nsActionName;
    }

    public Long getTenderRespId() {
        return this.tenderRespId;
    }

    public void setTenderRespId(Long tenderRespId) {
        this.tenderRespId = tenderRespId;
    }

    public Integer getNegotiationStatusId() {
        return this.negotiationStatusId;
    }

    public void setNegotiationStatusId(Integer negotiationStatusId) {
        this.negotiationStatusId = negotiationStatusId;
    }

    public Integer getNegotiationStatusApprovedById() {
        return this.negotiationStatusApprovedById;
    }

    public void setNegotiationStatusApprovedById(Integer negotiationStatusApprovedById) {
        this.negotiationStatusApprovedById = negotiationStatusApprovedById;
    }

    public String getOption() {
        return this.option;
    }

    public void setOption(String option) {
        this.option = option;
    }

    public String getMessageKey() {
        return this.messageKey;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public String getCurrentStatus() {
        return this.currentStatus;
    }

    public void setCurrentStatus(String currentStatus) {
        this.currentStatus = currentStatus;
    }

    public String getCurrentApproverName() {
        return this.currentApproverName;
    }

    public void setCurrentApproverName(String currentApproverName) {
        this.currentApproverName = currentApproverName;
    }

    public String getCurrentApprovedDateStr() {
        if (this.currentApprovedDate != null) {
            this.currentApprovedDateStr = new SimpleDateFormat("dd/MM/yyyy").format(this.currentApprovedDate);
        }
        return this.currentApprovedDateStr;
    }

    public void setCurrentApprovedDate(Date currentApprovedDate) {
        this.currentApprovedDate = currentApprovedDate;
    }

    public Integer getStatusIdValue() {
        return this.statusIdValue;
    }

    public void setStatusIdValue(Integer statusIdValue) {
        this.statusIdValue = statusIdValue;
    }

    public void setTenderResponseService(TenderResponseService tenderResponseService) {
        this.tenderResponseService = tenderResponseService;
    }

    public Integer getWorkOrderInchargeId() {
        return this.workOrderInchargeId;
    }

    public void setWorkOrderInchargeId(Integer workOrderInchargeId) {
        this.workOrderInchargeId = workOrderInchargeId;
    }

    public Long getWorksPackageId() {
        return this.worksPackageId;
    }

    public void setWorksPackageId(Long worksPackageId) {
        this.worksPackageId = worksPackageId;
    }

    public void setWorkspackageService(WorksPackageService workspackageService) {
        this.workspackageService = workspackageService;
    }

    public WorksPackage getWorksPackage() {
        return this.worksPackage;
    }

    public void setWorksPackage(WorksPackage worksPackage) {
        this.worksPackage = worksPackage;
    }

    public String getCreatedBySelection() {
        return this.createdBySelection;
    }

    public void setCreatedBySelection(String createdBySelection) {
        this.createdBySelection = createdBySelection;
    }

    public String getEditableDate() {
        return this.editableDate;
    }

    public void setEditableDate(String editableDate) {
        this.editableDate = editableDate;
    }

    public void setDepartmentService(DepartmentService departmentService) {
        this.departmentService = departmentService;
    }

    public String getWpYear() {
        if (this.worksPackage != null) {
            return this.abstractEstimateService.getCurrentFinancialYear(this.worksPackage.getWpDate()).getFinYearRange();
        }
        return this.wpYear;
    }

    public boolean validTenderNo() {
        boolean status = false;
        if (this.tenderHeader != null && this.tenderHeader.getTenderNo() != null) {
            AjaxTenderNegotiationAction ajaxTenderNegotiationAction = new AjaxTenderNegotiationAction();
            ajaxTenderNegotiationAction.setPersistenceService(this.getPersistenceService());
            ajaxTenderNegotiationAction.setAssignmentService(this.assignmentService);
            ajaxTenderNegotiationAction.setTenderNo(this.tenderHeader.getTenderNo());
            ajaxTenderNegotiationAction.setId(this.id);
            if (ajaxTenderNegotiationAction.getTendernoCheck()) {
                status = true;
            }
        }
        return status;
    }

    protected void getPositionAndUser() {
        ArrayList tenderResponseContractorsList = new ArrayList();
        Map exceptionaSorMap = this.worksService.getExceptionSOR();
        for (TenderResponse tenderResponse : this.searchResult.getList()) {
            PersonalInformation emp;
            if (SEARCH_NEGOTIATION_FOR_WO.equals(this.sourcepage)) {
                double totalTenderNegQty = tenderResponse.getTotalNegotiatedQuantity().getValue();
                double totalWorkOrderQty = this.getTotalWorkOrderQuantity(tenderResponse.getNegotiationNumber());
                totalTenderNegQty = (double)Math.round(totalTenderNegQty * 100.0) / 100.0;
                if ((totalWorkOrderQty = (double)Math.round(totalWorkOrderQty * 100.0) / 100.0) >= totalTenderNegQty) continue;
            }
            if (!tenderResponse.getEgwStatus().getCode().equalsIgnoreCase(APPROVED) && !tenderResponse.getEgwStatus().getCode().equalsIgnoreCase("CANCELLED") && (emp = this.employeeServiceOld.getEmployeeforPosition(tenderResponse.getCurrentState().getOwnerPosition())) != null && StringUtils.isNotBlank((String)emp.getEmployeeName())) {
                if (tenderResponse.getTenderEstimate().getAbstractEstimate() == null) {
                    tenderResponse.getTenderEstimate().getWorksPackage().setEmployeeName(emp.getEmployeeName());
                } else {
                    tenderResponse.getTenderEstimate().getAbstractEstimate().setPositionAndUserName(emp.getEmployeeName());
                }
            }
            double totalAmt = 0.0;
            for (TenderResponseActivity act : tenderResponse.getTenderResponseActivities()) {
                double result = 1.0;
                if (act.getActivity().getSchedule() != null && exceptionaSorMap.containsKey(act.getActivity().getUom().getUom())) {
                    result = ((Integer)exceptionaSorMap.get(act.getActivity().getUom().getUom())).intValue();
                    totalAmt += act.getNegotiatedQuantity() * act.getNegotiatedRate() / result;
                    continue;
                }
                totalAmt += act.getNegotiatedQuantity() * act.getNegotiatedRate();
            }
            tenderResponse.setTotalAmount(totalAmt);
            for (TenderResponseContractors tenderResponseCntractrs : tenderResponse.getTenderResponseContractors()) {
                if (tenderResponseCntractrs.getTenderResponse().getEgwStatus() != null && tenderResponseCntractrs.getTenderResponse().getEgwStatus().getCode().equals(TenderResponse.TenderResponseStatus.APPROVED.toString())) {
                    OfflineStatus setStatus = (OfflineStatus)this.persistenceService.findByNamedQuery("getmaxStatusByObjectId_Type", new Object[]{tenderResponseCntractrs.getId(), tenderResponseCntractrs.getId(), TenderResponseContractors.class.getSimpleName(), TenderResponseContractors.class.getSimpleName()});
                    if (setStatus == null) {
                        tenderResponseCntractrs.setStatus(tenderResponse.getEgwStatus().getCode());
                        tenderResponseCntractrs.setStatusCode(tenderResponse.getEgwStatus().getCode());
                        continue;
                    }
                    tenderResponseCntractrs.setStatus(setStatus.getEgwStatus().getDescription());
                    tenderResponseCntractrs.setStatusCode(setStatus.getEgwStatus().getCode());
                    continue;
                }
                tenderResponseCntractrs.setStatus(tenderResponse.getEgwStatus().getCode());
                tenderResponseCntractrs.setStatusCode(tenderResponse.getEgwStatus().getCode());
            }
            String approved = this.getApprovedValue();
            OfflineStatus lastStatus = (OfflineStatus)this.worksStatusService.findByNamedQuery(STATUS_OBJECTID, new Object[]{((TenderResponseContractors)tenderResponse.getTenderResponseContractors().get(0)).getId(), OBJECT_TYPE, this.getLastStatus()});
            String actions = this.worksService.getWorksConfigValue("TENDERNEGOTIATION_SHOW_ACTIONS");
            if (StringUtils.isNotBlank((String)actions)) {
                String setStat = "";
                tenderResponse.getTenderNegotiationsActions().addAll(Arrays.asList(actions.split(",")));
                if (lastStatus != null || "view".equalsIgnoreCase(this.setStatus)) {
                    setStat = this.worksService.getWorksConfigValue("WORKS_VIEW_OFFLINE_STATUS_VALUE");
                } else if (lastStatus == null && StringUtils.isNotBlank((String)approved) && tenderResponse.getEgwStatus() != null && approved.equals(tenderResponse.getEgwStatus().getCode())) {
                    setStat = this.worksService.getWorksConfigValue("WORKS_SETSTATUS_VALUE");
                }
                if (StringUtils.isNotBlank((String)setStat)) {
                    tenderResponse.getTenderNegotiationsActions().add(setStat);
                }
            }
            tenderResponseContractorsList.addAll(tenderResponse.getTenderResponseContractors());
        }
        if (SEARCH_NEGOTIATION_FOR_WO.equals(this.sourcepage)) {
            ArrayList<TenderResponseContractors> tenderResponseContractorsTempList = new ArrayList<TenderResponseContractors>();
            ListIterator k = tenderResponseContractorsList.listIterator();
            while (k.hasNext()) {
                TenderResponseContractors tenderResponseCntractrs = (TenderResponseContractors)k.next();
                if (this.status != null && this.status != "" && this.contractorId != null && this.contractorId != -1L) {
                    if (!tenderResponseCntractrs.getStatusCode().equals(this.status) || !tenderResponseCntractrs.getContractor().getId().equals(this.contractorId)) continue;
                    tenderResponseContractorsTempList.add(tenderResponseCntractrs);
                    continue;
                }
                if (this.status != null && this.status != "" && (this.contractorId == null || this.contractorId == -1L)) {
                    if (!tenderResponseCntractrs.getStatusCode().equals(this.status)) continue;
                    tenderResponseContractorsTempList.add(tenderResponseCntractrs);
                    continue;
                }
                if (this.status != null && this.status != "" || this.contractorId == null || this.contractorId == -1L || !tenderResponseCntractrs.getContractor().getId().equals(this.contractorId)) continue;
                tenderResponseContractorsTempList.add(tenderResponseCntractrs);
            }
            this.searchResult.getList().clear();
            this.searchResult.getList().addAll(tenderResponseContractorsTempList);
        } else {
            this.searchResult.getList().clear();
            this.searchResult.getList().addAll(tenderResponseContractorsList);
        }
    }

    private double getTotalWorkOrderQuantity(String negotiationNumber) {
        Object[] params = new Object[]{negotiationNumber, "CANCELLED"};
        Double totalWorkOrderQty = (Double)this.getPersistenceService().findByNamedQuery("getTotalQuantityForWO", params);
        params = new Object[]{negotiationNumber, NEWNs};
        Double totalWorkOrderQtyForNew = (Double)this.getPersistenceService().findByNamedQuery("getTotalQuantityForNewWO", params);
        if (totalWorkOrderQty != null && totalWorkOrderQtyForNew != null) {
            totalWorkOrderQty = totalWorkOrderQty + totalWorkOrderQtyForNew;
        }
        if (totalWorkOrderQty == null && totalWorkOrderQtyForNew != null) {
            totalWorkOrderQty = totalWorkOrderQtyForNew;
        }
        if (totalWorkOrderQty == null) {
            return 0.0;
        }
        return totalWorkOrderQty;
    }

    public String getApprovedValue() {
        return TenderResponse.TenderResponseStatus.APPROVED.toString();
    }

    public String getLastStatus() {
        return this.worksService.getWorksConfigValue("TenderResponse.laststatus");
    }

    public String getDesignationNegotiation() {
        return this.designationNegotiation;
    }

    public void setDesignationNegotiation(String designationNegotiation) {
        this.designationNegotiation = designationNegotiation;
    }

    public String getDesignation() {
        return this.designation;
    }

    public void setDesignation(String designation) {
        this.designation = designation;
    }

    public String getTenderSource() {
        return this.tenderSource;
    }

    public void setTenderSource(String tenderSource) {
        this.tenderSource = tenderSource;
    }

    public String getSetStatus() {
        return this.setStatus;
    }

    public void setSetStatus(String setStatus) {
        this.setStatus = setStatus;
    }

    public Double getSorPerDiff() {
        return this.sorPerDiff;
    }

    public void setSorPerDiff(Double sorPerDiff) {
        this.sorPerDiff = sorPerDiff;
    }

    public String getWpNumber() {
        return this.wpNumber;
    }

    public void setWpNumber(String wpNumber) {
        this.wpNumber = wpNumber;
    }

    public Date getFromDate() {
        return this.fromDate;
    }

    public void setFromDate(Date fromDate) {
        this.fromDate = fromDate;
    }

    public Date getToDate() {
        return this.toDate;
    }

    public void setToDate(Date toDate) {
        this.toDate = toDate;
    }

    public String getTenderCretedBy() {
        return this.tenderCretedBy;
    }

    public void setTenderCretedBy(String tenderCretedBy) {
        this.tenderCretedBy = tenderCretedBy;
    }

    public String getTenderFileNumber() {
        return this.tenderFileNumber;
    }

    public void setTenderFileNumber(String tenderFileNumber) {
        this.tenderFileNumber = tenderFileNumber;
    }

    public List<Contractor> getContractorForApprovedNegotiation() {
        return this.getPersistenceService().findAllByNamedQuery("getApprovedNegotiationContractors", new Object[0]);
    }

    public void setDeptId(Long deptId) {
        this.deptId = deptId;
    }

    public Integer getDepartmentId() {
        return this.departmentId;
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        ArrayList<Object> paramList = new ArrayList<Object>();
        String negotiationStr = "from TenderResponse as tenderResponse  where tenderResponse.createdBy is not null ";
        if (this.getStatus().equals(TenderResponse.TenderResponseStatus.APPROVED.toString())) {
            negotiationStr = negotiationStr + " and tenderResponse.egwStatus.code= ?  and   tenderResponse.id  in ( select trc.tenderResponse.id from TenderResponseContractors trc where trc.id not in (select objectId from OfflineStatus where objectType='TenderResponseContractors' ))";
            paramList.add(this.status);
        } else if (this.getStatus().equals(TenderResponse.TenderResponseStatus.CANCELLED.toString())) {
            negotiationStr = negotiationStr + " and tenderResponse.egwStatus.code= ? ";
            paramList.add(this.status);
        } else if (StringUtils.isNotBlank((String)this.getStatus()) && !this.getStatus().equals("-1")) {
            negotiationStr = negotiationStr + "and tenderResponse.egwStatus.code != 'NEW' and ((tenderResponse.egwStatus.code = ?) or (tenderResponse.egwStatus.code = 'APPROVED' and tenderResponse.id in (select trc.tenderResponse.id from TenderResponseContractors trc where trc.id in ( select stat.objectId from OfflineStatus stat where stat.egwStatus.code= ? and stat.id = (select max(stat1.id) from OfflineStatus stat1 where trc.id=stat1.objectId and stat1.objectType='TenderResponseContractors') and stat.objectType='TenderResponseContractors')))) ";
            paramList.add(this.getStatus());
            paramList.add(this.getStatus());
            if (this.sourcepage != null && "cancelTN".equals(this.sourcepage)) {
                negotiationStr = negotiationStr + " and tenderResponse.egwStatus.code = 'APPROVED'";
            }
        }
        if (StringUtils.isNotBlank((String)this.negotiationNumber)) {
            negotiationStr = negotiationStr + " and UPPER(tenderResponse.negotiationNumber) like ?";
            paramList.add("%" + this.negotiationNumber.trim().toUpperCase() + "%");
        }
        if (this.fromDate != null && this.toDate != null && this.getFieldErrors().isEmpty()) {
            negotiationStr = negotiationStr + " and tenderResponse.negotiationDate between ? and ? ";
            paramList.add(this.fromDate);
            paramList.add(this.toDate);
        }
        if (this.departmentId != null && this.departmentId != -1) {
            negotiationStr = negotiationStr + " and (tenderResponse.tenderEstimate.abstractEstimate.id in " + "(select tr1.tenderEstimate.abstractEstimate.id from TenderResponse tr1 " + " where tr1.tenderEstimate.abstractEstimate.id!=null and  tr1.tenderEstimate.worksPackage.id=null and" + " tr1.tenderEstimate.abstractEstimate.executingDepartment.id= ?) " + " or tenderResponse.tenderEstimate.worksPackage.id in " + "(select tr.tenderEstimate.worksPackage.id from TenderResponse tr " + " where tr.tenderEstimate.abstractEstimate.id=null and  tr.tenderEstimate.worksPackage.id!=null and" + " tr.tenderEstimate.worksPackage.department.id= ?)) ";
            paramList.add(this.departmentId);
            paramList.add(this.departmentId);
        }
        if (StringUtils.isNotBlank((String)this.estimateNumber)) {
            negotiationStr = negotiationStr + " and tenderResponse.tenderEstimate.worksPackage.id in " + "(select wpd.worksPackage.id from WorksPackageDetails wpd where UPPER(wpd.estimate.estimateNumber) like ? )";
            paramList.add("%" + this.estimateNumber.trim().toUpperCase() + "%");
        }
        if (StringUtils.isNotBlank((String)this.projectCode)) {
            negotiationStr = negotiationStr + " and tenderResponse.tenderEstimate.worksPackage.id in " + "(select wpd.worksPackage.id from WorksPackageDetails wpd where UPPER(wpd.estimate.projectCode.code) like ?)";
            paramList.add("%" + this.projectCode.trim().toUpperCase() + "%");
        }
        if (StringUtils.isNotBlank((String)this.wpNumber)) {
            negotiationStr = negotiationStr + " and UPPER(tenderResponse.tenderEstimate.worksPackage.wpNumber) like ?";
            paramList.add("%" + this.wpNumber.trim().toUpperCase() + "%");
        }
        if (StringUtils.isNotBlank((String)this.tenderFileNumber)) {
            negotiationStr = negotiationStr + "  and  UPPER(tenderResponse.tenderEstimate.worksPackage.tenderFileNumber) like ? ";
            paramList.add("%" + this.tenderFileNumber.toUpperCase() + "%");
        }
        if (this.getContractorId() != null && this.getContractorId() != -1L) {
            negotiationStr = negotiationStr + "  and tenderResponse.id in ( select trc.tenderResponse.id from TenderResponseContractors trc where trc.contractor.id= ?)";
            paramList.add(this.getContractorId());
        }
        String countQuery = "select count(*) " + negotiationStr;
        return new SearchQueryHQL(negotiationStr, countQuery, paramList);
    }

    @ValidationErrorPage(value="searchNegotiationPage")
    public String search() {
        this.setPageSize(30);
        super.search();
        this.getPositionAndUser();
        return "searchNegotiationPage";
    }

    public String cancelApprovedTN() {
        TenderResponse tenderResponse = (TenderResponse)this.tenderResponseService.findById((Serializable)this.tenderRespId, false);
        tenderResponse.setEgwStatus(this.egwStatusHibernateDAO.getStatusByModuleAndCode("TenderResponse", "CANCELLED"));
        PersonalInformation prsnlInfo = this.employeeServiceOld.getEmpForUserId(this.worksService.getCurrentLoggedInUserId());
        String empName = "";
        if (prsnlInfo.getEmployeeFirstName() != null) {
            empName = prsnlInfo.getEmployeeFirstName();
        }
        if (prsnlInfo.getEmployeeLastName() != null) {
            empName = empName.concat(" ").concat(prsnlInfo.getEmployeeLastName());
        }
        if (this.cancelRemarks != null && StringUtils.isNotBlank((String)this.cancelRemarks)) {
            this.cancellationReason.concat(" : ").concat(this.cancelRemarks).concat(". ").concat(this.getText("tenderNegotiation.cancel.cancelledby")).concat(": ").concat(empName);
        } else {
            this.cancellationReason.concat(". ").concat(this.getText("tenderNegotiation.cancel.cancelledby")).concat(": ").concat(empName);
        }
        this.negotiationNumber = tenderResponse.getNegotiationNumber();
        this.messageKey = this.negotiationNumber + " : " + this.getText("tenderResponse.cancel");
        return "success";
    }

    public void setPersonalInformationService(PersonalInformationService personalInformationService) {
        this.personalInformationService = personalInformationService;
    }

    public String acceptanceNote() {
        return TENDER_ACCEPTANCE_NOTE;
    }

    public List<TenderResponseContractors> getActionTenderResponseContractors() {
        return this.actionTenderResponseContractors;
    }

    public void setActionTenderResponseContractors(List<TenderResponseContractors> actionTenderResponseContractors) {
        this.actionTenderResponseContractors = actionTenderResponseContractors;
    }

    public void setContractorService(PersistenceService<Contractor, Long> service) {
        this.contractorService = service;
    }

    public Long getContractorId() {
        return this.contractorId;
    }

    public void setContractorId(Long contractorId) {
        this.contractorId = contractorId;
    }

    public List<String> getTenderTypeList() {
        return this.tenderTypeList;
    }

    public void setTenderTypeList(List<String> tenderTypeList) {
        this.tenderTypeList = tenderTypeList;
    }

    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    public String getCancellationReason() {
        return this.cancellationReason;
    }

    public void setCancellationReason(String cancellationReason) {
        this.cancellationReason = cancellationReason;
    }

    public String getCancelRemarks() {
        return this.cancelRemarks;
    }

    public void setCancelRemarks(String cancelRemarks) {
        this.cancelRemarks = cancelRemarks;
    }

    public PersistenceService<OfflineStatus, Long> getWorksStatusService() {
        return this.worksStatusService;
    }

    public void setWorksStatusService(PersistenceService<OfflineStatus, Long> worksStatusService) {
        this.worksStatusService = worksStatusService;
    }

    public String getNegoNumber() {
        return this.negoNumber;
    }

    public void setNegoNumber(String negoNumber) {
        this.negoNumber = negoNumber;
    }

    public String getLoggedInUserEmployeeCode() {
        return this.loggedInUserEmployeeCode;
    }

    public void setLoggedInUserEmployeeCode(String loggedInUserEmployeeCode) {
        this.loggedInUserEmployeeCode = loggedInUserEmployeeCode;
    }

    public void setEisService(EisUtilService eisService) {
        this.eisService = eisService;
    }

    public Map<String, String> getTenderInvitationTypeMap() {
        return this.tenderInvitationTypeMap;
    }

    public void setTenderInvitationTypeMap(Map<String, String> tenderInvitationTypeMap) {
        this.tenderInvitationTypeMap = tenderInvitationTypeMap;
    }

    public List<TenderResponseActivity> getActionTenderResponseActivities() {
        return this.actionTenderResponseActivities;
    }

    public void setActionTenderResponseActivities(List<TenderResponseActivity> actionTenderResponseActivities) {
        this.actionTenderResponseActivities = actionTenderResponseActivities;
    }
}

