/*
 * Decompiled with CFR 0.152.
 */
package org.egov.works.web.actions.tender;

import java.util.ArrayList;
import java.util.LinkedList;
import org.apache.commons.lang.StringUtils;
import org.egov.infra.web.struts.actions.SearchFormAction;
import org.egov.infstr.search.SearchQuery;
import org.egov.infstr.search.SearchQueryHQL;
import org.egov.works.abstractestimate.entity.AbstractEstimate;
import org.egov.works.models.tender.TenderEstimate;
import org.egov.works.models.tender.TenderResponseActivity;

public class SearchTenderResponseActivitiesAction
extends SearchFormAction {
    private static final long serialVersionUID = 8616631394931994625L;
    private Long tenderRespContrId;
    private Long tenderRespId;
    private String activityType;
    private String sorCode;
    private String activityDesc;
    private Long estimateId;
    private String estimateName;
    private Long activityId;
    private String negotiationNumber;
    private double assignedQty;
    private String recordId;
    private String selectedactivities;

    public Object getModel() {
        return null;
    }

    public String execute() {
        return "index";
    }

    public void prepare() {
        super.prepare();
        ArrayList<AbstractEstimate> estimateList = new ArrayList<AbstractEstimate>();
        TenderEstimate tenderEstimate = null;
        if (this.tenderRespId != null) {
            tenderEstimate = (TenderEstimate)this.getPersistenceService().find("select tr.tenderEstimate from TenderResponse tr where tr.id=?", new Object[]{this.tenderRespId});
        }
        if (tenderEstimate != null && tenderEstimate.getAbstractEstimate() == null) {
            estimateList.addAll(tenderEstimate.getWorksPackage().getAllEstimates());
        } else if (tenderEstimate != null && tenderEstimate.getWorksPackage() == null) {
            estimateList.add(tenderEstimate.getAbstractEstimate());
        }
        this.addDropdownData("estimateList", estimateList);
    }

    public SearchQuery prepareQuery(String sortField, String sortOrder) {
        StringBuilder sb = new StringBuilder(300);
        ArrayList<Object> paramList = new ArrayList<Object>();
        int counter = 0;
        sb.append("from TenderResponseActivity as tra left join tra.activity.schedule schedule left join tra.activity.nonSor nonSor where tra.tenderResponse.id= ?");
        paramList.add(this.tenderRespId);
        ++counter;
        if (StringUtils.isNotBlank((String)this.activityType) && this.activityType.equalsIgnoreCase("SOR")) {
            sb.append(" and schedule is not null");
        }
        if (StringUtils.isNotBlank((String)this.activityType) && this.activityType.equalsIgnoreCase("Non SOR")) {
            sb.append(" and nonSor is not null");
        }
        if (StringUtils.isNotBlank((String)this.sorCode)) {
            sb.append(" and UPPER(schedule.code) like ?");
            paramList.add("%" + this.sorCode.toUpperCase() + "%");
            ++counter;
        }
        if (StringUtils.isNotBlank((String)this.activityDesc)) {
            sb.append(" and ((UPPER(schedule.description) like ?) or (UPPER(nonSor.description) like ? ))");
            paramList.add("%" + this.activityDesc.toUpperCase() + "%");
            ++counter;
            paramList.add("%" + this.activityDesc.toUpperCase() + "%");
            ++counter;
        }
        if (StringUtils.isNotBlank((String)this.estimateName)) {
            sb.append(" and UPPER(tra.activity.abstractEstimate.name) like ?");
            paramList.add("%" + this.estimateName.toUpperCase() + "%");
            ++counter;
        }
        if (this.estimateId != null && this.estimateId != -1L) {
            sb.append(" and tra.activity.abstractEstimate.id= ?");
            paramList.add(this.estimateId);
            ++counter;
        }
        if (StringUtils.isNotBlank((String)this.selectedactivities)) {
            sb.append(" and tra.activity.id not in(?").append(counter).append(")");
            String[] activitiesId = this.selectedactivities.split(",");
            ArrayList<Long> activitiesIdList = new ArrayList<Long>();
            for (String element : activitiesId) {
                activitiesIdList.add(Long.valueOf(element));
            }
            paramList.add(activitiesIdList);
        }
        sb.append(" order by tra.activity.abstractEstimate.id");
        String query = sb.toString();
        String countQuery = "select count(*) " + query;
        return new SearchQueryHQL(query, countQuery, paramList);
    }

    public String search() {
        this.setPageSize(100);
        String retVal = super.search();
        this.populateAssignedQunatity();
        if (this.searchResult.getFullListSize() == 0) {
            this.addFieldError("result not found", "No results found for search parameters");
        }
        return retVal;
    }

    private void populateAssignedQunatity() {
        LinkedList<TenderResponseActivity> tenderResponseActivityList = new LinkedList<TenderResponseActivity>();
        for (Object[] row : this.searchResult.getList()) {
            TenderResponseActivity tenderResponseActivity = (TenderResponseActivity)row[0];
            double assignedQty = this.getAssignedQuantity(tenderResponseActivity.getActivity().getId(), tenderResponseActivity.getTenderResponse().getNegotiationNumber());
            if (!(assignedQty < tenderResponseActivity.getNegotiatedQuantity())) continue;
            tenderResponseActivity.setAssignedQty(assignedQty);
            tenderResponseActivityList.add(tenderResponseActivity);
        }
        this.searchResult.getList().clear();
        this.searchResult.getList().addAll(tenderResponseActivityList);
    }

    private double getAssignedQuantity(Long activityId, String negotiationNumber) {
        Object[] params = new Object[]{negotiationNumber, "CANCELLED", activityId};
        Double assignedQty = (Double)this.getPersistenceService().findByNamedQuery("getAssignedQuantityForActivity", params);
        params = new Object[]{negotiationNumber, "NEW", activityId};
        Double assignedQtyForNew = (Double)this.getPersistenceService().findByNamedQuery("getAssignedQuantityForActivityForNewWO", params);
        if (assignedQty != null && assignedQtyForNew != null) {
            assignedQty = assignedQty + assignedQtyForNew;
        }
        if (assignedQty == null && assignedQtyForNew != null) {
            assignedQty = assignedQtyForNew;
        }
        if (assignedQty == null) {
            return 0.0;
        }
        return assignedQty;
    }

    public String getAssignedQuantity() {
        this.assignedQty = this.getAssignedQuantity(this.activityId, this.negotiationNumber);
        return "assignedQty";
    }

    public Long getTenderRespContrId() {
        return this.tenderRespContrId;
    }

    public void setTenderRespContrId(Long tenderRespContrId) {
        this.tenderRespContrId = tenderRespContrId;
    }

    public Long getTenderRespId() {
        return this.tenderRespId;
    }

    public void setTenderRespId(Long tenderRespId) {
        this.tenderRespId = tenderRespId;
    }

    public String getActivityType() {
        return this.activityType;
    }

    public void setActivityType(String activityType) {
        this.activityType = activityType;
    }

    public String getSorCode() {
        return this.sorCode;
    }

    public void setSorCode(String sorCode) {
        this.sorCode = sorCode;
    }

    public String getActivityDesc() {
        return this.activityDesc;
    }

    public void setActivityDesc(String activityDesc) {
        this.activityDesc = activityDesc;
    }

    public Long getEstimateId() {
        return this.estimateId;
    }

    public void setEstimateId(Long estimateId) {
        this.estimateId = estimateId;
    }

    public String getEstimateName() {
        return this.estimateName;
    }

    public void setEstimateName(String estimateName) {
        this.estimateName = estimateName;
    }

    public Long getActivityId() {
        return this.activityId;
    }

    public void setActivityId(Long activityId) {
        this.activityId = activityId;
    }

    public String getNegotiationNumber() {
        return this.negotiationNumber;
    }

    public void setNegotiationNumber(String negotiationNumber) {
        this.negotiationNumber = negotiationNumber;
    }

    public double getAssignedQty() {
        return this.assignedQty;
    }

    public void setAssignedQty(double assignedQty) {
        this.assignedQty = assignedQty;
    }

    public String getRecordId() {
        return this.recordId;
    }

    public void setRecordId(String recordId) {
        this.recordId = recordId;
    }

    public String getSelectedactivities() {
        return this.selectedactivities;
    }

    public void setSelectedactivities(String selectedactivities) {
        this.selectedactivities = selectedactivities;
    }
}

